/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import org.joml.Math;
import org.joml.Runtime;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class Intersectionf {
    public static final int POINT_ON_TRIANGLE_VERTEX_0 = 1;
    public static final int POINT_ON_TRIANGLE_VERTEX_1 = 2;
    public static final int POINT_ON_TRIANGLE_VERTEX_2 = 3;
    public static final int POINT_ON_TRIANGLE_EDGE_01 = 4;
    public static final int POINT_ON_TRIANGLE_EDGE_12 = 5;
    public static final int POINT_ON_TRIANGLE_EDGE_20 = 6;
    public static final int POINT_ON_TRIANGLE_FACE = 7;
    public static final int AAR_SIDE_MINX = 0;
    public static final int AAR_SIDE_MINY = 1;
    public static final int AAR_SIDE_MAXX = 2;
    public static final int AAR_SIDE_MAXY = 3;
    public static final int OUTSIDE = -1;
    public static final int ONE_INTERSECTION = 1;
    public static final int TWO_INTERSECTION = 2;
    public static final int INSIDE = 3;

    public static boolean testPlaneSphere(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = Math.sqrt(f2 * f2 + f3 * f3 + f4 * f4);
        float f11 = (f2 * f6 + f3 * f7 + f4 * f8 + f5) / f10;
        return -f9 <= f11 && f11 <= f9;
    }

    public static boolean intersectPlaneSphere(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Vector4f vector4f) {
        float f10 = Math.invsqrt(f2 * f2 + f3 * f3 + f4 * f4);
        float f11 = (f2 * f6 + f3 * f7 + f4 * f8 + f5) * f10;
        if (-f9 <= f11 && f11 <= f9) {
            vector4f.x = f6 + f11 * f2 * f10;
            vector4f.y = f7 + f11 * f3 * f10;
            vector4f.z = f8 + f11 * f4 * f10;
            vector4f.w = Math.sqrt(f9 * f9 - f11 * f11);
            return true;
        }
        return false;
    }

    public static boolean intersectPlaneSweptSphere(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, Vector4f vector4f) {
        float f13 = f2 * f6 + f3 * f7 + f4 * f8 - f5;
        if (Math.abs(f13) <= f9) {
            vector4f.set(f6, f7, f8, 0.0f);
            return true;
        }
        float f14 = f2 * f10 + f3 * f11 + f4 * f12;
        if (f14 * f13 >= 0.0f) {
            return false;
        }
        float f15 = f13 > 0.0f ? f9 : -f9;
        float f16 = (f15 - f13) / f14;
        vector4f.set(f6 + f16 * f10 - f15 * f2, f7 + f16 * f11 - f15 * f3, f8 + f16 * f12 - f15 * f4, f16);
        return true;
    }

    public static boolean testPlaneSweptSphere(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        float f13 = f6 * f2 + f7 * f3 + f8 * f4 - f5;
        float f14 = f10 * f2 + f11 * f3 + f12 * f4 - f5;
        if (f13 * f14 < 0.0f) {
            return true;
        }
        return Math.abs(f13) <= f9 || Math.abs(f14) <= f9;
    }

    public static boolean testAabPlane(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        float f12;
        float f13;
        float f14;
        float f15;
        float f16;
        float f17;
        if (f8 > 0.0f) {
            f17 = f5;
            f16 = f2;
        } else {
            f17 = f2;
            f16 = f5;
        }
        if (f9 > 0.0f) {
            f15 = f6;
            f14 = f3;
        } else {
            f15 = f3;
            f14 = f6;
        }
        if (f10 > 0.0f) {
            f13 = f7;
            f12 = f4;
        } else {
            f13 = f4;
            f12 = f7;
        }
        float f18 = f11 + f8 * f16 + f9 * f14 + f10 * f12;
        float f19 = f11 + f8 * f17 + f9 * f15 + f10 * f13;
        return f18 <= 0.0f && f19 >= 0.0f;
    }

    public static boolean testAabPlane(Vector3fc vector3fc, Vector3fc vector3fc2, float f2, float f3, float f4, float f5) {
        return Intersectionf.testAabPlane(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), f2, f3, f4, f5);
    }

    public static boolean testAabAab(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        return f5 >= f8 && f6 >= f9 && f7 >= f10 && f2 <= f11 && f3 <= f12 && f4 <= f13;
    }

    public static boolean testAabAab(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Vector3fc vector3fc4) {
        return Intersectionf.testAabAab(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), vector3fc4.x(), vector3fc4.y(), vector3fc4.z());
    }

    public static boolean testObOb(Vector3f vector3f, Vector3f vector3f2, Vector3f vector3f3, Vector3f vector3f4, Vector3f vector3f5, Vector3f vector3f6, Vector3f vector3f7, Vector3f vector3f8, Vector3f vector3f9, Vector3f vector3f10) {
        return Intersectionf.testObOb(vector3f.x, vector3f.y, vector3f.z, vector3f2.x, vector3f2.y, vector3f2.z, vector3f3.x, vector3f3.y, vector3f3.z, vector3f4.x, vector3f4.y, vector3f4.z, vector3f5.x, vector3f5.y, vector3f5.z, vector3f6.x, vector3f6.y, vector3f6.z, vector3f7.x, vector3f7.y, vector3f7.z, vector3f8.x, vector3f8.y, vector3f8.z, vector3f9.x, vector3f9.y, vector3f9.z, vector3f10.x, vector3f10.y, vector3f10.z);
    }

    public static boolean testObOb(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, float f20, float f21, float f22, float f23, float f24, float f25, float f26, float f27, float f28, float f29, float f30, float f31) {
        float f32 = f5 * f20 + f8 * f23 + f11 * f26;
        float f33 = f5 * f21 + f8 * f24 + f11 * f27;
        float f34 = f5 * f22 + f8 * f25 + f11 * f28;
        float f35 = f6 * f20 + f9 * f23 + f12 * f26;
        float f36 = f6 * f21 + f9 * f24 + f12 * f27;
        float f37 = f6 * f22 + f9 * f25 + f12 * f28;
        float f38 = f7 * f20 + f10 * f23 + f13 * f26;
        float f39 = f7 * f21 + f10 * f24 + f13 * f27;
        float f40 = f7 * f22 + f10 * f25 + f13 * f28;
        float f41 = 1.0E-5f;
        float f42 = Math.abs(f32) + f41;
        float f43 = Math.abs(f35) + f41;
        float f44 = Math.abs(f38) + f41;
        float f45 = Math.abs(f33) + f41;
        float f46 = Math.abs(f36) + f41;
        float f47 = Math.abs(f39) + f41;
        float f48 = Math.abs(f34) + f41;
        float f49 = Math.abs(f37) + f41;
        float f50 = Math.abs(f40) + f41;
        float f51 = f17 - f2;
        float f52 = f18 - f3;
        float f53 = f19 - f4;
        float f54 = f51 * f5 + f52 * f6 + f53 * f7;
        float f55 = f51 * f8 + f52 * f9 + f53 * f10;
        float f56 = f51 * f11 + f52 * f12 + f53 * f13;
        float f57 = f14;
        float f58 = f29 * f42 + f30 * f43 + f31 * f44;
        if (Math.abs(f54) > f57 + f58) {
            return false;
        }
        f57 = f15;
        f58 = f29 * f45 + f30 * f46 + f31 * f47;
        if (Math.abs(f55) > f57 + f58) {
            return false;
        }
        f57 = f16;
        f58 = f29 * f48 + f30 * f49 + f31 * f50;
        if (Math.abs(f56) > f57 + f58) {
            return false;
        }
        f57 = f14 * f42 + f15 * f45 + f16 * f48;
        f58 = f29;
        if (Math.abs(f54 * f32 + f55 * f33 + f56 * f34) > f57 + f58) {
            return false;
        }
        f57 = f14 * f43 + f15 * f46 + f16 * f49;
        f58 = f30;
        if (Math.abs(f54 * f35 + f55 * f36 + f56 * f37) > f57 + f58) {
            return false;
        }
        f57 = f14 * f44 + f15 * f47 + f16 * f50;
        f58 = f31;
        if (Math.abs(f54 * f38 + f55 * f39 + f56 * f40) > f57 + f58) {
            return false;
        }
        f57 = f15 * f48 + f16 * f45;
        f58 = f30 * f44 + f31 * f43;
        if (Math.abs(f56 * f33 - f55 * f34) > f57 + f58) {
            return false;
        }
        f57 = f15 * f49 + f16 * f46;
        f58 = f29 * f44 + f31 * f42;
        if (Math.abs(f56 * f36 - f55 * f37) > f57 + f58) {
            return false;
        }
        f57 = f15 * f50 + f16 * f47;
        f58 = f29 * f43 + f30 * f42;
        if (Math.abs(f56 * f39 - f55 * f40) > f57 + f58) {
            return false;
        }
        f57 = f14 * f48 + f16 * f42;
        f58 = f30 * f47 + f31 * f46;
        if (Math.abs(f54 * f34 - f56 * f32) > f57 + f58) {
            return false;
        }
        f57 = f14 * f49 + f16 * f43;
        f58 = f29 * f47 + f31 * f45;
        if (Math.abs(f54 * f37 - f56 * f35) > f57 + f58) {
            return false;
        }
        f57 = f14 * f50 + f16 * f44;
        f58 = f29 * f46 + f30 * f45;
        if (Math.abs(f54 * f40 - f56 * f38) > f57 + f58) {
            return false;
        }
        f57 = f14 * f45 + f15 * f42;
        f58 = f30 * f50 + f31 * f49;
        if (Math.abs(f55 * f32 - f54 * f33) > f57 + f58) {
            return false;
        }
        f57 = f14 * f46 + f15 * f43;
        f58 = f29 * f50 + f31 * f48;
        if (Math.abs(f55 * f35 - f54 * f36) > f57 + f58) {
            return false;
        }
        f57 = f14 * f47 + f15 * f44;
        f58 = f29 * f49 + f30 * f48;
        return !(Math.abs(f55 * f38 - f54 * f39) > f57 + f58);
    }

    public static boolean intersectSphereSphere(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Vector4f vector4f) {
        float f10 = f6 - f2;
        float f11 = f7 - f3;
        float f12 = f8 - f4;
        float f13 = f10 * f10 + f11 * f11 + f12 * f12;
        float f14 = 0.5f + (f5 - f9) / (2.0f * f13);
        float f15 = f5 - f14 * f14 * f13;
        if (f15 >= 0.0f) {
            vector4f.x = f2 + f14 * f10;
            vector4f.y = f3 + f14 * f11;
            vector4f.z = f4 + f14 * f12;
            vector4f.w = Math.sqrt(f15);
            return true;
        }
        return false;
    }

    public static boolean intersectSphereSphere(Vector3fc vector3fc, float f2, Vector3fc vector3fc2, float f3, Vector4f vector4f) {
        return Intersectionf.intersectSphereSphere(vector3fc.x(), vector3fc.y(), vector3fc.z(), f2, vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), f3, vector4f);
    }

    public static int intersectSphereTriangle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, Vector3f vector3f) {
        int n2 = Intersectionf.findClosestPointOnTriangle(f6, f7, f8, f9, f10, f11, f12, f13, f14, f2, f3, f4, vector3f);
        float f15 = vector3f.x - f2;
        float f16 = vector3f.y - f3;
        float f17 = vector3f.z - f4;
        float f18 = f15 * f15 + f16 * f16 + f17 * f17;
        if (f18 <= f5 * f5) {
            return n2;
        }
        return 0;
    }

    public static boolean testSphereSphere(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f6 - f2;
        float f11 = f7 - f3;
        float f12 = f8 - f4;
        float f13 = f10 * f10 + f11 * f11 + f12 * f12;
        float f14 = 0.5f + (f5 - f9) / (2.0f * f13);
        float f15 = f5 - f14 * f14 * f13;
        return f15 >= 0.0f;
    }

    public static boolean testSphereSphere(Vector3fc vector3fc, float f2, Vector3fc vector3fc2, float f3) {
        return Intersectionf.testSphereSphere(vector3fc.x(), vector3fc.y(), vector3fc.z(), f2, vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), f3);
    }

    public static float distancePointPlane(float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = Math.sqrt(f5 * f5 + f6 * f6 + f7 * f7);
        return (f5 * f2 + f6 * f3 + f7 * f4 + f8) / f9;
    }

    public static float distancePointPlane(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        float f14 = f9 - f6;
        float f15 = f13 - f7;
        float f16 = f12 - f6;
        float f17 = f10 - f7;
        float f18 = f11 - f5;
        float f19 = f8 - f5;
        float f20 = f14 * f15 - f16 * f17;
        float f21 = f17 * f18 - f15 * f19;
        float f22 = f19 * f16 - f18 * f14;
        float f23 = -(f20 * f5 + f21 * f6 + f22 * f7);
        return Intersectionf.distancePointPlane(f2, f3, f4, f20, f21, f22, f23);
    }

    public static float intersectRayPlane(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14) {
        float f15;
        float f16 = f11 * f5 + f12 * f6 + f13 * f7;
        if (f16 < f14 && (f15 = ((f8 - f2) * f11 + (f9 - f3) * f12 + (f10 - f4) * f13) / f16) >= 0.0f) {
            return f15;
        }
        return -1.0f;
    }

    public static float intersectRayPlane(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Vector3fc vector3fc4, float f2) {
        return Intersectionf.intersectRayPlane(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), vector3fc4.x(), vector3fc4.y(), vector3fc4.z(), f2);
    }

    public static float intersectRayPlane(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12) {
        float f13;
        float f14 = f8 * f5 + f9 * f6 + f10 * f7;
        if (f14 < 0.0f && (f13 = -(f8 * f2 + f9 * f3 + f10 * f4 + f11) / f14) >= 0.0f) {
            return f13;
        }
        return -1.0f;
    }

    public static boolean testAabSphere(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        float f12;
        float f13 = f11;
        if (f8 < f2) {
            f12 = f8 - f2;
            f13 -= f12 * f12;
        } else if (f8 > f5) {
            f12 = f8 - f5;
            f13 -= f12 * f12;
        }
        if (f9 < f3) {
            f12 = f9 - f3;
            f13 -= f12 * f12;
        } else if (f9 > f6) {
            f12 = f9 - f6;
            f13 -= f12 * f12;
        }
        if (f10 < f4) {
            f12 = f10 - f4;
            f13 -= f12 * f12;
        } else if (f10 > f7) {
            f12 = f10 - f7;
            f13 -= f12 * f12;
        }
        return f13 >= 0.0f;
    }

    public static boolean testAabSphere(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, float f2) {
        return Intersectionf.testAabSphere(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), f2);
    }

    public static Vector3f findClosestPointOnPlane(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, Vector3f vector3f) {
        float f11 = -(f5 * f2 + f6 * f3 + f7 * f4);
        float f12 = f5 * f8 + f6 * f9 + f7 * f10 - f11;
        vector3f.x = f8 - f12 * f5;
        vector3f.y = f9 - f12 * f6;
        vector3f.z = f10 - f12 * f7;
        return vector3f;
    }

    public static Vector3f findClosestPointOnLineSegment(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, Vector3f vector3f) {
        float f11 = f5 - f2;
        float f12 = f6 - f3;
        float f13 = f7 - f4;
        float f14 = ((f8 - f2) * f11 + (f9 - f3) * f12 + (f10 - f4) * f13) / (f11 * f11 + f12 * f12 + f13 * f13);
        if (f14 < 0.0f) {
            f14 = 0.0f;
        }
        if (f14 > 1.0f) {
            f14 = 1.0f;
        }
        vector3f.x = f2 + f14 * f11;
        vector3f.y = f3 + f14 * f12;
        vector3f.z = f4 + f14 * f13;
        return vector3f;
    }

    public static float findClosestPointsLineSegments(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, Vector3f vector3f, Vector3f vector3f2) {
        float f14;
        float f15;
        float f16;
        float f17;
        float f18;
        float f19 = f5 - f2;
        float f20 = f6 - f3;
        float f21 = f7 - f4;
        float f22 = f11 - f8;
        float f23 = f12 - f9;
        float f24 = f13 - f10;
        float f25 = f2 - f8;
        float f26 = f3 - f9;
        float f27 = f4 - f10;
        float f28 = f19 * f19 + f20 * f20 + f21 * f21;
        float f29 = f22 * f22 + f23 * f23 + f24 * f24;
        float f30 = f22 * f25 + f23 * f26 + f24 * f27;
        float f31 = 1.0E-5f;
        if (f28 <= f31 && f29 <= f31) {
            vector3f.set(f2, f3, f4);
            vector3f2.set(f8, f9, f10);
            return vector3f.dot(vector3f2);
        }
        if (f28 <= f31) {
            f18 = 0.0f;
            f17 = f30 / f29;
            f17 = Math.min(Math.max(f17, 0.0f), 1.0f);
        } else {
            f16 = f19 * f25 + f20 * f26 + f21 * f27;
            if (f29 <= f31) {
                f17 = 0.0f;
                f18 = Math.min(Math.max(-f16 / f28, 0.0f), 1.0f);
            } else {
                f14 = f28 * f29 - (f15 = f19 * f22 + f20 * f23 + f21 * f24) * f15;
                f18 = (double)f14 != 0.0 ? Math.min(Math.max((f15 * f30 - f16 * f29) / f14, 0.0f), 1.0f) : 0.0f;
                f17 = (f15 * f18 + f30) / f29;
                if ((double)f17 < 0.0) {
                    f17 = 0.0f;
                    f18 = Math.min(Math.max(-f16 / f28, 0.0f), 1.0f);
                } else if ((double)f17 > 1.0) {
                    f17 = 1.0f;
                    f18 = Math.min(Math.max((f15 - f16) / f28, 0.0f), 1.0f);
                }
            }
        }
        vector3f.set(f2 + f19 * f18, f3 + f20 * f18, f4 + f21 * f18);
        vector3f2.set(f8 + f22 * f17, f9 + f23 * f17, f10 + f24 * f17);
        f16 = vector3f.x - vector3f2.x;
        f15 = vector3f.y - vector3f2.y;
        f14 = vector3f.z - vector3f2.z;
        return f16 * f16 + f15 * f15 + f14 * f14;
    }

    public static float findClosestPointsLineSegmentTriangle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, Vector3f vector3f, Vector3f vector3f2) {
        float f17;
        float f18;
        float f19;
        float f20;
        float f21;
        float f22;
        float f23;
        float f24;
        float f25 = f24 = Intersectionf.findClosestPointsLineSegments(f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, vector3f, vector3f2);
        float f26 = vector3f.x;
        float f27 = vector3f.y;
        float f28 = vector3f.z;
        float f29 = vector3f2.x;
        float f30 = vector3f2.y;
        float f31 = vector3f2.z;
        f24 = Intersectionf.findClosestPointsLineSegments(f2, f3, f4, f5, f6, f7, f11, f12, f13, f14, f15, f16, vector3f, vector3f2);
        if (f24 < f25) {
            f25 = f24;
            f26 = vector3f.x;
            f27 = vector3f.y;
            f28 = vector3f.z;
            f29 = vector3f2.x;
            f30 = vector3f2.y;
            f31 = vector3f2.z;
        }
        if ((f24 = Intersectionf.findClosestPointsLineSegments(f2, f3, f4, f5, f6, f7, f14, f15, f16, f8, f9, f10, vector3f, vector3f2)) < f25) {
            f25 = f24;
            f26 = vector3f.x;
            f27 = vector3f.y;
            f28 = vector3f.z;
            f29 = vector3f2.x;
            f30 = vector3f2.y;
            f31 = vector3f2.z;
        }
        boolean bl2 = false;
        float f32 = Float.NaN;
        float f33 = Float.NaN;
        float f34 = Float.NaN;
        float f35 = Float.NaN;
        if (Intersectionf.testPointInTriangle(f2, f3, f4, f8, f9, f10, f11, f12, f13, f14, f15, f16)) {
            f23 = f12 - f9;
            f22 = f16 - f10;
            f21 = f15 - f9;
            f20 = f13 - f10;
            f19 = f14 - f8;
            f18 = f11 - f8;
            f32 = f23 * f22 - f21 * f20;
            f33 = f20 * f19 - f22 * f18;
            f34 = f18 * f21 - f19 * f23;
            bl2 = true;
            f17 = Math.invsqrt(f32 * f32 + f33 * f33 + f34 * f34);
            f35 = -((f32 *= f17) * f8 + (f33 *= f17) * f9 + (f34 *= f17) * f10);
            float f36 = f24 = f32 * f2 + f33 * f3 + f34 * f4 + f35;
            if ((f24 *= f24) < f25) {
                f25 = f24;
                f26 = f2;
                f27 = f3;
                f28 = f4;
                f29 = f2 - f32 * f36;
                f30 = f3 - f33 * f36;
                f31 = f4 - f34 * f36;
            }
        }
        if (Intersectionf.testPointInTriangle(f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16)) {
            if (!bl2) {
                f23 = f12 - f9;
                f22 = f16 - f10;
                f21 = f15 - f9;
                f20 = f13 - f10;
                f19 = f14 - f8;
                f18 = f11 - f8;
                f32 = f23 * f22 - f21 * f20;
                f33 = f20 * f19 - f22 * f18;
                f34 = f18 * f21 - f19 * f23;
                f17 = Math.invsqrt(f32 * f32 + f33 * f33 + f34 * f34);
                f35 = -((f32 *= f17) * f8 + (f33 *= f17) * f9 + (f34 *= f17) * f10);
            }
            f23 = f24 = f32 * f5 + f33 * f6 + f34 * f7 + f35;
            if ((f24 *= f24) < f25) {
                f25 = f24;
                f26 = f5;
                f27 = f6;
                f28 = f7;
                f29 = f5 - f32 * f23;
                f30 = f6 - f33 * f23;
                f31 = f7 - f34 * f23;
            }
        }
        vector3f.set(f26, f27, f28);
        vector3f2.set(f29, f30, f31);
        return f25;
    }

    public static int findClosestPointOnTriangle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, Vector3f vector3f) {
        float f14 = f5 - f2;
        float f15 = f6 - f3;
        float f16 = f7 - f4;
        float f17 = f8 - f2;
        float f18 = f9 - f3;
        float f19 = f10 - f4;
        float f20 = f11 - f2;
        float f21 = f12 - f3;
        float f22 = f13 - f4;
        float f23 = f14 * f20 + f15 * f21 + f16 * f22;
        float f24 = f17 * f20 + f18 * f21 + f19 * f22;
        if (f23 <= 0.0f && f24 <= 0.0f) {
            vector3f.x = f2;
            vector3f.y = f3;
            vector3f.z = f4;
            return 1;
        }
        float f25 = f11 - f5;
        float f26 = f12 - f6;
        float f27 = f13 - f7;
        float f28 = f14 * f25 + f15 * f26 + f16 * f27;
        float f29 = f17 * f25 + f18 * f26 + f19 * f27;
        if (f28 >= 0.0f && f29 <= f28) {
            vector3f.x = f5;
            vector3f.y = f6;
            vector3f.z = f7;
            return 2;
        }
        float f30 = f23 * f29 - f28 * f24;
        if (f30 <= 0.0f && f23 >= 0.0f && f28 <= 0.0f) {
            float f31 = f23 / (f23 - f28);
            vector3f.x = f2 + f31 * f14;
            vector3f.y = f3 + f31 * f15;
            vector3f.z = f4 + f31 * f16;
            return 4;
        }
        float f32 = f11 - f8;
        float f33 = f12 - f9;
        float f34 = f13 - f10;
        float f35 = f14 * f32 + f15 * f33 + f16 * f34;
        float f36 = f17 * f32 + f18 * f33 + f19 * f34;
        if (f36 >= 0.0f && f35 <= f36) {
            vector3f.x = f8;
            vector3f.y = f9;
            vector3f.z = f10;
            return 3;
        }
        float f37 = f35 * f24 - f23 * f36;
        if (f37 <= 0.0f && f24 >= 0.0f && f36 <= 0.0f) {
            float f38 = f24 / (f24 - f36);
            vector3f.x = f2 + f38 * f17;
            vector3f.y = f3 + f38 * f18;
            vector3f.z = f4 + f38 * f19;
            return 6;
        }
        float f39 = f28 * f36 - f35 * f29;
        if (f39 <= 0.0f && f29 - f28 >= 0.0f && f35 - f36 >= 0.0f) {
            float f40 = (f29 - f28) / (f29 - f28 + f35 - f36);
            vector3f.x = f5 + f40 * (f8 - f5);
            vector3f.y = f6 + f40 * (f9 - f6);
            vector3f.z = f7 + f40 * (f10 - f7);
            return 5;
        }
        float f41 = 1.0f / (f39 + f37 + f30);
        float f42 = f37 * f41;
        float f43 = f30 * f41;
        vector3f.x = f2 + f14 * f42 + f17 * f43;
        vector3f.y = f3 + f15 * f42 + f18 * f43;
        vector3f.z = f4 + f16 * f42 + f19 * f43;
        return 7;
    }

    public static int findClosestPointOnTriangle(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Vector3fc vector3fc4, Vector3f vector3f) {
        return Intersectionf.findClosestPointOnTriangle(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), vector3fc4.x(), vector3fc4.y(), vector3fc4.z(), vector3f);
    }

    public static Vector3f findClosestPointOnRectangle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, Vector3f vector3f) {
        float f14 = f5 - f2;
        float f15 = f6 - f3;
        float f16 = f7 - f4;
        float f17 = f8 - f2;
        float f18 = f9 - f3;
        float f19 = f10 - f4;
        float f20 = f11 - f2;
        float f21 = f12 - f3;
        float f22 = f13 - f4;
        float f23 = f2;
        float f24 = f3;
        float f25 = f4;
        float f26 = f20 * f14 + f21 * f15 + f22 * f16;
        float f27 = f14 * f14 + f15 * f15 + f16 * f16;
        if (f26 >= f27) {
            f23 += f14;
            f24 += f15;
            f25 += f16;
        } else if (f26 > 0.0f) {
            f23 += f26 / f27 * f14;
            f24 += f26 / f27 * f15;
            f25 += f26 / f27 * f16;
        }
        f26 = f20 * f17 + f21 * f18 + f22 * f19;
        f27 = f17 * f17 + f18 * f18 + f19 * f19;
        if (f26 >= f27) {
            f23 += f17;
            f24 += f18;
            f25 += f19;
        } else if (f26 > 0.0f) {
            f23 += f26 / f27 * f17;
            f24 += f26 / f27 * f18;
            f25 += f26 / f27 * f19;
        }
        vector3f.x = f23;
        vector3f.y = f24;
        vector3f.z = f25;
        return vector3f;
    }

    public static int intersectSweptSphereTriangle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19, Vector4f vector4f) {
        float f20;
        float f21;
        float f22;
        float f23;
        float f24;
        float f25;
        float f26;
        float f27;
        float f28;
        float f29;
        float f30;
        float f31;
        float f32;
        float f33;
        float f34;
        float f35;
        float f36;
        float f37;
        float f38;
        float f39;
        float f40;
        float f41;
        float f42;
        float f43;
        float f44;
        float f45;
        float f46;
        float f47;
        float f48;
        float f49;
        float f50;
        float f51;
        float f52;
        float f53;
        float f54;
        float f55;
        float f56;
        float f57;
        float f58;
        float f59;
        float f60;
        float f61;
        float f62;
        float f63;
        float f64;
        float f65 = f12 - f9;
        float f66 = f13 - f10;
        float f67 = f14 - f11;
        float f68 = f15 - f9;
        float f69 = f16 - f10;
        float f70 = f17 - f11;
        float f71 = f66 * f70 - f69 * f67;
        float f72 = f67 * f68 - f70 * f65;
        float f73 = f65 * f69 - f68 * f66;
        float f74 = -(f71 * f9 + f72 * f10 + f73 * f11);
        float f75 = Math.invsqrt(f71 * f71 + f72 * f72 + f73 * f73);
        float f76 = (f71 * f2 + f72 * f3 + f73 * f4 + f74) * f75;
        float f77 = (f71 * f6 + f72 * f7 + f73 * f8) * f75;
        if (f77 < f18 && f77 > -f18) {
            return 0;
        }
        float f78 = (f5 - f76) / f77;
        if (f78 > f19) {
            return 0;
        }
        float f79 = (-f5 - f76) / f77;
        float f80 = f2 - f5 * f71 * f75 + f6 * f78;
        float f81 = f3 - f5 * f72 * f75 + f7 * f78;
        float f82 = f4 - f5 * f73 * f75 + f8 * f78;
        boolean bl2 = Intersectionf.testPointInTriangle(f80, f81, f82, f9, f10, f11, f12, f13, f14, f15, f16, f17);
        if (bl2) {
            vector4f.x = f80;
            vector4f.y = f81;
            vector4f.z = f82;
            vector4f.w = f78;
            return 7;
        }
        int n2 = 0;
        float f83 = f6 * f6 + f7 * f7 + f8 * f8;
        float f84 = f2 - f9;
        float f85 = f3 - f10;
        float f86 = f4 - f11;
        float f87 = 2.0f * (f6 * f84 + f7 * f85 + f8 * f86);
        float f88 = f5 * f5;
        float f89 = f84 * f84 + f85 * f85 + f86 * f86 - f88;
        float f90 = f19;
        float f91 = Intersectionf.computeLowestRoot(f83, f87, f89, f90);
        if (f91 < f90) {
            vector4f.x = f9;
            vector4f.y = f10;
            vector4f.z = f11;
            vector4f.w = f91;
            f90 = f91;
            n2 = 1;
        }
        if ((f64 = Intersectionf.computeLowestRoot(f83, f63 = 2.0f * (f6 * (f62 = f2 - f12) + f7 * (f61 = f3 - f13) + f8 * (f60 = f4 - f14)), f59 = (f58 = f62 * f62 + f61 * f61 + f60 * f60) - f88, f90)) < f90) {
            vector4f.x = f12;
            vector4f.y = f13;
            vector4f.z = f14;
            vector4f.w = f64;
            f90 = f64;
            n2 = 2;
        }
        if ((f57 = Intersectionf.computeLowestRoot(f83, f56 = 2.0f * (f6 * (f55 = f2 - f15) + f7 * (f54 = f3 - f16) + f8 * (f53 = f4 - f17)), f52 = f55 * f55 + f54 * f54 + f53 * f53 - f88, f90)) < f90) {
            vector4f.x = f15;
            vector4f.y = f16;
            vector4f.z = f17;
            vector4f.w = f57;
            f90 = f57;
            n2 = 3;
        }
        if ((f51 = ((f50 = f65 * f6 + f66 * f7 + f67 * f8) * (f49 = Intersectionf.computeLowestRoot(f48 = (f47 = f65 * f65 + f66 * f66 + f67 * f67) * -(f46 = f6 * f6 + f7 * f7 + f8 * f8) + f50 * f50, f45 = f47 * 2.0f * (f44 = f6 * -f84 + f7 * -f85 + f8 * -f86) - 2.0f * f50 * (f43 = f65 * -f84 + f66 * -f85 + f67 * -f86), f42 = f47 * (f88 - (f41 = f84 * f84 + f85 * f85 + f86 * f86)) + f43 * f43, f90)) - f43) / f47) >= 0.0f && f51 <= 1.0f && f49 < f90) {
            vector4f.x = f9 + f51 * f65;
            vector4f.y = f10 + f51 * f66;
            vector4f.z = f11 + f51 * f67;
            vector4f.w = f49;
            f90 = f49;
            n2 = 4;
        }
        if ((f40 = ((f39 = f68 * f6 + f69 * f7 + f70 * f8) * (f38 = Intersectionf.computeLowestRoot(f37 = (f36 = f68 * f68 + f69 * f69 + f70 * f70) * -f46 + f39 * f39, f35 = f36 * 2.0f * f44 - 2.0f * f39 * (f34 = f68 * -f84 + f69 * -f85 + f70 * -f86), f33 = f36 * (f88 - f41) + f34 * f34, f90)) - f34) / f36) >= 0.0f && f40 <= 1.0f && f38 < f79) {
            vector4f.x = f9 + f40 * f68;
            vector4f.y = f10 + f40 * f69;
            vector4f.z = f11 + f40 * f70;
            vector4f.w = f38;
            f90 = f38;
            n2 = 6;
        }
        if ((f32 = ((f31 = (f30 = f15 - f12) * f6 + (f29 = f16 - f13) * f7 + (f28 = f17 - f14) * f8) * (f27 = Intersectionf.computeLowestRoot(f26 = (f25 = f30 * f30 + f29 * f29 + f28 * f28) * -f46 + f31 * f31, f24 = f25 * 2.0f * (f23 = f6 * -f62 + f7 * -f61 + f8 * -f60) - 2.0f * f31 * (f22 = f30 * -f62 + f29 * -f61 + f28 * -f60), f21 = f25 * (f88 - (f20 = f58)) + f22 * f22, f90)) - f22) / f25) >= 0.0f && f32 <= 1.0f && f27 < f90) {
            vector4f.x = f12 + f32 * f30;
            vector4f.y = f13 + f32 * f29;
            vector4f.z = f14 + f32 * f28;
            vector4f.w = f27;
            f90 = f27;
            n2 = 5;
        }
        return n2;
    }

    private static float computeLowestRoot(float f2, float f3, float f4, float f5) {
        float f6;
        float f7 = f3 * f3 - 4.0f * f2 * f4;
        if (f7 < 0.0f) {
            return Float.POSITIVE_INFINITY;
        }
        float f8 = Math.sqrt(f7);
        float f9 = (-f3 - f8) / (2.0f * f2);
        if (f9 > (f6 = (-f3 + f8) / (2.0f * f2))) {
            float f10 = f6;
            f6 = f9;
            f9 = f10;
        }
        if (f9 > 0.0f && f9 < f5) {
            return f9;
        }
        if (f6 > 0.0f && f6 < f5) {
            return f6;
        }
        return Float.POSITIVE_INFINITY;
    }

    public static boolean testPointInTriangle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        float f14 = f2 - f5;
        float f15 = f8 - f5;
        float f16 = f3 - f6;
        float f17 = f9 - f6;
        float f18 = f4 - f7;
        float f19 = f10 - f7;
        float f20 = f14 * f15 + f16 * f17 + f18 * f19;
        float f21 = f11 - f5;
        float f22 = f12 - f6;
        float f23 = f13 - f7;
        float f24 = f21 * f21 + f22 * f22 + f23 * f23;
        float f25 = f14 * f21 + f16 * f22 + f18 * f23;
        float f26 = f15 * f21 + f17 * f22 + f19 * f23;
        float f27 = f20 * f24 - f25 * f26;
        float f28 = f15 * f15 + f17 * f17 + f19 * f19;
        float f29 = f25 * f28 - f20 * f26;
        float f30 = f28 * f24 - f26 * f26;
        float f31 = f27 + f29 - f30;
        return ((long)(Runtime.floatToIntBits(f31) & ~(Runtime.floatToIntBits(f27) | Runtime.floatToIntBits(f29))) & Long.MIN_VALUE) != 0L;
    }

    public static boolean intersectRaySphere(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, Vector2f vector2f) {
        float f12;
        float f13 = f8 - f2;
        float f14 = f9 - f3;
        float f15 = f10 - f4;
        float f16 = f13 * f5 + f14 * f6 + f15 * f7;
        float f17 = f13 * f13 + f14 * f14 + f15 * f15 - f16 * f16;
        if (f17 > f11) {
            return false;
        }
        float f18 = Math.sqrt(f11 - f17);
        float f19 = f16 - f18;
        if (f19 < (f12 = f16 + f18) && f12 >= 0.0f) {
            vector2f.x = f19;
            vector2f.y = f12;
            return true;
        }
        return false;
    }

    public static boolean intersectRaySphere(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, float f2, Vector2f vector2f) {
        return Intersectionf.intersectRaySphere(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), f2, vector2f);
    }

    public static boolean testRaySphere(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        float f12;
        float f13 = f8 - f2;
        float f14 = f9 - f3;
        float f15 = f10 - f4;
        float f16 = f13 * f5 + f14 * f6 + f15 * f7;
        float f17 = f13 * f13 + f14 * f14 + f15 * f15 - f16 * f16;
        if (f17 > f11) {
            return false;
        }
        float f18 = Math.sqrt(f11 - f17);
        float f19 = f16 - f18;
        return f19 < (f12 = f16 + f18) && f12 >= 0.0f;
    }

    public static boolean testRaySphere(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, float f2) {
        return Intersectionf.testRaySphere(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), f2);
    }

    public static boolean testLineSegmentSphere(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        float f12;
        float f13 = f5 - f2;
        float f14 = f6 - f3;
        float f15 = f7 - f4;
        float f16 = (f8 - f2) * f13 + (f9 - f3) * f14 + (f10 - f4) * f15;
        float f17 = f13 * f13 + f14 * f14 + f15 * f15;
        float f18 = f16 / f17;
        if (f18 < 0.0f) {
            f13 = f2 - f8;
            f14 = f3 - f9;
            f15 = f4 - f10;
        } else if (f18 > 1.0f) {
            f13 = f5 - f8;
            f14 = f6 - f9;
            f15 = f7 - f10;
        } else {
            f12 = f2 + f18 * f13;
            float f19 = f3 + f18 * f14;
            float f20 = f4 + f18 * f15;
            f13 = f12 - f8;
            f14 = f19 - f9;
            f15 = f20 - f10;
        }
        f12 = f13 * f13 + f14 * f14 + f15 * f15;
        return f12 <= f11;
    }

    public static boolean testLineSegmentSphere(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, float f2) {
        return Intersectionf.testLineSegmentSphere(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), f2);
    }

    public static boolean intersectRayAab(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, Vector2f vector2f) {
        float f14;
        float f15;
        float f16;
        float f17;
        float f18;
        float f19;
        float f20 = 1.0f / f5;
        float f21 = 1.0f / f6;
        float f22 = 1.0f / f7;
        if (f20 >= 0.0f) {
            f19 = (f8 - f2) * f20;
            f18 = (f11 - f2) * f20;
        } else {
            f19 = (f11 - f2) * f20;
            f18 = (f8 - f2) * f20;
        }
        if (f21 >= 0.0f) {
            f17 = (f9 - f3) * f21;
            f16 = (f12 - f3) * f21;
        } else {
            f17 = (f12 - f3) * f21;
            f16 = (f9 - f3) * f21;
        }
        if (f19 > f16 || f17 > f18) {
            return false;
        }
        if (f22 >= 0.0f) {
            f15 = (f10 - f4) * f22;
            f14 = (f13 - f4) * f22;
        } else {
            f15 = (f13 - f4) * f22;
            f14 = (f10 - f4) * f22;
        }
        if (f19 > f14 || f15 > f18) {
            return false;
        }
        f19 = f17 > f19 || Float.isNaN(f19) ? f17 : f19;
        f18 = f16 < f18 || Float.isNaN(f18) ? f16 : f18;
        f19 = f15 > f19 ? f15 : f19;
        float f23 = f18 = f14 < f18 ? f14 : f18;
        if (f19 < f18 && f18 >= 0.0f) {
            vector2f.x = f19;
            vector2f.y = f18;
            return true;
        }
        return false;
    }

    public static boolean intersectRayAab(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Vector3fc vector3fc4, Vector2f vector2f) {
        return Intersectionf.intersectRayAab(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), vector3fc4.x(), vector3fc4.y(), vector3fc4.z(), vector2f);
    }

    public static int intersectLineSegmentAab(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, Vector2f vector2f) {
        float f14;
        float f15;
        float f16;
        float f17;
        float f18;
        float f19;
        float f20 = f5 - f2;
        float f21 = f6 - f3;
        float f22 = f7 - f4;
        float f23 = 1.0f / f20;
        float f24 = 1.0f / f21;
        float f25 = 1.0f / f22;
        if (f23 >= 0.0f) {
            f19 = (f8 - f2) * f23;
            f18 = (f11 - f2) * f23;
        } else {
            f19 = (f11 - f2) * f23;
            f18 = (f8 - f2) * f23;
        }
        if (f24 >= 0.0f) {
            f17 = (f9 - f3) * f24;
            f16 = (f12 - f3) * f24;
        } else {
            f17 = (f12 - f3) * f24;
            f16 = (f9 - f3) * f24;
        }
        if (f19 > f16 || f17 > f18) {
            return -1;
        }
        if (f25 >= 0.0f) {
            f15 = (f10 - f4) * f25;
            f14 = (f13 - f4) * f25;
        } else {
            f15 = (f13 - f4) * f25;
            f14 = (f10 - f4) * f25;
        }
        if (f19 > f14 || f15 > f18) {
            return -1;
        }
        f19 = f17 > f19 || Float.isNaN(f19) ? f17 : f19;
        f18 = f16 < f18 || Float.isNaN(f18) ? f16 : f18;
        f19 = f15 > f19 ? f15 : f19;
        f18 = f14 < f18 ? f14 : f18;
        int n2 = -1;
        if (f19 <= f18 && f19 <= 1.0f && f18 >= 0.0f) {
            if (f19 >= 0.0f && f18 > 1.0f) {
                f18 = f19;
                n2 = 1;
            } else if (f19 < 0.0f && f18 <= 1.0f) {
                f19 = f18;
                n2 = 1;
            } else {
                n2 = f19 < 0.0f && f18 > 1.0f ? 3 : 2;
            }
            vector2f.x = f19;
            vector2f.y = f18;
        }
        return n2;
    }

    public static int intersectLineSegmentAab(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Vector3fc vector3fc4, Vector2f vector2f) {
        return Intersectionf.intersectLineSegmentAab(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), vector3fc4.x(), vector3fc4.y(), vector3fc4.z(), vector2f);
    }

    public static boolean testRayAab(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13) {
        float f14;
        float f15;
        float f16;
        float f17;
        float f18;
        float f19;
        float f20 = 1.0f / f5;
        float f21 = 1.0f / f6;
        float f22 = 1.0f / f7;
        if (f20 >= 0.0f) {
            f19 = (f8 - f2) * f20;
            f18 = (f11 - f2) * f20;
        } else {
            f19 = (f11 - f2) * f20;
            f18 = (f8 - f2) * f20;
        }
        if (f21 >= 0.0f) {
            f17 = (f9 - f3) * f21;
            f16 = (f12 - f3) * f21;
        } else {
            f17 = (f12 - f3) * f21;
            f16 = (f9 - f3) * f21;
        }
        if (f19 > f16 || f17 > f18) {
            return false;
        }
        if (f22 >= 0.0f) {
            f15 = (f10 - f4) * f22;
            f14 = (f13 - f4) * f22;
        } else {
            f15 = (f13 - f4) * f22;
            f14 = (f10 - f4) * f22;
        }
        if (f19 > f14 || f15 > f18) {
            return false;
        }
        f19 = f17 > f19 || Float.isNaN(f19) ? f17 : f19;
        f18 = f16 < f18 || Float.isNaN(f18) ? f16 : f18;
        f19 = f15 > f19 ? f15 : f19;
        f18 = f14 < f18 ? f14 : f18;
        return f19 < f18 && f18 >= 0.0f;
    }

    public static boolean testRayAab(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Vector3fc vector3fc4) {
        return Intersectionf.testRayAab(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), vector3fc4.x(), vector3fc4.y(), vector3fc4.z());
    }

    public static boolean testRayTriangleFront(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17) {
        float f18 = f11 - f8;
        float f19 = f16 - f10;
        float f20 = f15 - f9;
        float f21 = f6 * f19 - f7 * f20;
        float f22 = f12 - f9;
        float f23 = f14 - f8;
        float f24 = f7 * f23 - f5 * f19;
        float f25 = f13 - f10;
        float f26 = f5 * f20 - f6 * f23;
        float f27 = f18 * f21 + f22 * f24 + f25 * f26;
        if (f27 < f17) {
            return false;
        }
        float f28 = f2 - f8;
        float f29 = f3 - f9;
        float f30 = f4 - f10;
        float f31 = f28 * f21 + f29 * f24 + f30 * f26;
        if (f31 < 0.0f || f31 > f27) {
            return false;
        }
        float f32 = f29 * f25 - f30 * f22;
        float f33 = f30 * f18 - f28 * f25;
        float f34 = f28 * f22 - f29 * f18;
        float f35 = f5 * f32 + f6 * f33 + f7 * f34;
        if (f35 < 0.0f || f31 + f35 > f27) {
            return false;
        }
        float f36 = 1.0f / f27;
        float f37 = (f23 * f32 + f20 * f33 + f19 * f34) * f36;
        return f37 >= f17;
    }

    public static boolean testRayTriangleFront(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Vector3fc vector3fc4, Vector3fc vector3fc5, float f2) {
        return Intersectionf.testRayTriangleFront(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), vector3fc4.x(), vector3fc4.y(), vector3fc4.z(), vector3fc5.x(), vector3fc5.y(), vector3fc5.z(), f2);
    }

    public static boolean testRayTriangle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17) {
        float f18 = f11 - f8;
        float f19 = f16 - f10;
        float f20 = f15 - f9;
        float f21 = f6 * f19 - f7 * f20;
        float f22 = f12 - f9;
        float f23 = f14 - f8;
        float f24 = f7 * f23 - f5 * f19;
        float f25 = f13 - f10;
        float f26 = f5 * f20 - f6 * f23;
        float f27 = f18 * f21 + f22 * f24 + f25 * f26;
        if (f27 > -f17 && f27 < f17) {
            return false;
        }
        float f28 = f2 - f8;
        float f29 = f3 - f9;
        float f30 = f4 - f10;
        float f31 = 1.0f / f27;
        float f32 = (f28 * f21 + f29 * f24 + f30 * f26) * f31;
        if (f32 < 0.0f || f32 > 1.0f) {
            return false;
        }
        float f33 = f29 * f25 - f30 * f22;
        float f34 = f30 * f18 - f28 * f25;
        float f35 = f28 * f22 - f29 * f18;
        float f36 = (f5 * f33 + f6 * f34 + f7 * f35) * f31;
        if (f36 < 0.0f || f32 + f36 > 1.0f) {
            return false;
        }
        float f37 = (f23 * f33 + f20 * f34 + f19 * f35) * f31;
        return f37 >= f17;
    }

    public static boolean testRayTriangle(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Vector3fc vector3fc4, Vector3fc vector3fc5, float f2) {
        return Intersectionf.testRayTriangle(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), vector3fc4.x(), vector3fc4.y(), vector3fc4.z(), vector3fc5.x(), vector3fc5.y(), vector3fc5.z(), f2);
    }

    public static float intersectRayTriangleFront(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17) {
        float f18 = f11 - f8;
        float f19 = f16 - f10;
        float f20 = f15 - f9;
        float f21 = f6 * f19 - f7 * f20;
        float f22 = f12 - f9;
        float f23 = f14 - f8;
        float f24 = f7 * f23 - f5 * f19;
        float f25 = f13 - f10;
        float f26 = f5 * f20 - f6 * f23;
        float f27 = f18 * f21 + f22 * f24 + f25 * f26;
        if (f27 <= f17) {
            return -1.0f;
        }
        float f28 = f2 - f8;
        float f29 = f3 - f9;
        float f30 = f4 - f10;
        float f31 = f28 * f21 + f29 * f24 + f30 * f26;
        if (f31 < 0.0f || f31 > f27) {
            return -1.0f;
        }
        float f32 = f29 * f25 - f30 * f22;
        float f33 = f30 * f18 - f28 * f25;
        float f34 = f28 * f22 - f29 * f18;
        float f35 = f5 * f32 + f6 * f33 + f7 * f34;
        if (f35 < 0.0f || f31 + f35 > f27) {
            return -1.0f;
        }
        float f36 = 1.0f / f27;
        float f37 = (f23 * f32 + f20 * f33 + f19 * f34) * f36;
        return f37;
    }

    public static float intersectRayTriangleFront(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Vector3fc vector3fc4, Vector3fc vector3fc5, float f2) {
        return Intersectionf.intersectRayTriangleFront(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), vector3fc4.x(), vector3fc4.y(), vector3fc4.z(), vector3fc5.x(), vector3fc5.y(), vector3fc5.z(), f2);
    }

    public static float intersectRayTriangle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17) {
        float f18 = f11 - f8;
        float f19 = f16 - f10;
        float f20 = f15 - f9;
        float f21 = f6 * f19 - f7 * f20;
        float f22 = f12 - f9;
        float f23 = f14 - f8;
        float f24 = f7 * f23 - f5 * f19;
        float f25 = f13 - f10;
        float f26 = f5 * f20 - f6 * f23;
        float f27 = f18 * f21 + f22 * f24 + f25 * f26;
        if (f27 > -f17 && f27 < f17) {
            return -1.0f;
        }
        float f28 = f2 - f8;
        float f29 = f3 - f9;
        float f30 = f4 - f10;
        float f31 = 1.0f / f27;
        float f32 = (f28 * f21 + f29 * f24 + f30 * f26) * f31;
        if (f32 < 0.0f || f32 > 1.0f) {
            return -1.0f;
        }
        float f33 = f29 * f25 - f30 * f22;
        float f34 = f30 * f18 - f28 * f25;
        float f35 = f28 * f22 - f29 * f18;
        float f36 = (f5 * f33 + f6 * f34 + f7 * f35) * f31;
        if (f36 < 0.0f || f32 + f36 > 1.0f) {
            return -1.0f;
        }
        float f37 = (f23 * f33 + f20 * f34 + f19 * f35) * f31;
        return f37;
    }

    public static float intersectRayTriangle(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Vector3fc vector3fc4, Vector3fc vector3fc5, float f2) {
        return Intersectionf.intersectRayTriangle(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), vector3fc4.x(), vector3fc4.y(), vector3fc4.z(), vector3fc5.x(), vector3fc5.y(), vector3fc5.z(), f2);
    }

    public static boolean testLineSegmentTriangle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17) {
        float f18 = f5 - f2;
        float f19 = f6 - f3;
        float f20 = f7 - f4;
        float f21 = Intersectionf.intersectRayTriangle(f2, f3, f4, f18, f19, f20, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17);
        return f21 >= 0.0f && f21 <= 1.0f;
    }

    public static boolean testLineSegmentTriangle(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Vector3fc vector3fc4, Vector3fc vector3fc5, float f2) {
        return Intersectionf.testLineSegmentTriangle(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), vector3fc4.x(), vector3fc4.y(), vector3fc4.z(), vector3fc5.x(), vector3fc5.y(), vector3fc5.z(), f2);
    }

    public static boolean intersectLineSegmentTriangle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, Vector3f vector3f) {
        float f18 = f5 - f2;
        float f19 = f6 - f3;
        float f20 = f7 - f4;
        float f21 = Intersectionf.intersectRayTriangle(f2, f3, f4, f18, f19, f20, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17);
        if (f21 >= 0.0f && f21 <= 1.0f) {
            vector3f.x = f2 + f18 * f21;
            vector3f.y = f3 + f19 * f21;
            vector3f.z = f4 + f20 * f21;
            return true;
        }
        return false;
    }

    public static boolean intersectLineSegmentTriangle(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, Vector3fc vector3fc4, Vector3fc vector3fc5, float f2, Vector3f vector3f) {
        return Intersectionf.intersectLineSegmentTriangle(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), vector3fc3.x(), vector3fc3.y(), vector3fc3.z(), vector3fc4.x(), vector3fc4.y(), vector3fc4.z(), vector3fc5.x(), vector3fc5.y(), vector3fc5.z(), f2, vector3f);
    }

    public static boolean intersectLineSegmentPlane(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, Vector3f vector3f) {
        float f12 = f5 - f2;
        float f13 = f6 - f3;
        float f14 = f7 - f4;
        float f15 = f8 * f12 + f9 * f13 + f10 * f14;
        float f16 = -(f8 * f2 + f9 * f3 + f10 * f4 + f11) / f15;
        if (f16 >= 0.0f && f16 <= 1.0f) {
            vector3f.x = f2 + f16 * f12;
            vector3f.y = f3 + f16 * f13;
            vector3f.z = f4 + f16 * f14;
            return true;
        }
        return false;
    }

    public static boolean testLineCircle(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = Math.sqrt(f2 * f2 + f3 * f3);
        float f9 = (f2 * f5 + f3 * f6 + f4) / f8;
        return -f7 <= f9 && f9 <= f7;
    }

    public static boolean intersectLineCircle(float f2, float f3, float f4, float f5, float f6, float f7, Vector3f vector3f) {
        float f8 = Math.invsqrt(f2 * f2 + f3 * f3);
        float f9 = (f2 * f5 + f3 * f6 + f4) * f8;
        if (-f7 <= f9 && f9 <= f7) {
            vector3f.x = f5 + f9 * f2 * f8;
            vector3f.y = f6 + f9 * f3 * f8;
            vector3f.z = Math.sqrt(f7 * f7 - f9 * f9);
            return true;
        }
        return false;
    }

    public static boolean intersectLineCircle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, Vector3f vector3f) {
        return Intersectionf.intersectLineCircle(f3 - f5, f4 - f2, (f2 - f4) * f3 + (f5 - f3) * f2, f6, f7, f8, vector3f);
    }

    public static boolean testAarLine(float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9;
        float f10;
        float f11;
        float f12;
        if (f6 > 0.0f) {
            f12 = f4;
            f11 = f2;
        } else {
            f12 = f2;
            f11 = f4;
        }
        if (f7 > 0.0f) {
            f10 = f5;
            f9 = f3;
        } else {
            f10 = f3;
            f9 = f5;
        }
        float f13 = f8 + f6 * f11 + f7 * f9;
        float f14 = f8 + f6 * f12 + f7 * f10;
        return f13 <= 0.0f && f14 >= 0.0f;
    }

    public static boolean testAarLine(Vector2fc vector2fc, Vector2fc vector2fc2, float f2, float f3, float f4) {
        return Intersectionf.testAarLine(vector2fc.x(), vector2fc.y(), vector2fc2.x(), vector2fc2.y(), f2, f3, f4);
    }

    public static boolean testAarLine(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f7 - f9;
        float f11 = f8 - f6;
        float f12 = -f11 * f7 - f10 * f6;
        return Intersectionf.testAarLine(f2, f3, f4, f5, f10, f11, f12);
    }

    public static boolean testAarAar(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        return f4 >= f6 && f5 >= f7 && f2 <= f8 && f3 <= f9;
    }

    public static boolean testAarAar(Vector2fc vector2fc, Vector2fc vector2fc2, Vector2fc vector2fc3, Vector2fc vector2fc4) {
        return Intersectionf.testAarAar(vector2fc.x(), vector2fc.y(), vector2fc2.x(), vector2fc2.y(), vector2fc3.x(), vector2fc3.y(), vector2fc4.x(), vector2fc4.y());
    }

    public static boolean testMovingCircleCircle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10;
        float f11 = f6 + f9;
        float f12 = Math.sqrt((f2 - f7) * (f2 - f7) + (f3 - f8) * (f3 - f8)) - f11;
        float f13 = Math.sqrt(f4 * f4 + f5 * f5);
        if (f13 < f12) {
            return false;
        }
        float f14 = 1.0f / f13;
        float f15 = f4 * f14;
        float f16 = f7 - f2;
        float f17 = f5 * f14;
        float f18 = f8 - f3;
        float f19 = f15 * f16 + f17 * f18;
        if (f19 <= 0.0f) {
            return false;
        }
        float f20 = Math.sqrt(f16 * f16 + f18 * f18);
        float f21 = f20 * f20 - f19 * f19;
        if (f21 >= (f10 = f11 * f11)) {
            return false;
        }
        float f22 = f10 - f21;
        if (f22 < 0.0f) {
            return false;
        }
        float f23 = f13;
        float f24 = f19 - Math.sqrt(f22);
        return !(f23 < f24);
    }

    public static boolean testMovingCircleCircle(Vector2f vector2f, Vector2f vector2f2, float f2, Vector2f vector2f3, float f3) {
        return Intersectionf.testMovingCircleCircle(vector2f.x, vector2f.y, vector2f2.x, vector2f2.y, f2, vector2f3.x, vector2f3.y, f3);
    }

    public static boolean intersectCircleCircle(float f2, float f3, float f4, float f5, float f6, float f7, Vector3f vector3f) {
        float f8 = f5 - f2;
        float f9 = f6 - f3;
        float f10 = f8 * f8 + f9 * f9;
        float f11 = 0.5f + (f4 - f7) / f10;
        float f12 = Math.sqrt(f4 - f11 * f11 * f10);
        if (f12 >= 0.0f) {
            vector3f.x = f2 + f11 * f8;
            vector3f.y = f3 + f11 * f9;
            vector3f.z = f12;
            return true;
        }
        return false;
    }

    public static boolean intersectCircleCircle(Vector2fc vector2fc, float f2, Vector2fc vector2fc2, float f3, Vector3f vector3f) {
        return Intersectionf.intersectCircleCircle(vector2fc.x(), vector2fc.y(), f2, vector2fc2.x(), vector2fc2.y(), f3, vector3f);
    }

    public static boolean testCircleCircle(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = (f2 - f5) * (f2 - f5) + (f3 - f6) * (f3 - f6);
        return f8 <= (f4 + f7) * (f4 + f7);
    }

    public static boolean testCircleCircle(Vector2fc vector2fc, float f2, Vector2fc vector2fc2, float f3) {
        return Intersectionf.testCircleCircle(vector2fc.x(), vector2fc.y(), f2, vector2fc2.x(), vector2fc2.y(), f3);
    }

    public static float distancePointLine(float f2, float f3, float f4, float f5, float f6) {
        float f7 = Math.sqrt(f4 * f4 + f5 * f5);
        return (f4 * f2 + f5 * f3 + f6) / f7;
    }

    public static float distancePointLine(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f6 - f4;
        float f9 = f7 - f5;
        float f10 = Math.sqrt(f8 * f8 + f9 * f9);
        return (f8 * (f5 - f3) - (f4 - f2) * f9) / f10;
    }

    public static float distancePointLine(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        float f11 = f8 - f5;
        float f12 = f9 - f6;
        float f13 = f10 - f7;
        float f14 = f5 - f2;
        float f15 = f6 - f3;
        float f16 = f7 - f4;
        float f17 = f12 * f16 - f13 * f15;
        float f18 = f13 * f14 - f11 * f16;
        float f19 = f11 * f15 - f12 * f14;
        return Math.sqrt((f17 * f17 + f18 * f18 + f19 * f19) / (f11 * f11 + f12 * f12 + f13 * f13));
    }

    public static float intersectRayLine(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        float f11;
        float f12 = f8 * f4 + f9 * f5;
        if (f12 < f10 && (f11 = ((f6 - f2) * f8 + (f7 - f3) * f9) / f12) >= 0.0f) {
            return f11;
        }
        return -1.0f;
    }

    public static float intersectRayLine(Vector2fc vector2fc, Vector2fc vector2fc2, Vector2fc vector2fc3, Vector2fc vector2fc4, float f2) {
        return Intersectionf.intersectRayLine(vector2fc.x(), vector2fc.y(), vector2fc2.x(), vector2fc2.y(), vector2fc3.x(), vector2fc3.y(), vector2fc4.x(), vector2fc4.y(), f2);
    }

    public static float intersectRayLineSegment(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f2 - f6;
        float f11 = f3 - f7;
        float f12 = f8 - f6;
        float f13 = f9 - f7;
        float f14 = 1.0f / (f13 * f4 - f12 * f5);
        float f15 = (f12 * f11 - f13 * f10) * f14;
        float f16 = (f11 * f4 - f10 * f5) * f14;
        if (f15 >= 0.0f && f16 >= 0.0f && f16 <= 1.0f) {
            return f15;
        }
        return -1.0f;
    }

    public static float intersectRayLineSegment(Vector2fc vector2fc, Vector2fc vector2fc2, Vector2fc vector2fc3, Vector2fc vector2fc4) {
        return Intersectionf.intersectRayLineSegment(vector2fc.x(), vector2fc.y(), vector2fc2.x(), vector2fc2.y(), vector2fc3.x(), vector2fc3.y(), vector2fc4.x(), vector2fc4.y());
    }

    public static boolean testAarCircle(float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9;
        float f10 = f8;
        if (f6 < f2) {
            f9 = f6 - f2;
            f10 -= f9 * f9;
        } else if (f6 > f4) {
            f9 = f6 - f4;
            f10 -= f9 * f9;
        }
        if (f7 < f3) {
            f9 = f7 - f3;
            f10 -= f9 * f9;
        } else if (f7 > f5) {
            f9 = f7 - f5;
            f10 -= f9 * f9;
        }
        return f10 >= 0.0f;
    }

    public static boolean testAarCircle(Vector2fc vector2fc, Vector2fc vector2fc2, Vector2fc vector2fc3, float f2) {
        return Intersectionf.testAarCircle(vector2fc.x(), vector2fc.y(), vector2fc2.x(), vector2fc2.y(), vector2fc3.x(), vector2fc3.y(), f2);
    }

    public static int findClosestPointOnTriangle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Vector2f vector2f) {
        float f10 = f4 - f2;
        float f11 = f5 - f3;
        float f12 = f6 - f2;
        float f13 = f7 - f3;
        float f14 = f8 - f2;
        float f15 = f9 - f3;
        float f16 = f10 * f14 + f11 * f15;
        float f17 = f12 * f14 + f13 * f15;
        if (f16 <= 0.0f && f17 <= 0.0f) {
            vector2f.x = f2;
            vector2f.y = f3;
            return 1;
        }
        float f18 = f8 - f4;
        float f19 = f9 - f5;
        float f20 = f10 * f18 + f11 * f19;
        float f21 = f12 * f18 + f13 * f19;
        if (f20 >= 0.0f && f21 <= f20) {
            vector2f.x = f4;
            vector2f.y = f5;
            return 2;
        }
        float f22 = f16 * f21 - f20 * f17;
        if (f22 <= 0.0f && f16 >= 0.0f && f20 <= 0.0f) {
            float f23 = f16 / (f16 - f20);
            vector2f.x = f2 + f23 * f10;
            vector2f.y = f3 + f23 * f11;
            return 4;
        }
        float f24 = f8 - f6;
        float f25 = f9 - f7;
        float f26 = f10 * f24 + f11 * f25;
        float f27 = f12 * f24 + f13 * f25;
        if (f27 >= 0.0f && f26 <= f27) {
            vector2f.x = f6;
            vector2f.y = f7;
            return 3;
        }
        float f28 = f26 * f17 - f16 * f27;
        if (f28 <= 0.0f && f17 >= 0.0f && f27 <= 0.0f) {
            float f29 = f17 / (f17 - f27);
            vector2f.x = f2 + f29 * f12;
            vector2f.y = f3 + f29 * f13;
            return 6;
        }
        float f30 = f20 * f27 - f26 * f21;
        if (f30 <= 0.0f && f21 - f20 >= 0.0f && f26 - f27 >= 0.0f) {
            float f31 = (f21 - f20) / (f21 - f20 + f26 - f27);
            vector2f.x = f4 + f31 * (f6 - f4);
            vector2f.y = f5 + f31 * (f7 - f5);
            return 5;
        }
        float f32 = 1.0f / (f30 + f28 + f22);
        float f33 = f28 * f32;
        float f34 = f22 * f32;
        vector2f.x = f2 + f10 * f33 + f12 * f34;
        vector2f.y = f3 + f11 * f33 + f13 * f34;
        return 7;
    }

    public static int findClosestPointOnTriangle(Vector2fc vector2fc, Vector2fc vector2fc2, Vector2fc vector2fc3, Vector2fc vector2fc4, Vector2f vector2f) {
        return Intersectionf.findClosestPointOnTriangle(vector2fc.x(), vector2fc.y(), vector2fc2.x(), vector2fc2.y(), vector2fc3.x(), vector2fc3.y(), vector2fc4.x(), vector2fc4.y(), vector2f);
    }

    public static boolean intersectRayCircle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, Vector2f vector2f) {
        float f9;
        float f10 = f6 - f2;
        float f11 = f7 - f3;
        float f12 = f10 * f4 + f11 * f5;
        float f13 = f10 * f10 + f11 * f11 - f12 * f12;
        if (f13 > f8) {
            return false;
        }
        float f14 = Math.sqrt(f8 - f13);
        float f15 = f12 - f14;
        if (f15 < (f9 = f12 + f14) && f9 >= 0.0f) {
            vector2f.x = f15;
            vector2f.y = f9;
            return true;
        }
        return false;
    }

    public static boolean intersectRayCircle(Vector2fc vector2fc, Vector2fc vector2fc2, Vector2fc vector2fc3, float f2, Vector2f vector2f) {
        return Intersectionf.intersectRayCircle(vector2fc.x(), vector2fc.y(), vector2fc2.x(), vector2fc2.y(), vector2fc3.x(), vector2fc3.y(), f2, vector2f);
    }

    public static boolean testRayCircle(float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9;
        float f10 = f6 - f2;
        float f11 = f7 - f3;
        float f12 = f10 * f4 + f11 * f5;
        float f13 = f10 * f10 + f11 * f11 - f12 * f12;
        if (f13 > f8) {
            return false;
        }
        float f14 = Math.sqrt(f8 - f13);
        float f15 = f12 - f14;
        return f15 < (f9 = f12 + f14) && f9 >= 0.0f;
    }

    public static boolean testRayCircle(Vector2fc vector2fc, Vector2fc vector2fc2, Vector2fc vector2fc3, float f2) {
        return Intersectionf.testRayCircle(vector2fc.x(), vector2fc.y(), vector2fc2.x(), vector2fc2.y(), vector2fc3.x(), vector2fc3.y(), f2);
    }

    public static int intersectRayAar(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Vector2f vector2f) {
        float f10;
        float f11;
        float f12;
        float f13;
        float f14 = 1.0f / f4;
        float f15 = 1.0f / f5;
        if (f14 >= 0.0f) {
            f13 = (f6 - f2) * f14;
            f12 = (f8 - f2) * f14;
        } else {
            f13 = (f8 - f2) * f14;
            f12 = (f6 - f2) * f14;
        }
        if (f15 >= 0.0f) {
            f11 = (f7 - f3) * f15;
            f10 = (f9 - f3) * f15;
        } else {
            f11 = (f9 - f3) * f15;
            f10 = (f7 - f3) * f15;
        }
        if (f13 > f10 || f11 > f12) {
            return -1;
        }
        f13 = f11 > f13 || Float.isNaN(f13) ? f11 : f13;
        f12 = f10 < f12 || Float.isNaN(f12) ? f10 : f12;
        int n2 = -1;
        if (f13 <= f12 && f12 >= 0.0f) {
            float f16 = f2 + f13 * f4;
            float f17 = f3 + f13 * f5;
            vector2f.x = f13;
            vector2f.y = f12;
            float f18 = Math.abs(f16 - f6);
            float f19 = Math.abs(f17 - f7);
            float f20 = Math.abs(f16 - f8);
            float f21 = Math.abs(f17 - f9);
            n2 = 0;
            float f22 = f18;
            if (f19 < f22) {
                f22 = f19;
                n2 = 1;
            }
            if (f20 < f22) {
                f22 = f20;
                n2 = 2;
            }
            if (f21 < f22) {
                n2 = 3;
            }
        }
        return n2;
    }

    public static int intersectRayAar(Vector2fc vector2fc, Vector2fc vector2fc2, Vector2fc vector2fc3, Vector2fc vector2fc4, Vector2f vector2f) {
        return Intersectionf.intersectRayAar(vector2fc.x(), vector2fc.y(), vector2fc2.x(), vector2fc2.y(), vector2fc3.x(), vector2fc3.y(), vector2fc4.x(), vector2fc4.y(), vector2f);
    }

    public static int intersectLineSegmentAar(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Vector2f vector2f) {
        float f10;
        float f11;
        float f12;
        float f13;
        float f14 = f4 - f2;
        float f15 = f5 - f3;
        float f16 = 1.0f / f14;
        float f17 = 1.0f / f15;
        if (f16 >= 0.0f) {
            f13 = (f6 - f2) * f16;
            f12 = (f8 - f2) * f16;
        } else {
            f13 = (f8 - f2) * f16;
            f12 = (f6 - f2) * f16;
        }
        if (f17 >= 0.0f) {
            f11 = (f7 - f3) * f17;
            f10 = (f9 - f3) * f17;
        } else {
            f11 = (f9 - f3) * f17;
            f10 = (f7 - f3) * f17;
        }
        if (f13 > f10 || f11 > f12) {
            return -1;
        }
        f13 = f11 > f13 || Float.isNaN(f13) ? f11 : f13;
        f12 = f10 < f12 || Float.isNaN(f12) ? f10 : f12;
        int n2 = -1;
        if (f13 <= f12 && f13 <= 1.0f && f12 >= 0.0f) {
            if (f13 >= 0.0f && f12 > 1.0f) {
                f12 = f13;
                n2 = 1;
            } else if (f13 < 0.0f && f12 <= 1.0f) {
                f13 = f12;
                n2 = 1;
            } else {
                n2 = f13 < 0.0f && f12 > 1.0f ? 3 : 2;
            }
            vector2f.x = f13;
            vector2f.y = f12;
        }
        return n2;
    }

    public static int intersectLineSegmentAar(Vector2fc vector2fc, Vector2fc vector2fc2, Vector2fc vector2fc3, Vector2fc vector2fc4, Vector2f vector2f) {
        return Intersectionf.intersectLineSegmentAar(vector2fc.x(), vector2fc.y(), vector2fc2.x(), vector2fc2.y(), vector2fc3.x(), vector2fc3.y(), vector2fc4.x(), vector2fc4.y(), vector2f);
    }

    public static boolean testRayAar(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10;
        float f11;
        float f12;
        float f13;
        float f14 = 1.0f / f4;
        float f15 = 1.0f / f5;
        if (f14 >= 0.0f) {
            f13 = (f6 - f2) * f14;
            f12 = (f8 - f2) * f14;
        } else {
            f13 = (f8 - f2) * f14;
            f12 = (f6 - f2) * f14;
        }
        if (f15 >= 0.0f) {
            f11 = (f7 - f3) * f15;
            f10 = (f9 - f3) * f15;
        } else {
            f11 = (f9 - f3) * f15;
            f10 = (f7 - f3) * f15;
        }
        if (f13 > f10 || f11 > f12) {
            return false;
        }
        f13 = f11 > f13 || Float.isNaN(f13) ? f11 : f13;
        f12 = f10 < f12 || Float.isNaN(f12) ? f10 : f12;
        return f13 < f12 && f12 >= 0.0f;
    }

    public static boolean testRayAar(Vector2fc vector2fc, Vector2fc vector2fc2, Vector2fc vector2fc3, Vector2fc vector2fc4) {
        return Intersectionf.testRayAar(vector2fc.x(), vector2fc.y(), vector2fc2.x(), vector2fc2.y(), vector2fc3.x(), vector2fc3.y(), vector2fc4.x(), vector2fc4.y());
    }

    public static boolean testPointTriangle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        boolean bl2;
        boolean bl3 = (f2 - f6) * (f5 - f7) - (f4 - f6) * (f3 - f7) < 0.0f;
        boolean bl4 = bl2 = (f2 - f8) * (f7 - f9) - (f6 - f8) * (f3 - f9) < 0.0f;
        if (bl3 != bl2) {
            return false;
        }
        boolean bl5 = (f2 - f4) * (f9 - f5) - (f8 - f4) * (f3 - f5) < 0.0f;
        return bl2 == bl5;
    }

    public static boolean testPointTriangle(Vector2fc vector2fc, Vector2fc vector2fc2, Vector2fc vector2fc3, Vector2fc vector2fc4) {
        return Intersectionf.testPointTriangle(vector2fc.x(), vector2fc.y(), vector2fc2.x(), vector2fc2.y(), vector2fc3.x(), vector2fc3.y(), vector2fc4.x(), vector2fc4.y());
    }

    public static boolean testPointAar(float f2, float f3, float f4, float f5, float f6, float f7) {
        return f2 >= f4 && f3 >= f5 && f2 <= f6 && f3 <= f7;
    }

    public static boolean testPointCircle(float f2, float f3, float f4, float f5, float f6) {
        float f7 = f2 - f4;
        float f8 = f7 * f7;
        float f9 = f3 - f5;
        float f10 = f9 * f9;
        return f8 + f10 <= f6;
    }

    public static boolean testCircleTriangle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        float f11;
        float f12 = f2 - f5;
        float f13 = f3 - f6;
        float f14 = f12 * f12 + f13 * f13 - f4;
        if (f14 <= 0.0f) {
            return true;
        }
        float f15 = f2 - f7;
        float f16 = f3 - f8;
        float f17 = f15 * f15 + f16 * f16 - f4;
        if (f17 <= 0.0f) {
            return true;
        }
        float f18 = f2 - f9;
        float f19 = f3 - f10;
        float f20 = f18 * f18 + f19 * f19 - f4;
        if (f20 <= 0.0f) {
            return true;
        }
        float f21 = f7 - f5;
        float f22 = f8 - f6;
        float f23 = f9 - f7;
        float f24 = f10 - f8;
        float f25 = f5 - f9;
        float f26 = f6 - f10;
        if (f21 * f13 - f22 * f12 >= 0.0f && f23 * f16 - f24 * f15 >= 0.0f && f25 * f19 - f26 * f18 >= 0.0f) {
            return true;
        }
        float f27 = f12 * f21 + f13 * f22;
        if (f27 >= 0.0f && f27 <= (f11 = f21 * f21 + f22 * f22) && f14 * f11 <= f27 * f27) {
            return true;
        }
        f27 = f15 * f23 + f16 * f24;
        if (f27 > 0.0f && f27 <= (f11 = f23 * f23 + f24 * f24) && f17 * f11 <= f27 * f27) {
            return true;
        }
        f27 = f18 * f25 + f19 * f26;
        return f27 >= 0.0f && f27 < (f11 = f25 * f25 + f26 * f26) && f20 * f11 <= f27 * f27;
    }

    public static boolean testCircleTriangle(Vector2fc vector2fc, float f2, Vector2fc vector2fc2, Vector2fc vector2fc3, Vector2fc vector2fc4) {
        return Intersectionf.testCircleTriangle(vector2fc.x(), vector2fc.y(), f2, vector2fc2.x(), vector2fc2.y(), vector2fc3.x(), vector2fc3.y(), vector2fc4.x(), vector2fc4.y());
    }

    public static int intersectPolygonRay(float[] fArray, float f2, float f3, float f4, float f5, Vector2f vector2f) {
        float f6 = Float.POSITIVE_INFINITY;
        int n2 = fArray.length >> 1;
        int n3 = -1;
        float f7 = fArray[n2 - 1 << 1];
        float f8 = fArray[(n2 - 1 << 1) + 1];
        for (int i2 = 0; i2 < n2; ++i2) {
            float f9;
            float f10 = fArray[i2 << 1];
            float f11 = f10 - f7;
            float f12 = f3 - f8;
            float f13 = fArray[(i2 << 1) + 1];
            float f14 = f13 - f8;
            float f15 = f2 - f7;
            float f16 = 1.0f / (f14 * f4 - f11 * f5);
            float f17 = (f11 * f12 - f14 * f15) * f16;
            if (f17 >= 0.0f && f17 < f6 && (f9 = (f12 * f4 - f15 * f5) * f16) >= 0.0f && f9 <= 1.0f) {
                n3 = (i2 - 1 + n2) % n2;
                f6 = f17;
                vector2f.x = f2 + f17 * f4;
                vector2f.y = f3 + f17 * f5;
            }
            f7 = f10;
            f8 = f13;
        }
        return n3;
    }

    public static int intersectPolygonRay(Vector2fc[] vector2fcArray, float f2, float f3, float f4, float f5, Vector2f vector2f) {
        float f6 = Float.POSITIVE_INFINITY;
        int n2 = vector2fcArray.length;
        int n3 = -1;
        float f7 = vector2fcArray[n2 - 1].x();
        float f8 = vector2fcArray[n2 - 1].y();
        for (int i2 = 0; i2 < n2; ++i2) {
            float f9;
            float f10;
            float f11;
            float f12;
            float f13;
            float f14;
            Vector2fc vector2fc = vector2fcArray[i2];
            float f15 = vector2fc.x();
            float f16 = f15 - f7;
            float f17 = (f16 * (f14 = f3 - f8) - (f13 = (f12 = vector2fc.y()) - f8) * (f11 = f2 - f7)) * (f10 = 1.0f / (f13 * f4 - f16 * f5));
            if (f17 >= 0.0f && f17 < f6 && (f9 = (f14 * f4 - f11 * f5) * f10) >= 0.0f && f9 <= 1.0f) {
                n3 = (i2 - 1 + n2) % n2;
                f6 = f17;
                vector2f.x = f2 + f17 * f4;
                vector2f.y = f3 + f17 * f5;
            }
            f7 = f15;
            f8 = f12;
        }
        return n3;
    }

    public static boolean intersectLineLine(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, Vector2f vector2f) {
        float f10 = f2 - f4;
        float f11 = f5 - f3;
        float f12 = f11 * f2 + f10 * f3;
        float f13 = f6 - f8;
        float f14 = f9 - f7;
        float f15 = f14 * f6 + f13 * f7;
        float f16 = f11 * f13 - f14 * f10;
        if (f16 == 0.0f) {
            return false;
        }
        vector2f.x = (f13 * f12 - f10 * f15) / f16;
        vector2f.y = (f11 * f15 - f14 * f12) / f16;
        return true;
    }

    private static boolean separatingAxis(Vector2f[] vector2fArray, Vector2f[] vector2fArray2, float f2, float f3) {
        float f4 = Float.POSITIVE_INFINITY;
        float f5 = Float.NEGATIVE_INFINITY;
        float f6 = Float.POSITIVE_INFINITY;
        float f7 = Float.NEGATIVE_INFINITY;
        int n2 = Math.max(vector2fArray.length, vector2fArray2.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            float f8;
            Vector2f vector2f;
            if (i2 < vector2fArray.length) {
                vector2f = vector2fArray[i2];
                f8 = vector2f.x * f2 + vector2f.y * f3;
                if (f8 < f4) {
                    f4 = f8;
                }
                if (f8 > f5) {
                    f5 = f8;
                }
            }
            if (i2 < vector2fArray2.length) {
                vector2f = vector2fArray2[i2];
                f8 = vector2f.x * f2 + vector2f.y * f3;
                if (f8 < f6) {
                    f6 = f8;
                }
                if (f8 > f7) {
                    f7 = f8;
                }
            }
            if (!(f4 <= f7) || !(f6 <= f5)) continue;
            return false;
        }
        return true;
    }

    public static boolean testPolygonPolygon(Vector2f[] vector2fArray, Vector2f[] vector2fArray2) {
        Vector2f vector2f;
        Vector2f vector2f2;
        int n2 = 0;
        int n3 = vector2fArray.length - 1;
        while (n2 < vector2fArray.length) {
            vector2f2 = vector2fArray[n2];
            vector2f = vector2fArray[n3];
            if (Intersectionf.separatingAxis(vector2fArray, vector2fArray2, vector2f2.y - vector2f.y, vector2f.x - vector2f2.x)) {
                return false;
            }
            n3 = n2++;
        }
        n2 = 0;
        n3 = vector2fArray2.length - 1;
        while (n2 < vector2fArray2.length) {
            vector2f2 = vector2fArray2[n2];
            vector2f = vector2fArray2[n3];
            if (Intersectionf.separatingAxis(vector2fArray, vector2fArray2, vector2f2.y - vector2f.y, vector2f.x - vector2f2.x)) {
                return false;
            }
            n3 = n2++;
        }
        return true;
    }
}

