/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import org.joml.Math;
import org.joml.Runtime;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector4d;

public class Intersectiond {
    public static final int POINT_ON_TRIANGLE_VERTEX_0 = 1;
    public static final int POINT_ON_TRIANGLE_VERTEX_1 = 2;
    public static final int POINT_ON_TRIANGLE_VERTEX_2 = 3;
    public static final int POINT_ON_TRIANGLE_EDGE_01 = 4;
    public static final int POINT_ON_TRIANGLE_EDGE_12 = 5;
    public static final int POINT_ON_TRIANGLE_EDGE_20 = 6;
    public static final int POINT_ON_TRIANGLE_FACE = 7;
    public static final int AAR_SIDE_MINX = 0;
    public static final int AAR_SIDE_MINY = 1;
    public static final int AAR_SIDE_MAXX = 2;
    public static final int AAR_SIDE_MAXY = 3;
    public static final int OUTSIDE = -1;
    public static final int ONE_INTERSECTION = 1;
    public static final int TWO_INTERSECTION = 2;
    public static final int INSIDE = 3;

    public static boolean testPlaneSphere(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
        double d11 = (d2 * d6 + d3 * d7 + d4 * d8 + d5) / d10;
        return -d9 <= d11 && d11 <= d9;
    }

    public static boolean intersectPlaneSphere(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, Vector4d vector4d) {
        double d10 = Math.invsqrt(d2 * d2 + d3 * d3 + d4 * d4);
        double d11 = (d2 * d6 + d3 * d7 + d4 * d8 + d5) * d10;
        if (-d9 <= d11 && d11 <= d9) {
            vector4d.x = d6 + d11 * d2 * d10;
            vector4d.y = d7 + d11 * d3 * d10;
            vector4d.z = d8 + d11 * d4 * d10;
            vector4d.w = Math.sqrt(d9 * d9 - d11 * d11);
            return true;
        }
        return false;
    }

    public static boolean intersectPlaneSweptSphere(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, Vector4d vector4d) {
        double d13 = d2 * d6 + d3 * d7 + d4 * d8 - d5;
        if (Math.abs(d13) <= d9) {
            vector4d.set(d6, d7, d8, 0.0);
            return true;
        }
        double d14 = d2 * d10 + d3 * d11 + d4 * d12;
        if (d14 * d13 >= 0.0) {
            return false;
        }
        double d15 = d13 > 0.0 ? d9 : -d9;
        double d16 = (d15 - d13) / d14;
        vector4d.set(d6 + d16 * d10 - d15 * d2, d7 + d16 * d11 - d15 * d3, d8 + d16 * d12 - d15 * d4, d16);
        return true;
    }

    public static boolean testPlaneSweptSphere(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        double d13 = d6 * d2 + d7 * d3 + d8 * d4 - d5;
        double d14 = d10 * d2 + d11 * d3 + d12 * d4 - d5;
        if (d13 * d14 < 0.0) {
            return true;
        }
        return Math.abs(d13) <= d9 || Math.abs(d14) <= d9;
    }

    public static boolean testAabPlane(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11) {
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        if (d8 > 0.0) {
            d17 = d5;
            d16 = d2;
        } else {
            d17 = d2;
            d16 = d5;
        }
        if (d9 > 0.0) {
            d15 = d6;
            d14 = d3;
        } else {
            d15 = d3;
            d14 = d6;
        }
        if (d10 > 0.0) {
            d13 = d7;
            d12 = d4;
        } else {
            d13 = d4;
            d12 = d7;
        }
        double d18 = d11 + d8 * d16 + d9 * d14 + d10 * d12;
        double d19 = d11 + d8 * d17 + d9 * d15 + d10 * d13;
        return d18 <= 0.0 && d19 >= 0.0;
    }

    public static boolean testAabPlane(Vector3dc vector3dc, Vector3dc vector3dc2, double d2, double d3, double d4, double d5) {
        return Intersectiond.testAabPlane(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), d2, d3, d4, d5);
    }

    public static boolean testAabAab(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        return d5 >= d8 && d6 >= d9 && d7 >= d10 && d2 <= d11 && d3 <= d12 && d4 <= d13;
    }

    public static boolean testAabAab(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Vector3dc vector3dc4) {
        return Intersectiond.testAabAab(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), vector3dc4.x(), vector3dc4.y(), vector3dc4.z());
    }

    public static boolean testObOb(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4, Vector3d vector3d5, Vector3d vector3d6, Vector3d vector3d7, Vector3d vector3d8, Vector3d vector3d9, Vector3d vector3d10) {
        return Intersectiond.testObOb(vector3d.x, vector3d.y, vector3d.z, vector3d2.x, vector3d2.y, vector3d2.z, vector3d3.x, vector3d3.y, vector3d3.z, vector3d4.x, vector3d4.y, vector3d4.z, vector3d5.x, vector3d5.y, vector3d5.z, vector3d6.x, vector3d6.y, vector3d6.z, vector3d7.x, vector3d7.y, vector3d7.z, vector3d8.x, vector3d8.y, vector3d8.z, vector3d9.x, vector3d9.y, vector3d9.z, vector3d10.x, vector3d10.y, vector3d10.z);
    }

    public static boolean testObOb(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17, double d18, double d19, double d20, double d21, double d22, double d23, double d24, double d25, double d26, double d27, double d28, double d29, double d30, double d31) {
        double d32 = d5 * d20 + d8 * d23 + d11 * d26;
        double d33 = d5 * d21 + d8 * d24 + d11 * d27;
        double d34 = d5 * d22 + d8 * d25 + d11 * d28;
        double d35 = d6 * d20 + d9 * d23 + d12 * d26;
        double d36 = d6 * d21 + d9 * d24 + d12 * d27;
        double d37 = d6 * d22 + d9 * d25 + d12 * d28;
        double d38 = d7 * d20 + d10 * d23 + d13 * d26;
        double d39 = d7 * d21 + d10 * d24 + d13 * d27;
        double d40 = d7 * d22 + d10 * d25 + d13 * d28;
        double d41 = 1.0E-8;
        double d42 = Math.abs(d32) + d41;
        double d43 = Math.abs(d35) + d41;
        double d44 = Math.abs(d38) + d41;
        double d45 = Math.abs(d33) + d41;
        double d46 = Math.abs(d36) + d41;
        double d47 = Math.abs(d39) + d41;
        double d48 = Math.abs(d34) + d41;
        double d49 = Math.abs(d37) + d41;
        double d50 = Math.abs(d40) + d41;
        double d51 = d17 - d2;
        double d52 = d18 - d3;
        double d53 = d19 - d4;
        double d54 = d51 * d5 + d52 * d6 + d53 * d7;
        double d55 = d51 * d8 + d52 * d9 + d53 * d10;
        double d56 = d51 * d11 + d52 * d12 + d53 * d13;
        double d57 = d14;
        double d58 = d29 * d42 + d30 * d43 + d31 * d44;
        if (Math.abs(d54) > d57 + d58) {
            return false;
        }
        d57 = d15;
        d58 = d29 * d45 + d30 * d46 + d31 * d47;
        if (Math.abs(d55) > d57 + d58) {
            return false;
        }
        d57 = d16;
        d58 = d29 * d48 + d30 * d49 + d31 * d50;
        if (Math.abs(d56) > d57 + d58) {
            return false;
        }
        d57 = d14 * d42 + d15 * d45 + d16 * d48;
        d58 = d29;
        if (Math.abs(d54 * d32 + d55 * d33 + d56 * d34) > d57 + d58) {
            return false;
        }
        d57 = d14 * d43 + d15 * d46 + d16 * d49;
        d58 = d30;
        if (Math.abs(d54 * d35 + d55 * d36 + d56 * d37) > d57 + d58) {
            return false;
        }
        d57 = d14 * d44 + d15 * d47 + d16 * d50;
        d58 = d31;
        if (Math.abs(d54 * d38 + d55 * d39 + d56 * d40) > d57 + d58) {
            return false;
        }
        d57 = d15 * d48 + d16 * d45;
        d58 = d30 * d44 + d31 * d43;
        if (Math.abs(d56 * d33 - d55 * d34) > d57 + d58) {
            return false;
        }
        d57 = d15 * d49 + d16 * d46;
        d58 = d29 * d44 + d31 * d42;
        if (Math.abs(d56 * d36 - d55 * d37) > d57 + d58) {
            return false;
        }
        d57 = d15 * d50 + d16 * d47;
        d58 = d29 * d43 + d30 * d42;
        if (Math.abs(d56 * d39 - d55 * d40) > d57 + d58) {
            return false;
        }
        d57 = d14 * d48 + d16 * d42;
        d58 = d30 * d47 + d31 * d46;
        if (Math.abs(d54 * d34 - d56 * d32) > d57 + d58) {
            return false;
        }
        d57 = d14 * d49 + d16 * d43;
        d58 = d29 * d47 + d31 * d45;
        if (Math.abs(d54 * d37 - d56 * d35) > d57 + d58) {
            return false;
        }
        d57 = d14 * d50 + d16 * d44;
        d58 = d29 * d46 + d30 * d45;
        if (Math.abs(d54 * d40 - d56 * d38) > d57 + d58) {
            return false;
        }
        d57 = d14 * d45 + d15 * d42;
        d58 = d30 * d50 + d31 * d49;
        if (Math.abs(d55 * d32 - d54 * d33) > d57 + d58) {
            return false;
        }
        d57 = d14 * d46 + d15 * d43;
        d58 = d29 * d50 + d31 * d48;
        if (Math.abs(d55 * d35 - d54 * d36) > d57 + d58) {
            return false;
        }
        d57 = d14 * d47 + d15 * d44;
        d58 = d29 * d49 + d30 * d48;
        return !(Math.abs(d55 * d38 - d54 * d39) > d57 + d58);
    }

    public static boolean intersectSphereSphere(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, Vector4d vector4d) {
        double d10 = d6 - d2;
        double d11 = d7 - d3;
        double d12 = d8 - d4;
        double d13 = d10 * d10 + d11 * d11 + d12 * d12;
        double d14 = 0.5 + (d5 - d9) / (2.0 * d13);
        double d15 = d5 - d14 * d14 * d13;
        if (d15 >= 0.0) {
            vector4d.x = d2 + d14 * d10;
            vector4d.y = d3 + d14 * d11;
            vector4d.z = d4 + d14 * d12;
            vector4d.w = Math.sqrt(d15);
            return true;
        }
        return false;
    }

    public static boolean intersectSphereSphere(Vector3dc vector3dc, double d2, Vector3dc vector3dc2, double d3, Vector4d vector4d) {
        return Intersectiond.intersectSphereSphere(vector3dc.x(), vector3dc.y(), vector3dc.z(), d2, vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), d3, vector4d);
    }

    public static int intersectSphereTriangle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, Vector3d vector3d) {
        int n2 = Intersectiond.findClosestPointOnTriangle(d6, d7, d8, d9, d10, d11, d12, d13, d14, d2, d3, d4, vector3d);
        double d15 = vector3d.x - d2;
        double d16 = vector3d.y - d3;
        double d17 = vector3d.z - d4;
        double d18 = d15 * d15 + d16 * d16 + d17 * d17;
        if (d18 <= d5 * d5) {
            return n2;
        }
        return 0;
    }

    public static boolean testSphereSphere(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d6 - d2;
        double d11 = d7 - d3;
        double d12 = d8 - d4;
        double d13 = d10 * d10 + d11 * d11 + d12 * d12;
        double d14 = 0.5 + (d5 - d9) / (2.0 * d13);
        double d15 = d5 - d14 * d14 * d13;
        return d15 >= 0.0;
    }

    public static boolean testSphereSphere(Vector3dc vector3dc, double d2, Vector3dc vector3dc2, double d3) {
        return Intersectiond.testSphereSphere(vector3dc.x(), vector3dc.y(), vector3dc.z(), d2, vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), d3);
    }

    public static double distancePointPlane(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7);
        return (d5 * d2 + d6 * d3 + d7 * d4 + d8) / d9;
    }

    public static double distancePointPlane(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        double d14 = d9 - d6;
        double d15 = d13 - d7;
        double d16 = d12 - d6;
        double d17 = d10 - d7;
        double d18 = d11 - d5;
        double d19 = d8 - d5;
        double d20 = d14 * d15 - d16 * d17;
        double d21 = d17 * d18 - d15 * d19;
        double d22 = d19 * d16 - d18 * d14;
        double d23 = -(d20 * d5 + d21 * d6 + d22 * d7);
        return Intersectiond.distancePointPlane(d2, d3, d4, d20, d21, d22, d23);
    }

    public static double intersectRayPlane(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14) {
        double d15;
        double d16 = d11 * d5 + d12 * d6 + d13 * d7;
        if (d16 < d14 && (d15 = ((d8 - d2) * d11 + (d9 - d3) * d12 + (d10 - d4) * d13) / d16) >= 0.0) {
            return d15;
        }
        return -1.0;
    }

    public static double intersectRayPlane(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Vector3dc vector3dc4, double d2) {
        return Intersectiond.intersectRayPlane(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), vector3dc4.x(), vector3dc4.y(), vector3dc4.z(), d2);
    }

    public static double intersectRayPlane(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        double d13;
        double d14 = d8 * d5 + d9 * d6 + d10 * d7;
        if (d14 < 0.0 && (d13 = -(d8 * d2 + d9 * d3 + d10 * d4 + d11) / d14) >= 0.0) {
            return d13;
        }
        return -1.0;
    }

    public static boolean testAabSphere(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11) {
        double d12;
        double d13 = d11;
        if (d8 < d2) {
            d12 = d8 - d2;
            d13 -= d12 * d12;
        } else if (d8 > d5) {
            d12 = d8 - d5;
            d13 -= d12 * d12;
        }
        if (d9 < d3) {
            d12 = d9 - d3;
            d13 -= d12 * d12;
        } else if (d9 > d6) {
            d12 = d9 - d6;
            d13 -= d12 * d12;
        }
        if (d10 < d4) {
            d12 = d10 - d4;
            d13 -= d12 * d12;
        } else if (d10 > d7) {
            d12 = d10 - d7;
            d13 -= d12 * d12;
        }
        return d13 >= 0.0;
    }

    public static boolean testAabSphere(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, double d2) {
        return Intersectiond.testAabSphere(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), d2);
    }

    public static Vector3d findClosestPointOnPlane(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, Vector3d vector3d) {
        double d11 = -(d5 * d2 + d6 * d3 + d7 * d4);
        double d12 = d5 * d8 + d6 * d9 + d7 * d10 - d11;
        vector3d.x = d8 - d12 * d5;
        vector3d.y = d9 - d12 * d6;
        vector3d.z = d10 - d12 * d7;
        return vector3d;
    }

    public static Vector3d findClosestPointOnLineSegment(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, Vector3d vector3d) {
        double d11 = d5 - d2;
        double d12 = d6 - d3;
        double d13 = d7 - d4;
        double d14 = ((d8 - d2) * d11 + (d9 - d3) * d12 + (d10 - d4) * d13) / (d11 * d11 + d12 * d12 + d13 * d13);
        if (d14 < 0.0) {
            d14 = 0.0;
        }
        if (d14 > 1.0) {
            d14 = 1.0;
        }
        vector3d.x = d2 + d14 * d11;
        vector3d.y = d3 + d14 * d12;
        vector3d.z = d4 + d14 * d13;
        return vector3d;
    }

    public static double findClosestPointsLineSegments(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, Vector3d vector3d, Vector3d vector3d2) {
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19 = d5 - d2;
        double d20 = d6 - d3;
        double d21 = d7 - d4;
        double d22 = d11 - d8;
        double d23 = d12 - d9;
        double d24 = d13 - d10;
        double d25 = d2 - d8;
        double d26 = d3 - d9;
        double d27 = d4 - d10;
        double d28 = d19 * d19 + d20 * d20 + d21 * d21;
        double d29 = d22 * d22 + d23 * d23 + d24 * d24;
        double d30 = d22 * d25 + d23 * d26 + d24 * d27;
        double d31 = 1.0E-8;
        if (d28 <= d31 && d29 <= d31) {
            vector3d.set(d2, d3, d4);
            vector3d2.set(d8, d9, d10);
            return vector3d.dot(vector3d2);
        }
        if (d28 <= d31) {
            d18 = 0.0;
            d17 = d30 / d29;
            d17 = Math.min(Math.max(d17, 0.0), 1.0);
        } else {
            d16 = d19 * d25 + d20 * d26 + d21 * d27;
            if (d29 <= d31) {
                d17 = 0.0;
                d18 = Math.min(Math.max(-d16 / d28, 0.0), 1.0);
            } else {
                d14 = d28 * d29 - (d15 = d19 * d22 + d20 * d23 + d21 * d24) * d15;
                d18 = d14 != 0.0 ? Math.min(Math.max((d15 * d30 - d16 * d29) / d14, 0.0), 1.0) : 0.0;
                d17 = (d15 * d18 + d30) / d29;
                if (d17 < 0.0) {
                    d17 = 0.0;
                    d18 = Math.min(Math.max(-d16 / d28, 0.0), 1.0);
                } else if (d17 > 1.0) {
                    d17 = 1.0;
                    d18 = Math.min(Math.max((d15 - d16) / d28, 0.0), 1.0);
                }
            }
        }
        vector3d.set(d2 + d19 * d18, d3 + d20 * d18, d4 + d21 * d18);
        vector3d2.set(d8 + d22 * d17, d9 + d23 * d17, d10 + d24 * d17);
        d16 = vector3d.x - vector3d2.x;
        d15 = vector3d.y - vector3d2.y;
        d14 = vector3d.z - vector3d2.z;
        return d16 * d16 + d15 * d15 + d14 * d14;
    }

    public static double findClosestPointsLineSegmentTriangle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, Vector3d vector3d, Vector3d vector3d2) {
        double d17;
        double d18;
        double d19;
        double d20;
        double d21;
        double d22;
        double d23;
        double d24;
        double d25 = d24 = Intersectiond.findClosestPointsLineSegments(d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12, d13, vector3d, vector3d2);
        double d26 = vector3d.x;
        double d27 = vector3d.y;
        double d28 = vector3d.z;
        double d29 = vector3d2.x;
        double d30 = vector3d2.y;
        double d31 = vector3d2.z;
        d24 = Intersectiond.findClosestPointsLineSegments(d2, d3, d4, d5, d6, d7, d11, d12, d13, d14, d15, d16, vector3d, vector3d2);
        if (d24 < d25) {
            d25 = d24;
            d26 = vector3d.x;
            d27 = vector3d.y;
            d28 = vector3d.z;
            d29 = vector3d2.x;
            d30 = vector3d2.y;
            d31 = vector3d2.z;
        }
        if ((d24 = Intersectiond.findClosestPointsLineSegments(d2, d3, d4, d5, d6, d7, d14, d15, d16, d8, d9, d10, vector3d, vector3d2)) < d25) {
            d25 = d24;
            d26 = vector3d.x;
            d27 = vector3d.y;
            d28 = vector3d.z;
            d29 = vector3d2.x;
            d30 = vector3d2.y;
            d31 = vector3d2.z;
        }
        boolean bl2 = false;
        double d32 = Double.NaN;
        double d33 = Double.NaN;
        double d34 = Double.NaN;
        double d35 = Double.NaN;
        if (Intersectiond.testPointInTriangle(d2, d3, d4, d8, d9, d10, d11, d12, d13, d14, d15, d16)) {
            d23 = d12 - d9;
            d22 = d16 - d10;
            d21 = d15 - d9;
            d20 = d13 - d10;
            d19 = d14 - d8;
            d18 = d11 - d8;
            d32 = d23 * d22 - d21 * d20;
            d33 = d20 * d19 - d22 * d18;
            d34 = d18 * d21 - d19 * d23;
            bl2 = true;
            d17 = Math.invsqrt(d32 * d32 + d33 * d33 + d34 * d34);
            d35 = -((d32 *= d17) * d8 + (d33 *= d17) * d9 + (d34 *= d17) * d10);
            double d36 = d24 = d32 * d2 + d33 * d3 + d34 * d4 + d35;
            if ((d24 *= d24) < d25) {
                d25 = d24;
                d26 = d2;
                d27 = d3;
                d28 = d4;
                d29 = d2 - d32 * d36;
                d30 = d3 - d33 * d36;
                d31 = d4 - d34 * d36;
            }
        }
        if (Intersectiond.testPointInTriangle(d5, d6, d7, d8, d9, d10, d11, d12, d13, d14, d15, d16)) {
            if (!bl2) {
                d23 = d12 - d9;
                d22 = d16 - d10;
                d21 = d15 - d9;
                d20 = d13 - d10;
                d19 = d14 - d8;
                d18 = d11 - d8;
                d32 = d23 * d22 - d21 * d20;
                d33 = d20 * d19 - d22 * d18;
                d34 = d18 * d21 - d19 * d23;
                d17 = Math.invsqrt(d32 * d32 + d33 * d33 + d34 * d34);
                d35 = -((d32 *= d17) * d8 + (d33 *= d17) * d9 + (d34 *= d17) * d10);
            }
            d23 = d24 = d32 * d5 + d33 * d6 + d34 * d7 + d35;
            if ((d24 *= d24) < d25) {
                d25 = d24;
                d26 = d5;
                d27 = d6;
                d28 = d7;
                d29 = d5 - d32 * d23;
                d30 = d6 - d33 * d23;
                d31 = d7 - d34 * d23;
            }
        }
        vector3d.set(d26, d27, d28);
        vector3d2.set(d29, d30, d31);
        return d25;
    }

    public static int findClosestPointOnTriangle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, Vector3d vector3d) {
        double d14 = d5 - d2;
        double d15 = d6 - d3;
        double d16 = d7 - d4;
        double d17 = d8 - d2;
        double d18 = d9 - d3;
        double d19 = d10 - d4;
        double d20 = d11 - d2;
        double d21 = d12 - d3;
        double d22 = d13 - d4;
        double d23 = d14 * d20 + d15 * d21 + d16 * d22;
        double d24 = d17 * d20 + d18 * d21 + d19 * d22;
        if (d23 <= 0.0 && d24 <= 0.0) {
            vector3d.x = d2;
            vector3d.y = d3;
            vector3d.z = d4;
            return 1;
        }
        double d25 = d11 - d5;
        double d26 = d12 - d6;
        double d27 = d13 - d7;
        double d28 = d14 * d25 + d15 * d26 + d16 * d27;
        double d29 = d17 * d25 + d18 * d26 + d19 * d27;
        if (d28 >= 0.0 && d29 <= d28) {
            vector3d.x = d5;
            vector3d.y = d6;
            vector3d.z = d7;
            return 2;
        }
        double d30 = d23 * d29 - d28 * d24;
        if (d30 <= 0.0 && d23 >= 0.0 && d28 <= 0.0) {
            double d31 = d23 / (d23 - d28);
            vector3d.x = d2 + d31 * d14;
            vector3d.y = d3 + d31 * d15;
            vector3d.z = d4 + d31 * d16;
            return 4;
        }
        double d32 = d11 - d8;
        double d33 = d12 - d9;
        double d34 = d13 - d10;
        double d35 = d14 * d32 + d15 * d33 + d16 * d34;
        double d36 = d17 * d32 + d18 * d33 + d19 * d34;
        if (d36 >= 0.0 && d35 <= d36) {
            vector3d.x = d8;
            vector3d.y = d9;
            vector3d.z = d10;
            return 3;
        }
        double d37 = d35 * d24 - d23 * d36;
        if (d37 <= 0.0 && d24 >= 0.0 && d36 <= 0.0) {
            double d38 = d24 / (d24 - d36);
            vector3d.x = d2 + d38 * d17;
            vector3d.y = d3 + d38 * d18;
            vector3d.z = d4 + d38 * d19;
            return 6;
        }
        double d39 = d28 * d36 - d35 * d29;
        if (d39 <= 0.0 && d29 - d28 >= 0.0 && d35 - d36 >= 0.0) {
            double d40 = (d29 - d28) / (d29 - d28 + d35 - d36);
            vector3d.x = d5 + d40 * (d8 - d5);
            vector3d.y = d6 + d40 * (d9 - d6);
            vector3d.z = d7 + d40 * (d10 - d7);
            return 5;
        }
        double d41 = 1.0 / (d39 + d37 + d30);
        double d42 = d37 * d41;
        double d43 = d30 * d41;
        vector3d.x = d2 + d14 * d42 + d17 * d43;
        vector3d.y = d3 + d15 * d42 + d18 * d43;
        vector3d.z = d4 + d16 * d42 + d19 * d43;
        return 7;
    }

    public static int findClosestPointOnTriangle(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Vector3dc vector3dc4, Vector3d vector3d) {
        return Intersectiond.findClosestPointOnTriangle(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), vector3dc4.x(), vector3dc4.y(), vector3dc4.z(), vector3d);
    }

    public static Vector3d findClosestPointOnRectangle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, Vector3d vector3d) {
        double d14 = d5 - d2;
        double d15 = d6 - d3;
        double d16 = d7 - d4;
        double d17 = d8 - d2;
        double d18 = d9 - d3;
        double d19 = d10 - d4;
        double d20 = d11 - d2;
        double d21 = d12 - d3;
        double d22 = d13 - d4;
        double d23 = d2;
        double d24 = d3;
        double d25 = d4;
        double d26 = d20 * d14 + d21 * d15 + d22 * d16;
        double d27 = d14 * d14 + d15 * d15 + d16 * d16;
        if (d26 >= d27) {
            d23 += d14;
            d24 += d15;
            d25 += d16;
        } else if (d26 > 0.0) {
            d23 += d26 / d27 * d14;
            d24 += d26 / d27 * d15;
            d25 += d26 / d27 * d16;
        }
        d26 = d20 * d17 + d21 * d18 + d22 * d19;
        d27 = d17 * d17 + d18 * d18 + d19 * d19;
        if (d26 >= d27) {
            d23 += d17;
            d24 += d18;
            d25 += d19;
        } else if (d26 > 0.0) {
            d23 += d26 / d27 * d17;
            d24 += d26 / d27 * d18;
            d25 += d26 / d27 * d19;
        }
        vector3d.x = d23;
        vector3d.y = d24;
        vector3d.z = d25;
        return vector3d;
    }

    public static int intersectSweptSphereTriangle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17, double d18, double d19, Vector4d vector4d) {
        double d20;
        double d21;
        double d22;
        double d23;
        double d24;
        double d25;
        double d26;
        double d27;
        double d28;
        double d29;
        double d30;
        double d31;
        double d32;
        double d33;
        double d34;
        double d35;
        double d36;
        double d37;
        double d38;
        double d39;
        double d40;
        double d41;
        double d42;
        double d43;
        double d44;
        double d45;
        double d46;
        double d47;
        double d48;
        double d49;
        double d50;
        double d51;
        double d52;
        double d53;
        double d54;
        double d55;
        double d56;
        double d57;
        double d58;
        double d59;
        double d60;
        double d61;
        double d62;
        double d63;
        double d64;
        double d65 = d12 - d9;
        double d66 = d13 - d10;
        double d67 = d14 - d11;
        double d68 = d15 - d9;
        double d69 = d16 - d10;
        double d70 = d17 - d11;
        double d71 = d66 * d70 - d69 * d67;
        double d72 = d67 * d68 - d70 * d65;
        double d73 = d65 * d69 - d68 * d66;
        double d74 = -(d71 * d9 + d72 * d10 + d73 * d11);
        double d75 = Math.invsqrt(d71 * d71 + d72 * d72 + d73 * d73);
        double d76 = (d71 * d2 + d72 * d3 + d73 * d4 + d74) * d75;
        double d77 = (d71 * d6 + d72 * d7 + d73 * d8) * d75;
        if (d77 < d18 && d77 > -d18) {
            return 0;
        }
        double d78 = (d5 - d76) / d77;
        if (d78 > d19) {
            return 0;
        }
        double d79 = (-d5 - d76) / d77;
        double d80 = d2 - d5 * d71 * d75 + d6 * d78;
        double d81 = d3 - d5 * d72 * d75 + d7 * d78;
        double d82 = d4 - d5 * d73 * d75 + d8 * d78;
        boolean bl2 = Intersectiond.testPointInTriangle(d80, d81, d82, d9, d10, d11, d12, d13, d14, d15, d16, d17);
        if (bl2) {
            vector4d.x = d80;
            vector4d.y = d81;
            vector4d.z = d82;
            vector4d.w = d78;
            return 7;
        }
        int n2 = 0;
        double d83 = d6 * d6 + d7 * d7 + d8 * d8;
        double d84 = d2 - d9;
        double d85 = d3 - d10;
        double d86 = d4 - d11;
        double d87 = 2.0 * (d6 * d84 + d7 * d85 + d8 * d86);
        double d88 = d5 * d5;
        double d89 = d84 * d84 + d85 * d85 + d86 * d86 - d88;
        double d90 = d19;
        double d91 = Intersectiond.computeLowestRoot(d83, d87, d89, d90);
        if (d91 < d90) {
            vector4d.x = d9;
            vector4d.y = d10;
            vector4d.z = d11;
            vector4d.w = d91;
            d90 = d91;
            n2 = 1;
        }
        if ((d64 = Intersectiond.computeLowestRoot(d83, d63 = 2.0 * (d6 * (d62 = d2 - d12) + d7 * (d61 = d3 - d13) + d8 * (d60 = d4 - d14)), d59 = (d58 = d62 * d62 + d61 * d61 + d60 * d60) - d88, d90)) < d90) {
            vector4d.x = d12;
            vector4d.y = d13;
            vector4d.z = d14;
            vector4d.w = d64;
            d90 = d64;
            n2 = 2;
        }
        if ((d57 = Intersectiond.computeLowestRoot(d83, d56 = 2.0 * (d6 * (d55 = d2 - d15) + d7 * (d54 = d3 - d16) + d8 * (d53 = d4 - d17)), d52 = d55 * d55 + d54 * d54 + d53 * d53 - d88, d90)) < d90) {
            vector4d.x = d15;
            vector4d.y = d16;
            vector4d.z = d17;
            vector4d.w = d57;
            d90 = d57;
            n2 = 3;
        }
        if ((d51 = ((d50 = d65 * d6 + d66 * d7 + d67 * d8) * (d49 = Intersectiond.computeLowestRoot(d48 = (d47 = d65 * d65 + d66 * d66 + d67 * d67) * -(d46 = d6 * d6 + d7 * d7 + d8 * d8) + d50 * d50, d45 = d47 * 2.0 * (d44 = d6 * -d84 + d7 * -d85 + d8 * -d86) - 2.0 * d50 * (d43 = d65 * -d84 + d66 * -d85 + d67 * -d86), d42 = d47 * (d88 - (d41 = d84 * d84 + d85 * d85 + d86 * d86)) + d43 * d43, d90)) - d43) / d47) >= 0.0 && d51 <= 1.0 && d49 < d90) {
            vector4d.x = d9 + d51 * d65;
            vector4d.y = d10 + d51 * d66;
            vector4d.z = d11 + d51 * d67;
            vector4d.w = d49;
            d90 = d49;
            n2 = 4;
        }
        if ((d40 = ((d39 = d68 * d6 + d69 * d7 + d70 * d8) * (d38 = Intersectiond.computeLowestRoot(d37 = (d36 = d68 * d68 + d69 * d69 + d70 * d70) * -d46 + d39 * d39, d35 = d36 * 2.0 * d44 - 2.0 * d39 * (d34 = d68 * -d84 + d69 * -d85 + d70 * -d86), d33 = d36 * (d88 - d41) + d34 * d34, d90)) - d34) / d36) >= 0.0 && d40 <= 1.0 && d38 < d79) {
            vector4d.x = d9 + d40 * d68;
            vector4d.y = d10 + d40 * d69;
            vector4d.z = d11 + d40 * d70;
            vector4d.w = d38;
            d90 = d38;
            n2 = 6;
        }
        if ((d32 = ((d31 = (d30 = d15 - d12) * d6 + (d29 = d16 - d13) * d7 + (d28 = d17 - d14) * d8) * (d27 = Intersectiond.computeLowestRoot(d26 = (d25 = d30 * d30 + d29 * d29 + d28 * d28) * -d46 + d31 * d31, d24 = d25 * 2.0 * (d23 = d6 * -d62 + d7 * -d61 + d8 * -d60) - 2.0 * d31 * (d22 = d30 * -d62 + d29 * -d61 + d28 * -d60), d21 = d25 * (d88 - (d20 = d58)) + d22 * d22, d90)) - d22) / d25) >= 0.0 && d32 <= 1.0 && d27 < d90) {
            vector4d.x = d12 + d32 * d30;
            vector4d.y = d13 + d32 * d29;
            vector4d.z = d14 + d32 * d28;
            vector4d.w = d27;
            d90 = d27;
            n2 = 5;
        }
        return n2;
    }

    private static double computeLowestRoot(double d2, double d3, double d4, double d5) {
        double d6;
        double d7 = d3 * d3 - 4.0 * d2 * d4;
        if (d7 < 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        double d8 = Math.sqrt(d7);
        double d9 = (-d3 - d8) / (2.0 * d2);
        if (d9 > (d6 = (-d3 + d8) / (2.0 * d2))) {
            double d10 = d6;
            d6 = d9;
            d9 = d10;
        }
        if (d9 > 0.0 && d9 < d5) {
            return d9;
        }
        if (d6 > 0.0 && d6 < d5) {
            return d6;
        }
        return Double.POSITIVE_INFINITY;
    }

    public static boolean testPointInTriangle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        double d14 = d2 - d5;
        double d15 = d8 - d5;
        double d16 = d3 - d6;
        double d17 = d9 - d6;
        double d18 = d4 - d7;
        double d19 = d10 - d7;
        double d20 = d14 * d15 + d16 * d17 + d18 * d19;
        double d21 = d11 - d5;
        double d22 = d12 - d6;
        double d23 = d13 - d7;
        double d24 = d21 * d21 + d22 * d22 + d23 * d23;
        double d25 = d14 * d21 + d16 * d22 + d18 * d23;
        double d26 = d15 * d21 + d17 * d22 + d19 * d23;
        double d27 = d20 * d24 - d25 * d26;
        double d28 = d15 * d15 + d17 * d17 + d19 * d19;
        double d29 = d25 * d28 - d20 * d26;
        double d30 = d28 * d24 - d26 * d26;
        double d31 = d27 + d29 - d30;
        return (Runtime.doubleToLongBits(d31) & ((Runtime.doubleToLongBits(d27) | Runtime.doubleToLongBits(d29)) ^ 0xFFFFFFFFFFFFFFFFL) & Long.MIN_VALUE) != 0L;
    }

    public static boolean intersectRaySphere(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, Vector2d vector2d) {
        double d12;
        double d13 = d8 - d2;
        double d14 = d9 - d3;
        double d15 = d10 - d4;
        double d16 = d13 * d5 + d14 * d6 + d15 * d7;
        double d17 = d13 * d13 + d14 * d14 + d15 * d15 - d16 * d16;
        if (d17 > d11) {
            return false;
        }
        double d18 = Math.sqrt(d11 - d17);
        double d19 = d16 - d18;
        if (d19 < (d12 = d16 + d18) && d12 >= 0.0) {
            vector2d.x = d19;
            vector2d.y = d12;
            return true;
        }
        return false;
    }

    public static boolean intersectRaySphere(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, double d2, Vector2d vector2d) {
        return Intersectiond.intersectRaySphere(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), d2, vector2d);
    }

    public static boolean testRaySphere(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11) {
        double d12;
        double d13 = d8 - d2;
        double d14 = d9 - d3;
        double d15 = d10 - d4;
        double d16 = d13 * d5 + d14 * d6 + d15 * d7;
        double d17 = d13 * d13 + d14 * d14 + d15 * d15 - d16 * d16;
        if (d17 > d11) {
            return false;
        }
        double d18 = Math.sqrt(d11 - d17);
        double d19 = d16 - d18;
        return d19 < (d12 = d16 + d18) && d12 >= 0.0;
    }

    public static boolean testRaySphere(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, double d2) {
        return Intersectiond.testRaySphere(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), d2);
    }

    public static boolean testLineSegmentSphere(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11) {
        double d12;
        double d13 = d5 - d2;
        double d14 = d6 - d3;
        double d15 = d7 - d4;
        double d16 = (d8 - d2) * d13 + (d9 - d3) * d14 + (d10 - d4) * d15;
        double d17 = d13 * d13 + d14 * d14 + d15 * d15;
        double d18 = d16 / d17;
        if (d18 < 0.0) {
            d13 = d2 - d8;
            d14 = d3 - d9;
            d15 = d4 - d10;
        } else if (d18 > 1.0) {
            d13 = d5 - d8;
            d14 = d6 - d9;
            d15 = d7 - d10;
        } else {
            d12 = d2 + d18 * d13;
            double d19 = d3 + d18 * d14;
            double d20 = d4 + d18 * d15;
            d13 = d12 - d8;
            d14 = d19 - d9;
            d15 = d20 - d10;
        }
        d12 = d13 * d13 + d14 * d14 + d15 * d15;
        return d12 <= d11;
    }

    public static boolean testLineSegmentSphere(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, double d2) {
        return Intersectiond.testLineSegmentSphere(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), d2);
    }

    public static boolean intersectRayAab(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, Vector2d vector2d) {
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19;
        double d20 = 1.0 / d5;
        double d21 = 1.0 / d6;
        double d22 = 1.0 / d7;
        if (d20 >= 0.0) {
            d19 = (d8 - d2) * d20;
            d18 = (d11 - d2) * d20;
        } else {
            d19 = (d11 - d2) * d20;
            d18 = (d8 - d2) * d20;
        }
        if (d21 >= 0.0) {
            d17 = (d9 - d3) * d21;
            d16 = (d12 - d3) * d21;
        } else {
            d17 = (d12 - d3) * d21;
            d16 = (d9 - d3) * d21;
        }
        if (d19 > d16 || d17 > d18) {
            return false;
        }
        if (d22 >= 0.0) {
            d15 = (d10 - d4) * d22;
            d14 = (d13 - d4) * d22;
        } else {
            d15 = (d13 - d4) * d22;
            d14 = (d10 - d4) * d22;
        }
        if (d19 > d14 || d15 > d18) {
            return false;
        }
        d19 = d17 > d19 || Double.isNaN(d19) ? d17 : d19;
        d18 = d16 < d18 || Double.isNaN(d18) ? d16 : d18;
        d19 = d15 > d19 ? d15 : d19;
        double d23 = d18 = d14 < d18 ? d14 : d18;
        if (d19 < d18 && d18 >= 0.0) {
            vector2d.x = d19;
            vector2d.y = d18;
            return true;
        }
        return false;
    }

    public static boolean intersectRayAab(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Vector3dc vector3dc4, Vector2d vector2d) {
        return Intersectiond.intersectRayAab(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), vector3dc4.x(), vector3dc4.y(), vector3dc4.z(), vector2d);
    }

    public static int intersectLineSegmentAab(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, Vector2d vector2d) {
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19;
        double d20 = d5 - d2;
        double d21 = d6 - d3;
        double d22 = d7 - d4;
        double d23 = 1.0 / d20;
        double d24 = 1.0 / d21;
        double d25 = 1.0 / d22;
        if (d23 >= 0.0) {
            d19 = (d8 - d2) * d23;
            d18 = (d11 - d2) * d23;
        } else {
            d19 = (d11 - d2) * d23;
            d18 = (d8 - d2) * d23;
        }
        if (d24 >= 0.0) {
            d17 = (d9 - d3) * d24;
            d16 = (d12 - d3) * d24;
        } else {
            d17 = (d12 - d3) * d24;
            d16 = (d9 - d3) * d24;
        }
        if (d19 > d16 || d17 > d18) {
            return -1;
        }
        if (d25 >= 0.0) {
            d15 = (d10 - d4) * d25;
            d14 = (d13 - d4) * d25;
        } else {
            d15 = (d13 - d4) * d25;
            d14 = (d10 - d4) * d25;
        }
        if (d19 > d14 || d15 > d18) {
            return -1;
        }
        d19 = d17 > d19 || Double.isNaN(d19) ? d17 : d19;
        d18 = d16 < d18 || Double.isNaN(d18) ? d16 : d18;
        d19 = d15 > d19 ? d15 : d19;
        d18 = d14 < d18 ? d14 : d18;
        int n2 = -1;
        if (d19 <= d18 && d19 <= 1.0 && d18 >= 0.0) {
            if (d19 >= 0.0 && d18 > 1.0) {
                d18 = d19;
                n2 = 1;
            } else if (d19 < 0.0 && d18 <= 1.0) {
                d19 = d18;
                n2 = 1;
            } else {
                n2 = d19 < 0.0 && d18 > 1.0 ? 3 : 2;
            }
            vector2d.x = d19;
            vector2d.y = d18;
        }
        return n2;
    }

    public static int intersectLineSegmentAab(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Vector3dc vector3dc4, Vector2d vector2d) {
        return Intersectiond.intersectLineSegmentAab(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), vector3dc4.x(), vector3dc4.y(), vector3dc4.z(), vector2d);
    }

    public static boolean testRayAab(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13) {
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19;
        double d20 = 1.0 / d5;
        double d21 = 1.0 / d6;
        double d22 = 1.0 / d7;
        if (d20 >= 0.0) {
            d19 = (d8 - d2) * d20;
            d18 = (d11 - d2) * d20;
        } else {
            d19 = (d11 - d2) * d20;
            d18 = (d8 - d2) * d20;
        }
        if (d21 >= 0.0) {
            d17 = (d9 - d3) * d21;
            d16 = (d12 - d3) * d21;
        } else {
            d17 = (d12 - d3) * d21;
            d16 = (d9 - d3) * d21;
        }
        if (d19 > d16 || d17 > d18) {
            return false;
        }
        if (d22 >= 0.0) {
            d15 = (d10 - d4) * d22;
            d14 = (d13 - d4) * d22;
        } else {
            d15 = (d13 - d4) * d22;
            d14 = (d10 - d4) * d22;
        }
        if (d19 > d14 || d15 > d18) {
            return false;
        }
        d19 = d17 > d19 || Double.isNaN(d19) ? d17 : d19;
        d18 = d16 < d18 || Double.isNaN(d18) ? d16 : d18;
        d19 = d15 > d19 ? d15 : d19;
        d18 = d14 < d18 ? d14 : d18;
        return d19 < d18 && d18 >= 0.0;
    }

    public static boolean testRayAab(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Vector3dc vector3dc4) {
        return Intersectiond.testRayAab(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), vector3dc4.x(), vector3dc4.y(), vector3dc4.z());
    }

    public static boolean testRayTriangleFront(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17) {
        double d18 = d11 - d8;
        double d19 = d16 - d10;
        double d20 = d15 - d9;
        double d21 = d6 * d19 - d7 * d20;
        double d22 = d12 - d9;
        double d23 = d14 - d8;
        double d24 = d7 * d23 - d5 * d19;
        double d25 = d13 - d10;
        double d26 = d5 * d20 - d6 * d23;
        double d27 = d18 * d21 + d22 * d24 + d25 * d26;
        if (d27 < d17) {
            return false;
        }
        double d28 = d2 - d8;
        double d29 = d3 - d9;
        double d30 = d4 - d10;
        double d31 = d28 * d21 + d29 * d24 + d30 * d26;
        if (d31 < 0.0 || d31 > d27) {
            return false;
        }
        double d32 = d29 * d25 - d30 * d22;
        double d33 = d30 * d18 - d28 * d25;
        double d34 = d28 * d22 - d29 * d18;
        double d35 = d5 * d32 + d6 * d33 + d7 * d34;
        if (d35 < 0.0 || d31 + d35 > d27) {
            return false;
        }
        double d36 = 1.0 / d27;
        double d37 = (d23 * d32 + d20 * d33 + d19 * d34) * d36;
        return d37 >= d17;
    }

    public static boolean testRayTriangleFront(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Vector3dc vector3dc4, Vector3dc vector3dc5, double d2) {
        return Intersectiond.testRayTriangleFront(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), vector3dc4.x(), vector3dc4.y(), vector3dc4.z(), vector3dc5.x(), vector3dc5.y(), vector3dc5.z(), d2);
    }

    public static boolean testRayTriangle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17) {
        double d18 = d11 - d8;
        double d19 = d16 - d10;
        double d20 = d15 - d9;
        double d21 = d6 * d19 - d7 * d20;
        double d22 = d12 - d9;
        double d23 = d14 - d8;
        double d24 = d7 * d23 - d5 * d19;
        double d25 = d13 - d10;
        double d26 = d5 * d20 - d6 * d23;
        double d27 = d18 * d21 + d22 * d24 + d25 * d26;
        if (d27 > -d17 && d27 < d17) {
            return false;
        }
        double d28 = d2 - d8;
        double d29 = d3 - d9;
        double d30 = d4 - d10;
        double d31 = 1.0 / d27;
        double d32 = (d28 * d21 + d29 * d24 + d30 * d26) * d31;
        if (d32 < 0.0 || d32 > 1.0) {
            return false;
        }
        double d33 = d29 * d25 - d30 * d22;
        double d34 = d30 * d18 - d28 * d25;
        double d35 = d28 * d22 - d29 * d18;
        double d36 = (d5 * d33 + d6 * d34 + d7 * d35) * d31;
        if (d36 < 0.0 || d32 + d36 > 1.0) {
            return false;
        }
        double d37 = (d23 * d33 + d20 * d34 + d19 * d35) * d31;
        return d37 >= d17;
    }

    public static boolean testRayTriangle(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Vector3dc vector3dc4, Vector3dc vector3dc5, double d2) {
        return Intersectiond.testRayTriangle(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), vector3dc4.x(), vector3dc4.y(), vector3dc4.z(), vector3dc5.x(), vector3dc5.y(), vector3dc5.z(), d2);
    }

    public static double intersectRayTriangleFront(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17) {
        double d18 = d11 - d8;
        double d19 = d16 - d10;
        double d20 = d15 - d9;
        double d21 = d6 * d19 - d7 * d20;
        double d22 = d12 - d9;
        double d23 = d14 - d8;
        double d24 = d7 * d23 - d5 * d19;
        double d25 = d13 - d10;
        double d26 = d5 * d20 - d6 * d23;
        double d27 = d18 * d21 + d22 * d24 + d25 * d26;
        if (d27 <= d17) {
            return -1.0;
        }
        double d28 = d2 - d8;
        double d29 = d3 - d9;
        double d30 = d4 - d10;
        double d31 = d28 * d21 + d29 * d24 + d30 * d26;
        if (d31 < 0.0 || d31 > d27) {
            return -1.0;
        }
        double d32 = d29 * d25 - d30 * d22;
        double d33 = d30 * d18 - d28 * d25;
        double d34 = d28 * d22 - d29 * d18;
        double d35 = d5 * d32 + d6 * d33 + d7 * d34;
        if (d35 < 0.0 || d31 + d35 > d27) {
            return -1.0;
        }
        double d36 = 1.0 / d27;
        double d37 = (d23 * d32 + d20 * d33 + d19 * d34) * d36;
        return d37;
    }

    public static double intersectRayTriangleFront(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Vector3dc vector3dc4, Vector3dc vector3dc5, double d2) {
        return Intersectiond.intersectRayTriangleFront(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), vector3dc4.x(), vector3dc4.y(), vector3dc4.z(), vector3dc5.x(), vector3dc5.y(), vector3dc5.z(), d2);
    }

    public static double intersectRayTriangle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17) {
        double d18 = d11 - d8;
        double d19 = d16 - d10;
        double d20 = d15 - d9;
        double d21 = d6 * d19 - d7 * d20;
        double d22 = d12 - d9;
        double d23 = d14 - d8;
        double d24 = d7 * d23 - d5 * d19;
        double d25 = d13 - d10;
        double d26 = d5 * d20 - d6 * d23;
        double d27 = d18 * d21 + d22 * d24 + d25 * d26;
        if (d27 > -d17 && d27 < d17) {
            return -1.0;
        }
        double d28 = d2 - d8;
        double d29 = d3 - d9;
        double d30 = d4 - d10;
        double d31 = 1.0 / d27;
        double d32 = (d28 * d21 + d29 * d24 + d30 * d26) * d31;
        if (d32 < 0.0 || d32 > 1.0) {
            return -1.0;
        }
        double d33 = d29 * d25 - d30 * d22;
        double d34 = d30 * d18 - d28 * d25;
        double d35 = d28 * d22 - d29 * d18;
        double d36 = (d5 * d33 + d6 * d34 + d7 * d35) * d31;
        if (d36 < 0.0 || d32 + d36 > 1.0) {
            return -1.0;
        }
        double d37 = (d23 * d33 + d20 * d34 + d19 * d35) * d31;
        return d37;
    }

    public static double intersectRayTriangle(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Vector3dc vector3dc4, Vector3dc vector3dc5, double d2) {
        return Intersectiond.intersectRayTriangle(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), vector3dc4.x(), vector3dc4.y(), vector3dc4.z(), vector3dc5.x(), vector3dc5.y(), vector3dc5.z(), d2);
    }

    public static boolean testLineSegmentTriangle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17) {
        double d18 = d5 - d2;
        double d19 = d6 - d3;
        double d20 = d7 - d4;
        double d21 = Intersectiond.intersectRayTriangle(d2, d3, d4, d18, d19, d20, d8, d9, d10, d11, d12, d13, d14, d15, d16, d17);
        return d21 >= 0.0 && d21 <= 1.0;
    }

    public static boolean testLineSegmentTriangle(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Vector3dc vector3dc4, Vector3dc vector3dc5, double d2) {
        return Intersectiond.testLineSegmentTriangle(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), vector3dc4.x(), vector3dc4.y(), vector3dc4.z(), vector3dc5.x(), vector3dc5.y(), vector3dc5.z(), d2);
    }

    public static boolean intersectLineSegmentTriangle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17, Vector3d vector3d) {
        double d18 = d5 - d2;
        double d19 = d6 - d3;
        double d20 = d7 - d4;
        double d21 = Intersectiond.intersectRayTriangle(d2, d3, d4, d18, d19, d20, d8, d9, d10, d11, d12, d13, d14, d15, d16, d17);
        if (d21 >= 0.0 && d21 <= 1.0) {
            vector3d.x = d2 + d18 * d21;
            vector3d.y = d3 + d19 * d21;
            vector3d.z = d4 + d20 * d21;
            return true;
        }
        return false;
    }

    public static boolean intersectLineSegmentTriangle(Vector3dc vector3dc, Vector3dc vector3dc2, Vector3dc vector3dc3, Vector3dc vector3dc4, Vector3dc vector3dc5, double d2, Vector3d vector3d) {
        return Intersectiond.intersectLineSegmentTriangle(vector3dc.x(), vector3dc.y(), vector3dc.z(), vector3dc2.x(), vector3dc2.y(), vector3dc2.z(), vector3dc3.x(), vector3dc3.y(), vector3dc3.z(), vector3dc4.x(), vector3dc4.y(), vector3dc4.z(), vector3dc5.x(), vector3dc5.y(), vector3dc5.z(), d2, vector3d);
    }

    public static boolean intersectLineSegmentPlane(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, Vector3d vector3d) {
        double d12 = d5 - d2;
        double d13 = d6 - d3;
        double d14 = d7 - d4;
        double d15 = d8 * d12 + d9 * d13 + d10 * d14;
        double d16 = -(d8 * d2 + d9 * d3 + d10 * d4 + d11) / d15;
        if (d16 >= 0.0 && d16 <= 1.0) {
            vector3d.x = d2 + d16 * d12;
            vector3d.y = d3 + d16 * d13;
            vector3d.z = d4 + d16 * d14;
            return true;
        }
        return false;
    }

    public static boolean testLineCircle(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = Math.sqrt(d2 * d2 + d3 * d3);
        double d9 = (d2 * d5 + d3 * d6 + d4) / d8;
        return -d7 <= d9 && d9 <= d7;
    }

    public static boolean intersectLineCircle(double d2, double d3, double d4, double d5, double d6, double d7, Vector3d vector3d) {
        double d8 = Math.invsqrt(d2 * d2 + d3 * d3);
        double d9 = (d2 * d5 + d3 * d6 + d4) * d8;
        if (-d7 <= d9 && d9 <= d7) {
            vector3d.x = d5 + d9 * d2 * d8;
            vector3d.y = d6 + d9 * d3 * d8;
            vector3d.z = Math.sqrt(d7 * d7 - d9 * d9);
            return true;
        }
        return false;
    }

    public static boolean intersectLineCircle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, Vector3d vector3d) {
        return Intersectiond.intersectLineCircle(d3 - d5, d4 - d2, (d2 - d4) * d3 + (d5 - d3) * d2, d6, d7, d8, vector3d);
    }

    public static boolean testAarLine(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10;
        double d11;
        double d12;
        if (d6 > 0.0) {
            d12 = d4;
            d11 = d2;
        } else {
            d12 = d2;
            d11 = d4;
        }
        if (d7 > 0.0) {
            d10 = d5;
            d9 = d3;
        } else {
            d10 = d3;
            d9 = d5;
        }
        double d13 = d8 + d6 * d11 + d7 * d9;
        double d14 = d8 + d6 * d12 + d7 * d10;
        return d13 <= 0.0 && d14 >= 0.0;
    }

    public static boolean testAarLine(Vector2dc vector2dc, Vector2dc vector2dc2, double d2, double d3, double d4) {
        return Intersectiond.testAarLine(vector2dc.x(), vector2dc.y(), vector2dc2.x(), vector2dc2.y(), d2, d3, d4);
    }

    public static boolean testAarLine(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d7 - d9;
        double d11 = d8 - d6;
        double d12 = -d11 * d7 - d10 * d6;
        return Intersectiond.testAarLine(d2, d3, d4, d5, d10, d11, d12);
    }

    public static boolean testAarAar(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        return d4 >= d6 && d5 >= d7 && d2 <= d8 && d3 <= d9;
    }

    public static boolean testAarAar(Vector2dc vector2dc, Vector2dc vector2dc2, Vector2dc vector2dc3, Vector2dc vector2dc4) {
        return Intersectiond.testAarAar(vector2dc.x(), vector2dc.y(), vector2dc2.x(), vector2dc2.y(), vector2dc3.x(), vector2dc3.y(), vector2dc4.x(), vector2dc4.y());
    }

    public static boolean testMovingCircleCircle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10;
        double d11 = d6 + d9;
        double d12 = Math.sqrt((d2 - d7) * (d2 - d7) + (d3 - d8) * (d3 - d8)) - d11;
        double d13 = Math.sqrt(d4 * d4 + d5 * d5);
        if (d13 < d12) {
            return false;
        }
        double d14 = 1.0 / d13;
        double d15 = d4 * d14;
        double d16 = d7 - d2;
        double d17 = d5 * d14;
        double d18 = d8 - d3;
        double d19 = d15 * d16 + d17 * d18;
        if (d19 <= 0.0) {
            return false;
        }
        double d20 = Math.sqrt(d16 * d16 + d18 * d18);
        double d21 = d20 * d20 - d19 * d19;
        if (d21 >= (d10 = d11 * d11)) {
            return false;
        }
        double d22 = d10 - d21;
        if (d22 < 0.0) {
            return false;
        }
        double d23 = d13;
        double d24 = d19 - Math.sqrt(d22);
        return !(d23 < d24);
    }

    public static boolean testMovingCircleCircle(Vector2d vector2d, Vector2d vector2d2, double d2, Vector2d vector2d3, double d3) {
        return Intersectiond.testMovingCircleCircle(vector2d.x, vector2d.y, vector2d2.x, vector2d2.y, d2, vector2d3.x, vector2d3.y, d3);
    }

    public static boolean intersectCircleCircle(double d2, double d3, double d4, double d5, double d6, double d7, Vector3d vector3d) {
        double d8 = d5 - d2;
        double d9 = d6 - d3;
        double d10 = d8 * d8 + d9 * d9;
        double d11 = 0.5 + (d4 - d7) / d10;
        double d12 = Math.sqrt(d4 - d11 * d11 * d10);
        if (d12 >= 0.0) {
            vector3d.x = d2 + d11 * d8;
            vector3d.y = d3 + d11 * d9;
            vector3d.z = d12;
            return true;
        }
        return false;
    }

    public static boolean intersectCircleCircle(Vector2dc vector2dc, double d2, Vector2dc vector2dc2, double d3, Vector3d vector3d) {
        return Intersectiond.intersectCircleCircle(vector2dc.x(), vector2dc.y(), d2, vector2dc2.x(), vector2dc2.y(), d3, vector3d);
    }

    public static boolean testCircleCircle(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = (d2 - d5) * (d2 - d5) + (d3 - d6) * (d3 - d6);
        return d8 <= (d4 + d7) * (d4 + d7);
    }

    public static boolean testCircleCircle(Vector2dc vector2dc, double d2, Vector2dc vector2dc2, double d3) {
        return Intersectiond.testCircleCircle(vector2dc.x(), vector2dc.y(), d2, vector2dc2.x(), vector2dc2.y(), d3);
    }

    public static double distancePointLine(double d2, double d3, double d4, double d5, double d6) {
        double d7 = Math.sqrt(d4 * d4 + d5 * d5);
        return (d4 * d2 + d5 * d3 + d6) / d7;
    }

    public static double distancePointLine(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d6 - d4;
        double d9 = d7 - d5;
        double d10 = Math.sqrt(d8 * d8 + d9 * d9);
        return (d8 * (d5 - d3) - (d4 - d2) * d9) / d10;
    }

    public static double distancePointLine(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11 = d8 - d5;
        double d12 = d9 - d6;
        double d13 = d10 - d7;
        double d14 = d5 - d2;
        double d15 = d6 - d3;
        double d16 = d7 - d4;
        double d17 = d12 * d16 - d13 * d15;
        double d18 = d13 * d14 - d11 * d16;
        double d19 = d11 * d15 - d12 * d14;
        return Math.sqrt((d17 * d17 + d18 * d18 + d19 * d19) / (d11 * d11 + d12 * d12 + d13 * d13));
    }

    public static double intersectRayLine(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11;
        double d12 = d8 * d4 + d9 * d5;
        if (d12 < d10 && (d11 = ((d6 - d2) * d8 + (d7 - d3) * d9) / d12) >= 0.0) {
            return d11;
        }
        return -1.0;
    }

    public static double intersectRayLine(Vector2dc vector2dc, Vector2dc vector2dc2, Vector2dc vector2dc3, Vector2dc vector2dc4, double d2) {
        return Intersectiond.intersectRayLine(vector2dc.x(), vector2dc.y(), vector2dc2.x(), vector2dc2.y(), vector2dc3.x(), vector2dc3.y(), vector2dc4.x(), vector2dc4.y(), d2);
    }

    public static double intersectRayLineSegment(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d2 - d6;
        double d11 = d3 - d7;
        double d12 = d8 - d6;
        double d13 = d9 - d7;
        double d14 = 1.0 / (d13 * d4 - d12 * d5);
        double d15 = (d12 * d11 - d13 * d10) * d14;
        double d16 = (d11 * d4 - d10 * d5) * d14;
        if (d15 >= 0.0 && d16 >= 0.0 && d16 <= 1.0) {
            return d15;
        }
        return -1.0;
    }

    public static double intersectRayLineSegment(Vector2dc vector2dc, Vector2dc vector2dc2, Vector2dc vector2dc3, Vector2dc vector2dc4) {
        return Intersectiond.intersectRayLineSegment(vector2dc.x(), vector2dc.y(), vector2dc2.x(), vector2dc2.y(), vector2dc3.x(), vector2dc3.y(), vector2dc4.x(), vector2dc4.y());
    }

    public static boolean testAarCircle(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10 = d8;
        if (d6 < d2) {
            d9 = d6 - d2;
            d10 -= d9 * d9;
        } else if (d6 > d4) {
            d9 = d6 - d4;
            d10 -= d9 * d9;
        }
        if (d7 < d3) {
            d9 = d7 - d3;
            d10 -= d9 * d9;
        } else if (d7 > d5) {
            d9 = d7 - d5;
            d10 -= d9 * d9;
        }
        return d10 >= 0.0;
    }

    public static boolean testAarCircle(Vector2dc vector2dc, Vector2dc vector2dc2, Vector2dc vector2dc3, double d2) {
        return Intersectiond.testAarCircle(vector2dc.x(), vector2dc.y(), vector2dc2.x(), vector2dc2.y(), vector2dc3.x(), vector2dc3.y(), d2);
    }

    public static int findClosestPointOnTriangle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, Vector2d vector2d) {
        double d10 = d4 - d2;
        double d11 = d5 - d3;
        double d12 = d6 - d2;
        double d13 = d7 - d3;
        double d14 = d8 - d2;
        double d15 = d9 - d3;
        double d16 = d10 * d14 + d11 * d15;
        double d17 = d12 * d14 + d13 * d15;
        if (d16 <= 0.0 && d17 <= 0.0) {
            vector2d.x = d2;
            vector2d.y = d3;
            return 1;
        }
        double d18 = d8 - d4;
        double d19 = d9 - d5;
        double d20 = d10 * d18 + d11 * d19;
        double d21 = d12 * d18 + d13 * d19;
        if (d20 >= 0.0 && d21 <= d20) {
            vector2d.x = d4;
            vector2d.y = d5;
            return 2;
        }
        double d22 = d16 * d21 - d20 * d17;
        if (d22 <= 0.0 && d16 >= 0.0 && d20 <= 0.0) {
            double d23 = d16 / (d16 - d20);
            vector2d.x = d2 + d23 * d10;
            vector2d.y = d3 + d23 * d11;
            return 4;
        }
        double d24 = d8 - d6;
        double d25 = d9 - d7;
        double d26 = d10 * d24 + d11 * d25;
        double d27 = d12 * d24 + d13 * d25;
        if (d27 >= 0.0 && d26 <= d27) {
            vector2d.x = d6;
            vector2d.y = d7;
            return 3;
        }
        double d28 = d26 * d17 - d16 * d27;
        if (d28 <= 0.0 && d17 >= 0.0 && d27 <= 0.0) {
            double d29 = d17 / (d17 - d27);
            vector2d.x = d2 + d29 * d12;
            vector2d.y = d3 + d29 * d13;
            return 6;
        }
        double d30 = d20 * d27 - d26 * d21;
        if (d30 <= 0.0 && d21 - d20 >= 0.0 && d26 - d27 >= 0.0) {
            double d31 = (d21 - d20) / (d21 - d20 + d26 - d27);
            vector2d.x = d4 + d31 * (d6 - d4);
            vector2d.y = d5 + d31 * (d7 - d5);
            return 5;
        }
        double d32 = 1.0 / (d30 + d28 + d22);
        double d33 = d28 * d32;
        double d34 = d22 * d32;
        vector2d.x = d2 + d10 * d33 + d12 * d34;
        vector2d.y = d3 + d11 * d33 + d13 * d34;
        return 7;
    }

    public static int findClosestPointOnTriangle(Vector2dc vector2dc, Vector2dc vector2dc2, Vector2dc vector2dc3, Vector2dc vector2dc4, Vector2d vector2d) {
        return Intersectiond.findClosestPointOnTriangle(vector2dc.x(), vector2dc.y(), vector2dc2.x(), vector2dc2.y(), vector2dc3.x(), vector2dc3.y(), vector2dc4.x(), vector2dc4.y(), vector2d);
    }

    public static boolean intersectRayCircle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, Vector2d vector2d) {
        double d9;
        double d10 = d6 - d2;
        double d11 = d7 - d3;
        double d12 = d10 * d4 + d11 * d5;
        double d13 = d10 * d10 + d11 * d11 - d12 * d12;
        if (d13 > d8) {
            return false;
        }
        double d14 = Math.sqrt(d8 - d13);
        double d15 = d12 - d14;
        if (d15 < (d9 = d12 + d14) && d9 >= 0.0) {
            vector2d.x = d15;
            vector2d.y = d9;
            return true;
        }
        return false;
    }

    public static boolean intersectRayCircle(Vector2dc vector2dc, Vector2dc vector2dc2, Vector2dc vector2dc3, double d2, Vector2d vector2d) {
        return Intersectiond.intersectRayCircle(vector2dc.x(), vector2dc.y(), vector2dc2.x(), vector2dc2.y(), vector2dc3.x(), vector2dc3.y(), d2, vector2d);
    }

    public static boolean testRayCircle(double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10 = d6 - d2;
        double d11 = d7 - d3;
        double d12 = d10 * d4 + d11 * d5;
        double d13 = d10 * d10 + d11 * d11 - d12 * d12;
        if (d13 > d8) {
            return false;
        }
        double d14 = Math.sqrt(d8 - d13);
        double d15 = d12 - d14;
        return d15 < (d9 = d12 + d14) && d9 >= 0.0;
    }

    public static boolean testRayCircle(Vector2dc vector2dc, Vector2dc vector2dc2, Vector2dc vector2dc3, double d2) {
        return Intersectiond.testRayCircle(vector2dc.x(), vector2dc.y(), vector2dc2.x(), vector2dc2.y(), vector2dc3.x(), vector2dc3.y(), d2);
    }

    public static int intersectRayAar(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, Vector2d vector2d) {
        double d10;
        double d11;
        double d12;
        double d13;
        double d14 = 1.0 / d4;
        double d15 = 1.0 / d5;
        if (d14 >= 0.0) {
            d13 = (d6 - d2) * d14;
            d12 = (d8 - d2) * d14;
        } else {
            d13 = (d8 - d2) * d14;
            d12 = (d6 - d2) * d14;
        }
        if (d15 >= 0.0) {
            d11 = (d7 - d3) * d15;
            d10 = (d9 - d3) * d15;
        } else {
            d11 = (d9 - d3) * d15;
            d10 = (d7 - d3) * d15;
        }
        if (d13 > d10 || d11 > d12) {
            return -1;
        }
        d13 = d11 > d13 || Double.isNaN(d13) ? d11 : d13;
        d12 = d10 < d12 || Double.isNaN(d12) ? d10 : d12;
        int n2 = -1;
        if (d13 < d12 && d12 >= 0.0) {
            double d16 = d2 + d13 * d4;
            double d17 = d3 + d13 * d5;
            vector2d.x = d13;
            vector2d.y = d12;
            double d18 = Math.abs(d16 - d6);
            double d19 = Math.abs(d17 - d7);
            double d20 = Math.abs(d16 - d8);
            double d21 = Math.abs(d17 - d9);
            n2 = 0;
            double d22 = d18;
            if (d19 < d22) {
                d22 = d19;
                n2 = 1;
            }
            if (d20 < d22) {
                d22 = d20;
                n2 = 2;
            }
            if (d21 < d22) {
                n2 = 3;
            }
        }
        return n2;
    }

    public static int intersectRayAar(Vector2dc vector2dc, Vector2dc vector2dc2, Vector2dc vector2dc3, Vector2dc vector2dc4, Vector2d vector2d) {
        return Intersectiond.intersectRayAar(vector2dc.x(), vector2dc.y(), vector2dc2.x(), vector2dc2.y(), vector2dc3.x(), vector2dc3.y(), vector2dc4.x(), vector2dc4.y(), vector2d);
    }

    public static int intersectLineSegmentAar(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, Vector2d vector2d) {
        double d10;
        double d11;
        double d12;
        double d13;
        double d14 = d4 - d2;
        double d15 = d5 - d3;
        double d16 = 1.0 / d14;
        double d17 = 1.0 / d15;
        if (d16 >= 0.0) {
            d13 = (d6 - d2) * d16;
            d12 = (d8 - d2) * d16;
        } else {
            d13 = (d8 - d2) * d16;
            d12 = (d6 - d2) * d16;
        }
        if (d17 >= 0.0) {
            d11 = (d7 - d3) * d17;
            d10 = (d9 - d3) * d17;
        } else {
            d11 = (d9 - d3) * d17;
            d10 = (d7 - d3) * d17;
        }
        if (d13 > d10 || d11 > d12) {
            return -1;
        }
        d13 = d11 > d13 || Double.isNaN(d13) ? d11 : d13;
        d12 = d10 < d12 || Double.isNaN(d12) ? d10 : d12;
        int n2 = -1;
        if (d13 <= d12 && d13 <= 1.0 && d12 >= 0.0) {
            if (d13 >= 0.0 && d12 > 1.0) {
                d12 = d13;
                n2 = 1;
            } else if (d13 < 0.0 && d12 <= 1.0) {
                d13 = d12;
                n2 = 1;
            } else {
                n2 = d13 < 0.0 && d12 > 1.0 ? 3 : 2;
            }
            vector2d.x = d13;
            vector2d.y = d12;
        }
        return n2;
    }

    public static int intersectLineSegmentAar(Vector2dc vector2dc, Vector2dc vector2dc2, Vector2dc vector2dc3, Vector2dc vector2dc4, Vector2d vector2d) {
        return Intersectiond.intersectLineSegmentAar(vector2dc.x(), vector2dc.y(), vector2dc2.x(), vector2dc2.y(), vector2dc3.x(), vector2dc3.y(), vector2dc4.x(), vector2dc4.y(), vector2d);
    }

    public static boolean testRayAar(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10;
        double d11;
        double d12;
        double d13;
        double d14 = 1.0 / d4;
        double d15 = 1.0 / d5;
        if (d14 >= 0.0) {
            d13 = (d6 - d2) * d14;
            d12 = (d8 - d2) * d14;
        } else {
            d13 = (d8 - d2) * d14;
            d12 = (d6 - d2) * d14;
        }
        if (d15 >= 0.0) {
            d11 = (d7 - d3) * d15;
            d10 = (d9 - d3) * d15;
        } else {
            d11 = (d9 - d3) * d15;
            d10 = (d7 - d3) * d15;
        }
        if (d13 > d10 || d11 > d12) {
            return false;
        }
        d13 = d11 > d13 || Double.isNaN(d13) ? d11 : d13;
        d12 = d10 < d12 || Double.isNaN(d12) ? d10 : d12;
        return d13 < d12 && d12 >= 0.0;
    }

    public static boolean testRayAar(Vector2dc vector2dc, Vector2dc vector2dc2, Vector2dc vector2dc3, Vector2dc vector2dc4) {
        return Intersectiond.testRayAar(vector2dc.x(), vector2dc.y(), vector2dc2.x(), vector2dc2.y(), vector2dc3.x(), vector2dc3.y(), vector2dc4.x(), vector2dc4.y());
    }

    public static boolean testPointTriangle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        boolean bl2;
        boolean bl3 = (d2 - d6) * (d5 - d7) - (d4 - d6) * (d3 - d7) < 0.0;
        boolean bl4 = bl2 = (d2 - d8) * (d7 - d9) - (d6 - d8) * (d3 - d9) < 0.0;
        if (bl3 != bl2) {
            return false;
        }
        boolean bl5 = (d2 - d4) * (d9 - d5) - (d8 - d4) * (d3 - d5) < 0.0;
        return bl2 == bl5;
    }

    public static boolean testPointTriangle(Vector2dc vector2dc, Vector2dc vector2dc2, Vector2dc vector2dc3, Vector2dc vector2dc4) {
        return Intersectiond.testPointTriangle(vector2dc.x(), vector2dc.y(), vector2dc2.x(), vector2dc2.y(), vector2dc3.x(), vector2dc3.y(), vector2dc4.x(), vector2dc4.y());
    }

    public static boolean testPointAar(double d2, double d3, double d4, double d5, double d6, double d7) {
        return d2 >= d4 && d3 >= d5 && d2 <= d6 && d3 <= d7;
    }

    public static boolean testPointCircle(double d2, double d3, double d4, double d5, double d6) {
        double d7 = d2 - d4;
        double d8 = d7 * d7;
        double d9 = d3 - d5;
        double d10 = d9 * d9;
        return d8 + d10 <= d6;
    }

    public static boolean testCircleTriangle(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11;
        double d12 = d2 - d5;
        double d13 = d3 - d6;
        double d14 = d12 * d12 + d13 * d13 - d4;
        if (d14 <= 0.0) {
            return true;
        }
        double d15 = d2 - d7;
        double d16 = d3 - d8;
        double d17 = d15 * d15 + d16 * d16 - d4;
        if (d17 <= 0.0) {
            return true;
        }
        double d18 = d2 - d9;
        double d19 = d3 - d10;
        double d20 = d18 * d18 + d19 * d19 - d4;
        if (d20 <= 0.0) {
            return true;
        }
        double d21 = d7 - d5;
        double d22 = d8 - d6;
        double d23 = d9 - d7;
        double d24 = d10 - d8;
        double d25 = d5 - d9;
        double d26 = d6 - d10;
        if (d21 * d13 - d22 * d12 >= 0.0 && d23 * d16 - d24 * d15 >= 0.0 && d25 * d19 - d26 * d18 >= 0.0) {
            return true;
        }
        double d27 = d12 * d21 + d13 * d22;
        if (d27 >= 0.0 && d27 <= (d11 = d21 * d21 + d22 * d22) && d14 * d11 <= d27 * d27) {
            return true;
        }
        d27 = d15 * d23 + d16 * d24;
        if (d27 > 0.0 && d27 <= (d11 = d23 * d23 + d24 * d24) && d17 * d11 <= d27 * d27) {
            return true;
        }
        d27 = d18 * d25 + d19 * d26;
        return d27 >= 0.0 && d27 < (d11 = d25 * d25 + d26 * d26) && d20 * d11 <= d27 * d27;
    }

    public static boolean testCircleTriangle(Vector2dc vector2dc, double d2, Vector2dc vector2dc2, Vector2dc vector2dc3, Vector2dc vector2dc4) {
        return Intersectiond.testCircleTriangle(vector2dc.x(), vector2dc.y(), d2, vector2dc2.x(), vector2dc2.y(), vector2dc3.x(), vector2dc3.y(), vector2dc4.x(), vector2dc4.y());
    }

    public static int intersectPolygonRay(double[] dArray, double d2, double d3, double d4, double d5, Vector2d vector2d) {
        double d6 = Double.POSITIVE_INFINITY;
        int n2 = dArray.length >> 1;
        int n3 = -1;
        double d7 = dArray[n2 - 1 << 1];
        double d8 = dArray[(n2 - 1 << 1) + 1];
        for (int i2 = 0; i2 < n2; ++i2) {
            double d9;
            double d10 = dArray[i2 << 1];
            double d11 = d10 - d7;
            double d12 = d3 - d8;
            double d13 = dArray[(i2 << 1) + 1];
            double d14 = d13 - d8;
            double d15 = d2 - d7;
            double d16 = 1.0 / (d14 * d4 - d11 * d5);
            double d17 = (d11 * d12 - d14 * d15) * d16;
            if (d17 >= 0.0 && d17 < d6 && (d9 = (d12 * d4 - d15 * d5) * d16) >= 0.0 && d9 <= 1.0) {
                n3 = (i2 - 1 + n2) % n2;
                d6 = d17;
                vector2d.x = d2 + d17 * d4;
                vector2d.y = d3 + d17 * d5;
            }
            d7 = d10;
            d8 = d13;
        }
        return n3;
    }

    public static int intersectPolygonRay(Vector2dc[] vector2dcArray, double d2, double d3, double d4, double d5, Vector2d vector2d) {
        double d6 = Double.POSITIVE_INFINITY;
        int n2 = vector2dcArray.length;
        int n3 = -1;
        double d7 = vector2dcArray[n2 - 1].x();
        double d8 = vector2dcArray[n2 - 1].y();
        for (int i2 = 0; i2 < n2; ++i2) {
            double d9;
            double d10;
            double d11;
            double d12;
            double d13;
            double d14;
            Vector2dc vector2dc = vector2dcArray[i2];
            double d15 = vector2dc.x();
            double d16 = d15 - d7;
            double d17 = (d16 * (d14 = d3 - d8) - (d13 = (d12 = vector2dc.y()) - d8) * (d11 = d2 - d7)) * (d10 = 1.0 / (d13 * d4 - d16 * d5));
            if (d17 >= 0.0 && d17 < d6 && (d9 = (d14 * d4 - d11 * d5) * d10) >= 0.0 && d9 <= 1.0) {
                n3 = (i2 - 1 + n2) % n2;
                d6 = d17;
                vector2d.x = d2 + d17 * d4;
                vector2d.y = d3 + d17 * d5;
            }
            d7 = d15;
            d8 = d12;
        }
        return n3;
    }

    public static boolean intersectLineLine(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, Vector2d vector2d) {
        double d10 = d2 - d4;
        double d11 = d5 - d3;
        double d12 = d11 * d2 + d10 * d3;
        double d13 = d6 - d8;
        double d14 = d9 - d7;
        double d15 = d14 * d6 + d13 * d7;
        double d16 = d11 * d13 - d14 * d10;
        if (d16 == 0.0) {
            return false;
        }
        vector2d.x = (d13 * d12 - d10 * d15) / d16;
        vector2d.y = (d11 * d15 - d14 * d12) / d16;
        return true;
    }

    private static boolean separatingAxis(Vector2d[] vector2dArray, Vector2d[] vector2dArray2, double d2, double d3) {
        double d4 = Double.POSITIVE_INFINITY;
        double d5 = Double.NEGATIVE_INFINITY;
        double d6 = Double.POSITIVE_INFINITY;
        double d7 = Double.NEGATIVE_INFINITY;
        int n2 = Math.max(vector2dArray.length, vector2dArray2.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            double d8;
            Vector2d vector2d;
            if (i2 < vector2dArray.length) {
                vector2d = vector2dArray[i2];
                d8 = vector2d.x * d2 + vector2d.y * d3;
                if (d8 < d4) {
                    d4 = d8;
                }
                if (d8 > d5) {
                    d5 = d8;
                }
            }
            if (i2 < vector2dArray2.length) {
                vector2d = vector2dArray2[i2];
                d8 = vector2d.x * d2 + vector2d.y * d3;
                if (d8 < d6) {
                    d6 = d8;
                }
                if (d8 > d7) {
                    d7 = d8;
                }
            }
            if (!(d4 <= d7) || !(d6 <= d5)) continue;
            return false;
        }
        return true;
    }

    public static boolean testPolygonPolygon(Vector2d[] vector2dArray, Vector2d[] vector2dArray2) {
        Vector2d vector2d;
        Vector2d vector2d2;
        int n2 = 0;
        int n3 = vector2dArray.length - 1;
        while (n2 < vector2dArray.length) {
            vector2d2 = vector2dArray[n2];
            vector2d = vector2dArray[n3];
            if (Intersectiond.separatingAxis(vector2dArray, vector2dArray2, vector2d2.y - vector2d.y, vector2d.x - vector2d2.x)) {
                return false;
            }
            n3 = n2++;
        }
        n2 = 0;
        n3 = vector2dArray2.length - 1;
        while (n2 < vector2dArray2.length) {
            vector2d2 = vector2dArray2[n2];
            vector2d = vector2dArray2[n3];
            if (Intersectiond.separatingAxis(vector2dArray, vector2dArray2, vector2d2.y - vector2d.y, vector2d.x - vector2d2.x)) {
                return false;
            }
            n3 = n2++;
        }
        return true;
    }
}

