/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import org.joml.Math;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class FrustumRayBuilder {
    private float nxnyX;
    private float nxnyY;
    private float nxnyZ;
    private float pxnyX;
    private float pxnyY;
    private float pxnyZ;
    private float pxpyX;
    private float pxpyY;
    private float pxpyZ;
    private float nxpyX;
    private float nxpyY;
    private float nxpyZ;
    private float cx;
    private float cy;
    private float cz;

    public FrustumRayBuilder() {
    }

    public FrustumRayBuilder(Matrix4fc matrix4fc) {
        this.set(matrix4fc);
    }

    public FrustumRayBuilder set(Matrix4fc matrix4fc) {
        float f2 = matrix4fc.m03() + matrix4fc.m00();
        float f3 = matrix4fc.m13() + matrix4fc.m10();
        float f4 = matrix4fc.m23() + matrix4fc.m20();
        float f5 = matrix4fc.m33() + matrix4fc.m30();
        float f6 = matrix4fc.m03() - matrix4fc.m00();
        float f7 = matrix4fc.m13() - matrix4fc.m10();
        float f8 = matrix4fc.m23() - matrix4fc.m20();
        float f9 = matrix4fc.m33() - matrix4fc.m30();
        float f10 = matrix4fc.m03() + matrix4fc.m01();
        float f11 = matrix4fc.m13() + matrix4fc.m11();
        float f12 = matrix4fc.m23() + matrix4fc.m21();
        float f13 = matrix4fc.m03() - matrix4fc.m01();
        float f14 = matrix4fc.m13() - matrix4fc.m11();
        float f15 = matrix4fc.m23() - matrix4fc.m21();
        float f16 = matrix4fc.m33() - matrix4fc.m31();
        this.nxnyX = f11 * f4 - f12 * f3;
        this.nxnyY = f12 * f2 - f10 * f4;
        this.nxnyZ = f10 * f3 - f11 * f2;
        this.pxnyX = f7 * f12 - f8 * f11;
        this.pxnyY = f8 * f10 - f6 * f12;
        this.pxnyZ = f6 * f11 - f7 * f10;
        this.nxpyX = f3 * f15 - f4 * f14;
        this.nxpyY = f4 * f13 - f2 * f15;
        this.nxpyZ = f2 * f14 - f3 * f13;
        this.pxpyX = f14 * f8 - f15 * f7;
        this.pxpyY = f15 * f6 - f13 * f8;
        this.pxpyZ = f13 * f7 - f14 * f6;
        float f17 = f7 * f4 - f8 * f3;
        float f18 = f8 * f2 - f6 * f4;
        float f19 = f6 * f3 - f7 * f2;
        float f20 = 1.0f / (f2 * this.pxpyX + f3 * this.pxpyY + f4 * this.pxpyZ);
        this.cx = (-this.pxpyX * f5 - this.nxpyX * f9 - f17 * f16) * f20;
        this.cy = (-this.pxpyY * f5 - this.nxpyY * f9 - f18 * f16) * f20;
        this.cz = (-this.pxpyZ * f5 - this.nxpyZ * f9 - f19 * f16) * f20;
        return this;
    }

    public Vector3fc origin(Vector3f vector3f) {
        vector3f.x = this.cx;
        vector3f.y = this.cy;
        vector3f.z = this.cz;
        return vector3f;
    }

    public Vector3fc dir(float f2, float f3, Vector3f vector3f) {
        float f4 = this.nxnyX + (this.nxpyX - this.nxnyX) * f3;
        float f5 = this.nxnyY + (this.nxpyY - this.nxnyY) * f3;
        float f6 = this.nxnyZ + (this.nxpyZ - this.nxnyZ) * f3;
        float f7 = this.pxnyX + (this.pxpyX - this.pxnyX) * f3;
        float f8 = this.pxnyY + (this.pxpyY - this.pxnyY) * f3;
        float f9 = this.pxnyZ + (this.pxpyZ - this.pxnyZ) * f3;
        float f10 = f4 + (f7 - f4) * f2;
        float f11 = f5 + (f8 - f5) * f2;
        float f12 = f6 + (f9 - f6) * f2;
        float f13 = Math.invsqrt(f10 * f10 + f11 * f11 + f12 * f12);
        vector3f.x = f10 * f13;
        vector3f.y = f11 * f13;
        vector3f.z = f12 * f13;
        return vector3f;
    }
}

