/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import org.joml.Math;
import org.joml.Matrix4fc;
import org.joml.Vector2fc;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class FrustumIntersection {
    public static final int PLANE_NX = 0;
    public static final int PLANE_PX = 1;
    public static final int PLANE_NY = 2;
    public static final int PLANE_PY = 3;
    public static final int PLANE_NZ = 4;
    public static final int PLANE_PZ = 5;
    public static final int INTERSECT = -1;
    public static final int INSIDE = -2;
    public static final int OUTSIDE = -3;
    public static final int PLANE_MASK_NX = 1;
    public static final int PLANE_MASK_PX = 2;
    public static final int PLANE_MASK_NY = 4;
    public static final int PLANE_MASK_PY = 8;
    public static final int PLANE_MASK_NZ = 16;
    public static final int PLANE_MASK_PZ = 32;
    private float nxX;
    private float nxY;
    private float nxZ;
    private float nxW;
    private float pxX;
    private float pxY;
    private float pxZ;
    private float pxW;
    private float nyX;
    private float nyY;
    private float nyZ;
    private float nyW;
    private float pyX;
    private float pyY;
    private float pyZ;
    private float pyW;
    private float nzX;
    private float nzY;
    private float nzZ;
    private float nzW;
    private float pzX;
    private float pzY;
    private float pzZ;
    private float pzW;
    private final Vector4f[] planes = new Vector4f[6];

    public FrustumIntersection() {
        for (int i2 = 0; i2 < 6; ++i2) {
            this.planes[i2] = new Vector4f();
        }
    }

    public FrustumIntersection(Matrix4fc matrix4fc) {
        for (int i2 = 0; i2 < 6; ++i2) {
            this.planes[i2] = new Vector4f();
        }
        this.set(matrix4fc, true);
    }

    public FrustumIntersection(Matrix4fc matrix4fc, boolean bl2) {
        for (int i2 = 0; i2 < 6; ++i2) {
            this.planes[i2] = new Vector4f();
        }
        this.set(matrix4fc, bl2);
    }

    public FrustumIntersection set(Matrix4fc matrix4fc) {
        return this.set(matrix4fc, true);
    }

    public FrustumIntersection set(Matrix4fc matrix4fc, boolean bl2) {
        float f2;
        this.nxX = matrix4fc.m03() + matrix4fc.m00();
        this.nxY = matrix4fc.m13() + matrix4fc.m10();
        this.nxZ = matrix4fc.m23() + matrix4fc.m20();
        this.nxW = matrix4fc.m33() + matrix4fc.m30();
        if (bl2) {
            f2 = Math.invsqrt(this.nxX * this.nxX + this.nxY * this.nxY + this.nxZ * this.nxZ);
            this.nxX *= f2;
            this.nxY *= f2;
            this.nxZ *= f2;
            this.nxW *= f2;
        }
        this.planes[0].set(this.nxX, this.nxY, this.nxZ, this.nxW);
        this.pxX = matrix4fc.m03() - matrix4fc.m00();
        this.pxY = matrix4fc.m13() - matrix4fc.m10();
        this.pxZ = matrix4fc.m23() - matrix4fc.m20();
        this.pxW = matrix4fc.m33() - matrix4fc.m30();
        if (bl2) {
            f2 = Math.invsqrt(this.pxX * this.pxX + this.pxY * this.pxY + this.pxZ * this.pxZ);
            this.pxX *= f2;
            this.pxY *= f2;
            this.pxZ *= f2;
            this.pxW *= f2;
        }
        this.planes[1].set(this.pxX, this.pxY, this.pxZ, this.pxW);
        this.nyX = matrix4fc.m03() + matrix4fc.m01();
        this.nyY = matrix4fc.m13() + matrix4fc.m11();
        this.nyZ = matrix4fc.m23() + matrix4fc.m21();
        this.nyW = matrix4fc.m33() + matrix4fc.m31();
        if (bl2) {
            f2 = Math.invsqrt(this.nyX * this.nyX + this.nyY * this.nyY + this.nyZ * this.nyZ);
            this.nyX *= f2;
            this.nyY *= f2;
            this.nyZ *= f2;
            this.nyW *= f2;
        }
        this.planes[2].set(this.nyX, this.nyY, this.nyZ, this.nyW);
        this.pyX = matrix4fc.m03() - matrix4fc.m01();
        this.pyY = matrix4fc.m13() - matrix4fc.m11();
        this.pyZ = matrix4fc.m23() - matrix4fc.m21();
        this.pyW = matrix4fc.m33() - matrix4fc.m31();
        if (bl2) {
            f2 = Math.invsqrt(this.pyX * this.pyX + this.pyY * this.pyY + this.pyZ * this.pyZ);
            this.pyX *= f2;
            this.pyY *= f2;
            this.pyZ *= f2;
            this.pyW *= f2;
        }
        this.planes[3].set(this.pyX, this.pyY, this.pyZ, this.pyW);
        this.nzX = matrix4fc.m03() + matrix4fc.m02();
        this.nzY = matrix4fc.m13() + matrix4fc.m12();
        this.nzZ = matrix4fc.m23() + matrix4fc.m22();
        this.nzW = matrix4fc.m33() + matrix4fc.m32();
        if (bl2) {
            f2 = Math.invsqrt(this.nzX * this.nzX + this.nzY * this.nzY + this.nzZ * this.nzZ);
            this.nzX *= f2;
            this.nzY *= f2;
            this.nzZ *= f2;
            this.nzW *= f2;
        }
        this.planes[4].set(this.nzX, this.nzY, this.nzZ, this.nzW);
        this.pzX = matrix4fc.m03() - matrix4fc.m02();
        this.pzY = matrix4fc.m13() - matrix4fc.m12();
        this.pzZ = matrix4fc.m23() - matrix4fc.m22();
        this.pzW = matrix4fc.m33() - matrix4fc.m32();
        if (bl2) {
            f2 = Math.invsqrt(this.pzX * this.pzX + this.pzY * this.pzY + this.pzZ * this.pzZ);
            this.pzX *= f2;
            this.pzY *= f2;
            this.pzZ *= f2;
            this.pzW *= f2;
        }
        this.planes[5].set(this.pzX, this.pzY, this.pzZ, this.pzW);
        return this;
    }

    public boolean testPoint(Vector3fc vector3fc) {
        return this.testPoint(vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public boolean testPoint(float f2, float f3, float f4) {
        return this.nxX * f2 + this.nxY * f3 + this.nxZ * f4 + this.nxW >= 0.0f && this.pxX * f2 + this.pxY * f3 + this.pxZ * f4 + this.pxW >= 0.0f && this.nyX * f2 + this.nyY * f3 + this.nyZ * f4 + this.nyW >= 0.0f && this.pyX * f2 + this.pyY * f3 + this.pyZ * f4 + this.pyW >= 0.0f && this.nzX * f2 + this.nzY * f3 + this.nzZ * f4 + this.nzW >= 0.0f && this.pzX * f2 + this.pzY * f3 + this.pzZ * f4 + this.pzW >= 0.0f;
    }

    public boolean testSphere(Vector3fc vector3fc, float f2) {
        return this.testSphere(vector3fc.x(), vector3fc.y(), vector3fc.z(), f2);
    }

    public boolean testSphere(float f2, float f3, float f4, float f5) {
        return this.nxX * f2 + this.nxY * f3 + this.nxZ * f4 + this.nxW >= -f5 && this.pxX * f2 + this.pxY * f3 + this.pxZ * f4 + this.pxW >= -f5 && this.nyX * f2 + this.nyY * f3 + this.nyZ * f4 + this.nyW >= -f5 && this.pyX * f2 + this.pyY * f3 + this.pyZ * f4 + this.pyW >= -f5 && this.nzX * f2 + this.nzY * f3 + this.nzZ * f4 + this.nzW >= -f5 && this.pzX * f2 + this.pzY * f3 + this.pzZ * f4 + this.pzW >= -f5;
    }

    public int intersectSphere(Vector3fc vector3fc, float f2) {
        return this.intersectSphere(vector3fc.x(), vector3fc.y(), vector3fc.z(), f2);
    }

    public int intersectSphere(float f2, float f3, float f4, float f5) {
        boolean bl2 = true;
        float f6 = this.nxX * f2 + this.nxY * f3 + this.nxZ * f4 + this.nxW;
        if (f6 >= -f5) {
            bl2 &= f6 >= f5;
            f6 = this.pxX * f2 + this.pxY * f3 + this.pxZ * f4 + this.pxW;
            if (f6 >= -f5) {
                bl2 &= f6 >= f5;
                f6 = this.nyX * f2 + this.nyY * f3 + this.nyZ * f4 + this.nyW;
                if (f6 >= -f5) {
                    bl2 &= f6 >= f5;
                    f6 = this.pyX * f2 + this.pyY * f3 + this.pyZ * f4 + this.pyW;
                    if (f6 >= -f5) {
                        bl2 &= f6 >= f5;
                        f6 = this.nzX * f2 + this.nzY * f3 + this.nzZ * f4 + this.nzW;
                        if (f6 >= -f5) {
                            bl2 &= f6 >= f5;
                            f6 = this.pzX * f2 + this.pzY * f3 + this.pzZ * f4 + this.pzW;
                            if (f6 >= -f5) {
                                return (bl2 &= f6 >= f5) ? -2 : -1;
                            }
                        }
                    }
                }
            }
        }
        return -3;
    }

    public boolean testAab(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.testAab(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean testAab(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = this.nxX * (this.nxX < 0.0f ? f2 : f5) + this.nxY * (this.nxY < 0.0f ? f3 : f6);
        float f9 = this.nxZ < 0.0f ? f4 : f7;
        if (!(f8 + this.nxZ * f9 >= -this.nxW)) return false;
        float f10 = this.pxX * (this.pxX < 0.0f ? f2 : f5) + this.pxY * (this.pxY < 0.0f ? f3 : f6);
        float f11 = this.pxZ < 0.0f ? f4 : f7;
        if (!(f10 + this.pxZ * f11 >= -this.pxW)) return false;
        float f12 = this.nyX * (this.nyX < 0.0f ? f2 : f5) + this.nyY * (this.nyY < 0.0f ? f3 : f6);
        float f13 = this.nyZ < 0.0f ? f4 : f7;
        if (!(f12 + this.nyZ * f13 >= -this.nyW)) return false;
        float f14 = this.pyX * (this.pyX < 0.0f ? f2 : f5) + this.pyY * (this.pyY < 0.0f ? f3 : f6);
        float f15 = this.pyZ < 0.0f ? f4 : f7;
        if (!(f14 + this.pyZ * f15 >= -this.pyW)) return false;
        float f16 = this.nzX * (this.nzX < 0.0f ? f2 : f5) + this.nzY * (this.nzY < 0.0f ? f3 : f6);
        float f17 = this.nzZ < 0.0f ? f4 : f7;
        if (!(f16 + this.nzZ * f17 >= -this.nzW)) return false;
        float f18 = this.pzX * (this.pzX < 0.0f ? f2 : f5) + this.pzY * (this.pzY < 0.0f ? f3 : f6);
        float f19 = this.pzZ < 0.0f ? f4 : f7;
        if (!(f18 + this.pzZ * f19 >= -this.pzW)) return false;
        return true;
    }

    public boolean testPlaneXY(Vector2fc vector2fc, Vector2fc vector2fc2) {
        return this.testPlaneXY(vector2fc.x(), vector2fc.y(), vector2fc2.x(), vector2fc2.y());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean testPlaneXY(float f2, float f3, float f4, float f5) {
        float f6 = this.nxX * (this.nxX < 0.0f ? f2 : f4);
        float f7 = this.nxY < 0.0f ? f3 : f5;
        if (!(f6 + this.nxY * f7 >= -this.nxW)) return false;
        float f8 = this.pxX * (this.pxX < 0.0f ? f2 : f4);
        float f9 = this.pxY < 0.0f ? f3 : f5;
        if (!(f8 + this.pxY * f9 >= -this.pxW)) return false;
        float f10 = this.nyX * (this.nyX < 0.0f ? f2 : f4);
        float f11 = this.nyY < 0.0f ? f3 : f5;
        if (!(f10 + this.nyY * f11 >= -this.nyW)) return false;
        float f12 = this.pyX * (this.pyX < 0.0f ? f2 : f4);
        float f13 = this.pyY < 0.0f ? f3 : f5;
        if (!(f12 + this.pyY * f13 >= -this.pyW)) return false;
        float f14 = this.nzX * (this.nzX < 0.0f ? f2 : f4);
        float f15 = this.nzY < 0.0f ? f3 : f5;
        if (!(f14 + this.nzY * f15 >= -this.nzW)) return false;
        float f16 = this.pzX * (this.pzX < 0.0f ? f2 : f4);
        float f17 = this.pzY < 0.0f ? f3 : f5;
        if (!(f16 + this.pzY * f17 >= -this.pzW)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean testPlaneXZ(float f2, float f3, float f4, float f5) {
        float f6 = this.nxX * (this.nxX < 0.0f ? f2 : f4);
        float f7 = this.nxZ < 0.0f ? f3 : f5;
        if (!(f6 + this.nxZ * f7 >= -this.nxW)) return false;
        float f8 = this.pxX * (this.pxX < 0.0f ? f2 : f4);
        float f9 = this.pxZ < 0.0f ? f3 : f5;
        if (!(f8 + this.pxZ * f9 >= -this.pxW)) return false;
        float f10 = this.nyX * (this.nyX < 0.0f ? f2 : f4);
        float f11 = this.nyZ < 0.0f ? f3 : f5;
        if (!(f10 + this.nyZ * f11 >= -this.nyW)) return false;
        float f12 = this.pyX * (this.pyX < 0.0f ? f2 : f4);
        float f13 = this.pyZ < 0.0f ? f3 : f5;
        if (!(f12 + this.pyZ * f13 >= -this.pyW)) return false;
        float f14 = this.nzX * (this.nzX < 0.0f ? f2 : f4);
        float f15 = this.nzZ < 0.0f ? f3 : f5;
        if (!(f14 + this.nzZ * f15 >= -this.nzW)) return false;
        float f16 = this.pzX * (this.pzX < 0.0f ? f2 : f4);
        float f17 = this.pzZ < 0.0f ? f3 : f5;
        if (!(f16 + this.pzZ * f17 >= -this.pzW)) return false;
        return true;
    }

    public int intersectAab(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.intersectAab(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public int intersectAab(float f2, float f3, float f4, float f5, float f6, float f7) {
        int n2 = 0;
        boolean bl2 = true;
        float f8 = this.nxX * (this.nxX < 0.0f ? f2 : f5) + this.nxY * (this.nxY < 0.0f ? f3 : f6);
        float f9 = this.nxZ < 0.0f ? f4 : f7;
        if (f8 + this.nxZ * f9 >= -this.nxW) {
            n2 = 1;
            bl2 &= this.nxX * (this.nxX < 0.0f ? f5 : f2) + this.nxY * (this.nxY < 0.0f ? f6 : f3) + this.nxZ * (this.nxZ < 0.0f ? f7 : f4) >= -this.nxW;
            float f10 = this.pxX * (this.pxX < 0.0f ? f2 : f5) + this.pxY * (this.pxY < 0.0f ? f3 : f6);
            float f11 = this.pxZ < 0.0f ? f4 : f7;
            if (f10 + this.pxZ * f11 >= -this.pxW) {
                n2 = 2;
                bl2 &= this.pxX * (this.pxX < 0.0f ? f5 : f2) + this.pxY * (this.pxY < 0.0f ? f6 : f3) + this.pxZ * (this.pxZ < 0.0f ? f7 : f4) >= -this.pxW;
                float f12 = this.nyX * (this.nyX < 0.0f ? f2 : f5) + this.nyY * (this.nyY < 0.0f ? f3 : f6);
                float f13 = this.nyZ < 0.0f ? f4 : f7;
                if (f12 + this.nyZ * f13 >= -this.nyW) {
                    n2 = 3;
                    bl2 &= this.nyX * (this.nyX < 0.0f ? f5 : f2) + this.nyY * (this.nyY < 0.0f ? f6 : f3) + this.nyZ * (this.nyZ < 0.0f ? f7 : f4) >= -this.nyW;
                    float f14 = this.pyX * (this.pyX < 0.0f ? f2 : f5) + this.pyY * (this.pyY < 0.0f ? f3 : f6);
                    float f15 = this.pyZ < 0.0f ? f4 : f7;
                    if (f14 + this.pyZ * f15 >= -this.pyW) {
                        n2 = 4;
                        bl2 &= this.pyX * (this.pyX < 0.0f ? f5 : f2) + this.pyY * (this.pyY < 0.0f ? f6 : f3) + this.pyZ * (this.pyZ < 0.0f ? f7 : f4) >= -this.pyW;
                        float f16 = this.nzX * (this.nzX < 0.0f ? f2 : f5) + this.nzY * (this.nzY < 0.0f ? f3 : f6);
                        float f17 = this.nzZ < 0.0f ? f4 : f7;
                        if (f16 + this.nzZ * f17 >= -this.nzW) {
                            n2 = 5;
                            bl2 &= this.nzX * (this.nzX < 0.0f ? f5 : f2) + this.nzY * (this.nzY < 0.0f ? f6 : f3) + this.nzZ * (this.nzZ < 0.0f ? f7 : f4) >= -this.nzW;
                            float f18 = this.pzX * (this.pzX < 0.0f ? f2 : f5) + this.pzY * (this.pzY < 0.0f ? f3 : f6);
                            float f19 = this.pzZ < 0.0f ? f4 : f7;
                            if (f18 + this.pzZ * f19 >= -this.pzW) {
                                return (bl2 &= this.pzX * (this.pzX < 0.0f ? f5 : f2) + this.pzY * (this.pzY < 0.0f ? f6 : f3) + this.pzZ * (this.pzZ < 0.0f ? f7 : f4) >= -this.pzW) ? -2 : -1;
                            }
                        }
                    }
                }
            }
        }
        return n2;
    }

    public float distanceToPlane(float f2, float f3, float f4, float f5, float f6, float f7, int n2) {
        return this.planes[n2].x * (this.planes[n2].x < 0.0f ? f5 : f2) + this.planes[n2].y * (this.planes[n2].y < 0.0f ? f6 : f3) + this.planes[n2].z * (this.planes[n2].z < 0.0f ? f7 : f4) + this.planes[n2].w;
    }

    public int intersectAab(Vector3fc vector3fc, Vector3fc vector3fc2, int n2) {
        return this.intersectAab(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), n2);
    }

    public int intersectAab(float f2, float f3, float f4, float f5, float f6, float f7, int n2) {
        int n3;
        block3: {
            block8: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    n3 = 0;
                                    boolean bl2 = true;
                                    if ((n2 & 1) == 0) break block2;
                                    float f8 = this.nxX * (this.nxX < 0.0f ? f2 : f5) + this.nxY * (this.nxY < 0.0f ? f3 : f6);
                                    float f9 = this.nxZ < 0.0f ? f4 : f7;
                                    if (!(f8 + this.nxZ * f9 >= -this.nxW)) break block3;
                                }
                                n3 = 1;
                                bl2 &= this.nxX * (this.nxX < 0.0f ? f5 : f2) + this.nxY * (this.nxY < 0.0f ? f6 : f3) + this.nxZ * (this.nxZ < 0.0f ? f7 : f4) >= -this.nxW;
                                if ((n2 & 2) == 0) break block4;
                                float f10 = this.pxX * (this.pxX < 0.0f ? f2 : f5) + this.pxY * (this.pxY < 0.0f ? f3 : f6);
                                float f11 = this.pxZ < 0.0f ? f4 : f7;
                                if (!(f10 + this.pxZ * f11 >= -this.pxW)) break block3;
                            }
                            n3 = 2;
                            bl2 &= this.pxX * (this.pxX < 0.0f ? f5 : f2) + this.pxY * (this.pxY < 0.0f ? f6 : f3) + this.pxZ * (this.pxZ < 0.0f ? f7 : f4) >= -this.pxW;
                            if ((n2 & 4) == 0) break block5;
                            float f12 = this.nyX * (this.nyX < 0.0f ? f2 : f5) + this.nyY * (this.nyY < 0.0f ? f3 : f6);
                            float f13 = this.nyZ < 0.0f ? f4 : f7;
                            if (!(f12 + this.nyZ * f13 >= -this.nyW)) break block3;
                        }
                        n3 = 3;
                        bl2 &= this.nyX * (this.nyX < 0.0f ? f5 : f2) + this.nyY * (this.nyY < 0.0f ? f6 : f3) + this.nyZ * (this.nyZ < 0.0f ? f7 : f4) >= -this.nyW;
                        if ((n2 & 8) == 0) break block6;
                        float f14 = this.pyX * (this.pyX < 0.0f ? f2 : f5) + this.pyY * (this.pyY < 0.0f ? f3 : f6);
                        float f15 = this.pyZ < 0.0f ? f4 : f7;
                        if (!(f14 + this.pyZ * f15 >= -this.pyW)) break block3;
                    }
                    n3 = 4;
                    bl2 &= this.pyX * (this.pyX < 0.0f ? f5 : f2) + this.pyY * (this.pyY < 0.0f ? f6 : f3) + this.pyZ * (this.pyZ < 0.0f ? f7 : f4) >= -this.pyW;
                    if ((n2 & 0x10) == 0) break block7;
                    float f16 = this.nzX * (this.nzX < 0.0f ? f2 : f5) + this.nzY * (this.nzY < 0.0f ? f3 : f6);
                    float f17 = this.nzZ < 0.0f ? f4 : f7;
                    if (!(f16 + this.nzZ * f17 >= -this.nzW)) break block3;
                }
                n3 = 5;
                bl2 &= this.nzX * (this.nzX < 0.0f ? f5 : f2) + this.nzY * (this.nzY < 0.0f ? f6 : f3) + this.nzZ * (this.nzZ < 0.0f ? f7 : f4) >= -this.nzW;
                if ((n2 & 0x20) == 0) break block8;
                float f18 = this.pzX * (this.pzX < 0.0f ? f2 : f5) + this.pzY * (this.pzY < 0.0f ? f3 : f6);
                float f19 = this.pzZ < 0.0f ? f4 : f7;
                if (!(f18 + this.pzZ * f19 >= -this.pzW)) break block3;
            }
            return (bl2 &= this.pzX * (this.pzX < 0.0f ? f5 : f2) + this.pzY * (this.pzY < 0.0f ? f6 : f3) + this.pzZ * (this.pzZ < 0.0f ? f7 : f4) >= -this.pzW) ? -2 : -1;
        }
        return n3;
    }

    public int intersectAab(Vector3fc vector3fc, Vector3fc vector3fc2, int n2, int n3) {
        return this.intersectAab(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z(), n2, n3);
    }

    public int intersectAab(float f2, float f3, float f4, float f5, float f6, float f7, int n2, int n3) {
        int n4;
        block6: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block7: {
                                block5: {
                                    n4 = n3;
                                    boolean bl2 = true;
                                    Vector4f vector4f = this.planes[n3];
                                    if ((n2 & 1 << n3) != 0) {
                                        float f8 = vector4f.x * (vector4f.x < 0.0f ? f2 : f5) + vector4f.y * (vector4f.y < 0.0f ? f3 : f6);
                                        float f9 = vector4f.z;
                                        float f10 = vector4f.z < 0.0f ? f4 : f7;
                                        if (f8 + f9 * f10 < -vector4f.w) {
                                            return n4;
                                        }
                                    }
                                    if ((n2 & 1) == 0) break block5;
                                    float f11 = this.nxX * (this.nxX < 0.0f ? f2 : f5) + this.nxY * (this.nxY < 0.0f ? f3 : f6);
                                    float f12 = this.nxZ < 0.0f ? f4 : f7;
                                    if (!(f11 + this.nxZ * f12 >= -this.nxW)) break block6;
                                }
                                n4 = 1;
                                bl2 &= this.nxX * (this.nxX < 0.0f ? f5 : f2) + this.nxY * (this.nxY < 0.0f ? f6 : f3) + this.nxZ * (this.nxZ < 0.0f ? f7 : f4) >= -this.nxW;
                                if ((n2 & 2) == 0) break block7;
                                float f13 = this.pxX * (this.pxX < 0.0f ? f2 : f5) + this.pxY * (this.pxY < 0.0f ? f3 : f6);
                                float f14 = this.pxZ < 0.0f ? f4 : f7;
                                if (!(f13 + this.pxZ * f14 >= -this.pxW)) break block6;
                            }
                            n4 = 2;
                            bl2 &= this.pxX * (this.pxX < 0.0f ? f5 : f2) + this.pxY * (this.pxY < 0.0f ? f6 : f3) + this.pxZ * (this.pxZ < 0.0f ? f7 : f4) >= -this.pxW;
                            if ((n2 & 4) == 0) break block8;
                            float f15 = this.nyX * (this.nyX < 0.0f ? f2 : f5) + this.nyY * (this.nyY < 0.0f ? f3 : f6);
                            float f16 = this.nyZ < 0.0f ? f4 : f7;
                            if (!(f15 + this.nyZ * f16 >= -this.nyW)) break block6;
                        }
                        n4 = 3;
                        bl2 &= this.nyX * (this.nyX < 0.0f ? f5 : f2) + this.nyY * (this.nyY < 0.0f ? f6 : f3) + this.nyZ * (this.nyZ < 0.0f ? f7 : f4) >= -this.nyW;
                        if ((n2 & 8) == 0) break block9;
                        float f17 = this.pyX * (this.pyX < 0.0f ? f2 : f5) + this.pyY * (this.pyY < 0.0f ? f3 : f6);
                        float f18 = this.pyZ < 0.0f ? f4 : f7;
                        if (!(f17 + this.pyZ * f18 >= -this.pyW)) break block6;
                    }
                    n4 = 4;
                    bl2 &= this.pyX * (this.pyX < 0.0f ? f5 : f2) + this.pyY * (this.pyY < 0.0f ? f6 : f3) + this.pyZ * (this.pyZ < 0.0f ? f7 : f4) >= -this.pyW;
                    if ((n2 & 0x10) == 0) break block10;
                    float f19 = this.nzX * (this.nzX < 0.0f ? f2 : f5) + this.nzY * (this.nzY < 0.0f ? f3 : f6);
                    float f20 = this.nzZ < 0.0f ? f4 : f7;
                    if (!(f19 + this.nzZ * f20 >= -this.nzW)) break block6;
                }
                n4 = 5;
                bl2 &= this.nzX * (this.nzX < 0.0f ? f5 : f2) + this.nzY * (this.nzY < 0.0f ? f6 : f3) + this.nzZ * (this.nzZ < 0.0f ? f7 : f4) >= -this.nzW;
                if ((n2 & 0x20) == 0) break block11;
                float f21 = this.pzX * (this.pzX < 0.0f ? f2 : f5) + this.pzY * (this.pzY < 0.0f ? f3 : f6);
                float f22 = this.pzZ < 0.0f ? f4 : f7;
                if (!(f21 + this.pzZ * f22 >= -this.pzW)) break block6;
            }
            return (bl2 &= this.pzX * (this.pzX < 0.0f ? f5 : f2) + this.pzY * (this.pzY < 0.0f ? f6 : f3) + this.pzZ * (this.pzZ < 0.0f ? f7 : f4) >= -this.pzW) ? -2 : -1;
        }
        return n4;
    }

    public boolean testLineSegment(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.testLineSegment(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    public boolean testLineSegment(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8;
        float f9;
        float f10;
        float f11;
        float f12 = Math.fma(this.nxX, f2, Math.fma(this.nxY, f3, Math.fma(this.nxZ, f4, this.nxW)));
        float f13 = Math.fma(this.nxX, f5, Math.fma(this.nxY, f6, Math.fma(this.nxZ, f7, this.nxW)));
        if (f12 < 0.0f && f13 < 0.0f) {
            return false;
        }
        if (f12 * f13 < 0.0f) {
            f11 = Math.abs(f12) / Math.abs(f13 - f12);
            f10 = Math.fma(f5 - f2, f11, f2);
            f9 = Math.fma(f6 - f3, f11, f3);
            f8 = Math.fma(f7 - f4, f11, f4);
            if (f12 < 0.0f) {
                f2 = f10;
                f3 = f9;
                f4 = f8;
            } else {
                f5 = f10;
                f6 = f9;
                f7 = f8;
            }
        }
        f12 = Math.fma(this.pxX, f2, Math.fma(this.pxY, f3, Math.fma(this.pxZ, f4, this.pxW)));
        f13 = Math.fma(this.pxX, f5, Math.fma(this.pxY, f6, Math.fma(this.pxZ, f7, this.pxW)));
        if (f12 < 0.0f && f13 < 0.0f) {
            return false;
        }
        if (f12 * f13 < 0.0f) {
            f11 = Math.abs(f12) / Math.abs(f13 - f12);
            f10 = Math.fma(f5 - f2, f11, f2);
            f9 = Math.fma(f6 - f3, f11, f3);
            f8 = Math.fma(f7 - f4, f11, f4);
            if (f12 < 0.0f) {
                f2 = f10;
                f3 = f9;
                f4 = f8;
            } else {
                f5 = f10;
                f6 = f9;
                f7 = f8;
            }
        }
        f12 = Math.fma(this.nyX, f2, Math.fma(this.nyY, f3, Math.fma(this.nyZ, f4, this.nyW)));
        f13 = Math.fma(this.nyX, f5, Math.fma(this.nyY, f6, Math.fma(this.nyZ, f7, this.nyW)));
        if (f12 < 0.0f && f13 < 0.0f) {
            return false;
        }
        if (f12 * f13 < 0.0f) {
            f11 = Math.abs(f12) / Math.abs(f13 - f12);
            f10 = Math.fma(f5 - f2, f11, f2);
            f9 = Math.fma(f6 - f3, f11, f3);
            f8 = Math.fma(f7 - f4, f11, f4);
            if (f12 < 0.0f) {
                f2 = f10;
                f3 = f9;
                f4 = f8;
            } else {
                f5 = f10;
                f6 = f9;
                f7 = f8;
            }
        }
        f12 = Math.fma(this.pyX, f2, Math.fma(this.pyY, f3, Math.fma(this.pyZ, f4, this.pyW)));
        f13 = Math.fma(this.pyX, f5, Math.fma(this.pyY, f6, Math.fma(this.pyZ, f7, this.pyW)));
        if (f12 < 0.0f && f13 < 0.0f) {
            return false;
        }
        if (f12 * f13 < 0.0f) {
            f11 = Math.abs(f12) / Math.abs(f13 - f12);
            f10 = Math.fma(f5 - f2, f11, f2);
            f9 = Math.fma(f6 - f3, f11, f3);
            f8 = Math.fma(f7 - f4, f11, f4);
            if (f12 < 0.0f) {
                f2 = f10;
                f3 = f9;
                f4 = f8;
            } else {
                f5 = f10;
                f6 = f9;
                f7 = f8;
            }
        }
        f12 = Math.fma(this.nzX, f2, Math.fma(this.nzY, f3, Math.fma(this.nzZ, f4, this.nzW)));
        f13 = Math.fma(this.nzX, f5, Math.fma(this.nzY, f6, Math.fma(this.nzZ, f7, this.nzW)));
        if (f12 < 0.0f && f13 < 0.0f) {
            return false;
        }
        if (f12 * f13 < 0.0f) {
            f11 = Math.abs(f12) / Math.abs(f13 - f12);
            f10 = Math.fma(f5 - f2, f11, f2);
            f9 = Math.fma(f6 - f3, f11, f3);
            f8 = Math.fma(f7 - f4, f11, f4);
            if (f12 < 0.0f) {
                f2 = f10;
                f3 = f9;
                f4 = f8;
            } else {
                f5 = f10;
                f6 = f9;
                f7 = f8;
            }
        }
        f12 = Math.fma(this.pzX, f2, Math.fma(this.pzY, f3, Math.fma(this.pzZ, f4, this.pzW)));
        f13 = Math.fma(this.pzX, f5, Math.fma(this.pzY, f6, Math.fma(this.pzZ, f7, this.pzW)));
        return f12 >= 0.0f || f13 >= 0.0f;
    }
}

