/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.AxisAngle4d;
import org.joml.Math;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3fc;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class AxisAngle4f
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public float angle;
    public float x;
    public float y;
    public float z;

    public AxisAngle4f() {
        this.z = 1.0f;
    }

    public AxisAngle4f(AxisAngle4f axisAngle4f) {
        this.x = axisAngle4f.x;
        this.y = axisAngle4f.y;
        this.z = axisAngle4f.z;
        this.angle = (float)(((double)axisAngle4f.angle < 0.0 ? java.lang.Math.PI * 2 + (double)axisAngle4f.angle % (java.lang.Math.PI * 2) : (double)axisAngle4f.angle) % (java.lang.Math.PI * 2));
    }

    public AxisAngle4f(Quaternionfc quaternionfc) {
        float f2 = Math.safeAcos(quaternionfc.w());
        float f3 = Math.invsqrt(1.0f - quaternionfc.w() * quaternionfc.w());
        if (Float.isInfinite(f3)) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 1.0f;
        } else {
            this.x = quaternionfc.x() * f3;
            this.y = quaternionfc.y() * f3;
            this.z = quaternionfc.z() * f3;
        }
        this.angle = f2 + f2;
    }

    public AxisAngle4f(float f2, float f3, float f4, float f5) {
        this.x = f3;
        this.y = f4;
        this.z = f5;
        this.angle = (float)(((double)f2 < 0.0 ? java.lang.Math.PI * 2 + (double)f2 % (java.lang.Math.PI * 2) : (double)f2) % (java.lang.Math.PI * 2));
    }

    public AxisAngle4f(float f2, Vector3fc vector3fc) {
        this(f2, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public AxisAngle4f set(AxisAngle4f axisAngle4f) {
        this.x = axisAngle4f.x;
        this.y = axisAngle4f.y;
        this.z = axisAngle4f.z;
        this.angle = axisAngle4f.angle;
        this.angle = (float)(((double)this.angle < 0.0 ? java.lang.Math.PI * 2 + (double)this.angle % (java.lang.Math.PI * 2) : (double)this.angle) % (java.lang.Math.PI * 2));
        return this;
    }

    public AxisAngle4f set(AxisAngle4d axisAngle4d) {
        this.x = (float)axisAngle4d.x;
        this.y = (float)axisAngle4d.y;
        this.z = (float)axisAngle4d.z;
        this.angle = (float)axisAngle4d.angle;
        this.angle = (float)(((double)this.angle < 0.0 ? java.lang.Math.PI * 2 + (double)this.angle % (java.lang.Math.PI * 2) : (double)this.angle) % (java.lang.Math.PI * 2));
        return this;
    }

    public AxisAngle4f set(float f2, float f3, float f4, float f5) {
        this.x = f3;
        this.y = f4;
        this.z = f5;
        this.angle = (float)(((double)f2 < 0.0 ? java.lang.Math.PI * 2 + (double)f2 % (java.lang.Math.PI * 2) : (double)f2) % (java.lang.Math.PI * 2));
        return this;
    }

    public AxisAngle4f set(float f2, Vector3fc vector3fc) {
        return this.set(f2, vector3fc.x(), vector3fc.y(), vector3fc.z());
    }

    public AxisAngle4f set(Quaternionfc quaternionfc) {
        float f2 = Math.safeAcos(quaternionfc.w());
        float f3 = Math.invsqrt(1.0f - quaternionfc.w() * quaternionfc.w());
        if (Float.isInfinite(f3)) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 1.0f;
        } else {
            this.x = quaternionfc.x() * f3;
            this.y = quaternionfc.y() * f3;
            this.z = quaternionfc.z() * f3;
        }
        this.angle = f2 + f2;
        return this;
    }

    public AxisAngle4f set(Quaterniondc quaterniondc) {
        double d2 = Math.safeAcos(quaterniondc.w());
        double d3 = Math.invsqrt(1.0 - quaterniondc.w() * quaterniondc.w());
        if (Double.isInfinite(d3)) {
            this.x = 0.0f;
            this.y = 0.0f;
            this.z = 1.0f;
        } else {
            this.x = (float)(quaterniondc.x() * d3);
            this.y = (float)(quaterniondc.y() * d3);
            this.z = (float)(quaterniondc.z() * d3);
        }
        this.angle = (float)(d2 + d2);
        return this;
    }

    public AxisAngle4f set(Matrix3fc matrix3fc) {
        float f2 = matrix3fc.m00();
        float f3 = matrix3fc.m01();
        float f4 = matrix3fc.m02();
        float f5 = matrix3fc.m10();
        float f6 = matrix3fc.m11();
        float f7 = matrix3fc.m12();
        float f8 = matrix3fc.m20();
        float f9 = matrix3fc.m21();
        float f10 = matrix3fc.m22();
        float f11 = Math.invsqrt(matrix3fc.m00() * matrix3fc.m00() + matrix3fc.m01() * matrix3fc.m01() + matrix3fc.m02() * matrix3fc.m02());
        float f12 = Math.invsqrt(matrix3fc.m10() * matrix3fc.m10() + matrix3fc.m11() * matrix3fc.m11() + matrix3fc.m12() * matrix3fc.m12());
        float f13 = Math.invsqrt(matrix3fc.m20() * matrix3fc.m20() + matrix3fc.m21() * matrix3fc.m21() + matrix3fc.m22() * matrix3fc.m22());
        f2 *= f11;
        f3 *= f11;
        f4 *= f11;
        f5 *= f12;
        f6 *= f12;
        f7 *= f12;
        f8 *= f13;
        f9 *= f13;
        f10 *= f13;
        float f14 = 1.0E-4f;
        float f15 = 0.001f;
        if (Math.abs(f5 - f3) < f14 && Math.abs(f8 - f4) < f14 && Math.abs(f9 - f7) < f14) {
            if (Math.abs(f5 + f3) < f15 && Math.abs(f8 + f4) < f15 && Math.abs(f9 + f7) < f15 && Math.abs(f2 + f6 + f10 - 3.0f) < f15) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            float f16 = (f2 + 1.0f) / 2.0f;
            float f17 = (f6 + 1.0f) / 2.0f;
            float f18 = (f10 + 1.0f) / 2.0f;
            float f19 = (f5 + f3) / 4.0f;
            float f20 = (f8 + f4) / 4.0f;
            float f21 = (f9 + f7) / 4.0f;
            if (f16 > f17 && f16 > f18) {
                this.x = Math.sqrt(f16);
                this.y = f19 / this.x;
                this.z = f20 / this.x;
            } else if (f17 > f18) {
                this.y = Math.sqrt(f17);
                this.x = f19 / this.y;
                this.z = f21 / this.y;
            } else {
                this.z = Math.sqrt(f18);
                this.x = f20 / this.z;
                this.y = f21 / this.z;
            }
            return this;
        }
        float f22 = Math.sqrt((f7 - f9) * (f7 - f9) + (f8 - f4) * (f8 - f4) + (f3 - f5) * (f3 - f5));
        this.angle = Math.safeAcos((f2 + f6 + f10 - 1.0f) / 2.0f);
        this.x = (f7 - f9) / f22;
        this.y = (f8 - f4) / f22;
        this.z = (f3 - f5) / f22;
        return this;
    }

    public AxisAngle4f set(Matrix3dc matrix3dc) {
        double d2 = matrix3dc.m00();
        double d3 = matrix3dc.m01();
        double d4 = matrix3dc.m02();
        double d5 = matrix3dc.m10();
        double d6 = matrix3dc.m11();
        double d7 = matrix3dc.m12();
        double d8 = matrix3dc.m20();
        double d9 = matrix3dc.m21();
        double d10 = matrix3dc.m22();
        double d11 = Math.invsqrt(matrix3dc.m00() * matrix3dc.m00() + matrix3dc.m01() * matrix3dc.m01() + matrix3dc.m02() * matrix3dc.m02());
        double d12 = Math.invsqrt(matrix3dc.m10() * matrix3dc.m10() + matrix3dc.m11() * matrix3dc.m11() + matrix3dc.m12() * matrix3dc.m12());
        double d13 = Math.invsqrt(matrix3dc.m20() * matrix3dc.m20() + matrix3dc.m21() * matrix3dc.m21() + matrix3dc.m22() * matrix3dc.m22());
        d2 *= d11;
        d3 *= d11;
        d4 *= d11;
        d5 *= d12;
        d6 *= d12;
        d7 *= d12;
        d8 *= d13;
        d9 *= d13;
        d10 *= d13;
        double d14 = 1.0E-4;
        double d15 = 0.001;
        if (Math.abs(d5 - d3) < d14 && Math.abs(d8 - d4) < d14 && Math.abs(d9 - d7) < d14) {
            if (Math.abs(d5 + d3) < d15 && Math.abs(d8 + d4) < d15 && Math.abs(d9 + d7) < d15 && Math.abs(d2 + d6 + d10 - 3.0) < d15) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            double d16 = (d2 + 1.0) / 2.0;
            double d17 = (d6 + 1.0) / 2.0;
            double d18 = (d10 + 1.0) / 2.0;
            double d19 = (d5 + d3) / 4.0;
            double d20 = (d8 + d4) / 4.0;
            double d21 = (d9 + d7) / 4.0;
            if (d16 > d17 && d16 > d18) {
                this.x = (float)Math.sqrt(d16);
                this.y = (float)(d19 / (double)this.x);
                this.z = (float)(d20 / (double)this.x);
            } else if (d17 > d18) {
                this.y = (float)Math.sqrt(d17);
                this.x = (float)(d19 / (double)this.y);
                this.z = (float)(d21 / (double)this.y);
            } else {
                this.z = (float)Math.sqrt(d18);
                this.x = (float)(d20 / (double)this.z);
                this.y = (float)(d21 / (double)this.z);
            }
            return this;
        }
        double d22 = Math.sqrt((d7 - d9) * (d7 - d9) + (d8 - d4) * (d8 - d4) + (d3 - d5) * (d3 - d5));
        this.angle = (float)Math.safeAcos((d2 + d6 + d10 - 1.0) / 2.0);
        this.x = (float)((d7 - d9) / d22);
        this.y = (float)((d8 - d4) / d22);
        this.z = (float)((d3 - d5) / d22);
        return this;
    }

    public AxisAngle4f set(Matrix4fc matrix4fc) {
        float f2 = matrix4fc.m00();
        float f3 = matrix4fc.m01();
        float f4 = matrix4fc.m02();
        float f5 = matrix4fc.m10();
        float f6 = matrix4fc.m11();
        float f7 = matrix4fc.m12();
        float f8 = matrix4fc.m20();
        float f9 = matrix4fc.m21();
        float f10 = matrix4fc.m22();
        float f11 = Math.invsqrt(matrix4fc.m00() * matrix4fc.m00() + matrix4fc.m01() * matrix4fc.m01() + matrix4fc.m02() * matrix4fc.m02());
        float f12 = Math.invsqrt(matrix4fc.m10() * matrix4fc.m10() + matrix4fc.m11() * matrix4fc.m11() + matrix4fc.m12() * matrix4fc.m12());
        float f13 = Math.invsqrt(matrix4fc.m20() * matrix4fc.m20() + matrix4fc.m21() * matrix4fc.m21() + matrix4fc.m22() * matrix4fc.m22());
        f2 *= f11;
        f3 *= f11;
        f4 *= f11;
        f5 *= f12;
        f6 *= f12;
        f7 *= f12;
        f8 *= f13;
        f9 *= f13;
        f10 *= f13;
        float f14 = 1.0E-4f;
        float f15 = 0.001f;
        if (Math.abs(f5 - f3) < f14 && Math.abs(f8 - f4) < f14 && Math.abs(f9 - f7) < f14) {
            if (Math.abs(f5 + f3) < f15 && Math.abs(f8 + f4) < f15 && Math.abs(f9 + f7) < f15 && Math.abs(f2 + f6 + f10 - 3.0f) < f15) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            float f16 = (f2 + 1.0f) / 2.0f;
            float f17 = (f6 + 1.0f) / 2.0f;
            float f18 = (f10 + 1.0f) / 2.0f;
            float f19 = (f5 + f3) / 4.0f;
            float f20 = (f8 + f4) / 4.0f;
            float f21 = (f9 + f7) / 4.0f;
            if (f16 > f17 && f16 > f18) {
                this.x = Math.sqrt(f16);
                this.y = f19 / this.x;
                this.z = f20 / this.x;
            } else if (f17 > f18) {
                this.y = Math.sqrt(f17);
                this.x = f19 / this.y;
                this.z = f21 / this.y;
            } else {
                this.z = Math.sqrt(f18);
                this.x = f20 / this.z;
                this.y = f21 / this.z;
            }
            return this;
        }
        float f22 = Math.sqrt((f7 - f9) * (f7 - f9) + (f8 - f4) * (f8 - f4) + (f3 - f5) * (f3 - f5));
        this.angle = Math.safeAcos((f2 + f6 + f10 - 1.0f) / 2.0f);
        this.x = (f7 - f9) / f22;
        this.y = (f8 - f4) / f22;
        this.z = (f3 - f5) / f22;
        return this;
    }

    public AxisAngle4f set(Matrix4x3fc matrix4x3fc) {
        float f2 = matrix4x3fc.m00();
        float f3 = matrix4x3fc.m01();
        float f4 = matrix4x3fc.m02();
        float f5 = matrix4x3fc.m10();
        float f6 = matrix4x3fc.m11();
        float f7 = matrix4x3fc.m12();
        float f8 = matrix4x3fc.m20();
        float f9 = matrix4x3fc.m21();
        float f10 = matrix4x3fc.m22();
        float f11 = Math.invsqrt(matrix4x3fc.m00() * matrix4x3fc.m00() + matrix4x3fc.m01() * matrix4x3fc.m01() + matrix4x3fc.m02() * matrix4x3fc.m02());
        float f12 = Math.invsqrt(matrix4x3fc.m10() * matrix4x3fc.m10() + matrix4x3fc.m11() * matrix4x3fc.m11() + matrix4x3fc.m12() * matrix4x3fc.m12());
        float f13 = Math.invsqrt(matrix4x3fc.m20() * matrix4x3fc.m20() + matrix4x3fc.m21() * matrix4x3fc.m21() + matrix4x3fc.m22() * matrix4x3fc.m22());
        f2 *= f11;
        f3 *= f11;
        f4 *= f11;
        f5 *= f12;
        f6 *= f12;
        f7 *= f12;
        f8 *= f13;
        f9 *= f13;
        f10 *= f13;
        float f14 = 1.0E-4f;
        float f15 = 0.001f;
        if (Math.abs(f5 - f3) < f14 && Math.abs(f8 - f4) < f14 && Math.abs(f9 - f7) < f14) {
            if (Math.abs(f5 + f3) < f15 && Math.abs(f8 + f4) < f15 && Math.abs(f9 + f7) < f15 && Math.abs(f2 + f6 + f10 - 3.0f) < f15) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            float f16 = (f2 + 1.0f) / 2.0f;
            float f17 = (f6 + 1.0f) / 2.0f;
            float f18 = (f10 + 1.0f) / 2.0f;
            float f19 = (f5 + f3) / 4.0f;
            float f20 = (f8 + f4) / 4.0f;
            float f21 = (f9 + f7) / 4.0f;
            if (f16 > f17 && f16 > f18) {
                this.x = Math.sqrt(f16);
                this.y = f19 / this.x;
                this.z = f20 / this.x;
            } else if (f17 > f18) {
                this.y = Math.sqrt(f17);
                this.x = f19 / this.y;
                this.z = f21 / this.y;
            } else {
                this.z = Math.sqrt(f18);
                this.x = f20 / this.z;
                this.y = f21 / this.z;
            }
            return this;
        }
        float f22 = Math.sqrt((f7 - f9) * (f7 - f9) + (f8 - f4) * (f8 - f4) + (f3 - f5) * (f3 - f5));
        this.angle = Math.safeAcos((f2 + f6 + f10 - 1.0f) / 2.0f);
        this.x = (f7 - f9) / f22;
        this.y = (f8 - f4) / f22;
        this.z = (f3 - f5) / f22;
        return this;
    }

    public AxisAngle4f set(Matrix4dc matrix4dc) {
        double d2 = matrix4dc.m00();
        double d3 = matrix4dc.m01();
        double d4 = matrix4dc.m02();
        double d5 = matrix4dc.m10();
        double d6 = matrix4dc.m11();
        double d7 = matrix4dc.m12();
        double d8 = matrix4dc.m20();
        double d9 = matrix4dc.m21();
        double d10 = matrix4dc.m22();
        double d11 = Math.invsqrt(matrix4dc.m00() * matrix4dc.m00() + matrix4dc.m01() * matrix4dc.m01() + matrix4dc.m02() * matrix4dc.m02());
        double d12 = Math.invsqrt(matrix4dc.m10() * matrix4dc.m10() + matrix4dc.m11() * matrix4dc.m11() + matrix4dc.m12() * matrix4dc.m12());
        double d13 = Math.invsqrt(matrix4dc.m20() * matrix4dc.m20() + matrix4dc.m21() * matrix4dc.m21() + matrix4dc.m22() * matrix4dc.m22());
        d2 *= d11;
        d3 *= d11;
        d4 *= d11;
        d5 *= d12;
        d6 *= d12;
        d7 *= d12;
        d8 *= d13;
        d9 *= d13;
        d10 *= d13;
        double d14 = 1.0E-4;
        double d15 = 0.001;
        if (Math.abs(d5 - d3) < d14 && Math.abs(d8 - d4) < d14 && Math.abs(d9 - d7) < d14) {
            if (Math.abs(d5 + d3) < d15 && Math.abs(d8 + d4) < d15 && Math.abs(d9 + d7) < d15 && Math.abs(d2 + d6 + d10 - 3.0) < d15) {
                this.x = 0.0f;
                this.y = 0.0f;
                this.z = 1.0f;
                this.angle = 0.0f;
                return this;
            }
            this.angle = (float)java.lang.Math.PI;
            double d16 = (d2 + 1.0) / 2.0;
            double d17 = (d6 + 1.0) / 2.0;
            double d18 = (d10 + 1.0) / 2.0;
            double d19 = (d5 + d3) / 4.0;
            double d20 = (d8 + d4) / 4.0;
            double d21 = (d9 + d7) / 4.0;
            if (d16 > d17 && d16 > d18) {
                this.x = (float)Math.sqrt(d16);
                this.y = (float)(d19 / (double)this.x);
                this.z = (float)(d20 / (double)this.x);
            } else if (d17 > d18) {
                this.y = (float)Math.sqrt(d17);
                this.x = (float)(d19 / (double)this.y);
                this.z = (float)(d21 / (double)this.y);
            } else {
                this.z = (float)Math.sqrt(d18);
                this.x = (float)(d20 / (double)this.z);
                this.y = (float)(d21 / (double)this.z);
            }
            return this;
        }
        double d22 = Math.sqrt((d7 - d9) * (d7 - d9) + (d8 - d4) * (d8 - d4) + (d3 - d5) * (d3 - d5));
        this.angle = (float)Math.safeAcos((d2 + d6 + d10 - 1.0) / 2.0);
        this.x = (float)((d7 - d9) / d22);
        this.y = (float)((d8 - d4) / d22);
        this.z = (float)((d3 - d5) / d22);
        return this;
    }

    public Quaternionf get(Quaternionf quaternionf) {
        return quaternionf.set(this);
    }

    public Quaterniond get(Quaterniond quaterniond) {
        return quaterniond.set(this);
    }

    public Matrix4f get(Matrix4f matrix4f) {
        return matrix4f.set(this);
    }

    public Matrix3f get(Matrix3f matrix3f) {
        return matrix3f.set(this);
    }

    public Matrix4d get(Matrix4d matrix4d) {
        return matrix4d.set(this);
    }

    public Matrix3d get(Matrix3d matrix3d) {
        return matrix3d.set(this);
    }

    public AxisAngle4d get(AxisAngle4d axisAngle4d) {
        return axisAngle4d.set(this);
    }

    public AxisAngle4f get(AxisAngle4f axisAngle4f) {
        return axisAngle4f.set(this);
    }

    public void writeExternal(ObjectOutput objectOutput) {
        objectOutput.writeFloat(this.angle);
        objectOutput.writeFloat(this.x);
        objectOutput.writeFloat(this.y);
        objectOutput.writeFloat(this.z);
    }

    public void readExternal(ObjectInput objectInput) {
        this.angle = objectInput.readFloat();
        this.x = objectInput.readFloat();
        this.y = objectInput.readFloat();
        this.z = objectInput.readFloat();
    }

    public AxisAngle4f normalize() {
        float f2 = Math.invsqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        return this;
    }

    public AxisAngle4f rotate(float f2) {
        this.angle += f2;
        this.angle = (float)(((double)this.angle < 0.0 ? java.lang.Math.PI * 2 + (double)this.angle % (java.lang.Math.PI * 2) : (double)this.angle) % (java.lang.Math.PI * 2));
        return this;
    }

    public Vector3f transform(Vector3f vector3f) {
        return this.transform(vector3f, vector3f);
    }

    public Vector3f transform(Vector3fc vector3fc, Vector3f vector3f) {
        double d2 = Math.sin(this.angle);
        double d3 = Math.cosFromSin(d2, (double)this.angle);
        float f2 = this.x * vector3fc.x() + this.y * vector3fc.y() + this.z * vector3fc.z();
        vector3f.set((float)((double)vector3fc.x() * d3 + d2 * (double)(this.y * vector3fc.z() - this.z * vector3fc.y()) + (1.0 - d3) * (double)f2 * (double)this.x), (float)((double)vector3fc.y() * d3 + d2 * (double)(this.z * vector3fc.x() - this.x * vector3fc.z()) + (1.0 - d3) * (double)f2 * (double)this.y), (float)((double)vector3fc.z() * d3 + d2 * (double)(this.x * vector3fc.y() - this.y * vector3fc.x()) + (1.0 - d3) * (double)f2 * (double)this.z));
        return vector3f;
    }

    public Vector4f transform(Vector4f vector4f) {
        return this.transform(vector4f, vector4f);
    }

    public Vector4f transform(Vector4fc vector4fc, Vector4f vector4f) {
        double d2 = Math.sin(this.angle);
        double d3 = Math.cosFromSin(d2, (double)this.angle);
        float f2 = this.x * vector4fc.x() + this.y * vector4fc.y() + this.z * vector4fc.z();
        vector4f.set((float)((double)vector4fc.x() * d3 + d2 * (double)(this.y * vector4fc.z() - this.z * vector4fc.y()) + (1.0 - d3) * (double)f2 * (double)this.x), (float)((double)vector4fc.y() * d3 + d2 * (double)(this.z * vector4fc.x() - this.x * vector4fc.z()) + (1.0 - d3) * (double)f2 * (double)this.y), (float)((double)vector4fc.z() * d3 + d2 * (double)(this.x * vector4fc.y() - this.y * vector4fc.x()) + (1.0 - d3) * (double)f2 * (double)this.z), vector4f.w);
        return vector4f;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + " <| " + Runtime.format(this.angle, numberFormat) + ")";
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        float f2 = (float)(((double)this.angle < 0.0 ? java.lang.Math.PI * 2 + (double)this.angle % (java.lang.Math.PI * 2) : (double)this.angle) % (java.lang.Math.PI * 2));
        n3 = 31 * n3 + Float.floatToIntBits(f2);
        n3 = 31 * n3 + Float.floatToIntBits(this.x);
        n3 = 31 * n3 + Float.floatToIntBits(this.y);
        n3 = 31 * n3 + Float.floatToIntBits(this.z);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AxisAngle4f axisAngle4f = (AxisAngle4f)object;
        float f2 = (float)(((double)this.angle < 0.0 ? java.lang.Math.PI * 2 + (double)this.angle % (java.lang.Math.PI * 2) : (double)this.angle) % (java.lang.Math.PI * 2));
        float f3 = (float)(((double)axisAngle4f.angle < 0.0 ? java.lang.Math.PI * 2 + (double)axisAngle4f.angle % (java.lang.Math.PI * 2) : (double)axisAngle4f.angle) % (java.lang.Math.PI * 2));
        if (Float.floatToIntBits(f2) != Float.floatToIntBits(f3)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(axisAngle4f.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(axisAngle4f.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(axisAngle4f.z);
    }

    public Object clone() {
        return super.clone();
    }
}

