/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import org.joml.AxisAngle4f;
import org.joml.Math;
import org.joml.Matrix3d;
import org.joml.Matrix3dc;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3fc;
import org.joml.Options;
import org.joml.Quaterniond;
import org.joml.Quaterniondc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4d;
import org.joml.Vector4dc;

public class AxisAngle4d
implements Externalizable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public double angle;
    public double x;
    public double y;
    public double z;

    public AxisAngle4d() {
        this.z = 1.0;
    }

    public AxisAngle4d(AxisAngle4d axisAngle4d) {
        this.x = axisAngle4d.x;
        this.y = axisAngle4d.y;
        this.z = axisAngle4d.z;
        this.angle = (axisAngle4d.angle < 0.0 ? java.lang.Math.PI * 2 + axisAngle4d.angle % (java.lang.Math.PI * 2) : axisAngle4d.angle) % (java.lang.Math.PI * 2);
    }

    public AxisAngle4d(AxisAngle4f axisAngle4f) {
        this.x = axisAngle4f.x;
        this.y = axisAngle4f.y;
        this.z = axisAngle4f.z;
        this.angle = ((double)axisAngle4f.angle < 0.0 ? java.lang.Math.PI * 2 + (double)axisAngle4f.angle % (java.lang.Math.PI * 2) : (double)axisAngle4f.angle) % (java.lang.Math.PI * 2);
    }

    public AxisAngle4d(Quaternionfc quaternionfc) {
        float f2 = Math.safeAcos(quaternionfc.w());
        float f3 = Math.invsqrt(1.0f - quaternionfc.w() * quaternionfc.w());
        if (Float.isInfinite(f3)) {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 1.0;
        } else {
            this.x = quaternionfc.x() * f3;
            this.y = quaternionfc.y() * f3;
            this.z = quaternionfc.z() * f3;
        }
        this.angle = f2 + f2;
    }

    public AxisAngle4d(Quaterniondc quaterniondc) {
        double d2 = Math.safeAcos(quaterniondc.w());
        double d3 = Math.invsqrt(1.0 - quaterniondc.w() * quaterniondc.w());
        if (Double.isInfinite(d3)) {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 1.0;
        } else {
            this.x = quaterniondc.x() * d3;
            this.y = quaterniondc.y() * d3;
            this.z = quaterniondc.z() * d3;
        }
        this.angle = d2 + d2;
    }

    public AxisAngle4d(double d2, double d3, double d4, double d5) {
        this.x = d3;
        this.y = d4;
        this.z = d5;
        this.angle = (d2 < 0.0 ? java.lang.Math.PI * 2 + d2 % (java.lang.Math.PI * 2) : d2) % (java.lang.Math.PI * 2);
    }

    public AxisAngle4d(double d2, Vector3dc vector3dc) {
        this(d2, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public AxisAngle4d(double d2, Vector3f vector3f) {
        this(d2, vector3f.x, vector3f.y, vector3f.z);
    }

    public AxisAngle4d set(AxisAngle4d axisAngle4d) {
        this.x = axisAngle4d.x;
        this.y = axisAngle4d.y;
        this.z = axisAngle4d.z;
        this.angle = (axisAngle4d.angle < 0.0 ? java.lang.Math.PI * 2 + axisAngle4d.angle % (java.lang.Math.PI * 2) : axisAngle4d.angle) % (java.lang.Math.PI * 2);
        return this;
    }

    public AxisAngle4d set(AxisAngle4f axisAngle4f) {
        this.x = axisAngle4f.x;
        this.y = axisAngle4f.y;
        this.z = axisAngle4f.z;
        this.angle = ((double)axisAngle4f.angle < 0.0 ? java.lang.Math.PI * 2 + (double)axisAngle4f.angle % (java.lang.Math.PI * 2) : (double)axisAngle4f.angle) % (java.lang.Math.PI * 2);
        return this;
    }

    public AxisAngle4d set(double d2, double d3, double d4, double d5) {
        this.x = d3;
        this.y = d4;
        this.z = d5;
        this.angle = (d2 < 0.0 ? java.lang.Math.PI * 2 + d2 % (java.lang.Math.PI * 2) : d2) % (java.lang.Math.PI * 2);
        return this;
    }

    public AxisAngle4d set(double d2, Vector3dc vector3dc) {
        return this.set(d2, vector3dc.x(), vector3dc.y(), vector3dc.z());
    }

    public AxisAngle4d set(double d2, Vector3f vector3f) {
        return this.set(d2, vector3f.x, vector3f.y, vector3f.z);
    }

    public AxisAngle4d set(Quaternionfc quaternionfc) {
        float f2 = Math.safeAcos(quaternionfc.w());
        float f3 = Math.invsqrt(1.0f - quaternionfc.w() * quaternionfc.w());
        if (Float.isInfinite(f3)) {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 1.0;
        } else {
            this.x = quaternionfc.x() * f3;
            this.y = quaternionfc.y() * f3;
            this.z = quaternionfc.z() * f3;
        }
        this.angle = f2 + f2;
        return this;
    }

    public AxisAngle4d set(Quaterniondc quaterniondc) {
        double d2 = Math.safeAcos(quaterniondc.w());
        double d3 = Math.invsqrt(1.0 - quaterniondc.w() * quaterniondc.w());
        if (Double.isInfinite(d3)) {
            this.x = 0.0;
            this.y = 0.0;
            this.z = 1.0;
        } else {
            this.x = quaterniondc.x() * d3;
            this.y = quaterniondc.y() * d3;
            this.z = quaterniondc.z() * d3;
        }
        this.angle = d2 + d2;
        return this;
    }

    public AxisAngle4d set(Matrix3fc matrix3fc) {
        double d2 = matrix3fc.m00();
        double d3 = matrix3fc.m01();
        double d4 = matrix3fc.m02();
        double d5 = matrix3fc.m10();
        double d6 = matrix3fc.m11();
        double d7 = matrix3fc.m12();
        double d8 = matrix3fc.m20();
        double d9 = matrix3fc.m21();
        double d10 = matrix3fc.m22();
        double d11 = Math.invsqrt(matrix3fc.m00() * matrix3fc.m00() + matrix3fc.m01() * matrix3fc.m01() + matrix3fc.m02() * matrix3fc.m02());
        double d12 = Math.invsqrt(matrix3fc.m10() * matrix3fc.m10() + matrix3fc.m11() * matrix3fc.m11() + matrix3fc.m12() * matrix3fc.m12());
        double d13 = Math.invsqrt(matrix3fc.m20() * matrix3fc.m20() + matrix3fc.m21() * matrix3fc.m21() + matrix3fc.m22() * matrix3fc.m22());
        d2 *= d11;
        d3 *= d11;
        d4 *= d11;
        d5 *= d12;
        d6 *= d12;
        d7 *= d12;
        d8 *= d13;
        d9 *= d13;
        d10 *= d13;
        double d14 = 1.0E-4;
        double d15 = 0.001;
        if (Math.abs(d5 - d3) < d14 && Math.abs(d8 - d4) < d14 && Math.abs(d9 - d7) < d14) {
            if (Math.abs(d5 + d3) < d15 && Math.abs(d8 + d4) < d15 && Math.abs(d9 + d7) < d15 && Math.abs(d2 + d6 + d10 - 3.0) < d15) {
                this.x = 0.0;
                this.y = 0.0;
                this.z = 1.0;
                this.angle = 0.0;
                return this;
            }
            this.angle = java.lang.Math.PI;
            double d16 = (d2 + 1.0) / 2.0;
            double d17 = (d6 + 1.0) / 2.0;
            double d18 = (d10 + 1.0) / 2.0;
            double d19 = (d5 + d3) / 4.0;
            double d20 = (d8 + d4) / 4.0;
            double d21 = (d9 + d7) / 4.0;
            if (d16 > d17 && d16 > d18) {
                this.x = Math.sqrt(d16);
                this.y = d19 / this.x;
                this.z = d20 / this.x;
            } else if (d17 > d18) {
                this.y = Math.sqrt(d17);
                this.x = d19 / this.y;
                this.z = d21 / this.y;
            } else {
                this.z = Math.sqrt(d18);
                this.x = d20 / this.z;
                this.y = d21 / this.z;
            }
            return this;
        }
        double d22 = Math.sqrt((d7 - d9) * (d7 - d9) + (d8 - d4) * (d8 - d4) + (d3 - d5) * (d3 - d5));
        this.angle = Math.safeAcos((d2 + d6 + d10 - 1.0) / 2.0);
        this.x = (d7 - d9) / d22;
        this.y = (d8 - d4) / d22;
        this.z = (d3 - d5) / d22;
        return this;
    }

    public AxisAngle4d set(Matrix3dc matrix3dc) {
        double d2 = matrix3dc.m00();
        double d3 = matrix3dc.m01();
        double d4 = matrix3dc.m02();
        double d5 = matrix3dc.m10();
        double d6 = matrix3dc.m11();
        double d7 = matrix3dc.m12();
        double d8 = matrix3dc.m20();
        double d9 = matrix3dc.m21();
        double d10 = matrix3dc.m22();
        double d11 = Math.invsqrt(matrix3dc.m00() * matrix3dc.m00() + matrix3dc.m01() * matrix3dc.m01() + matrix3dc.m02() * matrix3dc.m02());
        double d12 = Math.invsqrt(matrix3dc.m10() * matrix3dc.m10() + matrix3dc.m11() * matrix3dc.m11() + matrix3dc.m12() * matrix3dc.m12());
        double d13 = Math.invsqrt(matrix3dc.m20() * matrix3dc.m20() + matrix3dc.m21() * matrix3dc.m21() + matrix3dc.m22() * matrix3dc.m22());
        d2 *= d11;
        d3 *= d11;
        d4 *= d11;
        d5 *= d12;
        d6 *= d12;
        d7 *= d12;
        d8 *= d13;
        d9 *= d13;
        d10 *= d13;
        double d14 = 1.0E-4;
        double d15 = 0.001;
        if (Math.abs(d5 - d3) < d14 && Math.abs(d8 - d4) < d14 && Math.abs(d9 - d7) < d14) {
            if (Math.abs(d5 + d3) < d15 && Math.abs(d8 + d4) < d15 && Math.abs(d9 + d7) < d15 && Math.abs(d2 + d6 + d10 - 3.0) < d15) {
                this.x = 0.0;
                this.y = 0.0;
                this.z = 1.0;
                this.angle = 0.0;
                return this;
            }
            this.angle = java.lang.Math.PI;
            double d16 = (d2 + 1.0) / 2.0;
            double d17 = (d6 + 1.0) / 2.0;
            double d18 = (d10 + 1.0) / 2.0;
            double d19 = (d5 + d3) / 4.0;
            double d20 = (d8 + d4) / 4.0;
            double d21 = (d9 + d7) / 4.0;
            if (d16 > d17 && d16 > d18) {
                this.x = Math.sqrt(d16);
                this.y = d19 / this.x;
                this.z = d20 / this.x;
            } else if (d17 > d18) {
                this.y = Math.sqrt(d17);
                this.x = d19 / this.y;
                this.z = d21 / this.y;
            } else {
                this.z = Math.sqrt(d18);
                this.x = d20 / this.z;
                this.y = d21 / this.z;
            }
            return this;
        }
        double d22 = Math.sqrt((d7 - d9) * (d7 - d9) + (d8 - d4) * (d8 - d4) + (d3 - d5) * (d3 - d5));
        this.angle = Math.safeAcos((d2 + d6 + d10 - 1.0) / 2.0);
        this.x = (d7 - d9) / d22;
        this.y = (d8 - d4) / d22;
        this.z = (d3 - d5) / d22;
        return this;
    }

    public AxisAngle4d set(Matrix4fc matrix4fc) {
        double d2 = matrix4fc.m00();
        double d3 = matrix4fc.m01();
        double d4 = matrix4fc.m02();
        double d5 = matrix4fc.m10();
        double d6 = matrix4fc.m11();
        double d7 = matrix4fc.m12();
        double d8 = matrix4fc.m20();
        double d9 = matrix4fc.m21();
        double d10 = matrix4fc.m22();
        double d11 = Math.invsqrt(matrix4fc.m00() * matrix4fc.m00() + matrix4fc.m01() * matrix4fc.m01() + matrix4fc.m02() * matrix4fc.m02());
        double d12 = Math.invsqrt(matrix4fc.m10() * matrix4fc.m10() + matrix4fc.m11() * matrix4fc.m11() + matrix4fc.m12() * matrix4fc.m12());
        double d13 = Math.invsqrt(matrix4fc.m20() * matrix4fc.m20() + matrix4fc.m21() * matrix4fc.m21() + matrix4fc.m22() * matrix4fc.m22());
        d2 *= d11;
        d3 *= d11;
        d4 *= d11;
        d5 *= d12;
        d6 *= d12;
        d7 *= d12;
        d8 *= d13;
        d9 *= d13;
        d10 *= d13;
        double d14 = 1.0E-4;
        double d15 = 0.001;
        if (Math.abs(d5 - d3) < d14 && Math.abs(d8 - d4) < d14 && Math.abs(d9 - d7) < d14) {
            if (Math.abs(d5 + d3) < d15 && Math.abs(d8 + d4) < d15 && Math.abs(d9 + d7) < d15 && Math.abs(d2 + d6 + d10 - 3.0) < d15) {
                this.x = 0.0;
                this.y = 0.0;
                this.z = 1.0;
                this.angle = 0.0;
                return this;
            }
            this.angle = java.lang.Math.PI;
            double d16 = (d2 + 1.0) / 2.0;
            double d17 = (d6 + 1.0) / 2.0;
            double d18 = (d10 + 1.0) / 2.0;
            double d19 = (d5 + d3) / 4.0;
            double d20 = (d8 + d4) / 4.0;
            double d21 = (d9 + d7) / 4.0;
            if (d16 > d17 && d16 > d18) {
                this.x = Math.sqrt(d16);
                this.y = d19 / this.x;
                this.z = d20 / this.x;
            } else if (d17 > d18) {
                this.y = Math.sqrt(d17);
                this.x = d19 / this.y;
                this.z = d21 / this.y;
            } else {
                this.z = Math.sqrt(d18);
                this.x = d20 / this.z;
                this.y = d21 / this.z;
            }
            return this;
        }
        double d22 = Math.sqrt((d7 - d9) * (d7 - d9) + (d8 - d4) * (d8 - d4) + (d3 - d5) * (d3 - d5));
        this.angle = Math.safeAcos((d2 + d6 + d10 - 1.0) / 2.0);
        this.x = (d7 - d9) / d22;
        this.y = (d8 - d4) / d22;
        this.z = (d3 - d5) / d22;
        return this;
    }

    public AxisAngle4d set(Matrix4x3fc matrix4x3fc) {
        double d2 = matrix4x3fc.m00();
        double d3 = matrix4x3fc.m01();
        double d4 = matrix4x3fc.m02();
        double d5 = matrix4x3fc.m10();
        double d6 = matrix4x3fc.m11();
        double d7 = matrix4x3fc.m12();
        double d8 = matrix4x3fc.m20();
        double d9 = matrix4x3fc.m21();
        double d10 = matrix4x3fc.m22();
        double d11 = Math.invsqrt(matrix4x3fc.m00() * matrix4x3fc.m00() + matrix4x3fc.m01() * matrix4x3fc.m01() + matrix4x3fc.m02() * matrix4x3fc.m02());
        double d12 = Math.invsqrt(matrix4x3fc.m10() * matrix4x3fc.m10() + matrix4x3fc.m11() * matrix4x3fc.m11() + matrix4x3fc.m12() * matrix4x3fc.m12());
        double d13 = Math.invsqrt(matrix4x3fc.m20() * matrix4x3fc.m20() + matrix4x3fc.m21() * matrix4x3fc.m21() + matrix4x3fc.m22() * matrix4x3fc.m22());
        d2 *= d11;
        d3 *= d11;
        d4 *= d11;
        d5 *= d12;
        d6 *= d12;
        d7 *= d12;
        d8 *= d13;
        d9 *= d13;
        d10 *= d13;
        double d14 = 1.0E-4;
        double d15 = 0.001;
        if (Math.abs(d5 - d3) < d14 && Math.abs(d8 - d4) < d14 && Math.abs(d9 - d7) < d14) {
            if (Math.abs(d5 + d3) < d15 && Math.abs(d8 + d4) < d15 && Math.abs(d9 + d7) < d15 && Math.abs(d2 + d6 + d10 - 3.0) < d15) {
                this.x = 0.0;
                this.y = 0.0;
                this.z = 1.0;
                this.angle = 0.0;
                return this;
            }
            this.angle = java.lang.Math.PI;
            double d16 = (d2 + 1.0) / 2.0;
            double d17 = (d6 + 1.0) / 2.0;
            double d18 = (d10 + 1.0) / 2.0;
            double d19 = (d5 + d3) / 4.0;
            double d20 = (d8 + d4) / 4.0;
            double d21 = (d9 + d7) / 4.0;
            if (d16 > d17 && d16 > d18) {
                this.x = Math.sqrt(d16);
                this.y = d19 / this.x;
                this.z = d20 / this.x;
            } else if (d17 > d18) {
                this.y = Math.sqrt(d17);
                this.x = d19 / this.y;
                this.z = d21 / this.y;
            } else {
                this.z = Math.sqrt(d18);
                this.x = d20 / this.z;
                this.y = d21 / this.z;
            }
            return this;
        }
        double d22 = Math.sqrt((d7 - d9) * (d7 - d9) + (d8 - d4) * (d8 - d4) + (d3 - d5) * (d3 - d5));
        this.angle = Math.safeAcos((d2 + d6 + d10 - 1.0) / 2.0);
        this.x = (d7 - d9) / d22;
        this.y = (d8 - d4) / d22;
        this.z = (d3 - d5) / d22;
        return this;
    }

    public AxisAngle4d set(Matrix4dc matrix4dc) {
        double d2 = matrix4dc.m00();
        double d3 = matrix4dc.m01();
        double d4 = matrix4dc.m02();
        double d5 = matrix4dc.m10();
        double d6 = matrix4dc.m11();
        double d7 = matrix4dc.m12();
        double d8 = matrix4dc.m20();
        double d9 = matrix4dc.m21();
        double d10 = matrix4dc.m22();
        double d11 = Math.invsqrt(matrix4dc.m00() * matrix4dc.m00() + matrix4dc.m01() * matrix4dc.m01() + matrix4dc.m02() * matrix4dc.m02());
        double d12 = Math.invsqrt(matrix4dc.m10() * matrix4dc.m10() + matrix4dc.m11() * matrix4dc.m11() + matrix4dc.m12() * matrix4dc.m12());
        double d13 = Math.invsqrt(matrix4dc.m20() * matrix4dc.m20() + matrix4dc.m21() * matrix4dc.m21() + matrix4dc.m22() * matrix4dc.m22());
        d2 *= d11;
        d3 *= d11;
        d4 *= d11;
        d5 *= d12;
        d6 *= d12;
        d7 *= d12;
        d8 *= d13;
        d9 *= d13;
        d10 *= d13;
        double d14 = 1.0E-4;
        double d15 = 0.001;
        if (Math.abs(d5 - d3) < d14 && Math.abs(d8 - d4) < d14 && Math.abs(d9 - d7) < d14) {
            if (Math.abs(d5 + d3) < d15 && Math.abs(d8 + d4) < d15 && Math.abs(d9 + d7) < d15 && Math.abs(d2 + d6 + d10 - 3.0) < d15) {
                this.x = 0.0;
                this.y = 0.0;
                this.z = 1.0;
                this.angle = 0.0;
                return this;
            }
            this.angle = java.lang.Math.PI;
            double d16 = (d2 + 1.0) / 2.0;
            double d17 = (d6 + 1.0) / 2.0;
            double d18 = (d10 + 1.0) / 2.0;
            double d19 = (d5 + d3) / 4.0;
            double d20 = (d8 + d4) / 4.0;
            double d21 = (d9 + d7) / 4.0;
            if (d16 > d17 && d16 > d18) {
                this.x = Math.sqrt(d16);
                this.y = d19 / this.x;
                this.z = d20 / this.x;
            } else if (d17 > d18) {
                this.y = Math.sqrt(d17);
                this.x = d19 / this.y;
                this.z = d21 / this.y;
            } else {
                this.z = Math.sqrt(d18);
                this.x = d20 / this.z;
                this.y = d21 / this.z;
            }
            return this;
        }
        double d22 = Math.sqrt((d7 - d9) * (d7 - d9) + (d8 - d4) * (d8 - d4) + (d3 - d5) * (d3 - d5));
        this.angle = Math.safeAcos((d2 + d6 + d10 - 1.0) / 2.0);
        this.x = (d7 - d9) / d22;
        this.y = (d8 - d4) / d22;
        this.z = (d3 - d5) / d22;
        return this;
    }

    public Quaternionf get(Quaternionf quaternionf) {
        return quaternionf.set(this);
    }

    public Quaterniond get(Quaterniond quaterniond) {
        return quaterniond.set(this);
    }

    public Matrix4f get(Matrix4f matrix4f) {
        return matrix4f.set(this);
    }

    public Matrix3f get(Matrix3f matrix3f) {
        return matrix3f.set(this);
    }

    public Matrix4d get(Matrix4d matrix4d) {
        return matrix4d.set(this);
    }

    public Matrix3d get(Matrix3d matrix3d) {
        return matrix3d.set(this);
    }

    public AxisAngle4d get(AxisAngle4d axisAngle4d) {
        return axisAngle4d.set(this);
    }

    public AxisAngle4f get(AxisAngle4f axisAngle4f) {
        return axisAngle4f.set(this);
    }

    public void writeExternal(ObjectOutput objectOutput) {
        objectOutput.writeDouble(this.angle);
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        objectOutput.writeDouble(this.z);
    }

    public void readExternal(ObjectInput objectInput) {
        this.angle = objectInput.readDouble();
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        this.z = objectInput.readDouble();
    }

    public AxisAngle4d normalize() {
        double d2 = Math.invsqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        this.x *= d2;
        this.y *= d2;
        this.z *= d2;
        return this;
    }

    public AxisAngle4d rotate(double d2) {
        this.angle += d2;
        this.angle = (this.angle < 0.0 ? java.lang.Math.PI * 2 + this.angle % (java.lang.Math.PI * 2) : this.angle) % (java.lang.Math.PI * 2);
        return this;
    }

    public Vector3d transform(Vector3d vector3d) {
        return this.transform(vector3d, vector3d);
    }

    public Vector3d transform(Vector3dc vector3dc, Vector3d vector3d) {
        double d2 = Math.sin(this.angle);
        double d3 = Math.cosFromSin(d2, this.angle);
        double d4 = this.x * vector3dc.x() + this.y * vector3dc.y() + this.z * vector3dc.z();
        vector3d.set(vector3dc.x() * d3 + d2 * (this.y * vector3dc.z() - this.z * vector3dc.y()) + (1.0 - d3) * d4 * this.x, vector3dc.y() * d3 + d2 * (this.z * vector3dc.x() - this.x * vector3dc.z()) + (1.0 - d3) * d4 * this.y, vector3dc.z() * d3 + d2 * (this.x * vector3dc.y() - this.y * vector3dc.x()) + (1.0 - d3) * d4 * this.z);
        return vector3d;
    }

    public Vector3f transform(Vector3f vector3f) {
        return this.transform(vector3f, vector3f);
    }

    public Vector3f transform(Vector3fc vector3fc, Vector3f vector3f) {
        double d2 = Math.sin(this.angle);
        double d3 = Math.cosFromSin(d2, this.angle);
        double d4 = this.x * (double)vector3fc.x() + this.y * (double)vector3fc.y() + this.z * (double)vector3fc.z();
        vector3f.set((float)((double)vector3fc.x() * d3 + d2 * (this.y * (double)vector3fc.z() - this.z * (double)vector3fc.y()) + (1.0 - d3) * d4 * this.x), (float)((double)vector3fc.y() * d3 + d2 * (this.z * (double)vector3fc.x() - this.x * (double)vector3fc.z()) + (1.0 - d3) * d4 * this.y), (float)((double)vector3fc.z() * d3 + d2 * (this.x * (double)vector3fc.y() - this.y * (double)vector3fc.x()) + (1.0 - d3) * d4 * this.z));
        return vector3f;
    }

    public Vector4d transform(Vector4d vector4d) {
        return this.transform(vector4d, vector4d);
    }

    public Vector4d transform(Vector4dc vector4dc, Vector4d vector4d) {
        double d2 = Math.sin(this.angle);
        double d3 = Math.cosFromSin(d2, this.angle);
        double d4 = this.x * vector4dc.x() + this.y * vector4dc.y() + this.z * vector4dc.z();
        vector4d.set(vector4dc.x() * d3 + d2 * (this.y * vector4dc.z() - this.z * vector4dc.y()) + (1.0 - d3) * d4 * this.x, vector4dc.y() * d3 + d2 * (this.z * vector4dc.x() - this.x * vector4dc.z()) + (1.0 - d3) * d4 * this.y, vector4dc.z() * d3 + d2 * (this.x * vector4dc.y() - this.y * vector4dc.x()) + (1.0 - d3) * d4 * this.z, vector4d.w);
        return vector4d;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + " <| " + Runtime.format(this.angle, numberFormat) + ")";
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        long l2 = Double.doubleToLongBits((this.angle < 0.0 ? java.lang.Math.PI * 2 + this.angle % (java.lang.Math.PI * 2) : this.angle) % (java.lang.Math.PI * 2));
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.x);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.y);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.z);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AxisAngle4d axisAngle4d = (AxisAngle4d)object;
        if (Double.doubleToLongBits((this.angle < 0.0 ? java.lang.Math.PI * 2 + this.angle % (java.lang.Math.PI * 2) : this.angle) % (java.lang.Math.PI * 2)) != Double.doubleToLongBits((axisAngle4d.angle < 0.0 ? java.lang.Math.PI * 2 + axisAngle4d.angle % (java.lang.Math.PI * 2) : axisAngle4d.angle) % (java.lang.Math.PI * 2))) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(axisAngle4d.x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(axisAngle4d.y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(axisAngle4d.z);
    }

    public Object clone() {
        return super.clone();
    }
}

