/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.jansi.internal;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;

public class OSInfo {
    private static final HashMap<String, String> j = new HashMap();

    public static void main(String[] stringArray) {
        if (stringArray.length >= 1) {
            if ("--os".equals(stringArray[0])) {
                System.out.print(OSInfo.fv());
                return;
            }
            if ("--arch".equals(stringArray[0])) {
                System.out.print(OSInfo.fy());
                return;
            }
        }
        System.out.print(OSInfo.fu());
    }

    public static String fu() {
        return OSInfo.fv() + "/" + OSInfo.fy();
    }

    public static String fv() {
        return OSInfo.bf(System.getProperty("os.name"));
    }

    public static boolean isAndroid() {
        return System.getProperty("java.runtime.name", "").toLowerCase().contains("android");
    }

    static String fw() {
        String string;
        Process process = Runtime.getRuntime().exec("uname -m");
        process.waitFor();
        InputStream inputStream = process.getInputStream();
        try {
            string = OSInfo.c(inputStream);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                System.err.println("Error while running uname -m: " + throwable2.getMessage());
                return "unknown";
            }
        }
        inputStream.close();
        return string;
    }

    private static String c(InputStream inputStream) {
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[32];
        while ((n2 = inputStream.read(byArray, 0, byArray.length)) >= 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toString();
    }

    static String fx() {
        if (System.getProperty("os.name").contains("Linux")) {
            String string = OSInfo.fw();
            if (string.startsWith("armv6")) {
                return "armv6";
            }
            if (string.startsWith("armv7")) {
                return "armv7";
            }
            if (string.startsWith("armv5")) {
                return "arm";
            }
            if (string.equals("aarch64")) {
                return "arm64";
            }
            String string2 = System.getProperty("sun.arch.abi");
            if (string2 != null && string2.startsWith("gnueabihf")) {
                return "armv7";
            }
        }
        return "arm";
    }

    public static String fy() {
        String string = System.getProperty("os.arch");
        if (OSInfo.isAndroid()) {
            return "android-arm";
        }
        if (string.startsWith("arm")) {
            string = OSInfo.fx();
        } else {
            String string2 = string.toLowerCase(Locale.US);
            if (j.containsKey(string2)) {
                return j.get(string2);
            }
        }
        return OSInfo.bg(string);
    }

    static String bf(String string) {
        if (string.contains("Windows")) {
            return "Windows";
        }
        if (string.contains("Mac") || string.contains("Darwin")) {
            return "Mac";
        }
        if (string.contains("Linux")) {
            return "Linux";
        }
        if (string.contains("AIX")) {
            return "AIX";
        }
        return string.replaceAll("\\W", "");
    }

    static String bg(String string) {
        return string.replaceAll("\\W", "");
    }

    static {
        j.put("x86", "x86");
        j.put("i386", "x86");
        j.put("i486", "x86");
        j.put("i586", "x86");
        j.put("i686", "x86");
        j.put("pentium", "x86");
        j.put("x86_64", "x86_64");
        j.put("amd64", "x86_64");
        j.put("em64t", "x86_64");
        j.put("universal", "x86_64");
        j.put("ia64", "ia64");
        j.put("ia64w", "ia64");
        j.put("ia64_32", "ia64_32");
        j.put("ia64n", "ia64_32");
        j.put("ppc", "ppc");
        j.put("power", "ppc");
        j.put("powerpc", "ppc");
        j.put("power_pc", "ppc");
        j.put("power_rs", "ppc");
        j.put("ppc64", "ppc64");
        j.put("power64", "ppc64");
        j.put("powerpc64", "ppc64");
        j.put("power_pc64", "ppc64");
        j.put("power_rs64", "ppc64");
        j.put("aarch64", "arm64");
    }
}

