/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Constants;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.Unbox$State;
import org.apache.logging.log4j.util.Unbox$WebSafeState;

@PerformanceSensitive(value={"allocation"})
public class Unbox {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int BITS_PER_INT = 32;
    private static final int RINGBUFFER_MIN_SIZE = 32;
    private static final int RINGBUFFER_SIZE = Unbox.calculateRingBufferSize("log4j.unbox.ringbuffer.size");
    private static final int MASK = RINGBUFFER_SIZE - 1;
    private static ThreadLocal<Unbox$State> threadLocalState = new ThreadLocal();
    private static Unbox$WebSafeState webSafeState = new Unbox$WebSafeState(null);

    private Unbox() {
    }

    private static int calculateRingBufferSize(String string) {
        String string2 = PropertiesUtil.getProperties().getStringProperty(string, String.valueOf(32));
        try {
            int n2 = Integer.parseInt(string2);
            if (n2 < 32) {
                n2 = 32;
                LOGGER.warn("Invalid {} {}, using minimum size {}.", (Object)string, (Object)string2, (Object)32);
            }
            return Unbox.ceilingNextPowerOfTwo(n2);
        }
        catch (Exception exception) {
            LOGGER.warn("Invalid {} {}, using default size {}.", (Object)string, (Object)string2, (Object)32);
            return 32;
        }
    }

    private static int ceilingNextPowerOfTwo(int n2) {
        return 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(float f2) {
        return Unbox.getSB().append(f2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(double d2) {
        return Unbox.getSB().append(d2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(short s2) {
        return Unbox.getSB().append(s2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(int n2) {
        return Unbox.getSB().append(n2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(char c2) {
        return Unbox.getSB().append(c2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(long l2) {
        return Unbox.getSB().append(l2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(byte by2) {
        return Unbox.getSB().append(by2);
    }

    @PerformanceSensitive(value={"allocation"})
    public static StringBuilder box(boolean bl2) {
        return Unbox.getSB().append(bl2);
    }

    private static Unbox$State getState() {
        Unbox$State unbox$State = threadLocalState.get();
        if (unbox$State == null) {
            unbox$State = new Unbox$State();
            threadLocalState.set(unbox$State);
        }
        return unbox$State;
    }

    private static StringBuilder getSB() {
        return Constants.ENABLE_THREADLOCALS ? Unbox.getState().getStringBuilder() : webSafeState.getStringBuilder();
    }

    static int getRingbufferSize() {
        return RINGBUFFER_SIZE;
    }

    static /* synthetic */ int access$000() {
        return RINGBUFFER_SIZE;
    }

    static /* synthetic */ int access$100() {
        return MASK;
    }
}

