/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import org.apache.logging.log4j.util.LoaderUtil$ThreadContextClassLoaderGetter;
import org.apache.logging.log4j.util.LoaderUtil$UrlResource;
import org.apache.logging.log4j.util.LowLevelLogUtil;
import org.apache.logging.log4j.util.PropertiesUtil;

public final class LoaderUtil {
    public static final String IGNORE_TCCL_PROPERTY = "log4j.ignoreTCL";
    private static final SecurityManager SECURITY_MANAGER = System.getSecurityManager();
    private static Boolean ignoreTCCL;
    private static final boolean GET_CLASS_LOADER_DISABLED;
    private static final PrivilegedAction<ClassLoader> TCCL_GETTER;

    private LoaderUtil() {
    }

    public static ClassLoader getThreadContextClassLoader() {
        if (GET_CLASS_LOADER_DISABLED) {
            return LoaderUtil.class.getClassLoader();
        }
        return SECURITY_MANAGER == null ? TCCL_GETTER.run() : AccessController.doPrivileged(TCCL_GETTER);
    }

    public static boolean isClassAvailable(String string) {
        try {
            Class<?> clazz = LoaderUtil.loadClass(string);
            return clazz != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        catch (Throwable throwable) {
            LowLevelLogUtil.logException("Unknown error checking for existence of class: " + string, throwable);
            return false;
        }
    }

    public static Class<?> loadClass(String string) {
        if (LoaderUtil.isIgnoreTccl()) {
            return Class.forName(string);
        }
        try {
            return LoaderUtil.getThreadContextClassLoader().loadClass(string);
        }
        catch (Throwable throwable) {
            return Class.forName(string);
        }
    }

    public static <T> T newInstanceOf(Class<T> clazz) {
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return clazz.newInstance();
        }
    }

    public static <T> T newInstanceOf(String string) {
        return (T)LoaderUtil.newInstanceOf(LoaderUtil.loadClass(string));
    }

    public static <T> T newCheckedInstanceOf(String string, Class<T> clazz) {
        return clazz.cast(LoaderUtil.newInstanceOf(string));
    }

    public static <T> T newCheckedInstanceOfProperty(String string, Class<T> clazz) {
        String string2 = PropertiesUtil.getProperties().getStringProperty(string);
        if (string2 == null) {
            return null;
        }
        return LoaderUtil.newCheckedInstanceOf(string2, clazz);
    }

    private static boolean isIgnoreTccl() {
        if (ignoreTCCL == null) {
            String string = PropertiesUtil.getProperties().getStringProperty(IGNORE_TCCL_PROPERTY, null);
            ignoreTCCL = string != null && !"false".equalsIgnoreCase(string.trim());
        }
        return ignoreTCCL;
    }

    public static Collection<URL> findResources(String string) {
        Collection<LoaderUtil$UrlResource> collection = LoaderUtil.findUrlResources(string);
        LinkedHashSet<URL> linkedHashSet = new LinkedHashSet<URL>(collection.size());
        for (LoaderUtil$UrlResource loaderUtil$UrlResource : collection) {
            linkedHashSet.add(loaderUtil$UrlResource.getUrl());
        }
        return linkedHashSet;
    }

    static Collection<LoaderUtil$UrlResource> findUrlResources(String string) {
        ClassLoader[] classLoaderArray = new ClassLoader[]{LoaderUtil.getThreadContextClassLoader(), LoaderUtil.class.getClassLoader(), GET_CLASS_LOADER_DISABLED ? null : ClassLoader.getSystemClassLoader()};
        LinkedHashSet<LoaderUtil$UrlResource> linkedHashSet = new LinkedHashSet<LoaderUtil$UrlResource>();
        for (ClassLoader classLoader : classLoaderArray) {
            if (classLoader == null) continue;
            try {
                Enumeration<URL> enumeration = classLoader.getResources(string);
                while (enumeration.hasMoreElements()) {
                    linkedHashSet.add(new LoaderUtil$UrlResource(classLoader, enumeration.nextElement()));
                }
            }
            catch (IOException iOException) {
                LowLevelLogUtil.logException(iOException);
            }
        }
        return linkedHashSet;
    }

    static /* synthetic */ boolean access$100() {
        return GET_CLASS_LOADER_DISABLED;
    }

    static {
        TCCL_GETTER = new LoaderUtil$ThreadContextClassLoaderGetter(null);
        if (SECURITY_MANAGER != null) {
            boolean bl2;
            try {
                SECURITY_MANAGER.checkPermission(new RuntimePermission("getClassLoader"));
                bl2 = false;
            }
            catch (SecurityException securityException) {
                bl2 = true;
            }
            GET_CLASS_LOADER_DISABLED = bl2;
        } else {
            GET_CLASS_LOADER_DISABLED = false;
        }
    }
}

