/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.lang.management.ThreadInfo;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ThreadDumpMessage$1;
import org.apache.logging.log4j.message.ThreadDumpMessage$BasicThreadInfoFactory;
import org.apache.logging.log4j.message.ThreadDumpMessage$ExtendedThreadInfoFactory;
import org.apache.logging.log4j.message.ThreadDumpMessage$ThreadDumpMessageProxy;
import org.apache.logging.log4j.message.ThreadDumpMessage$ThreadInfoFactory;
import org.apache.logging.log4j.message.ThreadInformation;
import org.apache.logging.log4j.util.StringBuilderFormattable;

@AsynchronouslyFormattable
public class ThreadDumpMessage
implements Message,
StringBuilderFormattable {
    private static final long serialVersionUID = -1103400781608841088L;
    private static final ThreadDumpMessage$ThreadInfoFactory FACTORY;
    private volatile Map<ThreadInformation, StackTraceElement[]> threads;
    private final String title;
    private String formattedMessage;

    public ThreadDumpMessage(String string) {
        this.title = string == null ? "" : string;
        this.threads = FACTORY.createThreadInfo();
    }

    private ThreadDumpMessage(String string, String string2) {
        this.formattedMessage = string;
        this.title = string2 == null ? "" : string2;
    }

    public String toString() {
        return this.getFormattedMessage();
    }

    @Override
    public String getFormattedMessage() {
        if (this.formattedMessage != null) {
            return this.formattedMessage;
        }
        StringBuilder stringBuilder = new StringBuilder(255);
        this.formatTo(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void formatTo(StringBuilder stringBuilder) {
        stringBuilder.append(this.title);
        if (this.title.length() > 0) {
            stringBuilder.append('\n');
        }
        for (Map.Entry<ThreadInformation, StackTraceElement[]> entry : this.threads.entrySet()) {
            ThreadInformation threadInformation = entry.getKey();
            threadInformation.printThreadInfo(stringBuilder);
            threadInformation.printStack(stringBuilder, entry.getValue());
            stringBuilder.append('\n');
        }
    }

    @Override
    public String getFormat() {
        return this.title == null ? "" : this.title;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    protected Object writeReplace() {
        return new ThreadDumpMessage$ThreadDumpMessageProxy(this);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new InvalidObjectException("Proxy required");
    }

    @Override
    public Throwable getThrowable() {
        return null;
    }

    static /* synthetic */ String access$200(ThreadDumpMessage threadDumpMessage) {
        return threadDumpMessage.title;
    }

    /* synthetic */ ThreadDumpMessage(String string, String string2, ThreadDumpMessage$1 threadDumpMessage$1) {
        this(string, string2);
    }

    static {
        Method[] methodArray = ThreadInfo.class.getMethods();
        boolean bl2 = true;
        for (Method method : methodArray) {
            if (!method.getName().equals("getLockInfo")) continue;
            bl2 = false;
            break;
        }
        FACTORY = bl2 ? new ThreadDumpMessage$BasicThreadInfoFactory() : new ThreadDumpMessage$ExtendedThreadInfoFactory(null);
    }
}

