/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Map;
import org.apache.logging.log4j.message.AsynchronouslyFormattable;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.StructuredDataId;
import org.apache.logging.log4j.message.StructuredDataMessage$Format;
import org.apache.logging.log4j.util.EnglishEnums;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.StringBuilders;

@AsynchronouslyFormattable
public class StructuredDataMessage
extends MapMessage
implements StringBuilderFormattable {
    private static final long serialVersionUID = 1703221292892071920L;
    private static final int MAX_LENGTH = 32;
    private static final int HASHVAL = 31;
    private StructuredDataId id;
    private String message;
    private String type;

    public StructuredDataMessage(String string, String string2, String string3) {
        this.id = new StructuredDataId(string, null, null);
        this.message = string2;
        this.type = string3;
    }

    public StructuredDataMessage(String string, String string2, String string3, Map<String, String> map) {
        super(map);
        this.id = new StructuredDataId(string, null, null);
        this.message = string2;
        this.type = string3;
    }

    public StructuredDataMessage(StructuredDataId structuredDataId, String string, String string2) {
        this.id = structuredDataId;
        this.message = string;
        this.type = string2;
    }

    public StructuredDataMessage(StructuredDataId structuredDataId, String string, String string2, Map<String, String> map) {
        super(map);
        this.id = structuredDataId;
        this.message = string;
        this.type = string2;
    }

    private StructuredDataMessage(StructuredDataMessage structuredDataMessage, Map<String, String> map) {
        super(map);
        this.id = structuredDataMessage.id;
        this.message = structuredDataMessage.message;
        this.type = structuredDataMessage.type;
    }

    protected StructuredDataMessage() {
    }

    @Override
    public StructuredDataMessage with(String string, String string2) {
        this.put(string, string2);
        return this;
    }

    @Override
    public String[] getFormats() {
        String[] stringArray = new String[StructuredDataMessage$Format.values().length];
        int n2 = 0;
        for (StructuredDataMessage$Format structuredDataMessage$Format : StructuredDataMessage$Format.values()) {
            stringArray[n2++] = structuredDataMessage$Format.name();
        }
        return stringArray;
    }

    public StructuredDataId getId() {
        return this.id;
    }

    protected void setId(String string) {
        this.id = new StructuredDataId(string, null, null);
    }

    protected void setId(StructuredDataId structuredDataId) {
        this.id = structuredDataId;
    }

    public String getType() {
        return this.type;
    }

    protected void setType(String string) {
        if (string.length() > 32) {
            throw new IllegalArgumentException("structured data type exceeds maximum length of 32 characters: " + string);
        }
        this.type = string;
    }

    @Override
    public void formatTo(StringBuilder stringBuilder) {
        this.asString(StructuredDataMessage$Format.FULL, null, stringBuilder);
    }

    @Override
    public String getFormat() {
        return this.message;
    }

    protected void setMessageFormat(String string) {
        this.message = string;
    }

    @Override
    protected void validate(String string, String string2) {
        this.validateKey(string);
    }

    private void validateKey(String string) {
        if (string.length() > 32) {
            throw new IllegalArgumentException("Structured data keys are limited to 32 characters. key: " + string);
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '!' && c2 <= '~' && c2 != '=' && c2 != ']' && c2 != '\"') continue;
            throw new IllegalArgumentException("Structured data keys must contain printable US ASCII charactersand may not contain a space, =, ], or \"");
        }
    }

    @Override
    public String asString() {
        return this.asString(StructuredDataMessage$Format.FULL, null);
    }

    @Override
    public String asString(String string) {
        try {
            return this.asString(EnglishEnums.valueOf(StructuredDataMessage$Format.class, string), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return this.asString();
        }
    }

    public final String asString(StructuredDataMessage$Format structuredDataMessage$Format, StructuredDataId structuredDataId) {
        StringBuilder stringBuilder = new StringBuilder();
        this.asString(structuredDataMessage$Format, structuredDataId, stringBuilder);
        return stringBuilder.toString();
    }

    public final void asString(StructuredDataMessage$Format structuredDataMessage$Format, StructuredDataId structuredDataId, StringBuilder stringBuilder) {
        String string;
        Object object;
        boolean bl2 = StructuredDataMessage$Format.FULL.equals((Object)structuredDataMessage$Format);
        if (bl2) {
            object = this.getType();
            if (object == null) {
                return;
            }
            stringBuilder.append(this.getType()).append(' ');
        }
        if ((object = (object = this.getId()) != null ? ((StructuredDataId)object).makeId(structuredDataId) : structuredDataId) == null || ((StructuredDataId)object).getName() == null) {
            return;
        }
        stringBuilder.append('[');
        StringBuilders.appendValue(stringBuilder, object);
        stringBuilder.append(' ');
        this.appendMap(stringBuilder);
        stringBuilder.append(']');
        if (bl2 && (string = this.getFormat()) != null) {
            stringBuilder.append(' ').append(string);
        }
    }

    @Override
    public String getFormattedMessage() {
        return this.asString(StructuredDataMessage$Format.FULL, null);
    }

    @Override
    public String getFormattedMessage(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = stringArray[i2];
                if (StructuredDataMessage$Format.XML.name().equalsIgnoreCase(string)) {
                    return this.asXml();
                }
                if (!StructuredDataMessage$Format.FULL.name().equalsIgnoreCase(string)) continue;
                return this.asString(StructuredDataMessage$Format.FULL, null);
            }
            return this.asString(null, null);
        }
        return this.asString(StructuredDataMessage$Format.FULL, null);
    }

    private String asXml() {
        StringBuilder stringBuilder = new StringBuilder();
        StructuredDataId structuredDataId = this.getId();
        if (structuredDataId == null || structuredDataId.getName() == null || this.type == null) {
            return stringBuilder.toString();
        }
        stringBuilder.append("<StructuredData>\n");
        stringBuilder.append("<type>").append(this.type).append("</type>\n");
        stringBuilder.append("<id>").append(structuredDataId).append("</id>\n");
        super.asXml(stringBuilder);
        stringBuilder.append("</StructuredData>\n");
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.asString(null, null);
    }

    @Override
    public MapMessage newInstance(Map<String, String> map) {
        return new StructuredDataMessage(this, map);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StructuredDataMessage structuredDataMessage = (StructuredDataMessage)object;
        if (!super.equals(object)) {
            return false;
        }
        if (this.type != null ? !this.type.equals(structuredDataMessage.type) : structuredDataMessage.type != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(structuredDataMessage.id) : structuredDataMessage.id != null) {
            return false;
        }
        return !(this.message != null ? !this.message.equals(structuredDataMessage.message) : structuredDataMessage.message != null);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 31 * n2 + (this.type != null ? this.type.hashCode() : 0);
        n2 = 31 * n2 + (this.id != null ? this.id.hashCode() : 0);
        n2 = 31 * n2 + (this.message != null ? this.message.hashCode() : 0);
        return n2;
    }
}

