/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.util.StringBuilderFormattable;

final class ParameterFormatter {
    static final String RECURSION_PREFIX = "[...";
    static final String RECURSION_SUFFIX = "...]";
    static final String ERROR_PREFIX = "[!!!";
    static final String ERROR_SEPARATOR = "=>";
    static final String ERROR_MSG_SEPARATOR = ":";
    static final String ERROR_SUFFIX = "!!!]";
    private static final char DELIM_START = '{';
    private static final char DELIM_STOP = '}';
    private static final char ESCAPE_CHAR = '\\';
    private static ThreadLocal<SimpleDateFormat> threadLocalSimpleDateFormat = new ThreadLocal();

    private ParameterFormatter() {
    }

    static int countArgumentPlaceholders(String string) {
        if (string == null) {
            return 0;
        }
        int n2 = string.length();
        int n3 = 0;
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\') {
                bl2 = !bl2;
                continue;
            }
            if (c2 == '{') {
                if (!bl2 && string.charAt(i2 + 1) == '}') {
                    ++n3;
                    ++i2;
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
        }
        return n3;
    }

    static int countArgumentPlaceholders2(String string, int[] nArray) {
        if (string == null) {
            return 0;
        }
        int n2 = string.length();
        int n3 = 0;
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\') {
                bl2 = !bl2;
                nArray[0] = -1;
                ++n3;
                continue;
            }
            if (c2 == '{') {
                if (!bl2 && string.charAt(i2 + 1) == '}') {
                    nArray[n3] = i2++;
                    ++n3;
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
        }
        return n3;
    }

    static int countArgumentPlaceholders3(char[] cArray, int n2, int[] nArray) {
        int n3 = 0;
        boolean bl2 = false;
        for (int i2 = 0; i2 < n2 - 1; ++i2) {
            char c2 = cArray[i2];
            if (c2 == '\\') {
                bl2 = !bl2;
                continue;
            }
            if (c2 == '{') {
                if (!bl2 && cArray[i2 + 1] == '}') {
                    nArray[n3] = i2++;
                    ++n3;
                }
                bl2 = false;
                continue;
            }
            bl2 = false;
        }
        return n3;
    }

    static String format(String string, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = objectArray == null ? 0 : objectArray.length;
        ParameterFormatter.formatMessage(stringBuilder, string, objectArray, n2);
        return stringBuilder.toString();
    }

    static void formatMessage2(StringBuilder stringBuilder, String string, Object[] objectArray, int n2, int[] nArray) {
        if (string == null || objectArray == null || n2 == 0) {
            stringBuilder.append(string);
            return;
        }
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(string, n3, nArray[i2]);
            n3 = nArray[i2] + 2;
            ParameterFormatter.recursiveDeepToString(objectArray[i2], stringBuilder, null);
        }
        stringBuilder.append(string, n3, string.length());
    }

    static void formatMessage3(StringBuilder stringBuilder, char[] cArray, int n2, Object[] objectArray, int n3, int[] nArray) {
        if (cArray == null) {
            return;
        }
        if (objectArray == null || n3 == 0) {
            stringBuilder.append(cArray);
            return;
        }
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            stringBuilder.append(cArray, n4, nArray[i2]);
            n4 = nArray[i2] + 2;
            ParameterFormatter.recursiveDeepToString(objectArray[i2], stringBuilder, null);
        }
        stringBuilder.append(cArray, n4, n2);
    }

    static void formatMessage(StringBuilder stringBuilder, String string, Object[] objectArray, int n2) {
        int n3;
        if (string == null || objectArray == null || n2 == 0) {
            stringBuilder.append(string);
            return;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = string.length();
        for (n3 = 0; n3 < n6 - 1; ++n3) {
            char c2 = string.charAt(n3);
            if (c2 == '\\') {
                ++n4;
                continue;
            }
            if (ParameterFormatter.isDelimPair(c2, string, n3)) {
                ++n3;
                ParameterFormatter.writeEscapedEscapeChars(n4, stringBuilder);
                if (ParameterFormatter.isOdd(n4)) {
                    ParameterFormatter.writeDelimPair(stringBuilder);
                } else {
                    ParameterFormatter.writeArgOrDelimPair(objectArray, n2, n5, stringBuilder);
                    ++n5;
                }
            } else {
                ParameterFormatter.handleLiteralChar(stringBuilder, n4, c2);
            }
            n4 = 0;
        }
        ParameterFormatter.handleRemainingCharIfAny(string, n6, stringBuilder, n4, n3);
    }

    private static boolean isDelimPair(char c2, String string, int n2) {
        return c2 == '{' && string.charAt(n2 + 1) == '}';
    }

    private static void handleRemainingCharIfAny(String string, int n2, StringBuilder stringBuilder, int n3, int n4) {
        if (n4 == n2 - 1) {
            char c2 = string.charAt(n4);
            ParameterFormatter.handleLastChar(stringBuilder, n3, c2);
        }
    }

    private static void handleLastChar(StringBuilder stringBuilder, int n2, char c2) {
        if (c2 == '\\') {
            ParameterFormatter.writeUnescapedEscapeChars(n2 + 1, stringBuilder);
        } else {
            ParameterFormatter.handleLiteralChar(stringBuilder, n2, c2);
        }
    }

    private static void handleLiteralChar(StringBuilder stringBuilder, int n2, char c2) {
        ParameterFormatter.writeUnescapedEscapeChars(n2, stringBuilder);
        stringBuilder.append(c2);
    }

    private static void writeDelimPair(StringBuilder stringBuilder) {
        stringBuilder.append('{');
        stringBuilder.append('}');
    }

    private static boolean isOdd(int n2) {
        return (n2 & 1) == 1;
    }

    private static void writeEscapedEscapeChars(int n2, StringBuilder stringBuilder) {
        int n3 = n2 >> 1;
        ParameterFormatter.writeUnescapedEscapeChars(n3, stringBuilder);
    }

    private static void writeUnescapedEscapeChars(int n2, StringBuilder stringBuilder) {
        while (n2 > 0) {
            stringBuilder.append('\\');
            --n2;
        }
    }

    private static void writeArgOrDelimPair(Object[] objectArray, int n2, int n3, StringBuilder stringBuilder) {
        if (n3 < n2) {
            ParameterFormatter.recursiveDeepToString(objectArray[n3], stringBuilder, null);
        } else {
            ParameterFormatter.writeDelimPair(stringBuilder);
        }
    }

    static String deepToString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<String> hashSet = new HashSet<String>();
        ParameterFormatter.recursiveDeepToString(object, stringBuilder, hashSet);
        return stringBuilder.toString();
    }

    private static void recursiveDeepToString(Object object, StringBuilder stringBuilder, Set<String> set) {
        if (ParameterFormatter.appendSpecialTypes(object, stringBuilder)) {
            return;
        }
        if (ParameterFormatter.isMaybeRecursive(object)) {
            ParameterFormatter.appendPotentiallyRecursiveValue(object, stringBuilder, set);
        } else {
            ParameterFormatter.tryObjectToString(object, stringBuilder);
        }
    }

    private static boolean appendSpecialTypes(Object object, StringBuilder stringBuilder) {
        if (object == null || object instanceof String) {
            stringBuilder.append((String)object);
            return true;
        }
        if (object instanceof CharSequence) {
            stringBuilder.append((CharSequence)object);
            return true;
        }
        if (object instanceof StringBuilderFormattable) {
            ((StringBuilderFormattable)object).formatTo(stringBuilder);
            return true;
        }
        if (object instanceof Integer) {
            stringBuilder.append((Integer)object);
            return true;
        }
        if (object instanceof Long) {
            stringBuilder.append((Long)object);
            return true;
        }
        if (object instanceof Double) {
            stringBuilder.append((Double)object);
            return true;
        }
        if (object instanceof Boolean) {
            stringBuilder.append((Boolean)object);
            return true;
        }
        if (object instanceof Character) {
            stringBuilder.append(((Character)object).charValue());
            return true;
        }
        if (object instanceof Short) {
            stringBuilder.append(((Short)object).shortValue());
            return true;
        }
        if (object instanceof Float) {
            stringBuilder.append(((Float)object).floatValue());
            return true;
        }
        return ParameterFormatter.appendDate(object, stringBuilder);
    }

    private static boolean appendDate(Object object, StringBuilder stringBuilder) {
        if (!(object instanceof Date)) {
            return false;
        }
        Date date = (Date)object;
        SimpleDateFormat simpleDateFormat = ParameterFormatter.getSimpleDateFormat();
        stringBuilder.append(simpleDateFormat.format(date));
        return true;
    }

    private static SimpleDateFormat getSimpleDateFormat() {
        SimpleDateFormat simpleDateFormat = threadLocalSimpleDateFormat.get();
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            threadLocalSimpleDateFormat.set(simpleDateFormat);
        }
        return simpleDateFormat;
    }

    private static boolean isMaybeRecursive(Object object) {
        return object.getClass().isArray() || object instanceof Map || object instanceof Collection;
    }

    private static void appendPotentiallyRecursiveValue(Object object, StringBuilder stringBuilder, Set<String> set) {
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            ParameterFormatter.appendArray(object, stringBuilder, set, clazz);
        } else if (object instanceof Map) {
            ParameterFormatter.appendMap(object, stringBuilder, set);
        } else if (object instanceof Collection) {
            ParameterFormatter.appendCollection(object, stringBuilder, set);
        }
    }

    private static void appendArray(Object object, StringBuilder stringBuilder, Set<String> set, Class<?> clazz) {
        if (clazz == byte[].class) {
            stringBuilder.append(Arrays.toString((byte[])object));
        } else if (clazz == short[].class) {
            stringBuilder.append(Arrays.toString((short[])object));
        } else if (clazz == int[].class) {
            stringBuilder.append(Arrays.toString((int[])object));
        } else if (clazz == long[].class) {
            stringBuilder.append(Arrays.toString((long[])object));
        } else if (clazz == float[].class) {
            stringBuilder.append(Arrays.toString((float[])object));
        } else if (clazz == double[].class) {
            stringBuilder.append(Arrays.toString((double[])object));
        } else if (clazz == boolean[].class) {
            stringBuilder.append(Arrays.toString((boolean[])object));
        } else if (clazz == char[].class) {
            stringBuilder.append(Arrays.toString((char[])object));
        } else {
            String string;
            if (set == null) {
                set = new HashSet<String>();
            }
            if (set.contains(string = ParameterFormatter.identityToString(object))) {
                stringBuilder.append(RECURSION_PREFIX).append(string).append(RECURSION_SUFFIX);
            } else {
                set.add(string);
                Object[] objectArray = (Object[])object;
                stringBuilder.append('[');
                boolean bl2 = true;
                for (Object object2 : objectArray) {
                    if (bl2) {
                        bl2 = false;
                    } else {
                        stringBuilder.append(", ");
                    }
                    ParameterFormatter.recursiveDeepToString(object2, stringBuilder, new HashSet<String>(set));
                }
                stringBuilder.append(']');
            }
        }
    }

    private static void appendMap(Object object, StringBuilder stringBuilder, Set<String> set) {
        String string;
        if (set == null) {
            set = new HashSet<String>();
        }
        if (set.contains(string = ParameterFormatter.identityToString(object))) {
            stringBuilder.append(RECURSION_PREFIX).append(string).append(RECURSION_SUFFIX);
        } else {
            set.add(string);
            Map map = (Map)object;
            stringBuilder.append('{');
            boolean bl2 = true;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(", ");
                }
                Object k2 = entry2.getKey();
                Object v2 = entry2.getValue();
                ParameterFormatter.recursiveDeepToString(k2, stringBuilder, new HashSet<String>(set));
                stringBuilder.append('=');
                ParameterFormatter.recursiveDeepToString(v2, stringBuilder, new HashSet<String>(set));
            }
            stringBuilder.append('}');
        }
    }

    private static void appendCollection(Object object, StringBuilder stringBuilder, Set<String> set) {
        String string;
        if (set == null) {
            set = new HashSet<String>();
        }
        if (set.contains(string = ParameterFormatter.identityToString(object))) {
            stringBuilder.append(RECURSION_PREFIX).append(string).append(RECURSION_SUFFIX);
        } else {
            set.add(string);
            Collection collection = (Collection)object;
            stringBuilder.append('[');
            boolean bl2 = true;
            for (Object e2 : collection) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(", ");
                }
                ParameterFormatter.recursiveDeepToString(e2, stringBuilder, new HashSet<String>(set));
            }
            stringBuilder.append(']');
        }
    }

    private static void tryObjectToString(Object object, StringBuilder stringBuilder) {
        try {
            stringBuilder.append(object.toString());
        }
        catch (Throwable throwable) {
            ParameterFormatter.handleErrorInObjectToString(object, stringBuilder, throwable);
        }
    }

    private static void handleErrorInObjectToString(Object object, StringBuilder stringBuilder, Throwable throwable) {
        stringBuilder.append(ERROR_PREFIX);
        stringBuilder.append(ParameterFormatter.identityToString(object));
        stringBuilder.append(ERROR_SEPARATOR);
        String string = throwable.getMessage();
        String string2 = throwable.getClass().getName();
        stringBuilder.append(string2);
        if (!string2.equals(string)) {
            stringBuilder.append(ERROR_MSG_SEPARATOR);
            stringBuilder.append(string);
        }
        stringBuilder.append(ERROR_SUFFIX);
    }

    static String identityToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName() + '@' + Integer.toHexString(System.identityHashCode(object));
    }
}

