/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.Serializable;
import org.apache.logging.log4j.message.DefaultFlowMessageFactory$SimpleEntryMessage;
import org.apache.logging.log4j.message.DefaultFlowMessageFactory$SimpleExitMessage;
import org.apache.logging.log4j.message.EntryMessage;
import org.apache.logging.log4j.message.ExitMessage;
import org.apache.logging.log4j.message.FlowMessageFactory;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.message.SimpleMessage;

public class DefaultFlowMessageFactory
implements Serializable,
FlowMessageFactory {
    private static final String EXIT_DEFAULT_PREFIX = "Exit";
    private static final String ENTRY_DEFAULT_PREFIX = "Enter";
    private static final long serialVersionUID = 8578655591131397576L;
    private final String entryText;
    private final String exitText;

    public DefaultFlowMessageFactory() {
        this(ENTRY_DEFAULT_PREFIX, EXIT_DEFAULT_PREFIX);
    }

    public DefaultFlowMessageFactory(String string, String string2) {
        this.entryText = string;
        this.exitText = string2;
    }

    public String getEntryText() {
        return this.entryText;
    }

    public String getExitText() {
        return this.exitText;
    }

    @Override
    public EntryMessage newEntryMessage(Message message) {
        return new DefaultFlowMessageFactory$SimpleEntryMessage(this.entryText, this.makeImmutable(message));
    }

    private Message makeImmutable(Message message) {
        if (!(message instanceof ReusableMessage)) {
            return message;
        }
        return new SimpleMessage(message.getFormattedMessage());
    }

    @Override
    public ExitMessage newExitMessage(EntryMessage entryMessage) {
        return new DefaultFlowMessageFactory$SimpleExitMessage(this.exitText, entryMessage);
    }

    @Override
    public ExitMessage newExitMessage(Object object, EntryMessage entryMessage) {
        return new DefaultFlowMessageFactory$SimpleExitMessage(this.exitText, object, entryMessage);
    }

    @Override
    public ExitMessage newExitMessage(Object object, Message message) {
        return new DefaultFlowMessageFactory$SimpleExitMessage(this.exitText, object, message);
    }
}

