/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.datetime;

import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat$FixedFormat;

public class FixedDateFormat {
    private final FixedDateFormat$FixedFormat fixedFormat;
    private final TimeZone timeZone;
    private final int length;
    private final FastDateFormat fastDateFormat;
    private final char timeSeparatorChar;
    private final char millisSeparatorChar;
    private final int timeSeparatorLength;
    private final int millisSeparatorLength;
    private volatile long midnightToday = 0L;
    private volatile long midnightTomorrow = 0L;
    private char[] cachedDate;
    private int dateLength;

    FixedDateFormat(FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat, TimeZone timeZone) {
        this.fixedFormat = Objects.requireNonNull(fixedDateFormat$FixedFormat);
        this.timeZone = Objects.requireNonNull(timeZone);
        this.timeSeparatorChar = FixedDateFormat$FixedFormat.access$000(fixedDateFormat$FixedFormat);
        this.timeSeparatorLength = FixedDateFormat$FixedFormat.access$100(fixedDateFormat$FixedFormat);
        this.millisSeparatorChar = FixedDateFormat$FixedFormat.access$200(fixedDateFormat$FixedFormat);
        this.millisSeparatorLength = FixedDateFormat$FixedFormat.access$300(fixedDateFormat$FixedFormat);
        this.length = fixedDateFormat$FixedFormat.getLength();
        this.fastDateFormat = fixedDateFormat$FixedFormat.getFastDateFormat(timeZone);
    }

    public static FixedDateFormat createIfSupported(String ... stringArray) {
        TimeZone timeZone;
        if (stringArray == null || stringArray.length == 0 || stringArray[0] == null) {
            return new FixedDateFormat(FixedDateFormat$FixedFormat.DEFAULT, TimeZone.getDefault());
        }
        if (stringArray.length > 1) {
            timeZone = stringArray[1] != null ? TimeZone.getTimeZone(stringArray[1]) : TimeZone.getDefault();
        } else {
            if (stringArray.length > 2) {
                return null;
            }
            timeZone = TimeZone.getDefault();
        }
        FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat = FixedDateFormat$FixedFormat.lookup(stringArray[0]);
        return fixedDateFormat$FixedFormat == null ? null : new FixedDateFormat(fixedDateFormat$FixedFormat, timeZone);
    }

    public static FixedDateFormat create(FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat) {
        return new FixedDateFormat(fixedDateFormat$FixedFormat, TimeZone.getDefault());
    }

    public static FixedDateFormat create(FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat, TimeZone timeZone) {
        return new FixedDateFormat(fixedDateFormat$FixedFormat, timeZone != null ? timeZone : TimeZone.getDefault());
    }

    public String getFormat() {
        return this.fixedFormat.getPattern();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public long millisSinceMidnight(long l2) {
        if (l2 >= this.midnightTomorrow || l2 < this.midnightToday) {
            this.updateMidnightMillis(l2);
        }
        return l2 - this.midnightToday;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMidnightMillis(long l2) {
        if (l2 >= this.midnightTomorrow || l2 < this.midnightToday) {
            FixedDateFormat fixedDateFormat = this;
            synchronized (fixedDateFormat) {
                this.updateCachedDate(l2);
                this.midnightToday = this.calcMidnightMillis(l2, 0);
                this.midnightTomorrow = this.calcMidnightMillis(l2, 1);
            }
        }
    }

    private long calcMidnightMillis(long l2, int n2) {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTimeInMillis(l2);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, n2);
        return calendar.getTimeInMillis();
    }

    private void updateCachedDate(long l2) {
        if (this.fastDateFormat != null) {
            StringBuilder stringBuilder = this.fastDateFormat.format(l2, new StringBuilder());
            this.cachedDate = stringBuilder.toString().toCharArray();
            this.dateLength = stringBuilder.length();
        }
    }

    public String format(long l2) {
        char[] cArray = new char[this.length << 1];
        int n2 = this.format(l2, cArray, 0);
        return new String(cArray, 0, n2);
    }

    public int format(long l2, char[] cArray, int n2) {
        int n3 = (int)this.millisSinceMidnight(l2);
        this.writeDate(cArray, n2);
        return this.writeTime(n3, cArray, n2 + this.dateLength) - n2;
    }

    private void writeDate(char[] cArray, int n2) {
        if (this.cachedDate != null) {
            System.arraycopy(this.cachedDate, 0, cArray, n2, this.dateLength);
        }
    }

    private int writeTime(int n2, char[] cArray, int n3) {
        int n4 = n2 / 3600000;
        int n5 = (n2 -= 3600000 * n4) / 60000;
        int n6 = (n2 -= 60000 * n5) / 1000;
        n2 -= 1000 * n6;
        int n7 = n4 / 10;
        cArray[n3++] = (char)(n7 + 48);
        cArray[n3++] = (char)(n4 - 10 * n7 + 48);
        cArray[n3] = this.timeSeparatorChar;
        n3 += this.timeSeparatorLength;
        n7 = n5 / 10;
        cArray[n3++] = (char)(n7 + 48);
        cArray[n3++] = (char)(n5 - 10 * n7 + 48);
        cArray[n3] = this.timeSeparatorChar;
        n3 += this.timeSeparatorLength;
        n7 = n6 / 10;
        cArray[n3++] = (char)(n7 + 48);
        cArray[n3++] = (char)(n6 - 10 * n7 + 48);
        cArray[n3] = this.millisSeparatorChar;
        n3 += this.millisSeparatorLength;
        n7 = n2 / 100;
        cArray[n3++] = (char)(n7 + 48);
        n2 -= 100 * n7;
        n7 = n2 / 10;
        cArray[n3++] = (char)(n7 + 48);
        cArray[n3++] = (char)((n2 -= 10 * n7) + 48);
        return n3;
    }
}

