/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util.datetime;

import java.util.Objects;
import java.util.TimeZone;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;

public enum FixedDateFormat$FixedFormat {
    ABSOLUTE("HH:mm:ss,SSS", null, 0, ':', 1, ',', 1),
    ABSOLUTE_PERIOD("HH:mm:ss.SSS", null, 0, ':', 1, '.', 1),
    COMPACT("yyyyMMddHHmmssSSS", "yyyyMMdd", 0, ' ', 0, ' ', 0),
    DATE("dd MMM yyyy HH:mm:ss,SSS", "dd MMM yyyy ", 0, ':', 1, ',', 1),
    DATE_PERIOD("dd MMM yyyy HH:mm:ss.SSS", "dd MMM yyyy ", 0, ':', 1, '.', 1),
    DEFAULT("yyyy-MM-dd HH:mm:ss,SSS", "yyyy-MM-dd ", 0, ':', 1, ',', 1),
    DEFAULT_PERIOD("yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd ", 0, ':', 1, '.', 1),
    ISO8601_BASIC("yyyyMMdd'T'HHmmss,SSS", "yyyyMMdd'T'", 2, ' ', 0, ',', 1),
    ISO8601_BASIC_PERIOD("yyyyMMdd'T'HHmmss.SSS", "yyyyMMdd'T'", 2, ' ', 0, '.', 1),
    ISO8601("yyyy-MM-dd'T'HH:mm:ss,SSS", "yyyy-MM-dd'T'", 2, ':', 1, ',', 1),
    ISO8601_PERIOD("yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'", 2, ':', 1, '.', 1);

    private final String pattern;
    private final String datePattern;
    private final int escapeCount;
    private final char timeSeparatorChar;
    private final int timeSeparatorLength;
    private final char millisSeparatorChar;
    private final int millisSeparatorLength;

    private FixedDateFormat$FixedFormat(String string2, String string3, int n3, char c2, int n4, char c3, int n5) {
        this.timeSeparatorChar = c2;
        this.timeSeparatorLength = n4;
        this.millisSeparatorChar = c3;
        this.millisSeparatorLength = n5;
        this.pattern = Objects.requireNonNull(string2);
        this.datePattern = string3;
        this.escapeCount = n3;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public static FixedDateFormat$FixedFormat lookup(String string) {
        for (FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat : FixedDateFormat$FixedFormat.values()) {
            if (!fixedDateFormat$FixedFormat.name().equals(string) && !fixedDateFormat$FixedFormat.getPattern().equals(string)) continue;
            return fixedDateFormat$FixedFormat;
        }
        return null;
    }

    public int getLength() {
        return this.pattern.length() - this.escapeCount;
    }

    public int getDatePatternLength() {
        return this.getDatePattern() == null ? 0 : this.getDatePattern().length() - this.escapeCount;
    }

    public FastDateFormat getFastDateFormat() {
        return this.getFastDateFormat(null);
    }

    public FastDateFormat getFastDateFormat(TimeZone timeZone) {
        return this.getDatePattern() == null ? null : FastDateFormat.getInstance(this.getDatePattern(), timeZone);
    }

    static /* synthetic */ char access$000(FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat) {
        return fixedDateFormat$FixedFormat.timeSeparatorChar;
    }

    static /* synthetic */ int access$100(FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat) {
        return fixedDateFormat$FixedFormat.timeSeparatorLength;
    }

    static /* synthetic */ char access$200(FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat) {
        return fixedDateFormat$FixedFormat.millisSeparatorChar;
    }

    static /* synthetic */ int access$300(FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat) {
        return fixedDateFormat$FixedFormat.millisSeparatorLength;
    }
}

