/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.AbstractLifeCycle;
import org.apache.logging.log4j.core.config.ConfigurationScheduler;
import org.apache.logging.log4j.core.util.FileWatcher;
import org.apache.logging.log4j.core.util.WatchManager$FileMonitor;
import org.apache.logging.log4j.core.util.WatchManager$WatchRunnable;
import org.apache.logging.log4j.status.StatusLogger;

public class WatchManager
extends AbstractLifeCycle {
    private static Logger logger = StatusLogger.getLogger();
    private final ConcurrentMap<File, WatchManager$FileMonitor> watchers = new ConcurrentHashMap<File, WatchManager$FileMonitor>();
    private int intervalSeconds = 0;
    private ScheduledFuture<?> future;
    private final ConfigurationScheduler scheduler;

    public WatchManager(ConfigurationScheduler configurationScheduler) {
        this.scheduler = configurationScheduler;
    }

    public void setIntervalSeconds(int n2) {
        if (!this.isStarted()) {
            if (this.intervalSeconds > 0 && n2 == 0) {
                this.scheduler.decrementScheduledItems();
            } else if (this.intervalSeconds == 0 && n2 > 0) {
                this.scheduler.incrementScheduledItems();
            }
            this.intervalSeconds = n2;
        }
    }

    public int getIntervalSeconds() {
        return this.intervalSeconds;
    }

    @Override
    public void start() {
        super.start();
        if (this.intervalSeconds > 0) {
            this.future = this.scheduler.scheduleWithFixedDelay(new WatchManager$WatchRunnable(this, null), this.intervalSeconds, this.intervalSeconds, TimeUnit.SECONDS);
        }
    }

    @Override
    public boolean stop(long l2, TimeUnit timeUnit) {
        this.setStopping();
        boolean bl2 = this.stop(this.future);
        this.setStopped();
        return bl2;
    }

    public void watchFile(File file, FileWatcher fileWatcher) {
        this.watchers.put(file, new WatchManager$FileMonitor(this, file.lastModified(), fileWatcher));
    }

    public Map<File, FileWatcher> getWatchers() {
        HashMap<File, FileWatcher> hashMap = new HashMap<File, FileWatcher>();
        for (Map.Entry entry : this.watchers.entrySet()) {
            hashMap.put((File)entry.getKey(), WatchManager$FileMonitor.access$100((WatchManager$FileMonitor)entry.getValue()));
        }
        return hashMap;
    }

    static /* synthetic */ ConcurrentMap access$200(WatchManager watchManager) {
        return watchManager.watchers;
    }

    static /* synthetic */ Logger access$400() {
        return logger;
    }
}

