/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.util;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class StringEncoder {
    private StringEncoder() {
    }

    public static byte[] toBytes(String string, Charset charset) {
        if (string != null) {
            if (StandardCharsets.ISO_8859_1.equals(charset)) {
                return StringEncoder.encodeSingleByteChars(string);
            }
            Charset charset2 = charset != null ? charset : Charset.defaultCharset();
            try {
                return string.getBytes(charset2.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return string.getBytes(charset2);
            }
        }
        return null;
    }

    public static byte[] encodeSingleByteChars(CharSequence charSequence) {
        int n2 = charSequence.length();
        byte[] byArray = new byte[n2];
        StringEncoder.encodeString(charSequence, 0, n2, byArray);
        return byArray;
    }

    public static int encodeIsoChars(CharSequence charSequence, int n2, byte[] byArray, int n3, int n4) {
        char c2;
        int n5;
        for (n5 = 0; n5 < n4 && (c2 = charSequence.charAt(n2++)) <= '\u00ff'; ++n5) {
            byArray[n3++] = (byte)c2;
        }
        return n5;
    }

    public static int encodeString(CharSequence charSequence, int n2, int n3, byte[] byArray) {
        int n4 = 0;
        int n5 = Math.min(n3, byArray.length);
        int n6 = n2 + n5;
        while (n2 < n6) {
            char c2;
            int n7 = StringEncoder.encodeIsoChars(charSequence, n2, byArray, n4, n5);
            n2 += n7;
            n4 += n7;
            if (n7 == n5) continue;
            if (Character.isHighSurrogate(c2 = charSequence.charAt(n2++)) && n2 < n6 && Character.isLowSurrogate(charSequence.charAt(n2))) {
                if (n3 > byArray.length) {
                    ++n6;
                    --n3;
                }
                ++n2;
            }
            byArray[n4++] = 63;
            n5 = Math.min(n6 - n2, byArray.length - n4);
        }
        return n4;
    }
}

