/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.script;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptFile;
import org.apache.logging.log4j.core.script.ScriptManager$1;
import org.apache.logging.log4j.core.script.ScriptManager$MainScriptRunner;
import org.apache.logging.log4j.core.script.ScriptManager$ScriptRunner;
import org.apache.logging.log4j.core.script.ScriptManager$ThreadLocalScriptRunner;
import org.apache.logging.log4j.core.util.FileWatcher;
import org.apache.logging.log4j.core.util.WatchManager;
import org.apache.logging.log4j.status.StatusLogger;

public class ScriptManager
implements Serializable,
FileWatcher {
    private static final long serialVersionUID = -2534169384971965196L;
    private static final String KEY_THREADING = "THREADING";
    private static final Logger logger = StatusLogger.getLogger();
    private final Configuration configuration;
    private final ScriptEngineManager manager = new ScriptEngineManager();
    private final ConcurrentMap<String, ScriptManager$ScriptRunner> scriptRunners = new ConcurrentHashMap<String, ScriptManager$ScriptRunner>();
    private final String languages;
    private final WatchManager watchManager;

    public ScriptManager(Configuration configuration, WatchManager watchManager) {
        this.configuration = configuration;
        this.watchManager = watchManager;
        List<ScriptEngineFactory> list = this.manager.getEngineFactories();
        if (logger.isDebugEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            logger.debug("Installed script engines");
            for (ScriptEngineFactory scriptEngineFactory : list) {
                String string = (String)scriptEngineFactory.getParameter(KEY_THREADING);
                if (string == null) {
                    string = "Not Thread Safe";
                }
                StringBuilder stringBuilder2 = new StringBuilder();
                for (String string2 : scriptEngineFactory.getNames()) {
                    if (stringBuilder2.length() > 0) {
                        stringBuilder2.append(", ");
                    }
                    stringBuilder2.append(string2);
                }
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((CharSequence)stringBuilder2);
                boolean bl2 = scriptEngineFactory.getScriptEngine() instanceof Compilable;
                logger.debug(scriptEngineFactory.getEngineName() + " Version: " + scriptEngineFactory.getEngineVersion() + ", Language: " + scriptEngineFactory.getLanguageName() + ", Threading: " + string + ", Compile: " + bl2 + ", Names: {" + stringBuilder2.toString() + "}");
            }
            this.languages = stringBuilder.toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (ScriptEngineFactory scriptEngineFactory : list) {
                for (String string : scriptEngineFactory.getNames()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(string);
                }
            }
            this.languages = stringBuilder.toString();
        }
    }

    public void addScript(AbstractScript abstractScript) {
        ScriptEngine scriptEngine = this.manager.getEngineByName(abstractScript.getLanguage());
        if (scriptEngine == null) {
            logger.error("No ScriptEngine found for language " + abstractScript.getLanguage() + ". Available languages are: " + this.languages);
            return;
        }
        if (scriptEngine.getFactory().getParameter(KEY_THREADING) == null) {
            this.scriptRunners.put(abstractScript.getName(), new ScriptManager$ThreadLocalScriptRunner(this, abstractScript));
        } else {
            this.scriptRunners.put(abstractScript.getName(), new ScriptManager$MainScriptRunner(this, scriptEngine, abstractScript));
        }
        if (abstractScript instanceof ScriptFile) {
            ScriptFile scriptFile = (ScriptFile)abstractScript;
            Path path = scriptFile.getPath();
            if (scriptFile.isWatched() && path != null) {
                this.watchManager.watchFile(path.toFile(), this);
            }
        }
    }

    public Bindings createBindings(AbstractScript abstractScript) {
        return this.getScriptRunner(abstractScript).createBindings();
    }

    public AbstractScript getScript(String string) {
        ScriptManager$ScriptRunner scriptManager$ScriptRunner = (ScriptManager$ScriptRunner)this.scriptRunners.get(string);
        return scriptManager$ScriptRunner != null ? scriptManager$ScriptRunner.getScript() : null;
    }

    @Override
    public void fileModified(File file) {
        ScriptManager$ScriptRunner scriptManager$ScriptRunner = (ScriptManager$ScriptRunner)this.scriptRunners.get(file.toString());
        if (scriptManager$ScriptRunner == null) {
            logger.info("{} is not a running script");
            return;
        }
        ScriptEngine scriptEngine = scriptManager$ScriptRunner.getScriptEngine();
        AbstractScript abstractScript = scriptManager$ScriptRunner.getScript();
        if (scriptEngine.getFactory().getParameter(KEY_THREADING) == null) {
            this.scriptRunners.put(abstractScript.getName(), new ScriptManager$ThreadLocalScriptRunner(this, abstractScript));
        } else {
            this.scriptRunners.put(abstractScript.getName(), new ScriptManager$MainScriptRunner(this, scriptEngine, abstractScript));
        }
    }

    public Object execute(String string, Bindings bindings) {
        ScriptManager$ScriptRunner scriptManager$ScriptRunner = (ScriptManager$ScriptRunner)this.scriptRunners.get(string);
        if (scriptManager$ScriptRunner == null) {
            logger.warn("No script named {} could be found");
            return null;
        }
        return AccessController.doPrivileged(new ScriptManager$1(this, scriptManager$ScriptRunner, bindings));
    }

    private ScriptManager$ScriptRunner getScriptRunner(AbstractScript abstractScript) {
        return (ScriptManager$ScriptRunner)this.scriptRunners.get(abstractScript.getName());
    }

    static /* synthetic */ Configuration access$000(ScriptManager scriptManager) {
        return scriptManager.configuration;
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }

    static /* synthetic */ ScriptEngineManager access$400(ScriptManager scriptManager) {
        return scriptManager.manager;
    }
}

