/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.AnsiConverter;
import org.apache.logging.log4j.core.pattern.AnsiEscape;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.core.util.Patterns;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="style", category="Converter")
@ConverterKeys(value={"style"})
@PerformanceSensitive(value={"allocation"})
public final class StyleConverter
extends LogEventPatternConverter
implements AnsiConverter {
    private final List<PatternFormatter> patternFormatters;
    private final boolean noAnsi;
    private final String style;
    private final String defaultStyle;

    private StyleConverter(List<PatternFormatter> list, String string, boolean bl2) {
        super("style", "style");
        this.patternFormatters = list;
        this.style = string;
        this.defaultStyle = AnsiEscape.getDefaultStyle();
        this.noAnsi = bl2;
    }

    public static StyleConverter newInstance(Configuration configuration, String[] stringArray) {
        if (stringArray.length < 1) {
            LOGGER.error("Incorrect number of options on style. Expected at least 1, received " + stringArray.length);
            return null;
        }
        if (stringArray[0] == null) {
            LOGGER.error("No pattern supplied on style");
            return null;
        }
        if (stringArray[1] == null) {
            LOGGER.error("No style attributes provided");
            return null;
        }
        PatternParser patternParser = PatternLayout.createPatternParser(configuration);
        List<PatternFormatter> list = patternParser.parse(stringArray[0]);
        String string = AnsiEscape.createSequence(stringArray[1].split(Patterns.COMMA_SEPARATOR));
        boolean bl2 = Arrays.toString(stringArray).contains("disableAnsi=true");
        boolean bl3 = Arrays.toString(stringArray).contains("noConsoleNoAnsi=true");
        boolean bl4 = bl2 || bl3 && System.console() == null;
        return new StyleConverter(list, string, bl4);
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        int n2 = 0;
        int n3 = 0;
        if (!this.noAnsi) {
            n2 = stringBuilder.length();
            stringBuilder.append(this.style);
            n3 = stringBuilder.length();
        }
        int n4 = this.patternFormatters.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            this.patternFormatters.get(i2).format(logEvent, stringBuilder);
        }
        if (!this.noAnsi) {
            if (stringBuilder.length() == n3) {
                stringBuilder.setLength(n2);
            } else {
                stringBuilder.append(this.defaultStyle);
            }
        }
    }

    @Override
    public boolean handlesThrowable() {
        for (PatternFormatter patternFormatter : this.patternFormatters) {
            if (!patternFormatter.handlesThrowable()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("[style=");
        stringBuilder.append(this.style);
        stringBuilder.append(", defaultStyle=");
        stringBuilder.append(this.defaultStyle);
        stringBuilder.append(", patternFormatters=");
        stringBuilder.append(this.patternFormatters);
        stringBuilder.append(", noAnsi=");
        stringBuilder.append(this.noAnsi);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

