/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.MdcPatternConverter$1;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.util.PerformanceSensitive;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringBuilders;
import org.apache.logging.log4j.util.TriConsumer;

@Plugin(name="MdcPatternConverter", category="Converter")
@ConverterKeys(value={"X", "mdc", "MDC"})
@PerformanceSensitive(value={"allocation"})
public final class MdcPatternConverter
extends LogEventPatternConverter {
    private static final ThreadLocal<StringBuilder> threadLocal = new ThreadLocal();
    private static final int DEFAULT_STRING_BUILDER_SIZE = 64;
    private static final int MAX_STRING_BUILDER_SIZE = Constants.MAX_REUSABLE_MESSAGE_SIZE;
    private final String key;
    private final String[] keys;
    private final boolean full;
    private static final TriConsumer<String, Object, StringBuilder> WRITE_KEY_VALUES_INTO = new MdcPatternConverter$1();

    private MdcPatternConverter(String[] stringArray) {
        super(stringArray != null && stringArray.length > 0 ? "MDC{" + stringArray[0] + '}' : "MDC", "mdc");
        if (stringArray != null && stringArray.length > 0) {
            this.full = false;
            if (stringArray[0].indexOf(44) > 0) {
                this.keys = stringArray[0].split(",");
                for (int i2 = 0; i2 < this.keys.length; ++i2) {
                    this.keys[i2] = this.keys[i2].trim();
                }
                this.key = null;
            } else {
                this.keys = null;
                this.key = stringArray[0];
            }
        } else {
            this.full = true;
            this.key = null;
            this.keys = null;
        }
    }

    public static MdcPatternConverter newInstance(String[] stringArray) {
        return new MdcPatternConverter(stringArray);
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        Object v2;
        ReadOnlyStringMap readOnlyStringMap = logEvent.getContextData();
        if (this.full) {
            if (readOnlyStringMap == null || readOnlyStringMap.size() == 0) {
                stringBuilder.append("{}");
                return;
            }
            MdcPatternConverter.appendFully(readOnlyStringMap, stringBuilder);
        } else if (this.keys != null) {
            if (readOnlyStringMap == null || readOnlyStringMap.size() == 0) {
                stringBuilder.append("{}");
                return;
            }
            MdcPatternConverter.appendSelectedKeys(this.keys, readOnlyStringMap, stringBuilder);
        } else if (readOnlyStringMap != null && (v2 = readOnlyStringMap.getValue(this.key)) != null) {
            StringBuilders.appendValue(stringBuilder, v2);
        }
    }

    private static void appendFully(ReadOnlyStringMap readOnlyStringMap, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = MdcPatternConverter.getStringBuilder();
        stringBuilder2.append("{");
        readOnlyStringMap.forEach(WRITE_KEY_VALUES_INTO, stringBuilder2);
        stringBuilder2.append('}');
        stringBuilder.append((CharSequence)stringBuilder2);
        MdcPatternConverter.trimToMaxSize(stringBuilder2);
    }

    private static void appendSelectedKeys(String[] stringArray, ReadOnlyStringMap readOnlyStringMap, StringBuilder stringBuilder) {
        StringBuilder stringBuilder2 = MdcPatternConverter.getStringBuilder();
        stringBuilder2.append("{");
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            Object v2 = readOnlyStringMap.getValue(string);
            if (v2 == null) continue;
            if (stringBuilder2.length() > 1) {
                stringBuilder2.append(", ");
            }
            stringBuilder2.append(string).append('=');
            StringBuilders.appendValue(stringBuilder2, v2);
        }
        stringBuilder2.append('}');
        stringBuilder.append((CharSequence)stringBuilder2);
        MdcPatternConverter.trimToMaxSize(stringBuilder2);
    }

    private static StringBuilder getStringBuilder() {
        StringBuilder stringBuilder = threadLocal.get();
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(64);
            threadLocal.set(stringBuilder);
        }
        stringBuilder.setLength(0);
        return stringBuilder;
    }

    private static void trimToMaxSize(StringBuilder stringBuilder) {
        if (stringBuilder.length() > MAX_STRING_BUILDER_SIZE) {
            stringBuilder.setLength(MAX_STRING_BUILDER_SIZE);
            stringBuilder.trimToSize();
        }
    }
}

