/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive(value={"allocation"})
public final class FormattingInfo {
    private static final char[] SPACES = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private static final FormattingInfo DEFAULT = new FormattingInfo(false, 0, Integer.MAX_VALUE, true);
    private final int minLength;
    private final int maxLength;
    private final boolean leftAlign;
    private final boolean leftTruncate;

    public FormattingInfo(boolean bl2, int n2, int n3, boolean bl3) {
        this.leftAlign = bl2;
        this.minLength = n2;
        this.maxLength = n3;
        this.leftTruncate = bl3;
    }

    public static FormattingInfo getDefault() {
        return DEFAULT;
    }

    public boolean isLeftAligned() {
        return this.leftAlign;
    }

    public boolean isLeftTruncate() {
        return this.leftTruncate;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void format(int n2, StringBuilder stringBuilder) {
        int n3 = stringBuilder.length() - n2;
        if (n3 > this.maxLength) {
            if (this.leftTruncate) {
                stringBuilder.delete(n2, stringBuilder.length() - this.maxLength);
            } else {
                stringBuilder.delete(n2 + this.maxLength, n2 + stringBuilder.length());
            }
        } else if (n3 < this.minLength) {
            if (this.leftAlign) {
                int n4 = stringBuilder.length();
                stringBuilder.setLength(n2 + this.minLength);
                for (int i2 = n4; i2 < stringBuilder.length(); ++i2) {
                    stringBuilder.setCharAt(i2, ' ');
                }
            } else {
                int n5;
                for (n5 = this.minLength - n3; n5 > SPACES.length; n5 -= SPACES.length) {
                    stringBuilder.insert(n2, SPACES);
                }
                stringBuilder.insert(n2, SPACES, 0, n5);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append("[leftAlign=");
        stringBuilder.append(this.leftAlign);
        stringBuilder.append(", maxLength=");
        stringBuilder.append(this.maxLength);
        stringBuilder.append(", minLength=");
        stringBuilder.append(this.minLength);
        stringBuilder.append(", leftTruncate=");
        stringBuilder.append(this.leftTruncate);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

