/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="encode", category="Converter")
@ConverterKeys(value={"enc", "encode"})
@PerformanceSensitive(value={"allocation"})
public final class EncodingPatternConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;

    private EncodingPatternConverter(List<PatternFormatter> list) {
        super("encode", "encode");
        this.formatters = list;
    }

    public static EncodingPatternConverter newInstance(Configuration configuration, String[] stringArray) {
        if (stringArray.length != 1) {
            LOGGER.error("Incorrect number of options on escape. Expected 1, received " + stringArray.length);
            return null;
        }
        if (stringArray[0] == null) {
            LOGGER.error("No pattern supplied on escape");
            return null;
        }
        PatternParser patternParser = PatternLayout.createPatternParser(configuration);
        List<PatternFormatter> list = patternParser.parse(stringArray[0]);
        return new EncodingPatternConverter(list);
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        int n2;
        int n3 = stringBuilder.length();
        for (n2 = 0; n2 < this.formatters.size(); ++n2) {
            this.formatters.get(n2).format(logEvent, stringBuilder);
        }
        block11: for (n2 = stringBuilder.length() - 1; n2 >= n3; --n2) {
            char c2 = stringBuilder.charAt(n2);
            switch (c2) {
                case '\r': {
                    stringBuilder.setCharAt(n2, '\\');
                    stringBuilder.insert(n2 + 1, 'r');
                    continue block11;
                }
                case '\n': {
                    stringBuilder.setCharAt(n2, '\\');
                    stringBuilder.insert(n2 + 1, 'n');
                    continue block11;
                }
                case '&': {
                    stringBuilder.setCharAt(n2, '&');
                    stringBuilder.insert(n2 + 1, "amp;");
                    continue block11;
                }
                case '<': {
                    stringBuilder.setCharAt(n2, '&');
                    stringBuilder.insert(n2 + 1, "lt;");
                    continue block11;
                }
                case '>': {
                    stringBuilder.setCharAt(n2, '&');
                    stringBuilder.insert(n2 + 1, "gt;");
                    continue block11;
                }
                case '\"': {
                    stringBuilder.setCharAt(n2, '&');
                    stringBuilder.insert(n2 + 1, "quot;");
                    continue block11;
                }
                case '\'': {
                    stringBuilder.setCharAt(n2, '&');
                    stringBuilder.insert(n2 + 1, "apos;");
                    continue block11;
                }
                case '/': {
                    stringBuilder.setCharAt(n2, '&');
                    stringBuilder.insert(n2 + 1, "#x2F;");
                }
            }
        }
    }
}

