/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ArrayPatternConverter;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.DatePatternConverter$CachedTime;
import org.apache.logging.log4j.core.pattern.DatePatternConverter$FixedFormatter;
import org.apache.logging.log4j.core.pattern.DatePatternConverter$Formatter;
import org.apache.logging.log4j.core.pattern.DatePatternConverter$PatternFormatter;
import org.apache.logging.log4j.core.pattern.DatePatternConverter$UnixFormatter;
import org.apache.logging.log4j.core.pattern.DatePatternConverter$UnixMillisFormatter;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.datetime.FastDateFormat;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat;
import org.apache.logging.log4j.core.util.datetime.FixedDateFormat$FixedFormat;
import org.apache.logging.log4j.util.PerformanceSensitive;

@Plugin(name="DatePatternConverter", category="Converter")
@ConverterKeys(value={"d", "date"})
@PerformanceSensitive(value={"allocation"})
public final class DatePatternConverter
extends LogEventPatternConverter
implements ArrayPatternConverter {
    private static final String UNIX_FORMAT = "UNIX";
    private static final String UNIX_MILLIS_FORMAT = "UNIX_MILLIS";
    private final String[] options;
    private final ThreadLocal<DatePatternConverter$Formatter> threadLocalFormatter = new ThreadLocal();
    private final AtomicReference<DatePatternConverter$CachedTime> cachedTime;
    private final DatePatternConverter$Formatter formatter;

    private DatePatternConverter(String[] stringArray) {
        super("Date", "date");
        this.options = stringArray == null ? null : Arrays.copyOf(stringArray, stringArray.length);
        this.formatter = this.createFormatter(stringArray);
        this.cachedTime = new AtomicReference<DatePatternConverter$CachedTime>(new DatePatternConverter$CachedTime(this, System.currentTimeMillis()));
    }

    private DatePatternConverter$Formatter createFormatter(String[] stringArray) {
        FixedDateFormat fixedDateFormat = FixedDateFormat.createIfSupported(stringArray);
        if (fixedDateFormat != null) {
            return DatePatternConverter.createFixedFormatter(fixedDateFormat);
        }
        return DatePatternConverter.createNonFixedFormatter(stringArray);
    }

    public static DatePatternConverter newInstance(String[] stringArray) {
        return new DatePatternConverter(stringArray);
    }

    private static DatePatternConverter$Formatter createFixedFormatter(FixedDateFormat fixedDateFormat) {
        return new DatePatternConverter$FixedFormatter(fixedDateFormat);
    }

    private static DatePatternConverter$Formatter createNonFixedFormatter(String[] stringArray) {
        Objects.requireNonNull(stringArray);
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("options array must have at least one element");
        }
        Objects.requireNonNull(stringArray[0]);
        String string = stringArray[0];
        if (UNIX_FORMAT.equals(string)) {
            return new DatePatternConverter$UnixFormatter(null);
        }
        if (UNIX_MILLIS_FORMAT.equals(string)) {
            return new DatePatternConverter$UnixMillisFormatter(null);
        }
        FixedDateFormat$FixedFormat fixedDateFormat$FixedFormat = FixedDateFormat$FixedFormat.lookup(string);
        String string2 = fixedDateFormat$FixedFormat == null ? string : fixedDateFormat$FixedFormat.getPattern();
        TimeZone timeZone = null;
        if (stringArray.length > 1 && stringArray[1] != null) {
            timeZone = TimeZone.getTimeZone(stringArray[1]);
        }
        try {
            FastDateFormat fastDateFormat = FastDateFormat.getInstance(string2, timeZone);
            return new DatePatternConverter$PatternFormatter(fastDateFormat);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.warn("Could not instantiate FastDateFormat with pattern " + string2, (Throwable)illegalArgumentException);
            return DatePatternConverter.createFixedFormatter(FixedDateFormat.create(FixedDateFormat$FixedFormat.DEFAULT, timeZone));
        }
    }

    public void format(Date date, StringBuilder stringBuilder) {
        this.format(date.getTime(), stringBuilder);
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        this.format(logEvent.getTimeMillis(), stringBuilder);
    }

    public void format(long l2, StringBuilder stringBuilder) {
        if (Constants.ENABLE_THREADLOCALS) {
            this.formatWithoutAllocation(l2, stringBuilder);
        } else {
            this.formatWithoutThreadLocals(l2, stringBuilder);
        }
    }

    private void formatWithoutAllocation(long l2, StringBuilder stringBuilder) {
        this.getThreadLocalFormatter().formatToBuffer(l2, stringBuilder);
    }

    private DatePatternConverter$Formatter getThreadLocalFormatter() {
        DatePatternConverter$Formatter datePatternConverter$Formatter = this.threadLocalFormatter.get();
        if (datePatternConverter$Formatter == null) {
            datePatternConverter$Formatter = this.createFormatter(this.options);
            this.threadLocalFormatter.set(datePatternConverter$Formatter);
        }
        return datePatternConverter$Formatter;
    }

    private void formatWithoutThreadLocals(long l2, StringBuilder stringBuilder) {
        DatePatternConverter$CachedTime datePatternConverter$CachedTime = this.cachedTime.get();
        if (l2 != datePatternConverter$CachedTime.timestampMillis) {
            DatePatternConverter$CachedTime datePatternConverter$CachedTime2 = new DatePatternConverter$CachedTime(this, l2);
            datePatternConverter$CachedTime = this.cachedTime.compareAndSet(datePatternConverter$CachedTime, datePatternConverter$CachedTime2) ? datePatternConverter$CachedTime2 : this.cachedTime.get();
        }
        stringBuilder.append(datePatternConverter$CachedTime.formatted);
    }

    @Override
    public void format(Object object, StringBuilder stringBuilder) {
        if (object instanceof Date) {
            this.format((Date)object, stringBuilder);
        }
        super.format(object, stringBuilder);
    }

    @Override
    public void format(StringBuilder stringBuilder, Object ... objectArray) {
        for (Object object : objectArray) {
            if (!(object instanceof Date)) continue;
            this.format(object, stringBuilder);
            break;
        }
    }

    public String getPattern() {
        return this.formatter.toPattern();
    }

    static /* synthetic */ DatePatternConverter$Formatter access$100(DatePatternConverter datePatternConverter) {
        return datePatternConverter.formatter;
    }
}

