/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.pattern.AnsiEscape;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.util.PerformanceSensitive;

public abstract class AbstractStyleNameConverter
extends LogEventPatternConverter {
    private final List<PatternFormatter> formatters;
    private final String style;

    protected AbstractStyleNameConverter(String string, List<PatternFormatter> list, String string2) {
        super(string, "style");
        this.formatters = list;
        this.style = string2;
    }

    protected static <T extends AbstractStyleNameConverter> T newInstance(Class<T> clazz, String string, Configuration configuration, String[] stringArray) {
        List<PatternFormatter> list = AbstractStyleNameConverter.toPatternFormatterList(configuration, stringArray);
        if (list == null) {
            return null;
        }
        try {
            Constructor<T> constructor = clazz.getConstructor(List.class, String.class);
            return (T)((AbstractStyleNameConverter)constructor.newInstance(list, AnsiEscape.createSequence(string)));
        }
        catch (SecurityException securityException) {
            LOGGER.error(securityException.toString(), (Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.error(noSuchMethodException.toString(), (Throwable)noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.error(illegalArgumentException.toString(), (Throwable)illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            LOGGER.error(instantiationException.toString(), (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.error(illegalAccessException.toString(), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOGGER.error(invocationTargetException.toString(), (Throwable)invocationTargetException);
        }
        return null;
    }

    private static List<PatternFormatter> toPatternFormatterList(Configuration configuration, String[] stringArray) {
        if (stringArray.length == 0 || stringArray[0] == null) {
            LOGGER.error("No pattern supplied on style for config=" + configuration);
            return null;
        }
        PatternParser patternParser = PatternLayout.createPatternParser(configuration);
        if (patternParser == null) {
            LOGGER.error("No PatternParser created for config=" + configuration + ", options=" + Arrays.toString(stringArray));
            return null;
        }
        return patternParser.parse(stringArray[0]);
    }

    @Override
    @PerformanceSensitive(value={"allocation"})
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        int n2 = stringBuilder.length();
        for (int i2 = 0; i2 < this.formatters.size(); ++i2) {
            PatternFormatter patternFormatter = this.formatters.get(i2);
            patternFormatter.format(logEvent, stringBuilder);
        }
        if (stringBuilder.length() > n2) {
            stringBuilder.insert(n2, this.style);
            stringBuilder.append(AnsiEscape.getDefaultStyle());
        }
    }
}

