/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import javax.net.ssl.TrustManagerFactory;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.net.ssl.AbstractKeyStoreConfiguration;

@Plugin(name="TrustStore", category="Core", printObject=true)
public class TrustStoreConfiguration
extends AbstractKeyStoreConfiguration {
    private final String trustManagerFactoryAlgorithm;

    public TrustStoreConfiguration(String string, String string2, String string3, String string4) {
        super(string, string2, string3);
        this.trustManagerFactoryAlgorithm = string4 == null ? TrustManagerFactory.getDefaultAlgorithm() : string4;
    }

    @PluginFactory
    public static TrustStoreConfiguration createKeyStoreConfiguration(@PluginAttribute(value="location") String string, @PluginAttribute(value="password", sensitive=true) String string2, @PluginAttribute(value="type") String string3, @PluginAttribute(value="trustManagerFactoryAlgorithm") String string4) {
        return new TrustStoreConfiguration(string, string2, string3, string4);
    }

    public TrustManagerFactory initTrustManagerFactory() {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.trustManagerFactoryAlgorithm);
        trustManagerFactory.init(this.getKeyStore());
        return trustManagerFactory;
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.trustManagerFactoryAlgorithm == null ? 0 : this.trustManagerFactoryAlgorithm.hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TrustStoreConfiguration trustStoreConfiguration = (TrustStoreConfiguration)object;
        return !(this.trustManagerFactoryAlgorithm == null ? trustStoreConfiguration.trustManagerFactoryAlgorithm != null : !this.trustManagerFactoryAlgorithm.equals(trustStoreConfiguration.trustManagerFactoryAlgorithm));
    }
}

