/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.ssl;

import javax.net.ssl.KeyManagerFactory;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.net.ssl.AbstractKeyStoreConfiguration;

@Plugin(name="KeyStore", category="Core", printObject=true)
public class KeyStoreConfiguration
extends AbstractKeyStoreConfiguration {
    private final String keyManagerFactoryAlgorithm;

    public KeyStoreConfiguration(String string, String string2, String string3, String string4) {
        super(string, string2, string3);
        this.keyManagerFactoryAlgorithm = string4 == null ? KeyManagerFactory.getDefaultAlgorithm() : string4;
    }

    @PluginFactory
    public static KeyStoreConfiguration createKeyStoreConfiguration(@PluginAttribute(value="location") String string, @PluginAttribute(value="password", sensitive=true) String string2, @PluginAttribute(value="type") String string3, @PluginAttribute(value="keyManagerFactoryAlgorithm") String string4) {
        return new KeyStoreConfiguration(string, string2, string3, string4);
    }

    public KeyManagerFactory initKeyManagerFactory() {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.keyManagerFactoryAlgorithm);
        keyManagerFactory.init(this.getKeyStore(), this.getPasswordAsCharArray());
        return keyManagerFactory;
    }

    @Override
    public int hashCode() {
        int n2 = 31;
        int n3 = super.hashCode();
        n3 = 31 * n3 + (this.keyManagerFactoryAlgorithm == null ? 0 : this.keyManagerFactoryAlgorithm.hashCode());
        return n3;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        KeyStoreConfiguration keyStoreConfiguration = (KeyStoreConfiguration)object;
        return !(this.keyManagerFactoryAlgorithm == null ? keyStoreConfiguration.keyManagerFactoryAlgorithm != null : !this.keyManagerFactoryAlgorithm.equals(keyStoreConfiguration.keyManagerFactoryAlgorithm));
    }
}

