/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.server;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OptionalDataException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.net.server.AbstractSocketServer;
import org.apache.logging.log4j.core.net.server.AbstractSocketServer$CommandLineArguments;
import org.apache.logging.log4j.core.net.server.AbstractSocketServer$ServerConfigurationFactory;
import org.apache.logging.log4j.core.net.server.JsonInputStreamLogEventBridge;
import org.apache.logging.log4j.core.net.server.LogEventBridge;
import org.apache.logging.log4j.core.net.server.ObjectInputStreamLogEventBridge;
import org.apache.logging.log4j.core.net.server.XmlInputStreamLogEventBridge;
import org.apache.logging.log4j.core.util.BasicCommandLineArguments;

public class UdpSocketServer<T extends InputStream>
extends AbstractSocketServer<T> {
    private final DatagramSocket datagramSocket;
    private final int maxBufferSize = 67584;

    public static UdpSocketServer<InputStream> createJsonSocketServer(int n2) {
        return new UdpSocketServer<InputStream>(n2, new JsonInputStreamLogEventBridge());
    }

    public static UdpSocketServer<ObjectInputStream> createSerializedSocketServer(int n2) {
        return new UdpSocketServer<ObjectInputStream>(n2, new ObjectInputStreamLogEventBridge());
    }

    public static UdpSocketServer<InputStream> createXmlSocketServer(int n2) {
        return new UdpSocketServer<InputStream>(n2, new XmlInputStreamLogEventBridge());
    }

    public static void main(String[] stringArray) {
        AbstractSocketServer$CommandLineArguments abstractSocketServer$CommandLineArguments = BasicCommandLineArguments.parseCommandLine(stringArray, UdpSocketServer.class, new AbstractSocketServer$CommandLineArguments());
        if (abstractSocketServer$CommandLineArguments.isHelp()) {
            return;
        }
        if (abstractSocketServer$CommandLineArguments.getConfigLocation() != null) {
            ConfigurationFactory.setConfigurationFactory(new AbstractSocketServer$ServerConfigurationFactory(abstractSocketServer$CommandLineArguments.getConfigLocation()));
        }
        UdpSocketServer<ObjectInputStream> udpSocketServer = UdpSocketServer.createSerializedSocketServer(abstractSocketServer$CommandLineArguments.getPort());
        Thread thread = udpSocketServer.startNewThread();
        if (abstractSocketServer$CommandLineArguments.isInteractive()) {
            udpSocketServer.awaitTermination(thread);
        }
    }

    public UdpSocketServer(int n2, LogEventBridge<T> logEventBridge) {
        super(n2, logEventBridge);
        this.datagramSocket = new DatagramSocket(n2);
    }

    @Override
    public void run() {
        while (this.isActive()) {
            if (this.datagramSocket.isClosed()) {
                return;
            }
            try {
                byte[] byArray = new byte[67584];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                this.datagramSocket.receive(datagramPacket);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(datagramPacket.getData(), datagramPacket.getOffset(), datagramPacket.getLength());
                this.logEventInput.logEvents(this.logEventInput.wrapStream(byteArrayInputStream), this);
            }
            catch (OptionalDataException optionalDataException) {
                if (this.datagramSocket.isClosed()) {
                    return;
                }
                this.logger.error("OptionalDataException eof=" + optionalDataException.eof + " length=" + optionalDataException.length, (Throwable)optionalDataException);
            }
            catch (EOFException eOFException) {
                if (this.datagramSocket.isClosed()) {
                    return;
                }
                this.logger.info("EOF encountered");
            }
            catch (IOException iOException) {
                if (this.datagramSocket.isClosed()) {
                    return;
                }
                this.logger.error("Exception encountered on accept. Ignoring. Stack Trace :", (Throwable)iOException);
            }
        }
    }

    @Override
    public void shutdown() {
        this.setActive(false);
        Thread.currentThread().interrupt();
        this.datagramSocket.close();
    }
}

