/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.net.server.AbstractSocketServer;
import org.apache.logging.log4j.core.net.server.AbstractSocketServer$ServerConfigurationFactory;
import org.apache.logging.log4j.core.net.server.JsonInputStreamLogEventBridge;
import org.apache.logging.log4j.core.net.server.LogEventBridge;
import org.apache.logging.log4j.core.net.server.ObjectInputStreamLogEventBridge;
import org.apache.logging.log4j.core.net.server.TcpSocketServer$CommandLineArguments;
import org.apache.logging.log4j.core.net.server.TcpSocketServer$SocketHandler;
import org.apache.logging.log4j.core.net.server.XmlInputStreamLogEventBridge;
import org.apache.logging.log4j.core.util.BasicCommandLineArguments;
import org.apache.logging.log4j.message.EntryMessage;

public class TcpSocketServer<T extends InputStream>
extends AbstractSocketServer<T> {
    private final ConcurrentMap<Long, TcpSocketServer$SocketHandler> handlers = new ConcurrentHashMap<Long, TcpSocketServer$SocketHandler>();
    private final ServerSocket serverSocket;

    public static TcpSocketServer<InputStream> createJsonSocketServer(int n2) {
        LOGGER.entry(new Object[]{"createJsonSocketServer", n2});
        TcpSocketServer<InputStream> tcpSocketServer = new TcpSocketServer<InputStream>(n2, new JsonInputStreamLogEventBridge());
        return LOGGER.exit(tcpSocketServer);
    }

    public static TcpSocketServer<ObjectInputStream> createSerializedSocketServer(int n2) {
        LOGGER.entry(n2);
        TcpSocketServer<ObjectInputStream> tcpSocketServer = new TcpSocketServer<ObjectInputStream>(n2, new ObjectInputStreamLogEventBridge());
        return LOGGER.exit(tcpSocketServer);
    }

    public static TcpSocketServer<ObjectInputStream> createSerializedSocketServer(int n2, int n3, InetAddress inetAddress) {
        LOGGER.entry(n2);
        TcpSocketServer<ObjectInputStream> tcpSocketServer = new TcpSocketServer<ObjectInputStream>(n2, n3, inetAddress, new ObjectInputStreamLogEventBridge());
        return LOGGER.exit(tcpSocketServer);
    }

    public static TcpSocketServer<InputStream> createXmlSocketServer(int n2) {
        LOGGER.entry(n2);
        TcpSocketServer<InputStream> tcpSocketServer = new TcpSocketServer<InputStream>(n2, new XmlInputStreamLogEventBridge());
        return LOGGER.exit(tcpSocketServer);
    }

    public static void main(String[] stringArray) {
        TcpSocketServer$CommandLineArguments tcpSocketServer$CommandLineArguments = BasicCommandLineArguments.parseCommandLine(stringArray, TcpSocketServer.class, new TcpSocketServer$CommandLineArguments());
        if (tcpSocketServer$CommandLineArguments.isHelp()) {
            return;
        }
        if (tcpSocketServer$CommandLineArguments.getConfigLocation() != null) {
            ConfigurationFactory.setConfigurationFactory(new AbstractSocketServer$ServerConfigurationFactory(tcpSocketServer$CommandLineArguments.getConfigLocation()));
        }
        TcpSocketServer<ObjectInputStream> tcpSocketServer = TcpSocketServer.createSerializedSocketServer(tcpSocketServer$CommandLineArguments.getPort(), tcpSocketServer$CommandLineArguments.getBacklog(), tcpSocketServer$CommandLineArguments.getLocalBindAddress());
        Thread thread = tcpSocketServer.startNewThread();
        if (tcpSocketServer$CommandLineArguments.isInteractive()) {
            tcpSocketServer.awaitTermination(thread);
        }
    }

    public TcpSocketServer(int n2, int n3, InetAddress inetAddress, LogEventBridge<T> logEventBridge) {
        this(n2, logEventBridge, new ServerSocket(n2, n3, inetAddress));
    }

    public TcpSocketServer(int n2, LogEventBridge<T> logEventBridge) {
        this(n2, logEventBridge, TcpSocketServer.extracted(n2));
    }

    private static ServerSocket extracted(int n2) {
        return new ServerSocket(n2);
    }

    public TcpSocketServer(int n2, LogEventBridge<T> logEventBridge, ServerSocket serverSocket) {
        super(n2, logEventBridge);
        this.serverSocket = serverSocket;
    }

    @Override
    public void run() {
        EntryMessage entryMessage = this.logger.traceEntry();
        while (this.isActive()) {
            if (this.serverSocket.isClosed()) {
                return;
            }
            try {
                this.logger.debug("Listening for a connection {}...", (Object)this.serverSocket);
                Socket socket = this.serverSocket.accept();
                this.logger.debug("Acepted connection on {}...", (Object)this.serverSocket);
                this.logger.debug("Socket accepted: {}", (Object)socket);
                socket.setSoLinger(true, 0);
                TcpSocketServer$SocketHandler object = new TcpSocketServer$SocketHandler(this, socket);
                this.handlers.put(object.getId(), object);
                object.start();
            }
            catch (IOException iOException) {
                if (this.serverSocket.isClosed()) {
                    this.logger.traceExit(entryMessage);
                    return;
                }
                this.logger.error("Exception encountered on accept. Ignoring. Stack trace :", (Throwable)iOException);
            }
        }
        for (Map.Entry entry : this.handlers.entrySet()) {
            TcpSocketServer$SocketHandler tcpSocketServer$SocketHandler = (TcpSocketServer$SocketHandler)entry.getValue();
            tcpSocketServer$SocketHandler.shutdown();
            try {
                tcpSocketServer$SocketHandler.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.logger.traceExit(entryMessage);
    }

    @Override
    public void shutdown() {
        EntryMessage entryMessage = this.logger.traceEntry();
        this.setActive(false);
        Thread.currentThread().interrupt();
        this.serverSocket.close();
        this.logger.traceExit(entryMessage);
    }

    static /* synthetic */ ConcurrentMap access$000(TcpSocketServer tcpSocketServer) {
        return tcpSocketServer.handlers;
    }
}

