/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.server;

import java.nio.charset.Charset;
import org.apache.logging.log4j.core.jackson.Log4jJsonObjectMapper;
import org.apache.logging.log4j.core.net.server.InputStreamLogEventBridge;

public class JsonInputStreamLogEventBridge
extends InputStreamLogEventBridge {
    private static final int[] END_PAIR = new int[]{-1, -1};
    private static final char EVENT_END_MARKER = '}';
    private static final char EVENT_START_MARKER = '{';
    private static final char JSON_ESC = '\\';
    private static final char JSON_STR_DELIM = '\"';
    private static final boolean THREAD_CONTEXT_MAP_AS_LIST = false;

    public JsonInputStreamLogEventBridge() {
        this(1024, Charset.defaultCharset());
    }

    public JsonInputStreamLogEventBridge(int n2, Charset charset) {
        super(new Log4jJsonObjectMapper(false, true), n2, charset, String.valueOf('}'));
    }

    @Override
    protected int[] getEventIndices(String string, int n2) {
        int n3 = string.indexOf(123, n2);
        if (n3 == -1) {
            return END_PAIR;
        }
        char[] cArray = string.toCharArray();
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = n3; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (bl3) {
                bl3 = false;
                continue;
            }
            switch (c2) {
                case '{': {
                    if (bl2) break;
                    ++n4;
                    break;
                }
                case '}': {
                    if (bl2) break;
                    --n4;
                    break;
                }
                case '\"': {
                    bl2 = !bl2;
                    break;
                }
                case '\\': {
                    bl3 = true;
                }
            }
            if (n4 != 0) continue;
            return new int[]{n3, i2};
        }
        return END_PAIR;
    }
}

