/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net.server;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LogEventListener;
import org.apache.logging.log4j.core.net.server.LogEventBridge;
import org.apache.logging.log4j.core.util.Log4jThread;

public abstract class AbstractSocketServer<T extends InputStream>
extends LogEventListener
implements Runnable {
    protected static final int MAX_PORT = 65534;
    private volatile boolean active = true;
    protected final LogEventBridge<T> logEventInput;
    protected final Logger logger;

    public AbstractSocketServer(int n2, LogEventBridge<T> logEventBridge) {
        this.logger = LogManager.getLogger(this.getClass().getName() + '.' + n2);
        this.logEventInput = Objects.requireNonNull(logEventBridge, "LogEventInput");
    }

    protected boolean isActive() {
        return this.active;
    }

    protected void setActive(boolean bl2) {
        this.active = bl2;
    }

    public Thread startNewThread() {
        Log4jThread log4jThread = new Log4jThread(this);
        log4jThread.start();
        return log4jThread;
    }

    public abstract void shutdown();

    public void awaitTermination(Thread thread) {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (!((string = bufferedReader.readLine()) == null || string.equalsIgnoreCase("quit") || string.equalsIgnoreCase("stop") || string.equalsIgnoreCase("exit"))) {
        }
        this.shutdown();
        thread.join();
    }
}

