/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.net.AbstractSocketManager;
import org.apache.logging.log4j.core.net.SocketOptions;
import org.apache.logging.log4j.core.net.TcpSocketManager$FactoryData;
import org.apache.logging.log4j.core.net.TcpSocketManager$Reconnector;
import org.apache.logging.log4j.core.net.TcpSocketManager$TcpSocketManagerFactory;
import org.apache.logging.log4j.util.Strings;

public class TcpSocketManager
extends AbstractSocketManager {
    public static final int DEFAULT_RECONNECTION_DELAY_MILLIS = 30000;
    private static final int DEFAULT_PORT = 4560;
    private static final TcpSocketManager$TcpSocketManagerFactory FACTORY = new TcpSocketManager$TcpSocketManagerFactory();
    private final int reconnectionDelay;
    private TcpSocketManager$Reconnector reconnector;
    private Socket socket;
    private final SocketOptions socketOptions;
    private final boolean retry;
    private final boolean immediateFail;
    private final int connectTimeoutMillis;

    @Deprecated
    public TcpSocketManager(String string, OutputStream outputStream, Socket socket, InetAddress inetAddress, String string2, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5) {
        this(string, outputStream, socket, inetAddress, string2, n2, n3, n4, bl2, layout, n5, null);
    }

    public TcpSocketManager(String string, OutputStream outputStream, Socket socket, InetAddress inetAddress, String string2, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5, SocketOptions socketOptions) {
        super(string, outputStream, inetAddress, string2, n2, layout, true, n5);
        this.connectTimeoutMillis = n3;
        this.reconnectionDelay = n4;
        this.socket = socket;
        this.immediateFail = bl2;
        boolean bl3 = this.retry = n4 > 0;
        if (socket == null) {
            this.reconnector = this.createReconnector();
            this.reconnector.start();
        }
        this.socketOptions = socketOptions;
    }

    @Deprecated
    public static TcpSocketManager getSocketManager(String string, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5) {
        return TcpSocketManager.getSocketManager(string, n2, n3, n4, bl2, layout, n5, null);
    }

    public static TcpSocketManager getSocketManager(String string, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5, SocketOptions socketOptions) {
        if (Strings.isEmpty(string)) {
            throw new IllegalArgumentException("A host name is required");
        }
        if (n2 <= 0) {
            n2 = 4560;
        }
        if (n4 == 0) {
            n4 = 30000;
        }
        return (TcpSocketManager)TcpSocketManager.getManager("TCP:" + string + ':' + n2, new TcpSocketManager$FactoryData(string, n2, n3, n4, bl2, layout, n5, socketOptions), FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(byte[] byArray, int n2, int n3, boolean bl2) {
        if (this.socket == null) {
            if (this.reconnector != null && !this.immediateFail) {
                this.reconnector.latch();
            }
            if (this.socket == null) {
                String string = "Error writing to " + this.getName() + " socket not available";
                throw new AppenderLoggingException(string);
            }
        }
        TcpSocketManager tcpSocketManager = this;
        synchronized (tcpSocketManager) {
            try {
                OutputStream outputStream = this.getOutputStream();
                outputStream.write(byArray, n2, n3);
                if (bl2) {
                    outputStream.flush();
                }
            }
            catch (IOException iOException) {
                if (this.retry && this.reconnector == null) {
                    this.reconnector = this.createReconnector();
                    this.reconnector.start();
                }
                String string = "Error writing to " + this.getName();
                throw new AppenderLoggingException(string, iOException);
            }
        }
    }

    @Override
    protected synchronized boolean closeOutputStream() {
        boolean bl2 = super.closeOutputStream();
        if (this.reconnector != null) {
            this.reconnector.shutdown();
            this.reconnector.interrupt();
            this.reconnector = null;
        }
        Socket socket = this.socket;
        this.socket = null;
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                LOGGER.error("Could not close socket {}", (Object)this.socket);
                return false;
            }
        }
        return bl2;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> hashMap = new HashMap<String, String>(super.getContentFormat());
        hashMap.put("protocol", "tcp");
        hashMap.put("direction", "out");
        return hashMap;
    }

    private TcpSocketManager$Reconnector createReconnector() {
        TcpSocketManager$Reconnector tcpSocketManager$Reconnector = new TcpSocketManager$Reconnector(this, this);
        tcpSocketManager$Reconnector.setDaemon(true);
        tcpSocketManager$Reconnector.setPriority(1);
        return tcpSocketManager$Reconnector;
    }

    protected Socket createSocket(InetAddress inetAddress, int n2) {
        return this.createSocket(inetAddress.getHostName(), n2);
    }

    protected Socket createSocket(String string, int n2) {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(string, n2), this.connectTimeoutMillis);
        if (this.socketOptions != null) {
            this.socketOptions.apply(socket);
        }
        return socket;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public Socket getSocket() {
        return this.socket;
    }

    static /* synthetic */ int access$000(TcpSocketManager tcpSocketManager) {
        return tcpSocketManager.reconnectionDelay;
    }

    static /* synthetic */ OutputStream access$100(TcpSocketManager tcpSocketManager) {
        return tcpSocketManager.getOutputStream();
    }

    static /* synthetic */ void access$200(TcpSocketManager tcpSocketManager, OutputStream outputStream) {
        tcpSocketManager.setOutputStream(outputStream);
    }

    static /* synthetic */ Socket access$302(TcpSocketManager tcpSocketManager, Socket socket) {
        tcpSocketManager.socket = socket;
        return tcpSocketManager.socket;
    }

    static /* synthetic */ TcpSocketManager$Reconnector access$402(TcpSocketManager tcpSocketManager, TcpSocketManager$Reconnector tcpSocketManager$Reconnector) {
        tcpSocketManager.reconnector = tcpSocketManager$Reconnector;
        return tcpSocketManager.reconnector;
    }

    static /* synthetic */ Logger access$500() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$600() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$700() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$800() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$1000() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$1800() {
        return LOGGER;
    }
}

