/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.net.SocketOptions;
import org.apache.logging.log4j.core.net.SslSocketManager$SslFactoryData;
import org.apache.logging.log4j.core.net.SslSocketManager$SslSocketManagerFactory;
import org.apache.logging.log4j.core.net.TcpSocketManager;
import org.apache.logging.log4j.core.net.ssl.SslConfiguration;
import org.apache.logging.log4j.util.Strings;

public class SslSocketManager
extends TcpSocketManager {
    public static final int DEFAULT_PORT = 6514;
    private static final SslSocketManager$SslSocketManagerFactory FACTORY = new SslSocketManager$SslSocketManagerFactory(null);
    private final SslConfiguration sslConfig;

    public SslSocketManager(String string, OutputStream outputStream, Socket socket, SslConfiguration sslConfiguration, InetAddress inetAddress, String string2, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5) {
        super(string, outputStream, socket, inetAddress, string2, n2, n3, n4, bl2, layout, n5, null);
        this.sslConfig = sslConfiguration;
    }

    public SslSocketManager(String string, OutputStream outputStream, Socket socket, SslConfiguration sslConfiguration, InetAddress inetAddress, String string2, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5, SocketOptions socketOptions) {
        super(string, outputStream, socket, inetAddress, string2, n2, n3, n4, bl2, layout, n5, socketOptions);
        this.sslConfig = sslConfiguration;
    }

    @Deprecated
    public static SslSocketManager getSocketManager(SslConfiguration sslConfiguration, String string, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5) {
        return SslSocketManager.getSocketManager(sslConfiguration, string, n2, n3, n4, bl2, layout, n5, null);
    }

    public static SslSocketManager getSocketManager(SslConfiguration sslConfiguration, String string, int n2, int n3, int n4, boolean bl2, Layout<? extends Serializable> layout, int n5, SocketOptions socketOptions) {
        if (Strings.isEmpty(string)) {
            throw new IllegalArgumentException("A host name is required");
        }
        if (n2 <= 0) {
            n2 = 6514;
        }
        if (n4 == 0) {
            n4 = 30000;
        }
        return (SslSocketManager)SslSocketManager.getManager("TLS:" + string + ':' + n2, new SslSocketManager$SslFactoryData(sslConfiguration, string, n2, n3, n4, bl2, layout, n5, socketOptions), FACTORY);
    }

    @Override
    protected Socket createSocket(String string, int n2) {
        SSLSocketFactory sSLSocketFactory = SslSocketManager.createSslSocketFactory(this.sslConfig);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n2);
        Socket socket = sSLSocketFactory.createSocket();
        socket.connect(inetSocketAddress, this.getConnectTimeoutMillis());
        return socket;
    }

    private static SSLSocketFactory createSslSocketFactory(SslConfiguration sslConfiguration) {
        SSLSocketFactory sSLSocketFactory = sslConfiguration != null ? sslConfiguration.getSslSocketFactory() : (SSLSocketFactory)SSLSocketFactory.getDefault();
        return sSLSocketFactory;
    }

    static /* synthetic */ Logger access$300() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$400() {
        return LOGGER;
    }

    static /* synthetic */ Logger access$1100() {
        return LOGGER;
    }

    static /* synthetic */ SSLSocketFactory access$1300(SslConfiguration sslConfiguration) {
        return SslSocketManager.createSslSocketFactory(sslConfiguration);
    }
}

