/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.net.SocketOptions;
import org.apache.logging.log4j.core.net.SslSocketManager;
import org.apache.logging.log4j.core.net.SslSocketManager$1;
import org.apache.logging.log4j.core.net.SslSocketManager$SslFactoryData;
import org.apache.logging.log4j.core.net.SslSocketManager$SslSocketManagerFactory$TlsSocketManagerFactoryException;
import org.apache.logging.log4j.core.util.Closer;

class SslSocketManager$SslSocketManagerFactory
implements ManagerFactory<SslSocketManager, SslSocketManager$SslFactoryData> {
    private SslSocketManager$SslSocketManagerFactory() {
    }

    @Override
    public SslSocketManager createManager(String string, SslSocketManager$SslFactoryData sslSocketManager$SslFactoryData) {
        InetAddress inetAddress = null;
        OutputStream outputStream = null;
        Socket socket = null;
        try {
            inetAddress = this.resolveAddress(SslSocketManager$SslFactoryData.access$100(sslSocketManager$SslFactoryData));
            socket = this.createSocket(sslSocketManager$SslFactoryData);
            outputStream = socket.getOutputStream();
            this.checkDelay(SslSocketManager$SslFactoryData.access$200(sslSocketManager$SslFactoryData), outputStream);
        }
        catch (IOException iOException) {
            SslSocketManager.access$300().error("SslSocketManager ({})", (Object)string, (Object)iOException);
            outputStream = new ByteArrayOutputStream();
        }
        catch (SslSocketManager$SslSocketManagerFactory$TlsSocketManagerFactoryException sslSocketManager$SslSocketManagerFactory$TlsSocketManagerFactoryException) {
            SslSocketManager.access$400().catching(Level.DEBUG, sslSocketManager$SslSocketManagerFactory$TlsSocketManagerFactoryException);
            Closer.closeSilently(socket);
            return null;
        }
        return new SslSocketManager(string, outputStream, socket, sslSocketManager$SslFactoryData.sslConfiguration, inetAddress, SslSocketManager$SslFactoryData.access$100(sslSocketManager$SslFactoryData), SslSocketManager$SslFactoryData.access$500(sslSocketManager$SslFactoryData), SslSocketManager$SslFactoryData.access$600(sslSocketManager$SslFactoryData), SslSocketManager$SslFactoryData.access$200(sslSocketManager$SslFactoryData), SslSocketManager$SslFactoryData.access$700(sslSocketManager$SslFactoryData), SslSocketManager$SslFactoryData.access$800(sslSocketManager$SslFactoryData), SslSocketManager$SslFactoryData.access$900(sslSocketManager$SslFactoryData), SslSocketManager$SslFactoryData.access$1000(sslSocketManager$SslFactoryData));
    }

    private InetAddress resolveAddress(String string) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            SslSocketManager.access$1100().error("Could not find address of {}", (Object)string, (Object)unknownHostException);
            throw new SslSocketManager$SslSocketManagerFactory$TlsSocketManagerFactoryException();
        }
        return inetAddress;
    }

    private void checkDelay(int n2, OutputStream outputStream) {
        if (n2 == 0 && outputStream == null) {
            throw new SslSocketManager$SslSocketManagerFactory$TlsSocketManagerFactoryException();
        }
    }

    private Socket createSocket(SslSocketManager$SslFactoryData sslSocketManager$SslFactoryData) {
        SSLSocketFactory sSLSocketFactory = SslSocketManager.access$1300(sslSocketManager$SslFactoryData.sslConfiguration);
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket();
        SocketOptions socketOptions = SslSocketManager$SslFactoryData.access$1000(sslSocketManager$SslFactoryData);
        if (socketOptions != null) {
            socketOptions.apply(sSLSocket);
        }
        sSLSocket.connect(new InetSocketAddress(SslSocketManager$SslFactoryData.access$100(sslSocketManager$SslFactoryData), SslSocketManager$SslFactoryData.access$500(sslSocketManager$SslFactoryData)), SslSocketManager$SslFactoryData.access$600(sslSocketManager$SslFactoryData));
        if (socketOptions != null) {
            socketOptions.apply(sSLSocket);
        }
        return sSLSocket;
    }

    /* synthetic */ SslSocketManager$SslSocketManagerFactory(SslSocketManager$1 var1_1) {
        this();
    }
}

