/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.core.layout.AbstractStringLayout$Serializer;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.net.MimeMessageBuilder;
import org.apache.logging.log4j.core.net.SmtpManager$FactoryData;
import org.apache.logging.log4j.core.net.SmtpManager$SMTPManagerFactory;
import org.apache.logging.log4j.core.util.CyclicBuffer;
import org.apache.logging.log4j.core.util.NameUtil;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.util.Strings;

public class SmtpManager
extends AbstractManager {
    private static final SmtpManager$SMTPManagerFactory FACTORY = new SmtpManager$SMTPManagerFactory(null);
    private final Session session;
    private final CyclicBuffer<LogEvent> buffer;
    private volatile MimeMessage message;
    private final SmtpManager$FactoryData data;

    private static MimeMessage createMimeMessage(SmtpManager$FactoryData smtpManager$FactoryData, Session session, LogEvent logEvent) {
        return new MimeMessageBuilder(session).setFrom(SmtpManager$FactoryData.access$600(smtpManager$FactoryData)).setReplyTo(SmtpManager$FactoryData.access$500(smtpManager$FactoryData)).setRecipients(Message.RecipientType.TO, SmtpManager$FactoryData.access$400(smtpManager$FactoryData)).setRecipients(Message.RecipientType.CC, SmtpManager$FactoryData.access$300(smtpManager$FactoryData)).setRecipients(Message.RecipientType.BCC, SmtpManager$FactoryData.access$200(smtpManager$FactoryData)).setSubject(SmtpManager$FactoryData.access$100(smtpManager$FactoryData).toSerializable(logEvent)).build();
    }

    protected SmtpManager(String string, Session session, MimeMessage mimeMessage, SmtpManager$FactoryData smtpManager$FactoryData) {
        super(null, string);
        this.session = session;
        this.message = mimeMessage;
        this.data = smtpManager$FactoryData;
        this.buffer = new CyclicBuffer<LogEvent>(LogEvent.class, SmtpManager$FactoryData.access$700(smtpManager$FactoryData));
    }

    public void add(LogEvent logEvent) {
        if (logEvent instanceof Log4jLogEvent && logEvent.getMessage() instanceof ReusableMessage) {
            ((Log4jLogEvent)logEvent).makeMessageImmutable();
        } else if (logEvent instanceof MutableLogEvent) {
            logEvent = ((MutableLogEvent)logEvent).createMemento();
        }
        this.buffer.add(logEvent);
    }

    public static SmtpManager getSmtpManager(Configuration configuration, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, int n2, String string9, String string10, boolean bl2, String string11, int n3) {
        if (Strings.isEmpty(string7)) {
            string7 = "smtp";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append(':');
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        stringBuilder.append(':');
        if (string3 != null) {
            stringBuilder.append(string3);
        }
        stringBuilder.append(':');
        if (string4 != null) {
            stringBuilder.append(string4);
        }
        stringBuilder.append(':');
        if (string5 != null) {
            stringBuilder.append(string5);
        }
        stringBuilder.append(':');
        if (string6 != null) {
            stringBuilder.append(string6);
        }
        stringBuilder.append(':');
        stringBuilder.append(string7).append(':').append(string8).append(':').append("port").append(':');
        if (string9 != null) {
            stringBuilder.append(string9);
        }
        stringBuilder.append(':');
        if (string10 != null) {
            stringBuilder.append(string10);
        }
        stringBuilder.append(bl2 ? ":debug:" : "::");
        stringBuilder.append(string11);
        String string12 = "SMTP:" + NameUtil.md5(stringBuilder.toString());
        AbstractStringLayout$Serializer abstractStringLayout$Serializer = PatternLayout.newSerializerBuilder().setConfiguration(configuration).setPattern(string6).build();
        return SmtpManager.getManager(string12, FACTORY, new SmtpManager$FactoryData(string, string2, string3, string4, string5, abstractStringLayout$Serializer, string7, string8, n2, string9, string10, bl2, n3));
    }

    public void sendEvents(Layout<?> layout, LogEvent logEvent) {
        if (this.message == null) {
            this.connect(logEvent);
        }
        try {
            LogEvent[] logEventArray = this.buffer.removeAll();
            byte[] byArray = this.formatContentToBytes(logEventArray, logEvent, layout);
            String string = layout.getContentType();
            String string2 = this.getEncoding(byArray, string);
            byte[] byArray2 = this.encodeContentToBytes(byArray, string2);
            InternetHeaders internetHeaders = this.getHeaders(string, string2);
            MimeMultipart mimeMultipart = this.getMimeMultipart(byArray2, internetHeaders);
            this.sendMultipartMessage(this.message, mimeMultipart);
        }
        catch (IOException | RuntimeException | MessagingException throwable) {
            this.logError("Caught exception while sending e-mail notification.", throwable);
            throw new LoggingException("Error occurred while sending email", throwable);
        }
    }

    protected byte[] formatContentToBytes(LogEvent[] logEventArray, LogEvent logEvent, Layout<?> layout) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeContent(logEventArray, logEvent, layout, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void writeContent(LogEvent[] logEventArray, LogEvent logEvent, Layout<?> layout, ByteArrayOutputStream byteArrayOutputStream) {
        this.writeHeader(layout, byteArrayOutputStream);
        this.writeBuffer(logEventArray, logEvent, layout, byteArrayOutputStream);
        this.writeFooter(layout, byteArrayOutputStream);
    }

    protected void writeHeader(Layout<?> layout, OutputStream outputStream) {
        byte[] byArray = layout.getHeader();
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    protected void writeBuffer(LogEvent[] logEventArray, LogEvent logEvent, Layout<?> layout, OutputStream outputStream) {
        for (LogEvent logEvent2 : logEventArray) {
            byte[] byArray = layout.toByteArray(logEvent2);
            outputStream.write(byArray);
        }
        byte[] byArray = layout.toByteArray(logEvent);
        outputStream.write(byArray);
    }

    protected void writeFooter(Layout<?> layout, OutputStream outputStream) {
        byte[] byArray = layout.getFooter();
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    protected String getEncoding(byte[] byArray, String string) {
        ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(byArray, string);
        return MimeUtility.getEncoding((DataSource)byteArrayDataSource);
    }

    protected byte[] encodeContentToBytes(byte[] byArray, String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encodeContent(byArray, string, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected void encodeContent(byte[] byArray, String string, ByteArrayOutputStream byteArrayOutputStream) {
        try (OutputStream outputStream = MimeUtility.encode((OutputStream)byteArrayOutputStream, (String)string);){
            outputStream.write(byArray);
        }
    }

    protected InternetHeaders getHeaders(String string, String string2) {
        InternetHeaders internetHeaders = new InternetHeaders();
        internetHeaders.setHeader("Content-Type", string + "; charset=UTF-8");
        internetHeaders.setHeader("Content-Transfer-Encoding", string2);
        return internetHeaders;
    }

    protected MimeMultipart getMimeMultipart(byte[] byArray, InternetHeaders internetHeaders) {
        MimeMultipart mimeMultipart = new MimeMultipart();
        MimeBodyPart mimeBodyPart = new MimeBodyPart(internetHeaders, byArray);
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        return mimeMultipart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMultipartMessage(MimeMessage mimeMessage, MimeMultipart mimeMultipart) {
        MimeMessage mimeMessage2 = mimeMessage;
        synchronized (mimeMessage2) {
            mimeMessage.setContent((Multipart)mimeMultipart);
            mimeMessage.setSentDate(new Date());
            Transport.send((Message)mimeMessage);
        }
    }

    private synchronized void connect(LogEvent logEvent) {
        if (this.message != null) {
            return;
        }
        try {
            this.message = SmtpManager.createMimeMessage(this.data, this.session, logEvent);
        }
        catch (MessagingException messagingException) {
            this.logError("Could not set SmtpAppender message options", messagingException);
            this.message = null;
        }
    }
}

