/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.net;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.naming.Context;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.net.JndiManager$1;
import org.apache.logging.log4j.core.net.JndiManager$JndiManagerFactory;
import org.apache.logging.log4j.core.util.JndiCloser;

public class JndiManager
extends AbstractManager {
    private static final JndiManager$JndiManagerFactory FACTORY = new JndiManager$JndiManagerFactory();
    private final Context context;

    private JndiManager(String string, Context context) {
        super(null, string);
        this.context = context;
    }

    public static JndiManager getDefaultManager() {
        return JndiManager.getManager(JndiManager.class.getName(), FACTORY, null);
    }

    public static JndiManager getDefaultManager(String string) {
        return JndiManager.getManager(string, FACTORY, null);
    }

    public static JndiManager getJndiManager(String string, String string2, String string3, String string4, String string5, Properties properties) {
        String string6 = JndiManager.class.getName() + '@' + JndiManager.class.hashCode();
        if (string == null) {
            return JndiManager.getManager(string6, FACTORY, null);
        }
        Properties properties2 = new Properties();
        properties2.setProperty("java.naming.factory.initial", string);
        if (string2 != null) {
            properties2.setProperty("java.naming.provider.url", string2);
        } else {
            LOGGER.warn("The JNDI InitialContextFactory class name [{}] was provided, but there was no associated provider URL. This is likely to cause problems.", (Object)string);
        }
        if (string3 != null) {
            properties2.setProperty("java.naming.factory.url.pkgs", string3);
        }
        if (string4 != null) {
            properties2.setProperty("java.naming.security.principal", string4);
            if (string5 != null) {
                properties2.setProperty("java.naming.security.credentials", string5);
            } else {
                LOGGER.warn("A security principal [{}] was provided, but with no corresponding security credentials.", (Object)string4);
            }
        }
        if (properties != null) {
            properties2.putAll((Map<?, ?>)properties);
        }
        return JndiManager.getManager(string6, FACTORY, properties2);
    }

    @Override
    protected boolean releaseSub(long l2, TimeUnit timeUnit) {
        return JndiCloser.closeSilently(this.context);
    }

    public <T> T lookup(String string) {
        return (T)this.context.lookup(string);
    }

    /* synthetic */ JndiManager(String string, Context context, JndiManager$1 jndiManager$1) {
        this(string, context);
    }

    static /* synthetic */ Logger access$200() {
        return LOGGER;
    }
}

