/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.lookup;

import org.apache.logging.log4j.core.lookup.StrMatcher$CharMatcher;
import org.apache.logging.log4j.core.lookup.StrMatcher$CharSetMatcher;
import org.apache.logging.log4j.core.lookup.StrMatcher$NoMatcher;
import org.apache.logging.log4j.core.lookup.StrMatcher$StringMatcher;
import org.apache.logging.log4j.core.lookup.StrMatcher$TrimMatcher;
import org.apache.logging.log4j.util.Strings;

public abstract class StrMatcher {
    private static final StrMatcher COMMA_MATCHER = new StrMatcher$CharMatcher(',');
    private static final StrMatcher TAB_MATCHER = new StrMatcher$CharMatcher('\t');
    private static final StrMatcher SPACE_MATCHER = new StrMatcher$CharMatcher(' ');
    private static final StrMatcher SPLIT_MATCHER = new StrMatcher$CharSetMatcher(" \t\n\r\f".toCharArray());
    private static final StrMatcher TRIM_MATCHER = new StrMatcher$TrimMatcher();
    private static final StrMatcher SINGLE_QUOTE_MATCHER = new StrMatcher$CharMatcher('\'');
    private static final StrMatcher DOUBLE_QUOTE_MATCHER = new StrMatcher$CharMatcher('\"');
    private static final StrMatcher QUOTE_MATCHER = new StrMatcher$CharSetMatcher("'\"".toCharArray());
    private static final StrMatcher NONE_MATCHER = new StrMatcher$NoMatcher();

    protected StrMatcher() {
    }

    public static StrMatcher commaMatcher() {
        return COMMA_MATCHER;
    }

    public static StrMatcher tabMatcher() {
        return TAB_MATCHER;
    }

    public static StrMatcher spaceMatcher() {
        return SPACE_MATCHER;
    }

    public static StrMatcher splitMatcher() {
        return SPLIT_MATCHER;
    }

    public static StrMatcher trimMatcher() {
        return TRIM_MATCHER;
    }

    public static StrMatcher singleQuoteMatcher() {
        return SINGLE_QUOTE_MATCHER;
    }

    public static StrMatcher doubleQuoteMatcher() {
        return DOUBLE_QUOTE_MATCHER;
    }

    public static StrMatcher quoteMatcher() {
        return QUOTE_MATCHER;
    }

    public static StrMatcher noneMatcher() {
        return NONE_MATCHER;
    }

    public static StrMatcher charMatcher(char c2) {
        return new StrMatcher$CharMatcher(c2);
    }

    public static StrMatcher charSetMatcher(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return NONE_MATCHER;
        }
        if (cArray.length == 1) {
            return new StrMatcher$CharMatcher(cArray[0]);
        }
        return new StrMatcher$CharSetMatcher(cArray);
    }

    public static StrMatcher charSetMatcher(String string) {
        if (Strings.isEmpty(string)) {
            return NONE_MATCHER;
        }
        if (string.length() == 1) {
            return new StrMatcher$CharMatcher(string.charAt(0));
        }
        return new StrMatcher$CharSetMatcher(string.toCharArray());
    }

    public static StrMatcher stringMatcher(String string) {
        if (Strings.isEmpty(string)) {
            return NONE_MATCHER;
        }
        return new StrMatcher$StringMatcher(string);
    }

    public abstract int isMatch(char[] var1, int var2, int var3, int var4);

    public int isMatch(char[] cArray, int n2) {
        return this.isMatch(cArray, n2, 0, cArray.length);
    }
}

