/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.core.layout.SerializedLayout$PrivateObjectOutputStream;

@Plugin(name="SerializedLayout", category="Core", elementType="layout", printObject=true)
public final class SerializedLayout
extends AbstractLayout<LogEvent> {
    private static byte[] serializedHeader;

    private SerializedLayout() {
        super(null, null, null);
    }

    @Override
    public byte[] toByteArray(LogEvent logEvent) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (SerializedLayout$PrivateObjectOutputStream serializedLayout$PrivateObjectOutputStream = new SerializedLayout$PrivateObjectOutputStream(this, byteArrayOutputStream);){
            serializedLayout$PrivateObjectOutputStream.writeObject(logEvent);
            serializedLayout$PrivateObjectOutputStream.reset();
        }
        catch (IOException iOException) {
            LOGGER.error("Serialization of LogEvent failed.", (Throwable)iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public LogEvent toSerializable(LogEvent logEvent) {
        return logEvent;
    }

    @PluginFactory
    public static SerializedLayout createLayout() {
        return new SerializedLayout();
    }

    @Override
    public byte[] getHeader() {
        return serializedHeader;
    }

    @Override
    public String getContentType() {
        return "application/octet-stream";
    }

    static {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            new ObjectOutputStream(byteArrayOutputStream).close();
            serializedHeader = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            LOGGER.error("Unable to generate Object stream header", (Throwable)exception);
        }
    }
}

