/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.layout.PatternMatch;
import org.apache.logging.log4j.core.layout.ScriptPatternSelector;
import org.apache.logging.log4j.core.layout.ScriptPatternSelector$1;
import org.apache.logging.log4j.core.script.AbstractScript;
import org.apache.logging.log4j.core.script.ScriptRef;
import org.apache.logging.log4j.core.util.Builder;

public class ScriptPatternSelector$Builder
implements Builder<ScriptPatternSelector> {
    @PluginElement(value="Script")
    private AbstractScript script;
    @PluginElement(value="PatternMatch")
    private PatternMatch[] properties;
    @PluginBuilderAttribute(value="defaultPattern")
    private String defaultPattern;
    @PluginBuilderAttribute(value="alwaysWriteExceptions")
    private boolean alwaysWriteExceptions = true;
    @PluginBuilderAttribute(value="disableAnsi")
    private boolean disableAnsi;
    @PluginBuilderAttribute(value="noConsoleNoAnsi")
    private boolean noConsoleNoAnsi;
    @PluginConfiguration
    private Configuration configuration;

    private ScriptPatternSelector$Builder() {
    }

    @Override
    public ScriptPatternSelector build() {
        if (this.script == null) {
            ScriptPatternSelector.access$000().error("A Script, ScriptFile or ScriptRef element must be provided for this ScriptFilter");
            return null;
        }
        if (this.script instanceof ScriptRef && this.configuration.getScriptManager().getScript(this.script.getName()) == null) {
            ScriptPatternSelector.access$000().error("No script with name {} has been declared.", (Object)this.script.getName());
            return null;
        }
        if (this.defaultPattern == null) {
            this.defaultPattern = "%m%n";
        }
        if (this.properties == null || this.properties.length == 0) {
            ScriptPatternSelector.access$000().warn("No marker patterns were provided");
            return null;
        }
        return new ScriptPatternSelector(this.script, this.properties, this.defaultPattern, this.alwaysWriteExceptions, this.disableAnsi, this.noConsoleNoAnsi, this.configuration);
    }

    public ScriptPatternSelector$Builder setScript(AbstractScript abstractScript) {
        this.script = abstractScript;
        return this;
    }

    public ScriptPatternSelector$Builder setProperties(PatternMatch[] patternMatchArray) {
        this.properties = patternMatchArray;
        return this;
    }

    public ScriptPatternSelector$Builder setDefaultPattern(String string) {
        this.defaultPattern = string;
        return this;
    }

    public ScriptPatternSelector$Builder setAlwaysWriteExceptions(boolean bl2) {
        this.alwaysWriteExceptions = bl2;
        return this;
    }

    public ScriptPatternSelector$Builder setDisableAnsi(boolean bl2) {
        this.disableAnsi = bl2;
        return this;
    }

    public ScriptPatternSelector$Builder setNoConsoleNoAnsi(boolean bl2) {
        this.noConsoleNoAnsi = bl2;
        return this;
    }

    public ScriptPatternSelector$Builder setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    /* synthetic */ ScriptPatternSelector$Builder(ScriptPatternSelector$1 scriptPatternSelector$1) {
        this();
    }
}

