/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.util.List;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.AbstractStringLayout$Serializer;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.layout.PatternLayout$PatternSelectorSerializer;
import org.apache.logging.log4j.core.layout.PatternLayout$PatternSerializer;
import org.apache.logging.log4j.core.layout.PatternSelector;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.core.pattern.RegexReplacement;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.util.Strings;

public class PatternLayout$SerializerBuilder
implements Builder<AbstractStringLayout$Serializer> {
    private Configuration configuration;
    private RegexReplacement replace;
    private String pattern;
    private String defaultPattern;
    private PatternSelector patternSelector;
    private boolean alwaysWriteExceptions;
    private boolean disableAnsi;
    private boolean noConsoleNoAnsi;

    @Override
    public AbstractStringLayout$Serializer build() {
        if (Strings.isEmpty(this.pattern) && Strings.isEmpty(this.defaultPattern)) {
            return null;
        }
        if (this.patternSelector == null) {
            try {
                PatternParser patternParser = PatternLayout.createPatternParser(this.configuration);
                List<PatternFormatter> list = patternParser.parse(this.pattern == null ? this.defaultPattern : this.pattern, this.alwaysWriteExceptions, this.disableAnsi, this.noConsoleNoAnsi);
                PatternFormatter[] patternFormatterArray = list.toArray(new PatternFormatter[0]);
                return new PatternLayout$PatternSerializer(patternFormatterArray, this.replace);
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException("Cannot parse pattern '" + this.pattern + "'", runtimeException);
            }
        }
        return new PatternLayout$PatternSelectorSerializer(this.patternSelector, this.replace, null);
    }

    public PatternLayout$SerializerBuilder setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public PatternLayout$SerializerBuilder setReplace(RegexReplacement regexReplacement) {
        this.replace = regexReplacement;
        return this;
    }

    public PatternLayout$SerializerBuilder setPattern(String string) {
        this.pattern = string;
        return this;
    }

    public PatternLayout$SerializerBuilder setDefaultPattern(String string) {
        this.defaultPattern = string;
        return this;
    }

    public PatternLayout$SerializerBuilder setPatternSelector(PatternSelector patternSelector) {
        this.patternSelector = patternSelector;
        return this;
    }

    public PatternLayout$SerializerBuilder setAlwaysWriteExceptions(boolean bl2) {
        this.alwaysWriteExceptions = bl2;
        return this;
    }

    public PatternLayout$SerializerBuilder setDisableAnsi(boolean bl2) {
        this.disableAnsi = bl2;
        return this;
    }

    public PatternLayout$SerializerBuilder setNoConsoleNoAnsi(boolean bl2) {
        this.noConsoleNoAnsi = bl2;
        return this;
    }
}

