/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.layout.MarkerPatternSelector$Builder;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.layout.PatternMatch;
import org.apache.logging.log4j.core.layout.PatternSelector;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="MarkerPatternSelector", category="Core", elementType="patternSelector", printObject=true)
public class MarkerPatternSelector
implements PatternSelector {
    private final Map<String, PatternFormatter[]> formatterMap = new HashMap<String, PatternFormatter[]>();
    private final Map<String, String> patternMap = new HashMap<String, String>();
    private final PatternFormatter[] defaultFormatters;
    private final String defaultPattern;
    private static Logger LOGGER = StatusLogger.getLogger();

    @Deprecated
    public MarkerPatternSelector(PatternMatch[] patternMatchArray, String string, boolean bl2, boolean bl3, Configuration configuration) {
        this(patternMatchArray, string, bl2, false, bl3, configuration);
    }

    private MarkerPatternSelector(PatternMatch[] patternMatchArray, String string, boolean bl2, boolean bl3, boolean bl4, Configuration configuration) {
        PatternParser patternParser = PatternLayout.createPatternParser(configuration);
        for (PatternMatch patternMatch : patternMatchArray) {
            try {
                List<PatternFormatter> list = patternParser.parse(patternMatch.getPattern(), bl2, bl3, bl4);
                this.formatterMap.put(patternMatch.getKey(), list.toArray(new PatternFormatter[list.size()]));
                this.patternMap.put(patternMatch.getKey(), patternMatch.getPattern());
            }
            catch (RuntimeException runtimeException) {
                throw new IllegalArgumentException("Cannot parse pattern '" + patternMatch.getPattern() + "'", runtimeException);
            }
        }
        try {
            List<PatternFormatter> list = patternParser.parse(string, bl2, bl3, bl4);
            this.defaultFormatters = list.toArray(new PatternFormatter[list.size()]);
            this.defaultPattern = string;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException("Cannot parse pattern '" + string + "'", runtimeException);
        }
    }

    @Override
    public PatternFormatter[] getFormatters(LogEvent logEvent) {
        Marker marker = logEvent.getMarker();
        if (marker == null) {
            return this.defaultFormatters;
        }
        for (String string : this.formatterMap.keySet()) {
            if (!marker.isInstanceOf(string)) continue;
            return this.formatterMap.get(string);
        }
        return this.defaultFormatters;
    }

    @PluginBuilderFactory
    public static MarkerPatternSelector$Builder newBuilder() {
        return new MarkerPatternSelector$Builder();
    }

    @Deprecated
    public static MarkerPatternSelector createSelector(PatternMatch[] patternMatchArray, String string, boolean bl2, boolean bl3, Configuration configuration) {
        MarkerPatternSelector$Builder markerPatternSelector$Builder = MarkerPatternSelector.newBuilder();
        markerPatternSelector$Builder.setProperties(patternMatchArray);
        markerPatternSelector$Builder.setDefaultPattern(string);
        markerPatternSelector$Builder.setAlwaysWriteExceptions(bl2);
        markerPatternSelector$Builder.setNoConsoleNoAnsi(bl3);
        markerPatternSelector$Builder.setConfiguration(configuration);
        return markerPatternSelector$Builder.build();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (Map.Entry<String, String> entry : this.patternMap.entrySet()) {
            if (!bl2) {
                stringBuilder.append(", ");
            }
            stringBuilder.append("key=\"").append(entry.getKey()).append("\", pattern=\"").append(entry.getValue()).append("\"");
            bl2 = false;
        }
        if (!bl2) {
            stringBuilder.append(", ");
        }
        stringBuilder.append("default=\"").append(this.defaultPattern).append("\"");
        return stringBuilder.toString();
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

