/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.layout.AbstractJacksonLayout;
import org.apache.logging.log4j.core.layout.JacksonFactory$JSON;
import org.apache.logging.log4j.core.layout.JsonLayout$Builder;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="JsonLayout", category="Core", elementType="layout", printObject=true)
public final class JsonLayout
extends AbstractJacksonLayout {
    private static final String DEFAULT_FOOTER = "]";
    private static final String DEFAULT_HEADER = "[";
    static final String CONTENT_TYPE = "application/json";

    protected JsonLayout(Configuration configuration, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, String string, String string2, Charset charset, boolean bl8) {
        super(configuration, new JacksonFactory$JSON(bl4, bl8).newWriter(bl2, bl3, bl6), charset, bl6, bl5, bl7, PatternLayout.newSerializerBuilder().setConfiguration(configuration).setPattern(string).setDefaultPattern(DEFAULT_HEADER).build(), PatternLayout.newSerializerBuilder().setConfiguration(configuration).setPattern(string2).setDefaultPattern(DEFAULT_FOOTER).build());
    }

    @Override
    public byte[] getHeader() {
        if (!this.complete) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.serializeToString(this.getHeaderSerializer());
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append(this.eol);
        return this.getBytes(stringBuilder.toString());
    }

    @Override
    public byte[] getFooter() {
        if (!this.complete) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.eol);
        String string = this.serializeToString(this.getFooterSerializer());
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append(this.eol);
        return this.getBytes(stringBuilder.toString());
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("version", "2.0");
        return hashMap;
    }

    @Override
    public String getContentType() {
        return "application/json; charset=" + this.getCharset();
    }

    @Deprecated
    public static JsonLayout createLayout(@PluginConfiguration Configuration configuration, @PluginAttribute(value="locationInfo") boolean bl2, @PluginAttribute(value="properties") boolean bl3, @PluginAttribute(value="propertiesAsList") boolean bl4, @PluginAttribute(value="complete") boolean bl5, @PluginAttribute(value="compact") boolean bl6, @PluginAttribute(value="eventEol") boolean bl7, @PluginAttribute(value="header", defaultString="[") String string, @PluginAttribute(value="footer", defaultString="]") String string2, @PluginAttribute(value="charset", defaultString="UTF-8") Charset charset, @PluginAttribute(value="includeStacktrace", defaultBoolean=true) boolean bl8) {
        boolean bl9 = bl3 && bl4;
        return new JsonLayout(configuration, bl2, bl3, bl9, bl5, bl6, bl7, string, string2, charset, bl8);
    }

    @PluginBuilderFactory
    public static <B extends JsonLayout$Builder<B>> B newBuilder() {
        return (B)((JsonLayout$Builder)new JsonLayout$Builder().asBuilder());
    }

    public static JsonLayout createDefaultLayout() {
        return new JsonLayout(new DefaultConfiguration(), false, false, false, false, false, false, DEFAULT_HEADER, DEFAULT_FOOTER, StandardCharsets.UTF_8, true);
    }

    @Override
    public void toSerializable(LogEvent logEvent, Writer writer) {
        if (this.complete && this.eventCount > 0L) {
            writer.append(", ");
        }
        super.toSerializable(logEvent, writer);
    }
}

