/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.impl.DefaultLogEventFactory;
import org.apache.logging.log4j.core.layout.AbstractLayout;
import org.apache.logging.log4j.core.layout.AbstractStringLayout$Serializer;
import org.apache.logging.log4j.core.layout.Encoder;
import org.apache.logging.log4j.core.layout.StringBuilderEncoder;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.StringEncoder;
import org.apache.logging.log4j.util.PropertiesUtil;

public abstract class AbstractStringLayout
extends AbstractLayout<String>
implements StringLayout {
    protected static final int DEFAULT_STRING_BUILDER_SIZE = 1024;
    protected static final int MAX_STRING_BUILDER_SIZE = Math.max(1024, AbstractStringLayout.size("log4j.layoutStringBuilder.maxSize", 2048));
    private static final ThreadLocal<StringBuilder> threadLocal = new ThreadLocal();
    private Encoder<StringBuilder> textEncoder;
    private transient Charset charset;
    private final String charsetName;
    private final AbstractStringLayout$Serializer footerSerializer;
    private final AbstractStringLayout$Serializer headerSerializer;
    private final boolean useCustomEncoding;

    protected static StringBuilder getStringBuilder() {
        StringBuilder stringBuilder = threadLocal.get();
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(1024);
            threadLocal.set(stringBuilder);
        }
        AbstractStringLayout.trimToMaxSize(stringBuilder);
        stringBuilder.setLength(0);
        return stringBuilder;
    }

    private static boolean isPreJava8() {
        String string = System.getProperty("java.version");
        String[] stringArray = string.split("\\.");
        try {
            int n2 = Integer.parseInt(stringArray[1]);
            return n2 < 8;
        }
        catch (Exception exception) {
            return true;
        }
    }

    private static int size(String string, int n2) {
        return PropertiesUtil.getProperties().getIntegerProperty(string, n2);
    }

    protected static void trimToMaxSize(StringBuilder stringBuilder) {
        if (stringBuilder.length() > MAX_STRING_BUILDER_SIZE) {
            stringBuilder.setLength(MAX_STRING_BUILDER_SIZE);
            stringBuilder.trimToSize();
        }
    }

    protected AbstractStringLayout(Charset charset) {
        this(charset, (byte[])null, (byte[])null);
    }

    protected AbstractStringLayout(Charset charset, byte[] byArray, byte[] byArray2) {
        super(null, byArray, byArray2);
        this.headerSerializer = null;
        this.footerSerializer = null;
        this.charset = charset == null ? StandardCharsets.UTF_8 : charset;
        this.charsetName = this.charset.name();
        this.useCustomEncoding = AbstractStringLayout.isPreJava8() && (StandardCharsets.ISO_8859_1.equals(charset) || StandardCharsets.US_ASCII.equals(charset));
        this.textEncoder = Constants.ENABLE_DIRECT_ENCODERS ? new StringBuilderEncoder(this.charset) : null;
    }

    protected AbstractStringLayout(Configuration configuration, Charset charset, AbstractStringLayout$Serializer abstractStringLayout$Serializer, AbstractStringLayout$Serializer abstractStringLayout$Serializer2) {
        super(configuration, null, null);
        this.headerSerializer = abstractStringLayout$Serializer;
        this.footerSerializer = abstractStringLayout$Serializer2;
        this.charset = charset == null ? StandardCharsets.UTF_8 : charset;
        this.charsetName = this.charset.name();
        this.useCustomEncoding = AbstractStringLayout.isPreJava8() && (StandardCharsets.ISO_8859_1.equals(charset) || StandardCharsets.US_ASCII.equals(charset));
        this.textEncoder = Constants.ENABLE_DIRECT_ENCODERS ? new StringBuilderEncoder(this.charset) : null;
    }

    protected byte[] getBytes(String string) {
        if (this.useCustomEncoding) {
            return StringEncoder.encodeSingleByteChars(string);
        }
        try {
            return string.getBytes(this.charsetName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes(this.charset);
        }
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public String getContentType() {
        return "text/plain";
    }

    @Override
    public byte[] getFooter() {
        return this.serializeToBytes(this.footerSerializer, super.getFooter());
    }

    public AbstractStringLayout$Serializer getFooterSerializer() {
        return this.footerSerializer;
    }

    @Override
    public byte[] getHeader() {
        return this.serializeToBytes(this.headerSerializer, super.getHeader());
    }

    public AbstractStringLayout$Serializer getHeaderSerializer() {
        return this.headerSerializer;
    }

    private DefaultLogEventFactory getLogEventFactory() {
        return DefaultLogEventFactory.getInstance();
    }

    protected Encoder<StringBuilder> getStringBuilderEncoder() {
        if (this.textEncoder == null) {
            this.textEncoder = new StringBuilderEncoder(this.getCharset());
        }
        return this.textEncoder;
    }

    protected byte[] serializeToBytes(AbstractStringLayout$Serializer abstractStringLayout$Serializer, byte[] byArray) {
        String string = this.serializeToString(abstractStringLayout$Serializer);
        if (abstractStringLayout$Serializer == null) {
            return byArray;
        }
        return StringEncoder.toBytes(string, this.getCharset());
    }

    protected String serializeToString(AbstractStringLayout$Serializer abstractStringLayout$Serializer) {
        if (abstractStringLayout$Serializer == null) {
            return null;
        }
        LoggerConfig loggerConfig = this.getConfiguration().getRootLogger();
        LogEvent logEvent = this.getLogEventFactory().createEvent(loggerConfig.getName(), null, "", loggerConfig.getLevel(), null, null, null);
        return abstractStringLayout$Serializer.toSerializable(logEvent);
    }

    @Override
    public byte[] toByteArray(LogEvent logEvent) {
        return this.getBytes((String)this.toSerializable(logEvent));
    }
}

