/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.status.StatusLogger;

public abstract class AbstractLayout<T extends Serializable>
implements Layout<T> {
    protected static final Logger LOGGER = StatusLogger.getLogger();
    protected final Configuration configuration;
    protected long eventCount;
    protected final byte[] footer;
    protected final byte[] header;

    @Deprecated
    public AbstractLayout(byte[] byArray, byte[] byArray2) {
        this(null, byArray, byArray2);
    }

    public AbstractLayout(Configuration configuration, byte[] byArray, byte[] byArray2) {
        this.configuration = configuration;
        this.header = byArray;
        this.footer = byArray2;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Map<String, String> getContentFormat() {
        return new HashMap<String, String>();
    }

    @Override
    public byte[] getFooter() {
        return this.footer;
    }

    @Override
    public byte[] getHeader() {
        return this.header;
    }

    protected void markEvent() {
        ++this.eventCount;
    }

    @Override
    public void encode(LogEvent logEvent, ByteBufferDestination byteBufferDestination) {
        byte[] byArray = this.toByteArray(logEvent);
        AbstractLayout.writeTo(byArray, 0, byArray.length, byteBufferDestination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTo(byte[] byArray, int n2, int n3, ByteBufferDestination byteBufferDestination) {
        int n4 = 0;
        ByteBufferDestination byteBufferDestination2 = byteBufferDestination;
        synchronized (byteBufferDestination2) {
            ByteBuffer byteBuffer = byteBufferDestination.getByteBuffer();
            do {
                if (n3 > byteBuffer.remaining()) {
                    byteBuffer = byteBufferDestination.drain(byteBuffer);
                }
                n4 = Math.min(n3, byteBuffer.remaining());
                byteBuffer.put(byArray, n2, n4);
                n2 += n4;
            } while ((n3 -= n4) > 0);
        }
    }
}

