/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.layout.AbstractStringLayout$Serializer;
import org.apache.logging.log4j.core.util.StringBuilderWriter;

abstract class AbstractJacksonLayout
extends AbstractStringLayout {
    protected static final String DEFAULT_EOL = "\r\n";
    protected static final String COMPACT_EOL = "";
    protected final String eol;
    protected final ObjectWriter objectWriter;
    protected final boolean compact;
    protected final boolean complete;

    protected AbstractJacksonLayout(Configuration configuration, ObjectWriter objectWriter, Charset charset, boolean bl2, boolean bl3, boolean bl4, AbstractStringLayout$Serializer abstractStringLayout$Serializer, AbstractStringLayout$Serializer abstractStringLayout$Serializer2) {
        super(configuration, charset, abstractStringLayout$Serializer, abstractStringLayout$Serializer2);
        this.objectWriter = objectWriter;
        this.compact = bl2;
        this.complete = bl3;
        this.eol = bl2 && !bl4 ? COMPACT_EOL : DEFAULT_EOL;
    }

    @Override
    public String toSerializable(LogEvent logEvent) {
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter();
        try {
            this.toSerializable(logEvent, stringBuilderWriter);
            return stringBuilderWriter.toString();
        }
        catch (IOException iOException) {
            LOGGER.error(iOException);
            return COMPACT_EOL;
        }
    }

    private static LogEvent convertMutableToLog4jEvent(LogEvent logEvent) {
        return logEvent instanceof MutableLogEvent ? ((MutableLogEvent)logEvent).createMemento() : logEvent;
    }

    public void toSerializable(LogEvent logEvent, Writer writer) {
        this.objectWriter.writeValue(writer, (Object)AbstractJacksonLayout.convertMutableToLog4jEvent(logEvent));
        writer.write(this.eol);
        this.markEvent();
    }
}

