/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.ThreadContext$ContextStack;
import org.apache.logging.log4j.core.ContextDataInjector;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.ContextDataInjectorFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent$Builder;
import org.apache.logging.log4j.core.impl.Log4jLogEvent$LogEventProxy;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.ClockFactory;
import org.apache.logging.log4j.core.util.DummyNanoClock;
import org.apache.logging.log4j.core.util.NanoClock;
import org.apache.logging.log4j.message.LoggerNameAwareMessage;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ReusableMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.message.TimestampMessage;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.StringMap;

public class Log4jLogEvent
implements LogEvent {
    private static final long serialVersionUID = -8393305700508709443L;
    private static final Clock CLOCK = ClockFactory.getClock();
    private static volatile NanoClock nanoClock = new DummyNanoClock();
    private static final ContextDataInjector CONTEXT_DATA_INJECTOR = ContextDataInjectorFactory.createInjector();
    private final String loggerFqcn;
    private final Marker marker;
    private final Level level;
    private final String loggerName;
    private Message message;
    private final long timeMillis;
    private final transient Throwable thrown;
    private ThrowableProxy thrownProxy;
    private final StringMap contextData;
    private final ThreadContext$ContextStack contextStack;
    private long threadId;
    private String threadName;
    private int threadPriority;
    private StackTraceElement source;
    private boolean includeLocation;
    private boolean endOfBatch = false;
    private final transient long nanoTime;

    public static Log4jLogEvent$Builder newBuilder() {
        return new Log4jLogEvent$Builder();
    }

    public Log4jLogEvent() {
        this("", null, "", null, null, null, null, null, null, 0L, null, 0, null, CLOCK.currentTimeMillis(), nanoClock.nanoTime());
    }

    @Deprecated
    public Log4jLogEvent(long l2) {
        this("", null, "", null, null, null, null, null, null, 0L, null, 0, null, l2, nanoClock.nanoTime());
    }

    @Deprecated
    public Log4jLogEvent(String string, Marker marker, String string2, Level level, Message message, Throwable throwable) {
        this(string, marker, string2, level, message, null, throwable);
    }

    public Log4jLogEvent(String string, Marker marker, String string2, Level level, Message message, List<Property> list, Throwable throwable) {
        this(string, marker, string2, level, message, throwable, null, Log4jLogEvent.createContextData(list), ThreadContext.getDepth() == 0 ? null : ThreadContext.cloneStack(), 0L, null, 0, null, message instanceof TimestampMessage ? ((TimestampMessage)((Object)message)).getTimestamp() : CLOCK.currentTimeMillis(), nanoClock.nanoTime());
    }

    @Deprecated
    public Log4jLogEvent(String string, Marker marker, String string2, Level level, Message message, Throwable throwable, Map<String, String> map, ThreadContext$ContextStack threadContext$ContextStack, String string3, StackTraceElement stackTraceElement, long l2) {
        this(string, marker, string2, level, message, throwable, null, Log4jLogEvent.createContextData(map), threadContext$ContextStack, 0L, string3, 0, stackTraceElement, l2, nanoClock.nanoTime());
    }

    @Deprecated
    public static Log4jLogEvent createEvent(String string, Marker marker, String string2, Level level, Message message, Throwable throwable, ThrowableProxy throwableProxy, Map<String, String> map, ThreadContext$ContextStack threadContext$ContextStack, String string3, StackTraceElement stackTraceElement, long l2) {
        Log4jLogEvent log4jLogEvent = new Log4jLogEvent(string, marker, string2, level, message, throwable, throwableProxy, Log4jLogEvent.createContextData(map), threadContext$ContextStack, 0L, string3, 0, stackTraceElement, l2, nanoClock.nanoTime());
        return log4jLogEvent;
    }

    private Log4jLogEvent(String string, Marker marker, String string2, Level level, Message message, Throwable throwable, ThrowableProxy throwableProxy, StringMap stringMap, ThreadContext$ContextStack threadContext$ContextStack, long l2, String string3, int n2, StackTraceElement stackTraceElement, long l3, long l4) {
        this.loggerName = string;
        this.marker = marker;
        this.loggerFqcn = string2;
        this.level = level == null ? Level.OFF : level;
        this.message = message;
        this.thrown = throwable;
        this.thrownProxy = throwableProxy;
        this.contextData = stringMap == null ? ContextDataFactory.createContextData() : stringMap;
        this.contextStack = threadContext$ContextStack == null ? ThreadContext.EMPTY_STACK : threadContext$ContextStack;
        this.timeMillis = message instanceof TimestampMessage ? ((TimestampMessage)((Object)message)).getTimestamp() : l3;
        this.threadId = l2;
        this.threadName = string3;
        this.threadPriority = n2;
        this.source = stackTraceElement;
        if (message != null && message instanceof LoggerNameAwareMessage) {
            ((LoggerNameAwareMessage)((Object)message)).setLoggerName(string);
        }
        this.nanoTime = l4;
    }

    private static StringMap createContextData(Map<String, String> map) {
        StringMap stringMap = ContextDataFactory.createContextData();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                stringMap.putValue(entry.getKey(), entry.getValue());
            }
        }
        return stringMap;
    }

    private static StringMap createContextData(List<Property> list) {
        StringMap stringMap = ContextDataFactory.createContextData();
        return CONTEXT_DATA_INJECTOR.injectContextData(list, stringMap);
    }

    public static NanoClock getNanoClock() {
        return nanoClock;
    }

    public static void setNanoClock(NanoClock nanoClock) {
        Log4jLogEvent.nanoClock = Objects.requireNonNull(nanoClock, "NanoClock must be non-null");
        StatusLogger.getLogger().trace("Using {} for nanosecond timestamps.", (Object)nanoClock.getClass().getSimpleName());
    }

    public Log4jLogEvent$Builder asBuilder() {
        return new Log4jLogEvent$Builder(this);
    }

    @Override
    public Log4jLogEvent toImmutable() {
        if (this.getMessage() instanceof ReusableMessage) {
            this.makeMessageImmutable();
        }
        return this;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public String getLoggerName() {
        return this.loggerName;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    public void makeMessageImmutable() {
        this.message = new SimpleMessage(this.message.getFormattedMessage());
    }

    @Override
    public long getThreadId() {
        if (this.threadId == 0L) {
            this.threadId = Thread.currentThread().getId();
        }
        return this.threadId;
    }

    @Override
    public String getThreadName() {
        if (this.threadName == null) {
            this.threadName = Thread.currentThread().getName();
        }
        return this.threadName;
    }

    @Override
    public int getThreadPriority() {
        if (this.threadPriority == 0) {
            this.threadPriority = Thread.currentThread().getPriority();
        }
        return this.threadPriority;
    }

    @Override
    public long getTimeMillis() {
        return this.timeMillis;
    }

    @Override
    public Throwable getThrown() {
        return this.thrown;
    }

    @Override
    public ThrowableProxy getThrownProxy() {
        if (this.thrownProxy == null && this.thrown != null) {
            this.thrownProxy = new ThrowableProxy(this.thrown);
        }
        return this.thrownProxy;
    }

    @Override
    public Marker getMarker() {
        return this.marker;
    }

    @Override
    public String getLoggerFqcn() {
        return this.loggerFqcn;
    }

    @Override
    public ReadOnlyStringMap getContextData() {
        return this.contextData;
    }

    @Override
    public Map<String, String> getContextMap() {
        return this.contextData.toMap();
    }

    @Override
    public ThreadContext$ContextStack getContextStack() {
        return this.contextStack;
    }

    @Override
    public StackTraceElement getSource() {
        if (this.source != null) {
            return this.source;
        }
        if (this.loggerFqcn == null || !this.includeLocation) {
            return null;
        }
        this.source = Log4jLogEvent.calcLocation(this.loggerFqcn);
        return this.source;
    }

    public static StackTraceElement calcLocation(String string) {
        if (string == null) {
            return null;
        }
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        StackTraceElement stackTraceElement = null;
        for (int i2 = stackTraceElementArray.length - 1; i2 > 0; --i2) {
            String string2 = stackTraceElementArray[i2].getClassName();
            if (string.equals(string2)) {
                return stackTraceElement;
            }
            stackTraceElement = stackTraceElementArray[i2];
        }
        return null;
    }

    @Override
    public boolean isIncludeLocation() {
        return this.includeLocation;
    }

    @Override
    public void setIncludeLocation(boolean bl2) {
        this.includeLocation = bl2;
    }

    @Override
    public boolean isEndOfBatch() {
        return this.endOfBatch;
    }

    @Override
    public void setEndOfBatch(boolean bl2) {
        this.endOfBatch = bl2;
    }

    @Override
    public long getNanoTime() {
        return this.nanoTime;
    }

    protected Object writeReplace() {
        this.getThrownProxy();
        return new Log4jLogEvent$LogEventProxy(this, this.includeLocation);
    }

    public static Serializable serialize(LogEvent logEvent, boolean bl2) {
        if (logEvent instanceof Log4jLogEvent) {
            logEvent.getThrownProxy();
            return new Log4jLogEvent$LogEventProxy((Log4jLogEvent)logEvent, bl2);
        }
        return new Log4jLogEvent$LogEventProxy(logEvent, bl2);
    }

    public static Serializable serialize(Log4jLogEvent log4jLogEvent, boolean bl2) {
        log4jLogEvent.getThrownProxy();
        return new Log4jLogEvent$LogEventProxy(log4jLogEvent, bl2);
    }

    public static boolean canDeserialize(Serializable serializable) {
        return serializable instanceof Log4jLogEvent$LogEventProxy;
    }

    public static Log4jLogEvent deserialize(Serializable serializable) {
        Objects.requireNonNull(serializable, "Event cannot be null");
        if (serializable instanceof Log4jLogEvent$LogEventProxy) {
            Log4jLogEvent$LogEventProxy log4jLogEvent$LogEventProxy = (Log4jLogEvent$LogEventProxy)serializable;
            Log4jLogEvent log4jLogEvent = new Log4jLogEvent(Log4jLogEvent$LogEventProxy.access$900(log4jLogEvent$LogEventProxy), Log4jLogEvent$LogEventProxy.access$1000(log4jLogEvent$LogEventProxy), Log4jLogEvent$LogEventProxy.access$1100(log4jLogEvent$LogEventProxy), Log4jLogEvent$LogEventProxy.access$1200(log4jLogEvent$LogEventProxy), Log4jLogEvent$LogEventProxy.access$1300(log4jLogEvent$LogEventProxy), Log4jLogEvent$LogEventProxy.access$1400(log4jLogEvent$LogEventProxy), Log4jLogEvent$LogEventProxy.access$1500(log4jLogEvent$LogEventProxy), Log4jLogEvent$LogEventProxy.access$1600(log4jLogEvent$LogEventProxy), Log4jLogEvent$LogEventProxy.access$1700(log4jLogEvent$LogEventProxy), Log4jLogEvent$LogEventProxy.access$1800(log4jLogEvent$LogEventProxy), Log4jLogEvent$LogEventProxy.access$1900(log4jLogEvent$LogEventProxy), Log4jLogEvent$LogEventProxy.access$2000(log4jLogEvent$LogEventProxy), Log4jLogEvent$LogEventProxy.access$2100(log4jLogEvent$LogEventProxy), Log4jLogEvent$LogEventProxy.access$2200(log4jLogEvent$LogEventProxy), Log4jLogEvent$LogEventProxy.access$2300(log4jLogEvent$LogEventProxy));
            log4jLogEvent.setEndOfBatch(Log4jLogEvent$LogEventProxy.access$2400(log4jLogEvent$LogEventProxy));
            log4jLogEvent.setIncludeLocation(Log4jLogEvent$LogEventProxy.access$2500(log4jLogEvent$LogEventProxy));
            return log4jLogEvent;
        }
        throw new IllegalArgumentException("Event is not a serialized LogEvent: " + serializable.toString());
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new InvalidObjectException("Proxy required");
    }

    public LogEvent createMemento() {
        return Log4jLogEvent.createMemento(this);
    }

    public static LogEvent createMemento(LogEvent logEvent) {
        return new Log4jLogEvent$Builder(logEvent).build();
    }

    public static Log4jLogEvent createMemento(LogEvent logEvent, boolean bl2) {
        return Log4jLogEvent.deserialize(Log4jLogEvent.serialize(logEvent, bl2));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.loggerName.isEmpty() ? "root" : this.loggerName;
        stringBuilder.append("Logger=").append(string);
        stringBuilder.append(" Level=").append(this.level.name());
        stringBuilder.append(" Message=").append(this.message == null ? null : this.message.getFormattedMessage());
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Log4jLogEvent log4jLogEvent = (Log4jLogEvent)object;
        if (this.endOfBatch != log4jLogEvent.endOfBatch) {
            return false;
        }
        if (this.includeLocation != log4jLogEvent.includeLocation) {
            return false;
        }
        if (this.timeMillis != log4jLogEvent.timeMillis) {
            return false;
        }
        if (this.nanoTime != log4jLogEvent.nanoTime) {
            return false;
        }
        if (this.loggerFqcn != null ? !this.loggerFqcn.equals(log4jLogEvent.loggerFqcn) : log4jLogEvent.loggerFqcn != null) {
            return false;
        }
        if (this.level != null ? !this.level.equals(log4jLogEvent.level) : log4jLogEvent.level != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(log4jLogEvent.source) : log4jLogEvent.source != null) {
            return false;
        }
        if (this.marker != null ? !this.marker.equals(log4jLogEvent.marker) : log4jLogEvent.marker != null) {
            return false;
        }
        if (this.contextData != null ? !this.contextData.equals(log4jLogEvent.contextData) : log4jLogEvent.contextData != null) {
            return false;
        }
        if (!this.message.equals(log4jLogEvent.message)) {
            return false;
        }
        if (!this.loggerName.equals(log4jLogEvent.loggerName)) {
            return false;
        }
        if (this.contextStack != null ? !this.contextStack.equals(log4jLogEvent.contextStack) : log4jLogEvent.contextStack != null) {
            return false;
        }
        if (this.threadId != log4jLogEvent.threadId) {
            return false;
        }
        if (this.threadName != null ? !this.threadName.equals(log4jLogEvent.threadName) : log4jLogEvent.threadName != null) {
            return false;
        }
        if (this.threadPriority != log4jLogEvent.threadPriority) {
            return false;
        }
        if (this.thrown != null ? !this.thrown.equals(log4jLogEvent.thrown) : log4jLogEvent.thrown != null) {
            return false;
        }
        return !(this.thrownProxy != null ? !this.thrownProxy.equals(log4jLogEvent.thrownProxy) : log4jLogEvent.thrownProxy != null);
    }

    public int hashCode() {
        int n2 = this.loggerFqcn != null ? this.loggerFqcn.hashCode() : 0;
        n2 = 31 * n2 + (this.marker != null ? this.marker.hashCode() : 0);
        n2 = 31 * n2 + (this.level != null ? this.level.hashCode() : 0);
        n2 = 31 * n2 + this.loggerName.hashCode();
        n2 = 31 * n2 + this.message.hashCode();
        n2 = 31 * n2 + (int)(this.timeMillis ^ this.timeMillis >>> 32);
        n2 = 31 * n2 + (int)(this.nanoTime ^ this.nanoTime >>> 32);
        n2 = 31 * n2 + (this.thrown != null ? this.thrown.hashCode() : 0);
        n2 = 31 * n2 + (this.thrownProxy != null ? this.thrownProxy.hashCode() : 0);
        n2 = 31 * n2 + (this.contextData != null ? this.contextData.hashCode() : 0);
        n2 = 31 * n2 + (this.contextStack != null ? this.contextStack.hashCode() : 0);
        n2 = 31 * n2 + (int)(this.threadId ^ this.threadId >>> 32);
        n2 = 31 * n2 + (this.threadName != null ? this.threadName.hashCode() : 0);
        n2 = 31 * n2 + (this.threadPriority ^ this.threadPriority >>> 32);
        n2 = 31 * n2 + (this.source != null ? this.source.hashCode() : 0);
        n2 = 31 * n2 + (this.includeLocation ? 1 : 0);
        n2 = 31 * n2 + (this.endOfBatch ? 1 : 0);
        return n2;
    }

    static /* synthetic */ Clock access$000() {
        return CLOCK;
    }

    static /* synthetic */ StringMap access$100(List list) {
        return Log4jLogEvent.createContextData(list);
    }

    static /* synthetic */ StringMap access$200(Log4jLogEvent log4jLogEvent) {
        return log4jLogEvent.contextData;
    }

    static /* synthetic */ ThrowableProxy access$300(Log4jLogEvent log4jLogEvent) {
        return log4jLogEvent.thrownProxy;
    }

    static /* synthetic */ StackTraceElement access$400(Log4jLogEvent log4jLogEvent) {
        return log4jLogEvent.source;
    }

    static /* synthetic */ long access$500(Log4jLogEvent log4jLogEvent) {
        return log4jLogEvent.threadId;
    }

    static /* synthetic */ String access$600(Log4jLogEvent log4jLogEvent) {
        return log4jLogEvent.threadName;
    }

    static /* synthetic */ int access$700(Log4jLogEvent log4jLogEvent) {
        return log4jLogEvent.threadPriority;
    }

    static /* synthetic */ String access$2600(Log4jLogEvent log4jLogEvent) {
        return log4jLogEvent.loggerFqcn;
    }

    static /* synthetic */ Marker access$2700(Log4jLogEvent log4jLogEvent) {
        return log4jLogEvent.marker;
    }

    static /* synthetic */ Level access$2800(Log4jLogEvent log4jLogEvent) {
        return log4jLogEvent.level;
    }

    static /* synthetic */ String access$2900(Log4jLogEvent log4jLogEvent) {
        return log4jLogEvent.loggerName;
    }

    static /* synthetic */ Message access$3000(Log4jLogEvent log4jLogEvent) {
        return log4jLogEvent.message;
    }

    static /* synthetic */ long access$3100(Log4jLogEvent log4jLogEvent) {
        return log4jLogEvent.timeMillis;
    }

    static /* synthetic */ Throwable access$3200(Log4jLogEvent log4jLogEvent) {
        return log4jLogEvent.thrown;
    }

    static /* synthetic */ ThreadContext$ContextStack access$3300(Log4jLogEvent log4jLogEvent) {
        return log4jLogEvent.contextStack;
    }

    static /* synthetic */ boolean access$3400(Log4jLogEvent log4jLogEvent) {
        return log4jLogEvent.endOfBatch;
    }

    static /* synthetic */ long access$3500(Log4jLogEvent log4jLogEvent) {
        return log4jLogEvent.nanoTime;
    }
}

