/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.impl;

import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.ThreadContext$ContextStack;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.async.RingBufferLogEvent;
import org.apache.logging.log4j.core.impl.ContextDataFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.impl.MutableLogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.util.StringMap;

public class Log4jLogEvent$Builder
implements Builder<LogEvent> {
    private String loggerFqcn;
    private Marker marker;
    private Level level;
    private String loggerName;
    private Message message;
    private Throwable thrown;
    private long timeMillis = Log4jLogEvent.access$000().currentTimeMillis();
    private ThrowableProxy thrownProxy;
    private StringMap contextData = Log4jLogEvent.access$100(null);
    private ThreadContext$ContextStack contextStack = ThreadContext.getImmutableStack();
    private long threadId;
    private String threadName;
    private int threadPriority;
    private StackTraceElement source;
    private boolean includeLocation;
    private boolean endOfBatch = false;
    private long nanoTime;

    public Log4jLogEvent$Builder() {
    }

    public Log4jLogEvent$Builder(LogEvent logEvent) {
        Objects.requireNonNull(logEvent);
        if (logEvent instanceof RingBufferLogEvent) {
            ((RingBufferLogEvent)logEvent).initializeBuilder(this);
            return;
        }
        if (logEvent instanceof MutableLogEvent) {
            ((MutableLogEvent)logEvent).initializeBuilder(this);
            return;
        }
        this.loggerFqcn = logEvent.getLoggerFqcn();
        this.marker = logEvent.getMarker();
        this.level = logEvent.getLevel();
        this.loggerName = logEvent.getLoggerName();
        this.message = logEvent.getMessage();
        this.timeMillis = logEvent.getTimeMillis();
        this.thrown = logEvent.getThrown();
        this.contextStack = logEvent.getContextStack();
        this.includeLocation = logEvent.isIncludeLocation();
        this.endOfBatch = logEvent.isEndOfBatch();
        this.nanoTime = logEvent.getNanoTime();
        if (logEvent instanceof Log4jLogEvent) {
            Log4jLogEvent log4jLogEvent = (Log4jLogEvent)logEvent;
            this.contextData = Log4jLogEvent.access$200(log4jLogEvent);
            this.thrownProxy = Log4jLogEvent.access$300(log4jLogEvent);
            this.source = Log4jLogEvent.access$400(log4jLogEvent);
            this.threadId = Log4jLogEvent.access$500(log4jLogEvent);
            this.threadName = Log4jLogEvent.access$600(log4jLogEvent);
            this.threadPriority = Log4jLogEvent.access$700(log4jLogEvent);
        } else {
            if (logEvent.getContextData() instanceof StringMap) {
                this.contextData = (StringMap)logEvent.getContextData();
            } else {
                if (this.contextData.isFrozen()) {
                    this.contextData = ContextDataFactory.createContextData();
                } else {
                    this.contextData.clear();
                }
                this.contextData.putAll(logEvent.getContextData());
            }
            this.thrownProxy = logEvent.getThrownProxy();
            this.source = logEvent.getSource();
            this.threadId = logEvent.getThreadId();
            this.threadName = logEvent.getThreadName();
            this.threadPriority = logEvent.getThreadPriority();
        }
    }

    public Log4jLogEvent$Builder setLevel(Level level) {
        this.level = level;
        return this;
    }

    public Log4jLogEvent$Builder setLoggerFqcn(String string) {
        this.loggerFqcn = string;
        return this;
    }

    public Log4jLogEvent$Builder setLoggerName(String string) {
        this.loggerName = string;
        return this;
    }

    public Log4jLogEvent$Builder setMarker(Marker marker) {
        this.marker = marker;
        return this;
    }

    public Log4jLogEvent$Builder setMessage(Message message) {
        this.message = message;
        return this;
    }

    public Log4jLogEvent$Builder setThrown(Throwable throwable) {
        this.thrown = throwable;
        return this;
    }

    public Log4jLogEvent$Builder setTimeMillis(long l2) {
        this.timeMillis = l2;
        return this;
    }

    public Log4jLogEvent$Builder setThrownProxy(ThrowableProxy throwableProxy) {
        this.thrownProxy = throwableProxy;
        return this;
    }

    @Deprecated
    public Log4jLogEvent$Builder setContextMap(Map<String, String> map) {
        this.contextData = ContextDataFactory.createContextData();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.contextData.putValue(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public Log4jLogEvent$Builder setContextData(StringMap stringMap) {
        this.contextData = stringMap;
        return this;
    }

    public Log4jLogEvent$Builder setContextStack(ThreadContext$ContextStack threadContext$ContextStack) {
        this.contextStack = threadContext$ContextStack;
        return this;
    }

    public Log4jLogEvent$Builder setThreadId(long l2) {
        this.threadId = l2;
        return this;
    }

    public Log4jLogEvent$Builder setThreadName(String string) {
        this.threadName = string;
        return this;
    }

    public Log4jLogEvent$Builder setThreadPriority(int n2) {
        this.threadPriority = n2;
        return this;
    }

    public Log4jLogEvent$Builder setSource(StackTraceElement stackTraceElement) {
        this.source = stackTraceElement;
        return this;
    }

    public Log4jLogEvent$Builder setIncludeLocation(boolean bl2) {
        this.includeLocation = bl2;
        return this;
    }

    public Log4jLogEvent$Builder setEndOfBatch(boolean bl2) {
        this.endOfBatch = bl2;
        return this;
    }

    public Log4jLogEvent$Builder setNanoTime(long l2) {
        this.nanoTime = l2;
        return this;
    }

    @Override
    public Log4jLogEvent build() {
        Log4jLogEvent log4jLogEvent = new Log4jLogEvent(this.loggerName, this.marker, this.loggerFqcn, this.level, this.message, this.thrown, this.thrownProxy, this.contextData, this.contextStack, this.threadId, this.threadName, this.threadPriority, this.source, this.timeMillis, this.nanoTime);
        log4jLogEvent.setIncludeLocation(this.includeLocation);
        log4jLogEvent.setEndOfBatch(this.endOfBatch);
        return log4jLogEvent;
    }
}

