/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.filter;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.DelayQueue;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Filter$Result;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.filter.BurstFilter$1;
import org.apache.logging.log4j.core.filter.BurstFilter$Builder;
import org.apache.logging.log4j.core.filter.BurstFilter$LogDelay;
import org.apache.logging.log4j.message.Message;

@Plugin(name="BurstFilter", category="Core", elementType="filter", printObject=true)
public final class BurstFilter
extends AbstractFilter {
    private static final long NANOS_IN_SECONDS = 1000000000L;
    private static final int DEFAULT_RATE = 10;
    private static final int DEFAULT_RATE_MULTIPLE = 100;
    private static final int HASH_SHIFT = 32;
    private final Level level;
    private final long burstInterval;
    private final DelayQueue<BurstFilter$LogDelay> history = new DelayQueue();
    private final Queue<BurstFilter$LogDelay> available = new ConcurrentLinkedQueue<BurstFilter$LogDelay>();

    static BurstFilter$LogDelay createLogDelay(long l2) {
        return new BurstFilter$LogDelay(l2);
    }

    private BurstFilter(Level level, float f2, long l2, Filter$Result filter$Result, Filter$Result filter$Result2) {
        super(filter$Result, filter$Result2);
        this.level = level;
        this.burstInterval = (long)(1.0E9f * ((float)l2 / f2));
        int n2 = 0;
        while ((long)n2 < l2) {
            this.available.add(BurstFilter.createLogDelay(0L));
            ++n2;
        }
    }

    @Override
    public Filter$Result filter(Logger logger, Level level, Marker marker, String string, Object ... objectArray) {
        return this.filter(level);
    }

    @Override
    public Filter$Result filter(Logger logger, Level level, Marker marker, Object object, Throwable throwable) {
        return this.filter(level);
    }

    @Override
    public Filter$Result filter(Logger logger, Level level, Marker marker, Message message, Throwable throwable) {
        return this.filter(level);
    }

    @Override
    public Filter$Result filter(LogEvent logEvent) {
        return this.filter(logEvent.getLevel());
    }

    @Override
    public Filter$Result filter(Logger logger, Level level, Marker marker, String string, Object object) {
        return this.filter(level);
    }

    @Override
    public Filter$Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2) {
        return this.filter(level);
    }

    @Override
    public Filter$Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3) {
        return this.filter(level);
    }

    @Override
    public Filter$Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4) {
        return this.filter(level);
    }

    @Override
    public Filter$Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5) {
        return this.filter(level);
    }

    @Override
    public Filter$Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        return this.filter(level);
    }

    @Override
    public Filter$Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        return this.filter(level);
    }

    @Override
    public Filter$Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        return this.filter(level);
    }

    @Override
    public Filter$Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9) {
        return this.filter(level);
    }

    @Override
    public Filter$Result filter(Logger logger, Level level, Marker marker, String string, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Object object9, Object object10) {
        return this.filter(level);
    }

    private Filter$Result filter(Level level) {
        if (this.level.isMoreSpecificThan(level)) {
            BurstFilter$LogDelay burstFilter$LogDelay = (BurstFilter$LogDelay)this.history.poll();
            while (burstFilter$LogDelay != null) {
                this.available.add(burstFilter$LogDelay);
                burstFilter$LogDelay = (BurstFilter$LogDelay)this.history.poll();
            }
            burstFilter$LogDelay = this.available.poll();
            if (burstFilter$LogDelay != null) {
                burstFilter$LogDelay.setDelay(this.burstInterval);
                this.history.add(burstFilter$LogDelay);
                return this.onMatch;
            }
            return this.onMismatch;
        }
        return this.onMatch;
    }

    public int getAvailable() {
        return this.available.size();
    }

    public void clear() {
        for (BurstFilter$LogDelay burstFilter$LogDelay : this.history) {
            this.history.remove(burstFilter$LogDelay);
            this.available.add(burstFilter$LogDelay);
        }
    }

    @Override
    public String toString() {
        return "level=" + this.level.toString() + ", interval=" + this.burstInterval + ", max=" + this.history.size();
    }

    @PluginBuilderFactory
    public static BurstFilter$Builder newBuilder() {
        return new BurstFilter$Builder();
    }

    /* synthetic */ BurstFilter(Level level, float f2, long l2, Filter$Result filter$Result, Filter$Result filter$Result2, BurstFilter$1 burstFilter$1) {
        this(level, f2, l2, filter$Result, filter$Result2);
    }
}

