/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.processor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.processor.PluginCache;
import org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;
import org.apache.logging.log4j.core.config.plugins.processor.PluginProcessor$PluginAliasesElementVisitor;
import org.apache.logging.log4j.core.config.plugins.processor.PluginProcessor$PluginElementVisitor;

@SupportedAnnotationTypes(value={"org.apache.logging.log4j.core.config.plugins.*"})
public class PluginProcessor
extends AbstractProcessor {
    public static final String PLUGIN_CACHE_FILE = "META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat";
    private final PluginCache pluginCache = new PluginCache();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        try {
            Set<? extends Element> set2 = roundEnvironment.getElementsAnnotatedWith(Plugin.class);
            if (set2.isEmpty()) {
                return false;
            }
            this.collectPlugins(set2);
            this.writeCacheFile(set2.toArray(new Element[set2.size()]));
            return true;
        }
        catch (IOException iOException) {
            this.error(iOException.getMessage());
            return false;
        }
    }

    private void error(CharSequence charSequence) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, charSequence);
    }

    private void collectPlugins(Iterable<? extends Element> iterable) {
        Elements elements = this.processingEnv.getElementUtils();
        PluginProcessor$PluginElementVisitor pluginProcessor$PluginElementVisitor = new PluginProcessor$PluginElementVisitor(elements, null);
        PluginProcessor$PluginAliasesElementVisitor pluginProcessor$PluginAliasesElementVisitor = new PluginProcessor$PluginAliasesElementVisitor(elements, null);
        for (Element element : iterable) {
            Plugin plugin = element.getAnnotation(Plugin.class);
            if (plugin == null) continue;
            PluginEntry pluginEntry = element.accept(pluginProcessor$PluginElementVisitor, plugin);
            Map<String, PluginEntry> map = this.pluginCache.getCategory(pluginEntry.getCategory());
            map.put(pluginEntry.getKey(), pluginEntry);
            Collection<PluginEntry> collection = element.accept(pluginProcessor$PluginAliasesElementVisitor, plugin);
            for (PluginEntry pluginEntry2 : collection) {
                map.put(pluginEntry2.getKey(), pluginEntry2);
            }
        }
    }

    private void writeCacheFile(Element ... elementArray) {
        FileObject fileObject = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", PLUGIN_CACHE_FILE, elementArray);
        try (OutputStream outputStream = fileObject.openOutputStream();){
            this.pluginCache.writeCache(outputStream);
        }
    }
}

