/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.plugins.convert;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverter;
import org.apache.logging.log4j.core.config.plugins.convert.TypeConverterRegistry;
import org.apache.logging.log4j.status.StatusLogger;

public final class TypeConverters {
    public static final String CATEGORY = "TypeConverter";
    private static final Logger LOGGER = StatusLogger.getLogger();

    public static <T> T convert(String string, Class<? extends T> clazz, Object object) {
        TypeConverter<?> typeConverter = TypeConverterRegistry.getInstance().findCompatibleConverter(clazz);
        if (string == null) {
            return (T)TypeConverters.parseDefaultValue(typeConverter, object);
        }
        try {
            return (T)typeConverter.convert(string);
        }
        catch (Exception exception) {
            LOGGER.warn("Error while converting string [{}] to type [{}]. Using default value [{}].", (Object)string, (Object)clazz, object, (Object)exception);
            return (T)TypeConverters.parseDefaultValue(typeConverter, object);
        }
    }

    private static <T> T parseDefaultValue(TypeConverter<T> typeConverter, Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof String)) {
            return (T)object;
        }
        try {
            return typeConverter.convert((String)object);
        }
        catch (Exception exception) {
            LOGGER.debug("Can't parse default value [{}] for type [{}].", object, (Object)typeConverter.getClass(), (Object)exception);
            return null;
        }
    }
}

