/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.AbstractConfiguration;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.ConfiguratonFileWatcher;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.config.json.JsonConfiguration$ErrorType;
import org.apache.logging.log4j.core.config.json.JsonConfiguration$Status;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.config.plugins.util.ResolverUtil;
import org.apache.logging.log4j.core.config.status.StatusConfiguration;
import org.apache.logging.log4j.core.util.Patterns;

public class JsonConfiguration
extends AbstractConfiguration
implements Reconfigurable {
    private static final String[] VERBOSE_CLASSES = new String[]{ResolverUtil.class.getName()};
    private final List<JsonConfiguration$Status> status = new ArrayList<JsonConfiguration$Status>();
    private JsonNode root;

    public JsonConfiguration(LoggerContext loggerContext, ConfigurationSource configurationSource) {
        super(loggerContext, configurationSource);
        File file = configurationSource.getFile();
        try {
            byte[] byArray;
            InputStream inputStream = configurationSource.getInputStream();
            Object object = null;
            try {
                byArray = JsonConfiguration.toByteArray(inputStream);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (object != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
            inputStream = new ByteArrayInputStream(byArray);
            this.root = this.getObjectMapper().readTree(inputStream);
            if (this.root.size() == 1) {
                for (Object object2 : this.root) {
                    this.root = object2;
                }
            }
            this.processAttributes(this.rootNode, this.root);
            object = new StatusConfiguration().withVerboseClasses(VERBOSE_CLASSES).withStatus(this.getDefaultStatus());
            for (Map.Entry entry : this.rootNode.getAttributes().entrySet()) {
                String string = (String)entry.getKey();
                String string2 = this.getStrSubstitutor().replace((String)entry.getValue());
                if ("status".equalsIgnoreCase(string)) {
                    ((StatusConfiguration)object).withStatus(string2);
                    continue;
                }
                if ("dest".equalsIgnoreCase(string)) {
                    ((StatusConfiguration)object).withDestination(string2);
                    continue;
                }
                if ("shutdownHook".equalsIgnoreCase(string)) {
                    this.isShutdownHookEnabled = !"disable".equalsIgnoreCase(string2);
                    continue;
                }
                if ("shutdownTimeout".equalsIgnoreCase(string)) {
                    this.shutdownTimeoutMillis = Long.parseLong(string2);
                    continue;
                }
                if ("verbose".equalsIgnoreCase((String)entry.getKey())) {
                    ((StatusConfiguration)object).withVerbosity(string2);
                    continue;
                }
                if ("packages".equalsIgnoreCase(string)) {
                    this.pluginPackages.addAll(Arrays.asList(string2.split(Patterns.COMMA_SEPARATOR)));
                    continue;
                }
                if ("name".equalsIgnoreCase(string)) {
                    this.setName(string2);
                    continue;
                }
                if ("monitorInterval".equalsIgnoreCase(string)) {
                    int n2 = Integer.parseInt(string2);
                    if (n2 <= 0) continue;
                    this.getWatchManager().setIntervalSeconds(n2);
                    if (file == null) continue;
                    ConfiguratonFileWatcher configuratonFileWatcher = new ConfiguratonFileWatcher(this, this.listeners);
                    this.getWatchManager().watchFile(file, configuratonFileWatcher);
                    continue;
                }
                if (!"advertiser".equalsIgnoreCase(string)) continue;
                this.createAdvertiser(string2, configurationSource, byArray, "application/json");
            }
            ((StatusConfiguration)object).initialize();
            if (this.getName() == null) {
                this.setName(configurationSource.getLocation());
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error parsing " + configurationSource.getLocation(), (Throwable)exception);
        }
    }

    protected ObjectMapper getObjectMapper() {
        return new ObjectMapper().configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }

    @Override
    public void setup() {
        Iterator iterator = this.root.fields();
        List<Node> list = this.rootNode.getChildren();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            JsonNode object = (JsonNode)entry.getValue();
            if (object.isObject()) {
                LOGGER.debug("Processing node for object {}", entry.getKey());
                list.add(this.constructNode((String)entry.getKey(), this.rootNode, object));
                continue;
            }
            if (!object.isArray()) continue;
            LOGGER.error("Arrays are not supported at the root configuration.");
        }
        LOGGER.debug("Completed parsing configuration");
        if (this.status.size() > 0) {
            for (JsonConfiguration$Status jsonConfiguration$Status : this.status) {
                LOGGER.error("Error processing element {}: {}", (Object)JsonConfiguration$Status.access$000(jsonConfiguration$Status), (Object)JsonConfiguration$Status.access$100(jsonConfiguration$Status));
            }
        }
    }

    @Override
    public Configuration reconfigure() {
        try {
            ConfigurationSource configurationSource = this.getConfigurationSource().resetInputStream();
            if (configurationSource == null) {
                return null;
            }
            return new JsonConfiguration(this.getLoggerContext(), configurationSource);
        }
        catch (IOException iOException) {
            LOGGER.error("Cannot locate file {}", (Object)this.getConfigurationSource(), (Object)iOException);
            return null;
        }
    }

    private Node constructNode(String string, Node node, JsonNode jsonNode) {
        Object object;
        Object object2;
        PluginType<?> pluginType = this.pluginManager.getPluginType(string);
        Node node2 = new Node(node, string, pluginType);
        this.processAttributes(node2, jsonNode);
        Iterator iterator = jsonNode.fields();
        List<Node> list = node2.getChildren();
        while (iterator.hasNext()) {
            object2 = (Map.Entry)iterator.next();
            object = (JsonNode)object2.getValue();
            if (object.isArray() || object.isObject()) {
                if (pluginType == null) {
                    this.status.add(new JsonConfiguration$Status(string, (JsonNode)object, JsonConfiguration$ErrorType.CLASS_NOT_FOUND));
                }
                if (object.isArray()) {
                    LOGGER.debug("Processing node for array {}", object2.getKey());
                    for (int i2 = 0; i2 < object.size(); ++i2) {
                        String string2 = this.getType(object.get(i2), (String)object2.getKey());
                        PluginType<?> pluginType2 = this.pluginManager.getPluginType(string2);
                        Node node3 = new Node(node2, (String)object2.getKey(), pluginType2);
                        this.processAttributes(node3, object.get(i2));
                        if (string2.equals(object2.getKey())) {
                            LOGGER.debug("Processing {}[{}]", object2.getKey(), (Object)i2);
                        } else {
                            LOGGER.debug("Processing {} {}[{}]", (Object)string2, object2.getKey(), (Object)i2);
                        }
                        Iterator iterator2 = object.get(i2).fields();
                        List<Node> list2 = node3.getChildren();
                        while (iterator2.hasNext()) {
                            Map.Entry entry = (Map.Entry)iterator2.next();
                            if (((JsonNode)entry.getValue()).isObject()) {
                                LOGGER.debug("Processing node for object {}", entry.getKey());
                                list2.add(this.constructNode((String)entry.getKey(), node3, (JsonNode)entry.getValue()));
                                continue;
                            }
                            if (!((JsonNode)entry.getValue()).isArray()) continue;
                            JsonNode jsonNode2 = (JsonNode)entry.getValue();
                            String string3 = (String)entry.getKey();
                            LOGGER.debug("Processing array for object {}", (Object)string3);
                            for (int i3 = 0; i3 < jsonNode2.size(); ++i3) {
                                list2.add(this.constructNode(string3, node3, jsonNode2.get(i3)));
                            }
                        }
                        list.add(node3);
                    }
                    continue;
                }
                LOGGER.debug("Processing node for object {}", object2.getKey());
                list.add(this.constructNode((String)object2.getKey(), node2, (JsonNode)object));
                continue;
            }
            LOGGER.debug("Node {} is of type {}", object2.getKey(), (Object)object.getNodeType());
        }
        object2 = pluginType == null ? "null" : pluginType.getElementName() + ':' + pluginType.getPluginClass();
        object = node2.getParent() == null ? "null" : (node2.getParent().getName() == null ? "root" : node2.getParent().getName());
        LOGGER.debug("Returning {} with parent {} of type {}", (Object)node2.getName(), object, object2);
        return node2;
    }

    private String getType(JsonNode jsonNode, String string) {
        Iterator iterator = jsonNode.fields();
        while (iterator.hasNext()) {
            JsonNode jsonNode2;
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!((String)entry.getKey()).equalsIgnoreCase("type") || !(jsonNode2 = (JsonNode)entry.getValue()).isValueNode()) continue;
            return jsonNode2.asText();
        }
        return string;
    }

    private void processAttributes(Node node, JsonNode jsonNode) {
        Map<String, String> map = node.getAttributes();
        Iterator iterator = jsonNode.fields();
        while (iterator.hasNext()) {
            JsonNode jsonNode2;
            Map.Entry entry = (Map.Entry)iterator.next();
            if (((String)entry.getKey()).equalsIgnoreCase("type") || !(jsonNode2 = (JsonNode)entry.getValue()).isValueNode()) continue;
            map.put((String)entry.getKey(), jsonNode2.asText());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[location=" + this.getConfigurationSource() + "]";
    }
}

